--
-- PostgreSQL database dump
--

-- Dumped from database version 13.13
-- Dumped by pg_dump version 13.13

-- Started on 2024-02-26 09:51:01

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 200 (class 1259 OID 16572)
-- Name: assurances; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.assurances (
    assurance_id integer NOT NULL,
    nom character varying(255) NOT NULL,
    statut boolean DEFAULT true NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    taux integer
);


ALTER TABLE public.assurances OWNER TO postgres;

--
-- TOC entry 201 (class 1259 OID 16576)
-- Name: assurances_assurance_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.assurances_assurance_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assurances_assurance_id_seq OWNER TO postgres;

--
-- TOC entry 3614 (class 0 OID 0)
-- Dependencies: 201
-- Name: assurances_assurance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.assurances_assurance_id_seq OWNED BY public.assurances.assurance_id;


--
-- TOC entry 202 (class 1259 OID 16578)
-- Name: categories; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.categories (
    categorie_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    type character varying(255) NOT NULL,
    statut boolean DEFAULT true NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.categories OWNER TO postgres;

--
-- TOC entry 203 (class 1259 OID 16585)
-- Name: categories_categorie_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.categories_categorie_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.categories_categorie_id_seq OWNER TO postgres;

--
-- TOC entry 3615 (class 0 OID 0)
-- Dependencies: 203
-- Name: categories_categorie_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.categories_categorie_id_seq OWNED BY public.categories.categorie_id;


--
-- TOC entry 204 (class 1259 OID 16587)
-- Name: centres; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.centres (
    centre_id integer NOT NULL,
    nom_centre character varying(255) NOT NULL,
    services character varying(255) NOT NULL,
    autorisation character varying(255) NOT NULL,
    adresse character varying(255) NOT NULL,
    telephone character varying(255) NOT NULL,
    impression character varying(255) NOT NULL,
    statut boolean NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    dps_id integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.centres OWNER TO postgres;

--
-- TOC entry 205 (class 1259 OID 16594)
-- Name: centres_centre_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.centres_centre_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.centres_centre_id_seq OWNER TO postgres;

--
-- TOC entry 3616 (class 0 OID 0)
-- Dependencies: 205
-- Name: centres_centre_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.centres_centre_id_seq OWNED BY public.centres.centre_id;


--
-- TOC entry 206 (class 1259 OID 16596)
-- Name: commandes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.commandes (
    commande_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date_commande date NOT NULL,
    date_valide date,
    date_cloture date,
    montant numeric(15,2) NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    etat character varying(30),
    fournisseur_id integer NOT NULL,
    taux integer DEFAULT 0,
    dps_id integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.commandes OWNER TO postgres;

--
-- TOC entry 207 (class 1259 OID 16600)
-- Name: commandes_commande_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.commandes_commande_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.commandes_commande_id_seq OWNER TO postgres;

--
-- TOC entry 3617 (class 0 OID 0)
-- Dependencies: 207
-- Name: commandes_commande_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.commandes_commande_id_seq OWNED BY public.commandes.commande_id;


--
-- TOC entry 208 (class 1259 OID 16602)
-- Name: compte_bancaires; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.compte_bancaires (
    compte_id integer NOT NULL,
    numero_compte integer NOT NULL,
    banque character varying(255) NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compte_bancaires OWNER TO postgres;

--
-- TOC entry 209 (class 1259 OID 16605)
-- Name: compte_bancaires_compte_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.compte_bancaires_compte_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compte_bancaires_compte_id_seq OWNER TO postgres;

--
-- TOC entry 3618 (class 0 OID 0)
-- Dependencies: 209
-- Name: compte_bancaires_compte_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.compte_bancaires_compte_id_seq OWNED BY public.compte_bancaires.compte_id;


--
-- TOC entry 210 (class 1259 OID 16607)
-- Name: correction_stocks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.correction_stocks (
    correction_stock_id integer NOT NULL,
    date_cs date NOT NULL,
    code_cs character varying(255) NOT NULL,
    motif character varying(255) NOT NULL,
    magasin_id integer NOT NULL,
    centre_id integer NOT NULL,
    user_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    cout integer
);


ALTER TABLE public.correction_stocks OWNER TO postgres;

--
-- TOC entry 211 (class 1259 OID 16613)
-- Name: correction_stocks_correction_stock_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.correction_stocks_correction_stock_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.correction_stocks_correction_stock_id_seq OWNER TO postgres;

--
-- TOC entry 3619 (class 0 OID 0)
-- Dependencies: 211
-- Name: correction_stocks_correction_stock_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.correction_stocks_correction_stock_id_seq OWNED BY public.correction_stocks.correction_stock_id;


--
-- TOC entry 212 (class 1259 OID 16615)
-- Name: directions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.directions (
    dps_id integer NOT NULL,
    dps_nom character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.directions OWNER TO postgres;

--
-- TOC entry 213 (class 1259 OID 16618)
-- Name: directions_dps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.directions_dps_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.directions_dps_id_seq OWNER TO postgres;

--
-- TOC entry 3620 (class 0 OID 0)
-- Dependencies: 213
-- Name: directions_dps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.directions_dps_id_seq OWNED BY public.directions.dps_id;


--
-- TOC entry 214 (class 1259 OID 16620)
-- Name: droit_profils; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.droit_profils (
    id bigint NOT NULL,
    droit_id bigint NOT NULL,
    profil_id bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.droit_profils OWNER TO postgres;

--
-- TOC entry 215 (class 1259 OID 16623)
-- Name: droit_profils_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.droit_profils_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.droit_profils_id_seq OWNER TO postgres;

--
-- TOC entry 3621 (class 0 OID 0)
-- Dependencies: 215
-- Name: droit_profils_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.droit_profils_id_seq OWNED BY public.droit_profils.id;


--
-- TOC entry 216 (class 1259 OID 16625)
-- Name: droits; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.droits (
    droit_id integer NOT NULL,
    code character varying(255) NOT NULL,
    groupe character varying(255) NOT NULL,
    nom character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    statut boolean DEFAULT true
);


ALTER TABLE public.droits OWNER TO postgres;

--
-- TOC entry 217 (class 1259 OID 16632)
-- Name: droits_droit_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.droits_droit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.droits_droit_id_seq OWNER TO postgres;

--
-- TOC entry 3622 (class 0 OID 0)
-- Dependencies: 217
-- Name: droits_droit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.droits_droit_id_seq OWNED BY public.droits.droit_id;


--
-- TOC entry 218 (class 1259 OID 16634)
-- Name: entrees; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.entrees (
    entree_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date date NOT NULL,
    motif character varying(255) NOT NULL,
    cout integer NOT NULL,
    mag_num integer NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.entrees OWNER TO postgres;

--
-- TOC entry 219 (class 1259 OID 16640)
-- Name: entrees_entree_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.entrees_entree_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entrees_entree_id_seq OWNER TO postgres;

--
-- TOC entry 3623 (class 0 OID 0)
-- Dependencies: 219
-- Name: entrees_entree_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.entrees_entree_id_seq OWNED BY public.entrees.entree_id;


--
-- TOC entry 220 (class 1259 OID 16642)
-- Name: factures; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.factures (
    facture_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date date NOT NULL,
    total integer NOT NULL,
    prise_encharge integer NOT NULL,
    part_patient integer NOT NULL,
    montant_recu integer NOT NULL,
    reliquat integer NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    assurance_id integer NOT NULL,
    patient_id integer NOT NULL,
    magasin_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.factures OWNER TO postgres;

--
-- TOC entry 221 (class 1259 OID 16645)
-- Name: factures_facture_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.factures_facture_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.factures_facture_id_seq OWNER TO postgres;

--
-- TOC entry 3624 (class 0 OID 0)
-- Dependencies: 221
-- Name: factures_facture_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.factures_facture_id_seq OWNED BY public.factures.facture_id;


--
-- TOC entry 222 (class 1259 OID 16647)
-- Name: failed_jobs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.failed_jobs (
    id bigint NOT NULL,
    uuid character varying(255) NOT NULL,
    connection text NOT NULL,
    queue text NOT NULL,
    payload text NOT NULL,
    exception text NOT NULL,
    failed_at timestamp(0) without time zone DEFAULT CURRENT_TIMESTAMP NOT NULL
);


ALTER TABLE public.failed_jobs OWNER TO postgres;

--
-- TOC entry 223 (class 1259 OID 16654)
-- Name: failed_jobs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.failed_jobs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.failed_jobs_id_seq OWNER TO postgres;

--
-- TOC entry 3625 (class 0 OID 0)
-- Dependencies: 223
-- Name: failed_jobs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.failed_jobs_id_seq OWNED BY public.failed_jobs.id;


--
-- TOC entry 224 (class 1259 OID 16656)
-- Name: fournisseurs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.fournisseurs (
    fournisseur_id integer NOT NULL,
    nom character varying(255) NOT NULL,
    adresse character varying(255) NOT NULL,
    ville character varying(255) NOT NULL,
    email character varying(255) NOT NULL,
    telephone character varying(255) NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    statut boolean DEFAULT true NOT NULL
);


ALTER TABLE public.fournisseurs OWNER TO postgres;

--
-- TOC entry 225 (class 1259 OID 16663)
-- Name: fournisseurs_fournisseur_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.fournisseurs_fournisseur_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.fournisseurs_fournisseur_id_seq OWNER TO postgres;

--
-- TOC entry 3626 (class 0 OID 0)
-- Dependencies: 225
-- Name: fournisseurs_fournisseur_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.fournisseurs_fournisseur_id_seq OWNED BY public.fournisseurs.fournisseur_id;


--
-- TOC entry 226 (class 1259 OID 16665)
-- Name: initialisations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.initialisations (
    ini_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date date NOT NULL,
    motif character varying(255) NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.initialisations OWNER TO postgres;

--
-- TOC entry 227 (class 1259 OID 16671)
-- Name: initialisations_ini_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.initialisations_ini_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.initialisations_ini_id_seq OWNER TO postgres;

--
-- TOC entry 3627 (class 0 OID 0)
-- Dependencies: 227
-- Name: initialisations_ini_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.initialisations_ini_id_seq OWNED BY public.initialisations.ini_id;


--
-- TOC entry 228 (class 1259 OID 16673)
-- Name: magasins; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.magasins (
    magasin_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    type character varying(255) NOT NULL,
    centre_id integer NOT NULL,
    statut boolean DEFAULT true NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.magasins OWNER TO postgres;

--
-- TOC entry 229 (class 1259 OID 16680)
-- Name: magasins_magasin_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.magasins_magasin_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.magasins_magasin_id_seq OWNER TO postgres;

--
-- TOC entry 3628 (class 0 OID 0)
-- Dependencies: 229
-- Name: magasins_magasin_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.magasins_magasin_id_seq OWNED BY public.magasins.magasin_id;


--
-- TOC entry 230 (class 1259 OID 16682)
-- Name: migrations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.migrations (
    id integer NOT NULL,
    migration character varying(255) NOT NULL,
    batch integer NOT NULL
);


ALTER TABLE public.migrations OWNER TO postgres;

--
-- TOC entry 231 (class 1259 OID 16685)
-- Name: migrations_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.migrations_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.migrations_id_seq OWNER TO postgres;

--
-- TOC entry 3629 (class 0 OID 0)
-- Dependencies: 231
-- Name: migrations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.migrations_id_seq OWNED BY public.migrations.id;


--
-- TOC entry 232 (class 1259 OID 16687)
-- Name: mouvements; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mouvements (
    mouvement_id integer NOT NULL,
    date date NOT NULL,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    magasin_id integer NOT NULL,
    centre_id integer NOT NULL,
    qte_initiale integer DEFAULT 0,
    qte_entree integer DEFAULT 0,
    qte_sortie integer DEFAULT 0,
    qte_reelle integer DEFAULT 0,
    idop character varying(255),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    idcon integer,
    motif character varying,
    user_id integer,
    dps_id integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.mouvements OWNER TO postgres;

--
-- TOC entry 233 (class 1259 OID 16698)
-- Name: mouvements_mouvement_stock_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mouvements_mouvement_stock_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mouvements_mouvement_stock_id_seq OWNER TO postgres;

--
-- TOC entry 3630 (class 0 OID 0)
-- Dependencies: 233
-- Name: mouvements_mouvement_stock_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mouvements_mouvement_stock_id_seq OWNED BY public.mouvements.mouvement_id;


--
-- TOC entry 234 (class 1259 OID 16700)
-- Name: mutuelles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mutuelles (
    mutuelle_id integer NOT NULL,
    nom character varying(255) NOT NULL,
    statut boolean NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.mutuelles OWNER TO postgres;

--
-- TOC entry 235 (class 1259 OID 16703)
-- Name: mutuelles_mutuelle_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mutuelles_mutuelle_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mutuelles_mutuelle_id_seq OWNER TO postgres;

--
-- TOC entry 3631 (class 0 OID 0)
-- Dependencies: 235
-- Name: mutuelles_mutuelle_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mutuelles_mutuelle_id_seq OWNED BY public.mutuelles.mutuelle_id;


--
-- TOC entry 236 (class 1259 OID 16705)
-- Name: operation_bancaires; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.operation_bancaires (
    operation_id integer NOT NULL,
    date date NOT NULL,
    type_operation character varying(255) NOT NULL,
    libelle character varying(255) NOT NULL,
    operant character varying(255) NOT NULL,
    initiale double precision NOT NULL,
    entree double precision NOT NULL,
    sortie double precision NOT NULL,
    solde double precision NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    compte_id integer,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.operation_bancaires OWNER TO postgres;

--
-- TOC entry 237 (class 1259 OID 16711)
-- Name: operation_bancaires_operation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.operation_bancaires_operation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.operation_bancaires_operation_id_seq OWNER TO postgres;

--
-- TOC entry 3632 (class 0 OID 0)
-- Dependencies: 237
-- Name: operation_bancaires_operation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.operation_bancaires_operation_id_seq OWNED BY public.operation_bancaires.operation_id;


--
-- TOC entry 238 (class 1259 OID 16713)
-- Name: password_resets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.password_resets (
    email character varying(255) NOT NULL,
    token character varying(255) NOT NULL,
    created_at timestamp(0) without time zone
);


ALTER TABLE public.password_resets OWNER TO postgres;

--
-- TOC entry 239 (class 1259 OID 16719)
-- Name: patients; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.patients (
    patient_id integer NOT NULL,
    code_patient character varying(255) NOT NULL,
    nom_prenom character varying(255) NOT NULL,
    sexe character varying(255) NOT NULL,
    age integer NOT NULL,
    assurance_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.patients OWNER TO postgres;

--
-- TOC entry 240 (class 1259 OID 16725)
-- Name: patients_patient_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.patients_patient_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.patients_patient_id_seq OWNER TO postgres;

--
-- TOC entry 3633 (class 0 OID 0)
-- Dependencies: 240
-- Name: patients_patient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.patients_patient_id_seq OWNED BY public.patients.patient_id;


--
-- TOC entry 241 (class 1259 OID 16727)
-- Name: personal_access_tokens; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.personal_access_tokens (
    id bigint NOT NULL,
    tokenable_type character varying(255) NOT NULL,
    tokenable_id bigint NOT NULL,
    name character varying(255) NOT NULL,
    token character varying(64) NOT NULL,
    abilities text,
    last_used_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.personal_access_tokens OWNER TO postgres;

--
-- TOC entry 242 (class 1259 OID 16733)
-- Name: personal_access_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.personal_access_tokens_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.personal_access_tokens_id_seq OWNER TO postgres;

--
-- TOC entry 3634 (class 0 OID 0)
-- Dependencies: 242
-- Name: personal_access_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.personal_access_tokens_id_seq OWNED BY public.personal_access_tokens.id;


--
-- TOC entry 243 (class 1259 OID 16735)
-- Name: produit_commandes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produit_commandes (
    produit_commande_id integer NOT NULL,
    commande_id integer,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    qte integer NOT NULL,
    prix_achat integer NOT NULL,
    montant integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    code character varying(20),
    reference character varying(30),
    qte_liv integer DEFAULT 0
);


ALTER TABLE public.produit_commandes OWNER TO postgres;

--
-- TOC entry 244 (class 1259 OID 16739)
-- Name: produit_commandes_"produit_commande_id" _seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public."produit_commandes_""produit_commande_id"" _seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public."produit_commandes_""produit_commande_id"" _seq" OWNER TO postgres;

--
-- TOC entry 3635 (class 0 OID 0)
-- Dependencies: 244
-- Name: produit_commandes_"produit_commande_id" _seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public."produit_commandes_""produit_commande_id"" _seq" OWNED BY public.produit_commandes.produit_commande_id;


--
-- TOC entry 245 (class 1259 OID 16741)
-- Name: produit_correction_stocks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produit_correction_stocks (
    produit_correction_stock_id integer NOT NULL,
    correction_stock_id integer,
    code_cs character varying(255) NOT NULL,
    motif character varying(255) NOT NULL,
    qte integer NOT NULL,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    lot character varying,
    stock_produit_id integer,
    pu integer,
    cout integer,
    magasin_id integer
);


ALTER TABLE public.produit_correction_stocks OWNER TO postgres;

--
-- TOC entry 246 (class 1259 OID 16747)
-- Name: produit_correction_stocks_produit_correction_stock_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.produit_correction_stocks_produit_correction_stock_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.produit_correction_stocks_produit_correction_stock_id_seq OWNER TO postgres;

--
-- TOC entry 3636 (class 0 OID 0)
-- Dependencies: 246
-- Name: produit_correction_stocks_produit_correction_stock_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.produit_correction_stocks_produit_correction_stock_id_seq OWNED BY public.produit_correction_stocks.produit_correction_stock_id;


--
-- TOC entry 247 (class 1259 OID 16749)
-- Name: produit_entrees; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produit_entrees (
    """produit_entree_id"" " integer NOT NULL,
    entree_id integer NOT NULL,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    qte integer NOT NULL,
    prix_achat integer NOT NULL,
    montant integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.produit_entrees OWNER TO postgres;

--
-- TOC entry 248 (class 1259 OID 16752)
-- Name: produit_entrees_"produit_entree_id" _seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public."produit_entrees_""produit_entree_id"" _seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public."produit_entrees_""produit_entree_id"" _seq" OWNER TO postgres;

--
-- TOC entry 3637 (class 0 OID 0)
-- Dependencies: 248
-- Name: produit_entrees_"produit_entree_id" _seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public."produit_entrees_""produit_entree_id"" _seq" OWNED BY public.produit_entrees."""produit_entree_id"" ";


--
-- TOC entry 249 (class 1259 OID 16754)
-- Name: produit_factures; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produit_factures (
    produit_facture_id integer NOT NULL,
    facture_id integer NOT NULL,
    code character varying(255) NOT NULL,
    produit_id integer NOT NULL,
    reference character varying(255) NOT NULL,
    libelle character varying(255) NOT NULL,
    lot character varying(255) NOT NULL,
    qte integer NOT NULL,
    prix_public integer NOT NULL,
    base_assurance integer NOT NULL,
    total integer NOT NULL,
    taux integer NOT NULL,
    prise_encharge integer NOT NULL,
    part_patient integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.produit_factures OWNER TO postgres;

--
-- TOC entry 250 (class 1259 OID 16760)
-- Name: produit_factures_produit_facture_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.produit_factures_produit_facture_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.produit_factures_produit_facture_id_seq OWNER TO postgres;

--
-- TOC entry 3638 (class 0 OID 0)
-- Dependencies: 250
-- Name: produit_factures_produit_facture_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.produit_factures_produit_facture_id_seq OWNED BY public.produit_factures.produit_facture_id;


--
-- TOC entry 251 (class 1259 OID 16762)
-- Name: produit_reception_dps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produit_reception_dps (
    """produit_reception_dps_id"" " integer NOT NULL,
    reception_dps_id integer NOT NULL,
    code character varying(255) NOT NULL,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    qte_commandee integer NOT NULL,
    qte_recue integer NOT NULL,
    qte_transferee integer NOT NULL,
    remarque character varying(255) NOT NULL,
    commande_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.produit_reception_dps OWNER TO postgres;

--
-- TOC entry 252 (class 1259 OID 16768)
-- Name: produit_reception_dps_"produit_reception_dps_id" _seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public."produit_reception_dps_""produit_reception_dps_id"" _seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public."produit_reception_dps_""produit_reception_dps_id"" _seq" OWNER TO postgres;

--
-- TOC entry 3639 (class 0 OID 0)
-- Dependencies: 252
-- Name: produit_reception_dps_"produit_reception_dps_id" _seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public."produit_reception_dps_""produit_reception_dps_id"" _seq" OWNED BY public.produit_reception_dps."""produit_reception_dps_id"" ";


--
-- TOC entry 253 (class 1259 OID 16770)
-- Name: produit_reception_sis; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produit_reception_sis (
    produit_reception_si_id integer NOT NULL,
    reception_si_id integer,
    code character varying(255) NOT NULL,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    qte_commandee integer NOT NULL,
    qte_recue integer NOT NULL,
    qte_transferee integer NOT NULL,
    remarque character varying(255),
    commande_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.produit_reception_sis OWNER TO postgres;

--
-- TOC entry 254 (class 1259 OID 16776)
-- Name: produit_reception_sis_produit_reception_si_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.produit_reception_sis_produit_reception_si_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.produit_reception_sis_produit_reception_si_id_seq OWNER TO postgres;

--
-- TOC entry 3640 (class 0 OID 0)
-- Dependencies: 254
-- Name: produit_reception_sis_produit_reception_si_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.produit_reception_sis_produit_reception_si_id_seq OWNED BY public.produit_reception_sis.produit_reception_si_id;


--
-- TOC entry 255 (class 1259 OID 16778)
-- Name: produit_receptions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produit_receptions (
    produit_reception_id integer NOT NULL,
    reception_id integer,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    lot character varying(255),
    qte integer NOT NULL,
    pa integer NOT NULL,
    montant integer NOT NULL,
    date_expiration date,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    code character varying,
    commande_id integer,
    pv integer,
    unite integer DEFAULT 1,
    reception_si_id integer
);


ALTER TABLE public.produit_receptions OWNER TO postgres;

--
-- TOC entry 256 (class 1259 OID 16785)
-- Name: produit_receptions_"produit_reception_id" _seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public."produit_receptions_""produit_reception_id"" _seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public."produit_receptions_""produit_reception_id"" _seq" OWNER TO postgres;

--
-- TOC entry 3641 (class 0 OID 0)
-- Dependencies: 256
-- Name: produit_receptions_"produit_reception_id" _seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public."produit_receptions_""produit_reception_id"" _seq" OWNED BY public.produit_receptions.produit_reception_id;


--
-- TOC entry 257 (class 1259 OID 16787)
-- Name: produit_sorties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produit_sorties (
    """produit_sortie_id"" " integer NOT NULL,
    sortie_id integer NOT NULL,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    qte integer NOT NULL,
    prix_achat integer NOT NULL,
    montant integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.produit_sorties OWNER TO postgres;

--
-- TOC entry 258 (class 1259 OID 16790)
-- Name: produit_sorties_"produit_sortie_id" _seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public."produit_sorties_""produit_sortie_id"" _seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public."produit_sorties_""produit_sortie_id"" _seq" OWNER TO postgres;

--
-- TOC entry 3642 (class 0 OID 0)
-- Dependencies: 258
-- Name: produit_sorties_"produit_sortie_id" _seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public."produit_sorties_""produit_sortie_id"" _seq" OWNED BY public.produit_sorties."""produit_sortie_id"" ";


--
-- TOC entry 259 (class 1259 OID 16792)
-- Name: produit_transfert_dps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produit_transfert_dps (
    produit_transfert_dps_id integer NOT NULL,
    transfer_dps_id integer NOT NULL,
    code character varying(255) NOT NULL,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    qte_recue integer NOT NULL,
    qte_transferee integer NOT NULL,
    remarque character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.produit_transfert_dps OWNER TO postgres;

--
-- TOC entry 260 (class 1259 OID 16798)
-- Name: produit_transfert_dps_produit_transfert_dps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.produit_transfert_dps_produit_transfert_dps_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.produit_transfert_dps_produit_transfert_dps_id_seq OWNER TO postgres;

--
-- TOC entry 3643 (class 0 OID 0)
-- Dependencies: 260
-- Name: produit_transfert_dps_produit_transfert_dps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.produit_transfert_dps_produit_transfert_dps_id_seq OWNED BY public.produit_transfert_dps.produit_transfert_dps_id;


--
-- TOC entry 261 (class 1259 OID 16800)
-- Name: produit_transfert_sis; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produit_transfert_sis (
    produit_transfert_si_id integer NOT NULL,
    transfert_si_id integer NOT NULL,
    code character varying(255) NOT NULL,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    qte_recue integer NOT NULL,
    qte_transferee integer NOT NULL,
    remarque character varying(255) NOT NULL,
    commande_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.produit_transfert_sis OWNER TO postgres;

--
-- TOC entry 262 (class 1259 OID 16806)
-- Name: produit_transfert_sis_produit_transfert_si_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.produit_transfert_sis_produit_transfert_si_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.produit_transfert_sis_produit_transfert_si_id_seq OWNER TO postgres;

--
-- TOC entry 3644 (class 0 OID 0)
-- Dependencies: 262
-- Name: produit_transfert_sis_produit_transfert_si_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.produit_transfert_sis_produit_transfert_si_id_seq OWNED BY public.produit_transfert_sis.produit_transfert_si_id;


--
-- TOC entry 263 (class 1259 OID 16808)
-- Name: produit_transferts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produit_transferts (
    produit_transfert_id integer NOT NULL,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    qte integer NOT NULL,
    prix integer DEFAULT 0,
    montant integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    code character varying,
    lot character varying,
    idsp integer,
    ini integer DEFAULT 0,
    transfert_id integer
);


ALTER TABLE public.produit_transferts OWNER TO postgres;

--
-- TOC entry 264 (class 1259 OID 16816)
-- Name: produit_transferts_"produit_transfert_id" _seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public."produit_transferts_""produit_transfert_id"" _seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public."produit_transferts_""produit_transfert_id"" _seq" OWNER TO postgres;

--
-- TOC entry 3645 (class 0 OID 0)
-- Dependencies: 264
-- Name: produit_transferts_"produit_transfert_id" _seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public."produit_transferts_""produit_transfert_id"" _seq" OWNED BY public.produit_transferts.produit_transfert_id;


--
-- TOC entry 265 (class 1259 OID 16818)
-- Name: produit_ventes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produit_ventes (
    produit_vente_id integer NOT NULL,
    vente_id integer,
    code character varying(255) NOT NULL,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    mont integer NOT NULL,
    pec integer NOT NULL,
    net integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    pu integer,
    qte integer,
    taux_pdt integer,
    base integer,
    lot character varying,
    categorie_id integer,
    ini integer
);


ALTER TABLE public.produit_ventes OWNER TO postgres;

--
-- TOC entry 266 (class 1259 OID 16824)
-- Name: produit_ventes_produit_vente_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.produit_ventes_produit_vente_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.produit_ventes_produit_vente_id_seq OWNER TO postgres;

--
-- TOC entry 3646 (class 0 OID 0)
-- Dependencies: 266
-- Name: produit_ventes_produit_vente_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.produit_ventes_produit_vente_id_seq OWNED BY public.produit_ventes.produit_vente_id;


--
-- TOC entry 267 (class 1259 OID 16826)
-- Name: produits; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.produits (
    produit_id integer NOT NULL,
    reference character varying(255),
    nom_commercial character varying(255) NOT NULL,
    dci character varying(255) NOT NULL,
    famille_therapeutique character varying(255) NOT NULL,
    prix_achat integer NOT NULL,
    prix_vente integer NOT NULL,
    stock_minimal integer NOT NULL,
    stock_maximal integer NOT NULL,
    user_id integer NOT NULL,
    statut boolean DEFAULT true NOT NULL,
    categorie_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    type character varying,
    unite_achat integer,
    unite_vente integer,
    stock_alerte integer DEFAULT 0,
    stock_securite integer DEFAULT 0
);


ALTER TABLE public.produits OWNER TO postgres;

--
-- TOC entry 268 (class 1259 OID 16835)
-- Name: produits_produit_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.produits_produit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.produits_produit_id_seq OWNER TO postgres;

--
-- TOC entry 3647 (class 0 OID 0)
-- Dependencies: 268
-- Name: produits_produit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.produits_produit_id_seq OWNED BY public.produits.produit_id;


--
-- TOC entry 269 (class 1259 OID 16837)
-- Name: profil_users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.profil_users (
    id bigint NOT NULL,
    profil_id bigint NOT NULL,
    user_id bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.profil_users OWNER TO postgres;

--
-- TOC entry 270 (class 1259 OID 16840)
-- Name: profil_users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.profil_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.profil_users_id_seq OWNER TO postgres;

--
-- TOC entry 3648 (class 0 OID 0)
-- Dependencies: 270
-- Name: profil_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.profil_users_id_seq OWNED BY public.profil_users.id;


--
-- TOC entry 271 (class 1259 OID 16842)
-- Name: profils; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.profils (
    profil_id integer NOT NULL,
    nom character varying(255) NOT NULL,
    statut boolean NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.profils OWNER TO postgres;

--
-- TOC entry 272 (class 1259 OID 16845)
-- Name: profils_profil_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.profils_profil_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.profils_profil_id_seq OWNER TO postgres;

--
-- TOC entry 3649 (class 0 OID 0)
-- Dependencies: 272
-- Name: profils_profil_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.profils_profil_id_seq OWNED BY public.profils.profil_id;


--
-- TOC entry 273 (class 1259 OID 16847)
-- Name: reception_dps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reception_dps (
    reception_dps_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date_reception date NOT NULL,
    montant numeric(8,2) NOT NULL,
    etat character varying(255),
    commande_id integer NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    dps_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    etat_liv character varying
);


ALTER TABLE public.reception_dps OWNER TO postgres;

--
-- TOC entry 274 (class 1259 OID 16853)
-- Name: reception_dps_reception_dps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reception_dps_reception_dps_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reception_dps_reception_dps_id_seq OWNER TO postgres;

--
-- TOC entry 3650 (class 0 OID 0)
-- Dependencies: 274
-- Name: reception_dps_reception_dps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reception_dps_reception_dps_id_seq OWNED BY public.reception_dps.reception_dps_id;


--
-- TOC entry 275 (class 1259 OID 16855)
-- Name: reception_sis; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reception_sis (
    reception_si_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date_reception date NOT NULL,
    etat_liv character varying(255),
    commande_id integer NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    taux_liv integer DEFAULT 0,
    taux_tr integer DEFAULT 0
);


ALTER TABLE public.reception_sis OWNER TO postgres;

--
-- TOC entry 276 (class 1259 OID 16863)
-- Name: reception_sis_reception_si_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reception_sis_reception_si_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reception_sis_reception_si_id_seq OWNER TO postgres;

--
-- TOC entry 3651 (class 0 OID 0)
-- Dependencies: 276
-- Name: reception_sis_reception_si_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reception_sis_reception_si_id_seq OWNED BY public.reception_sis.reception_si_id;


--
-- TOC entry 277 (class 1259 OID 16865)
-- Name: receptions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.receptions (
    reception_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date_reception date NOT NULL,
    montant numeric(15,2) NOT NULL,
    etat character varying(255) NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    commande_id integer DEFAULT 0,
    magasin_id integer
);


ALTER TABLE public.receptions OWNER TO postgres;

--
-- TOC entry 278 (class 1259 OID 16872)
-- Name: receptions_reception_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.receptions_reception_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.receptions_reception_id_seq OWNER TO postgres;

--
-- TOC entry 3652 (class 0 OID 0)
-- Dependencies: 278
-- Name: receptions_reception_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.receptions_reception_id_seq OWNED BY public.receptions.reception_id;


--
-- TOC entry 279 (class 1259 OID 16874)
-- Name: reglements; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reglements (
    reglement_id integer NOT NULL,
    date_reglement date NOT NULL,
    montant_reglement integer NOT NULL,
    vente_id integer NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    reglement_source character varying,
    dps_id integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.reglements OWNER TO postgres;

--
-- TOC entry 280 (class 1259 OID 16881)
-- Name: reglements_regelement_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reglements_regelement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reglements_regelement_id_seq OWNER TO postgres;

--
-- TOC entry 3653 (class 0 OID 0)
-- Dependencies: 280
-- Name: reglements_regelement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reglements_regelement_id_seq OWNED BY public.reglements.reglement_id;


--
-- TOC entry 281 (class 1259 OID 16883)
-- Name: sorties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sorties (
    sortie_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date date NOT NULL,
    motif character varying(255) NOT NULL,
    cout integer NOT NULL,
    mag_num integer NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sorties OWNER TO postgres;

--
-- TOC entry 282 (class 1259 OID 16889)
-- Name: sorties_sortie_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sorties_sortie_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sorties_sortie_id_seq OWNER TO postgres;

--
-- TOC entry 3654 (class 0 OID 0)
-- Dependencies: 282
-- Name: sorties_sortie_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sorties_sortie_id_seq OWNED BY public.sorties.sortie_id;


--
-- TOC entry 283 (class 1259 OID 16891)
-- Name: stock_produits; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stock_produits (
    stock_produit_id integer NOT NULL,
    produit_id integer NOT NULL,
    libelle character varying(255) NOT NULL,
    lot character varying(255),
    magasin_id integer NOT NULL,
    centre_id integer NOT NULL,
    qte integer NOT NULL,
    date_peremption date,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    etat character varying DEFAULT 'Encours'::character varying,
    qtea integer,
    dps_id integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.stock_produits OWNER TO postgres;

--
-- TOC entry 284 (class 1259 OID 16899)
-- Name: stock_produits_stock_produit_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stock_produits_stock_produit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stock_produits_stock_produit_id_seq OWNER TO postgres;

--
-- TOC entry 3655 (class 0 OID 0)
-- Dependencies: 284
-- Name: stock_produits_stock_produit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stock_produits_stock_produit_id_seq OWNED BY public.stock_produits.stock_produit_id;


--
-- TOC entry 285 (class 1259 OID 16901)
-- Name: stocks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stocks (
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stocks OWNER TO postgres;

--
-- TOC entry 286 (class 1259 OID 16904)
-- Name: transfert_dps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transfert_dps (
    transfert_dps_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date_transfert date NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    dps_id integer DEFAULT 1 NOT NULL,
    reception_dps_id integer DEFAULT 1,
    observation character varying(255),
    etat character varying(255) DEFAULT 'Encours'::character varying,
    commande_id integer
);


ALTER TABLE public.transfert_dps OWNER TO postgres;

--
-- TOC entry 287 (class 1259 OID 16913)
-- Name: transfert_dps_transfert_dps_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transfert_dps_transfert_dps_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transfert_dps_transfert_dps_id_seq OWNER TO postgres;

--
-- TOC entry 3656 (class 0 OID 0)
-- Dependencies: 287
-- Name: transfert_dps_transfert_dps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transfert_dps_transfert_dps_id_seq OWNED BY public.transfert_dps.transfert_dps_id;


--
-- TOC entry 288 (class 1259 OID 16915)
-- Name: transfert_sis; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transfert_sis (
    transfert_si_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date_transfert date NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    reception_si_id integer,
    observation "char",
    etat character varying,
    commande_id integer
);


ALTER TABLE public.transfert_sis OWNER TO postgres;

--
-- TOC entry 289 (class 1259 OID 16921)
-- Name: transfert_sis_transfert_si_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transfert_sis_transfert_si_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transfert_sis_transfert_si_id_seq OWNER TO postgres;

--
-- TOC entry 3657 (class 0 OID 0)
-- Dependencies: 289
-- Name: transfert_sis_transfert_si_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transfert_sis_transfert_si_id_seq OWNED BY public.transfert_sis.transfert_si_id;


--
-- TOC entry 290 (class 1259 OID 16923)
-- Name: transferts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transferts (
    transfert_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date date NOT NULL,
    source integer NOT NULL,
    destination integer NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    cout double precision DEFAULT 0,
    source_id integer,
    destination_id integer
);


ALTER TABLE public.transferts OWNER TO postgres;

--
-- TOC entry 291 (class 1259 OID 16927)
-- Name: transferts_transfert_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transferts_transfert_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transferts_transfert_id_seq OWNER TO postgres;

--
-- TOC entry 3658 (class 0 OID 0)
-- Dependencies: 291
-- Name: transferts_transfert_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transferts_transfert_id_seq OWNED BY public.transferts.transfert_id;


--
-- TOC entry 292 (class 1259 OID 16929)
-- Name: usercons; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.usercons (
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    id integer
);


ALTER TABLE public.usercons OWNER TO postgres;

--
-- TOC entry 293 (class 1259 OID 16932)
-- Name: users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.users (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    email character varying(255) NOT NULL,
    email_verified_at timestamp(0) without time zone,
    password character varying(255) NOT NULL,
    remember_token character varying(100),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    centre_id integer,
    statut boolean DEFAULT true,
    profil_id integer,
    dps_id integer NOT NULL,
    type character varying(255) NOT NULL
);


ALTER TABLE public.users OWNER TO postgres;

--
-- TOC entry 294 (class 1259 OID 16939)
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_id_seq OWNER TO postgres;

--
-- TOC entry 3659 (class 0 OID 0)
-- Dependencies: 294
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.users_id_seq OWNED BY public.users.id;


--
-- TOC entry 295 (class 1259 OID 16941)
-- Name: validations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.validations (
    validation_id integer NOT NULL,
    date date NOT NULL,
    etat character varying(255),
    observation character varying(255),
    commande_id integer NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.validations OWNER TO postgres;

--
-- TOC entry 296 (class 1259 OID 16947)
-- Name: validations_validation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.validations_validation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.validations_validation_id_seq OWNER TO postgres;

--
-- TOC entry 3660 (class 0 OID 0)
-- Dependencies: 296
-- Name: validations_validation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.validations_validation_id_seq OWNED BY public.validations.validation_id;


--
-- TOC entry 297 (class 1259 OID 16949)
-- Name: valider_commande_controllers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.valider_commande_controllers (
    validation_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date date NOT NULL,
    commande_id integer NOT NULL,
    observation character varying(255),
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.valider_commande_controllers OWNER TO postgres;

--
-- TOC entry 298 (class 1259 OID 16955)
-- Name: valider_commande_controllers_validation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.valider_commande_controllers_validation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.valider_commande_controllers_validation_id_seq OWNER TO postgres;

--
-- TOC entry 3661 (class 0 OID 0)
-- Dependencies: 298
-- Name: valider_commande_controllers_validation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.valider_commande_controllers_validation_id_seq OWNED BY public.valider_commande_controllers.validation_id;


--
-- TOC entry 299 (class 1259 OID 16957)
-- Name: ventes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ventes (
    vente_id integer NOT NULL,
    code character varying(255) NOT NULL,
    date_vente date NOT NULL,
    montant_total integer NOT NULL,
    prise_en_charge integer NOT NULL,
    net_apayer integer NOT NULL,
    montant_recu integer NOT NULL,
    reliquat integer NOT NULL,
    patient_id integer NOT NULL,
    assurance_id integer NOT NULL,
    user_id integer NOT NULL,
    centre_id integer NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    etat character varying,
    montant_paye integer,
    heure_vente time with time zone,
    dps_id integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.ventes OWNER TO postgres;

--
-- TOC entry 300 (class 1259 OID 16964)
-- Name: ventes_vente_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.ventes_vente_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ventes_vente_id_seq OWNER TO postgres;

--
-- TOC entry 3662 (class 0 OID 0)
-- Dependencies: 300
-- Name: ventes_vente_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.ventes_vente_id_seq OWNED BY public.ventes.vente_id;


--
-- TOC entry 3187 (class 2604 OID 16966)
-- Name: assurances assurance_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.assurances ALTER COLUMN assurance_id SET DEFAULT nextval('public.assurances_assurance_id_seq'::regclass);


--
-- TOC entry 3189 (class 2604 OID 16967)
-- Name: categories categorie_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.categories ALTER COLUMN categorie_id SET DEFAULT nextval('public.categories_categorie_id_seq'::regclass);


--
-- TOC entry 3191 (class 2604 OID 16968)
-- Name: centres centre_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.centres ALTER COLUMN centre_id SET DEFAULT nextval('public.centres_centre_id_seq'::regclass);


--
-- TOC entry 3193 (class 2604 OID 16969)
-- Name: commandes commande_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.commandes ALTER COLUMN commande_id SET DEFAULT nextval('public.commandes_commande_id_seq'::regclass);


--
-- TOC entry 3195 (class 2604 OID 16970)
-- Name: compte_bancaires compte_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.compte_bancaires ALTER COLUMN compte_id SET DEFAULT nextval('public.compte_bancaires_compte_id_seq'::regclass);


--
-- TOC entry 3196 (class 2604 OID 16971)
-- Name: correction_stocks correction_stock_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.correction_stocks ALTER COLUMN correction_stock_id SET DEFAULT nextval('public.correction_stocks_correction_stock_id_seq'::regclass);


--
-- TOC entry 3197 (class 2604 OID 16972)
-- Name: directions dps_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.directions ALTER COLUMN dps_id SET DEFAULT nextval('public.directions_dps_id_seq'::regclass);


--
-- TOC entry 3198 (class 2604 OID 16973)
-- Name: droit_profils id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.droit_profils ALTER COLUMN id SET DEFAULT nextval('public.droit_profils_id_seq'::regclass);


--
-- TOC entry 3200 (class 2604 OID 16974)
-- Name: droits droit_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.droits ALTER COLUMN droit_id SET DEFAULT nextval('public.droits_droit_id_seq'::regclass);


--
-- TOC entry 3201 (class 2604 OID 16975)
-- Name: entrees entree_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.entrees ALTER COLUMN entree_id SET DEFAULT nextval('public.entrees_entree_id_seq'::regclass);


--
-- TOC entry 3202 (class 2604 OID 16976)
-- Name: factures facture_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.factures ALTER COLUMN facture_id SET DEFAULT nextval('public.factures_facture_id_seq'::regclass);


--
-- TOC entry 3204 (class 2604 OID 16977)
-- Name: failed_jobs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.failed_jobs ALTER COLUMN id SET DEFAULT nextval('public.failed_jobs_id_seq'::regclass);


--
-- TOC entry 3206 (class 2604 OID 16978)
-- Name: fournisseurs fournisseur_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.fournisseurs ALTER COLUMN fournisseur_id SET DEFAULT nextval('public.fournisseurs_fournisseur_id_seq'::regclass);


--
-- TOC entry 3207 (class 2604 OID 16979)
-- Name: initialisations ini_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.initialisations ALTER COLUMN ini_id SET DEFAULT nextval('public.initialisations_ini_id_seq'::regclass);


--
-- TOC entry 3209 (class 2604 OID 16980)
-- Name: magasins magasin_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.magasins ALTER COLUMN magasin_id SET DEFAULT nextval('public.magasins_magasin_id_seq'::regclass);


--
-- TOC entry 3210 (class 2604 OID 16981)
-- Name: migrations id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.migrations ALTER COLUMN id SET DEFAULT nextval('public.migrations_id_seq'::regclass);


--
-- TOC entry 3216 (class 2604 OID 16982)
-- Name: mouvements mouvement_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mouvements ALTER COLUMN mouvement_id SET DEFAULT nextval('public.mouvements_mouvement_stock_id_seq'::regclass);


--
-- TOC entry 3217 (class 2604 OID 16983)
-- Name: mutuelles mutuelle_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mutuelles ALTER COLUMN mutuelle_id SET DEFAULT nextval('public.mutuelles_mutuelle_id_seq'::regclass);


--
-- TOC entry 3218 (class 2604 OID 16984)
-- Name: operation_bancaires operation_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.operation_bancaires ALTER COLUMN operation_id SET DEFAULT nextval('public.operation_bancaires_operation_id_seq'::regclass);


--
-- TOC entry 3219 (class 2604 OID 16985)
-- Name: patients patient_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.patients ALTER COLUMN patient_id SET DEFAULT nextval('public.patients_patient_id_seq'::regclass);


--
-- TOC entry 3220 (class 2604 OID 16986)
-- Name: personal_access_tokens id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.personal_access_tokens ALTER COLUMN id SET DEFAULT nextval('public.personal_access_tokens_id_seq'::regclass);


--
-- TOC entry 3222 (class 2604 OID 16987)
-- Name: produit_commandes produit_commande_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_commandes ALTER COLUMN produit_commande_id SET DEFAULT nextval('public."produit_commandes_""produit_commande_id"" _seq"'::regclass);


--
-- TOC entry 3223 (class 2604 OID 16988)
-- Name: produit_correction_stocks produit_correction_stock_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_correction_stocks ALTER COLUMN produit_correction_stock_id SET DEFAULT nextval('public.produit_correction_stocks_produit_correction_stock_id_seq'::regclass);


--
-- TOC entry 3224 (class 2604 OID 16989)
-- Name: produit_entrees "produit_entree_id" ; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_entrees ALTER COLUMN """produit_entree_id"" " SET DEFAULT nextval('public."produit_entrees_""produit_entree_id"" _seq"'::regclass);


--
-- TOC entry 3225 (class 2604 OID 16990)
-- Name: produit_factures produit_facture_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_factures ALTER COLUMN produit_facture_id SET DEFAULT nextval('public.produit_factures_produit_facture_id_seq'::regclass);


--
-- TOC entry 3226 (class 2604 OID 16991)
-- Name: produit_reception_dps "produit_reception_dps_id" ; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_reception_dps ALTER COLUMN """produit_reception_dps_id"" " SET DEFAULT nextval('public."produit_reception_dps_""produit_reception_dps_id"" _seq"'::regclass);


--
-- TOC entry 3227 (class 2604 OID 16992)
-- Name: produit_reception_sis produit_reception_si_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_reception_sis ALTER COLUMN produit_reception_si_id SET DEFAULT nextval('public.produit_reception_sis_produit_reception_si_id_seq'::regclass);


--
-- TOC entry 3229 (class 2604 OID 16993)
-- Name: produit_receptions produit_reception_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_receptions ALTER COLUMN produit_reception_id SET DEFAULT nextval('public."produit_receptions_""produit_reception_id"" _seq"'::regclass);


--
-- TOC entry 3230 (class 2604 OID 16994)
-- Name: produit_sorties "produit_sortie_id" ; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_sorties ALTER COLUMN """produit_sortie_id"" " SET DEFAULT nextval('public."produit_sorties_""produit_sortie_id"" _seq"'::regclass);


--
-- TOC entry 3231 (class 2604 OID 16995)
-- Name: produit_transfert_dps produit_transfert_dps_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_transfert_dps ALTER COLUMN produit_transfert_dps_id SET DEFAULT nextval('public.produit_transfert_dps_produit_transfert_dps_id_seq'::regclass);


--
-- TOC entry 3232 (class 2604 OID 16996)
-- Name: produit_transfert_sis produit_transfert_si_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_transfert_sis ALTER COLUMN produit_transfert_si_id SET DEFAULT nextval('public.produit_transfert_sis_produit_transfert_si_id_seq'::regclass);


--
-- TOC entry 3235 (class 2604 OID 16997)
-- Name: produit_transferts produit_transfert_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_transferts ALTER COLUMN produit_transfert_id SET DEFAULT nextval('public."produit_transferts_""produit_transfert_id"" _seq"'::regclass);


--
-- TOC entry 3236 (class 2604 OID 16998)
-- Name: produit_ventes produit_vente_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_ventes ALTER COLUMN produit_vente_id SET DEFAULT nextval('public.produit_ventes_produit_vente_id_seq'::regclass);


--
-- TOC entry 3240 (class 2604 OID 16999)
-- Name: produits produit_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produits ALTER COLUMN produit_id SET DEFAULT nextval('public.produits_produit_id_seq'::regclass);


--
-- TOC entry 3241 (class 2604 OID 17000)
-- Name: profil_users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.profil_users ALTER COLUMN id SET DEFAULT nextval('public.profil_users_id_seq'::regclass);


--
-- TOC entry 3242 (class 2604 OID 17001)
-- Name: profils profil_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.profils ALTER COLUMN profil_id SET DEFAULT nextval('public.profils_profil_id_seq'::regclass);


--
-- TOC entry 3243 (class 2604 OID 17002)
-- Name: reception_dps reception_dps_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reception_dps ALTER COLUMN reception_dps_id SET DEFAULT nextval('public.reception_dps_reception_dps_id_seq'::regclass);


--
-- TOC entry 3246 (class 2604 OID 17003)
-- Name: reception_sis reception_si_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reception_sis ALTER COLUMN reception_si_id SET DEFAULT nextval('public.reception_sis_reception_si_id_seq'::regclass);


--
-- TOC entry 3248 (class 2604 OID 17004)
-- Name: receptions reception_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.receptions ALTER COLUMN reception_id SET DEFAULT nextval('public.receptions_reception_id_seq'::regclass);


--
-- TOC entry 3250 (class 2604 OID 17005)
-- Name: reglements reglement_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reglements ALTER COLUMN reglement_id SET DEFAULT nextval('public.reglements_regelement_id_seq'::regclass);


--
-- TOC entry 3251 (class 2604 OID 17006)
-- Name: sorties sortie_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sorties ALTER COLUMN sortie_id SET DEFAULT nextval('public.sorties_sortie_id_seq'::regclass);


--
-- TOC entry 3254 (class 2604 OID 17007)
-- Name: stock_produits stock_produit_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stock_produits ALTER COLUMN stock_produit_id SET DEFAULT nextval('public.stock_produits_stock_produit_id_seq'::regclass);


--
-- TOC entry 3258 (class 2604 OID 17008)
-- Name: transfert_dps transfert_dps_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transfert_dps ALTER COLUMN transfert_dps_id SET DEFAULT nextval('public.transfert_dps_transfert_dps_id_seq'::regclass);


--
-- TOC entry 3259 (class 2604 OID 17009)
-- Name: transfert_sis transfert_si_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transfert_sis ALTER COLUMN transfert_si_id SET DEFAULT nextval('public.transfert_sis_transfert_si_id_seq'::regclass);


--
-- TOC entry 3261 (class 2604 OID 17010)
-- Name: transferts transfert_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transferts ALTER COLUMN transfert_id SET DEFAULT nextval('public.transferts_transfert_id_seq'::regclass);


--
-- TOC entry 3263 (class 2604 OID 17011)
-- Name: users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.users ALTER COLUMN id SET DEFAULT nextval('public.users_id_seq'::regclass);


--
-- TOC entry 3264 (class 2604 OID 17012)
-- Name: validations validation_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.validations ALTER COLUMN validation_id SET DEFAULT nextval('public.validations_validation_id_seq'::regclass);


--
-- TOC entry 3265 (class 2604 OID 17013)
-- Name: valider_commande_controllers validation_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.valider_commande_controllers ALTER COLUMN validation_id SET DEFAULT nextval('public.valider_commande_controllers_validation_id_seq'::regclass);


--
-- TOC entry 3267 (class 2604 OID 17014)
-- Name: ventes vente_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ventes ALTER COLUMN vente_id SET DEFAULT nextval('public.ventes_vente_id_seq'::regclass);


--
-- TOC entry 3508 (class 0 OID 16572)
-- Dependencies: 200
-- Data for Name: assurances; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.assurances (assurance_id, nom, statut, centre_id, created_at, updated_at, taux) FROM stdin;
11	AMBULANT	t	1	2023-08-08 03:51:52	2023-08-08 03:51:52	0
21	INAM	t	1	2023-08-08 03:52:19	2023-08-08 03:52:19	80
31	SCHOOL ASSUR	t	1	2023-08-08 03:52:29	2023-08-08 03:52:29	100
41	SALAM	f	1	2023-08-08 03:52:37	2023-08-08 03:55:15	70
51	fgf	f	1	2023-08-08 03:58:03	2023-08-08 03:58:10	9
62	AMBULANTS	t	2	2023-08-08 09:37:49	2023-08-08 09:37:49	0
72	SUNU	t	2	2023-08-08 09:37:59	2023-08-08 09:37:59	70
81	SANTEE INTEGREE	t	1	2023-11-02 16:33:23	2023-11-02 16:33:23	100
\.


--
-- TOC entry 3510 (class 0 OID 16578)
-- Dependencies: 202
-- Data for Name: categories; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.categories (categorie_id, libelle, type, statut, created_at, updated_at) FROM stdin;
2	Produits pharmaceutiques	Stockable	t	2023-08-01 10:00:16	2023-08-01 10:01:28
4	Consommables	Stockable	t	2023-08-01 10:02:09	2023-08-01 10:02:09
5	Articles	Stockable	t	2023-08-01 10:02:23	2023-08-01 10:02:23
6	test	Non_stockable	f	2023-08-01 10:04:27	2023-08-01 10:06:06
7	ECG	Non_stockable	t	2023-08-01 10:07:28	2023-08-01 10:07:28
8	CONSULATATION	Non_stockable	t	2023-08-08 09:15:05	2023-08-08 09:15:05
3	Acte	Non_stockable	t	2023-08-01 10:01:50	2023-08-08 09:31:02
9	TEST	Stockable	t	2023-08-08 09:32:06	2023-08-08 09:32:06
10	c est comment	Stockable	t	2023-08-20 10:04:35	2023-12-13 11:06:34
11	Test2	Stockable	t	2023-12-13 11:20:28	2024-01-28 11:28:01
12	NEW CAT	Non_stockable	t	2024-01-28 11:28:27	2024-01-28 11:28:27
13	Deplacement ASC	Non_stockable	t	2024-02-25 20:29:36	2024-02-25 20:29:36
14	Deplacement ASC	Non_stockable	t	2024-02-25 20:29:43	2024-02-25 20:29:43
16	esai	Stockable	t	2024-02-25 22:06:23	2024-02-25 22:06:23
\.


--
-- TOC entry 3512 (class 0 OID 16587)
-- Dependencies: 204
-- Data for Name: centres; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.centres (centre_id, nom_centre, services, autorisation, adresse, telephone, impression, statut, created_at, updated_at, dps_id) FROM stdin;
1	CMS ADABAWERE	Medecine Generale, Laboratoire, ECG, Imagerie, Kinesitherapie	0976-MS/DRLC	Face EPP Baguida	22 43 45 56 / 88  00 55 66	A4	t	\N	\N	1
2	CMS BANGELI	Medecine Generale, Laboratoire, ECG, Imagerie, Kinesitherapie	2002	Deriere CEG CENTRE	228	A4	t	\N	\N	1
3	CMS NADOBA	Medecine Generale, Laboratoire, ECG, Imagerie, Kinesitherapie	SIT GEO	SIT GEO	228	A4	t	\N	\N	1
4	USP KPINDI	Medecine Generale, Laboratoire, ECG, Imagerie, Kinesitherapie	2000	KPINDI	228	A4	t	\N	\N	1
7	USP N'JEI	Medecine Generale, Laboratoire,, Imagerie, Kinesitherapie	2009	N'JEI	228	A4	t	\N	\N	1
8	USP NAWARE	Medecine Generale, Laboratoire, ECG, Imagerie, Kinesitherapie	2001	NAWARE	00228	A4	t	\N	\N	1
5	USP DJAMDE	Medecine Generale, Laboratoire, ECG, Imagerie, Kinesitherapie	2001	DJAMDE	228	A4	t	\N	\N	2
6	USP SARAKAWA	Medecine Generale, Laboratoire, ECG, Imagerie, Kinesitherapie	2008	SARAKAWA	228 90876543	Format_A5	t	\N	2023-11-21 17:22:16	2
16	DIRECTION PROFECTORALE	DIRECTION	DIRECTION	DIRECTION	DIRECTION	DIRECTION	t	\N	\N	5
17	SANTEE INTEGREE / INTEGRATE HEALTH	SANTEE INTEGREE / INTEGRATE HEALTH	SANTEE INTEGREE / INTEGRATE HEALTH	SANTEE INTEGREE / INTEGRATE HEALTH	SANTEE INTEGREE / INTEGRATE HEALTH	Format_A5	t	\N	2023-12-03 11:39:18	6
\.


--
-- TOC entry 3514 (class 0 OID 16596)
-- Dependencies: 206
-- Data for Name: commandes; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.commandes (commande_id, code, date_commande, date_valide, date_cloture, montant, user_id, centre_id, created_at, updated_at, etat, fournisseur_id, taux, dps_id) FROM stdin;
26	001CMDE11202311	2023-11-04	\N	\N	1202961.00	1	1	2023-11-04 18:25:23	2023-11-04 18:28:17	Livree	21	100	1
28	001CMDE11202335	2023-11-09	\N	\N	3101520.00	3	5	2023-11-09 16:50:32	2023-11-09 18:27:35	Livree	11	100	1
29	001CMDE11202322	2023-11-09	\N	\N	2196777.00	2	2	2023-11-09 17:00:11	2023-11-09 18:57:55	Livree	42	100	1
27	002CMDE11202311	2023-11-08	\N	\N	259187.00	1	1	2023-11-08 17:15:40	2023-11-09 19:11:01	Livree	11	100	1
30	003CMDE11202311	2023-11-10	\N	\N	131341.00	1	1	2023-11-10 11:14:33	2023-11-10 11:16:16	Partielle	11	98	1
31	001CMDE11202377	2023-11-10	\N	\N	89588.00	7	7	2023-11-10 12:43:39	2023-11-10 12:44:38	Livree	21	100	1
32	002CMDE11202377	2023-11-23	\N	\N	1986.00	7	7	2023-11-23 18:32:24	2023-11-23 18:32:24	Encours	21	0	1
33	003CMDE11202377	2023-11-23	\N	\N	750605.00	7	7	2023-11-23 19:36:37	2023-11-23 19:36:37	Encours	21	0	1
34	001CMDE112023917	2023-11-27	\N	\N	181207.00	9	17	2023-11-27 20:15:28	2023-11-27 20:15:28	Encours	21	0	1
35	001CMDE012024917	2024-01-28	\N	\N	581923.00	9	17	2024-01-28 11:35:07	2024-01-28 11:35:07	Encours	21	0	1
\.


--
-- TOC entry 3516 (class 0 OID 16602)
-- Dependencies: 208
-- Data for Name: compte_bancaires; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.compte_bancaires (compte_id, numero_compte, banque, centre_id, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3518 (class 0 OID 16607)
-- Dependencies: 210
-- Data for Name: correction_stocks; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.correction_stocks (correction_stock_id, date_cs, code_cs, motif, magasin_id, centre_id, user_id, created_at, updated_at, cout) FROM stdin;
\.


--
-- TOC entry 3520 (class 0 OID 16615)
-- Dependencies: 212
-- Data for Name: directions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.directions (dps_id, dps_nom, created_at, updated_at) FROM stdin;
1	DPS BASSAR	\N	\N
2	DPS BINAH	\N	\N
3	DPS DANKPEN	\N	\N
4	DPS KERAN	\N	\N
5	DPS KOZAH	\N	\N
6	SANTEE INTEGREE / INTEGRATE HEALTH	\N	\N
\.


--
-- TOC entry 3522 (class 0 OID 16620)
-- Dependencies: 214
-- Data for Name: droit_profils; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.droit_profils (id, droit_id, profil_id, created_at, updated_at) FROM stdin;
1090	48	28	2023-12-26 15:54:25	2023-12-26 15:54:25
1091	69	28	2023-12-26 15:54:25	2023-12-26 15:54:25
1092	70	28	2023-12-26 15:54:25	2023-12-26 15:54:25
1093	71	28	2023-12-26 15:54:25	2023-12-26 15:54:25
1094	73	28	2023-12-26 15:54:25	2023-12-26 15:54:25
1095	76	28	2023-12-26 15:54:25	2023-12-26 15:54:25
1096	7	28	2023-12-26 15:54:25	2023-12-26 15:54:25
1097	42	28	2023-12-26 15:54:25	2023-12-26 15:54:25
1098	44	28	2023-12-26 15:54:25	2023-12-26 15:54:25
1099	3	28	2023-12-26 15:54:25	2023-12-26 15:54:25
1100	49	28	2023-12-26 15:54:25	2023-12-26 15:54:25
994	29	26	2023-12-26 07:15:02	2023-12-26 07:15:02
995	51	26	2023-12-26 07:15:02	2023-12-26 07:15:02
996	27	26	2023-12-26 07:15:02	2023-12-26 07:15:02
997	28	26	2023-12-26 07:15:02	2023-12-26 07:15:02
998	13	26	2023-12-26 07:15:02	2023-12-26 07:15:02
999	15	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1000	52	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1001	14	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1002	6	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1003	5	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1004	54	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1005	4	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1006	19	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1007	48	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1008	53	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1009	22	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1010	21	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1011	20	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1012	39	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1013	58	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1014	41	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1015	40	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1016	38	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1017	37	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1018	56	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1019	36	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1020	57	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1021	16	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1022	18	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1023	17	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1024	69	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1025	70	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1026	71	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1027	59	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1028	11	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1029	10	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1030	12	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1031	78	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1032	74	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1033	73	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1034	72	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1035	77	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1036	76	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1037	75	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1038	79	26	2023-12-26 07:15:02	2023-12-26 07:15:02
938	57	29	2023-12-13 11:00:00	2023-12-13 11:00:00
939	16	29	2023-12-13 11:00:00	2023-12-13 11:00:00
940	18	29	2023-12-13 11:00:00	2023-12-13 11:00:00
941	17	29	2023-12-13 11:00:00	2023-12-13 11:00:00
942	70	29	2023-12-13 11:00:00	2023-12-13 11:00:00
943	59	29	2023-12-13 11:00:00	2023-12-13 11:00:00
944	11	29	2023-12-13 11:00:00	2023-12-13 11:00:00
945	10	29	2023-12-13 11:00:00	2023-12-13 11:00:00
946	12	29	2023-12-13 11:00:00	2023-12-13 11:00:00
947	78	29	2023-12-13 11:00:00	2023-12-13 11:00:00
948	72	29	2023-12-13 11:00:00	2023-12-13 11:00:00
949	75	29	2023-12-13 11:00:00	2023-12-13 11:00:00
950	79	29	2023-12-13 11:00:00	2023-12-13 11:00:00
951	66	29	2023-12-13 11:00:00	2023-12-13 11:00:00
952	7	29	2023-12-13 11:00:00	2023-12-13 11:00:00
953	8	29	2023-12-13 11:00:00	2023-12-13 11:00:00
954	60	29	2023-12-13 11:00:00	2023-12-13 11:00:00
955	9	29	2023-12-13 11:00:00	2023-12-13 11:00:00
956	67	29	2023-12-13 11:00:00	2023-12-13 11:00:00
957	68	29	2023-12-13 11:00:00	2023-12-13 11:00:00
958	26	29	2023-12-13 11:00:00	2023-12-13 11:00:00
959	24	29	2023-12-13 11:00:00	2023-12-13 11:00:00
960	23	29	2023-12-13 11:00:00	2023-12-13 11:00:00
961	25	29	2023-12-13 11:00:00	2023-12-13 11:00:00
962	61	29	2023-12-13 11:00:00	2023-12-13 11:00:00
963	35	29	2023-12-13 11:00:00	2023-12-13 11:00:00
964	62	29	2023-12-13 11:00:00	2023-12-13 11:00:00
965	33	29	2023-12-13 11:00:00	2023-12-13 11:00:00
966	34	29	2023-12-13 11:00:00	2023-12-13 11:00:00
967	42	29	2023-12-13 11:00:00	2023-12-13 11:00:00
968	44	29	2023-12-13 11:00:00	2023-12-13 11:00:00
969	43	29	2023-12-13 11:00:00	2023-12-13 11:00:00
970	31	29	2023-12-13 11:00:00	2023-12-13 11:00:00
971	30	29	2023-12-13 11:00:00	2023-12-13 11:00:00
972	32	29	2023-12-13 11:00:00	2023-12-13 11:00:00
973	2	29	2023-12-13 11:00:00	2023-12-13 11:00:00
974	50	29	2023-12-13 11:00:00	2023-12-13 11:00:00
975	3	29	2023-12-13 11:00:00	2023-12-13 11:00:00
976	49	29	2023-12-13 11:00:00	2023-12-13 11:00:00
977	46	29	2023-12-13 11:00:00	2023-12-13 11:00:00
978	65	29	2023-12-13 11:00:00	2023-12-13 11:00:00
979	64	29	2023-12-13 11:00:00	2023-12-13 11:00:00
980	63	29	2023-12-13 11:00:00	2023-12-13 11:00:00
981	45	29	2023-12-13 11:00:00	2023-12-13 11:00:00
982	47	29	2023-12-13 11:00:00	2023-12-13 11:00:00
1039	66	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1040	7	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1041	8	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1042	60	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1043	9	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1044	67	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1045	68	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1046	26	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1047	24	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1048	23	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1049	25	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1050	61	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1051	35	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1052	62	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1053	33	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1054	34	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1055	42	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1056	44	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1057	43	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1058	31	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1059	30	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1060	32	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1061	2	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1062	50	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1063	3	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1064	49	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1065	46	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1066	65	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1067	64	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1068	63	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1069	45	26	2023-12-26 07:15:02	2023-12-26 07:15:02
1070	47	26	2023-12-26 07:15:02	2023-12-26 07:15:02
913	29	29	2023-12-13 11:00:00	2023-12-13 11:00:00
914	51	29	2023-12-13 11:00:00	2023-12-13 11:00:00
915	27	29	2023-12-13 11:00:00	2023-12-13 11:00:00
916	28	29	2023-12-13 11:00:00	2023-12-13 11:00:00
917	13	29	2023-12-13 11:00:00	2023-12-13 11:00:00
918	15	29	2023-12-13 11:00:00	2023-12-13 11:00:00
919	52	29	2023-12-13 11:00:00	2023-12-13 11:00:00
920	14	29	2023-12-13 11:00:00	2023-12-13 11:00:00
921	6	29	2023-12-13 11:00:00	2023-12-13 11:00:00
922	5	29	2023-12-13 11:00:00	2023-12-13 11:00:00
923	54	29	2023-12-13 11:00:00	2023-12-13 11:00:00
924	4	29	2023-12-13 11:00:00	2023-12-13 11:00:00
925	19	29	2023-12-13 11:00:00	2023-12-13 11:00:00
926	53	29	2023-12-13 11:00:00	2023-12-13 11:00:00
927	22	29	2023-12-13 11:00:00	2023-12-13 11:00:00
928	21	29	2023-12-13 11:00:00	2023-12-13 11:00:00
929	20	29	2023-12-13 11:00:00	2023-12-13 11:00:00
930	39	29	2023-12-13 11:00:00	2023-12-13 11:00:00
931	58	29	2023-12-13 11:00:00	2023-12-13 11:00:00
932	41	29	2023-12-13 11:00:00	2023-12-13 11:00:00
933	40	29	2023-12-13 11:00:00	2023-12-13 11:00:00
934	38	29	2023-12-13 11:00:00	2023-12-13 11:00:00
935	37	29	2023-12-13 11:00:00	2023-12-13 11:00:00
936	56	29	2023-12-13 11:00:00	2023-12-13 11:00:00
937	36	29	2023-12-13 11:00:00	2023-12-13 11:00:00
1119	13	23	2024-01-29 09:16:41	2024-01-29 09:16:41
1120	15	23	2024-01-29 09:16:43	2024-01-29 09:16:43
1121	14	23	2024-01-29 09:16:43	2024-01-29 09:16:43
1122	6	23	2024-01-29 09:16:44	2024-01-29 09:16:44
1123	5	23	2024-01-29 09:16:44	2024-01-29 09:16:44
1124	4	23	2024-01-29 09:16:44	2024-01-29 09:16:44
1125	39	23	2024-01-29 09:16:45	2024-01-29 09:16:45
1126	56	23	2024-01-29 09:16:45	2024-01-29 09:16:45
1127	36	23	2024-01-29 09:16:46	2024-01-29 09:16:46
1128	57	23	2024-01-29 09:16:46	2024-01-29 09:16:46
1129	16	23	2024-01-29 09:16:46	2024-01-29 09:16:46
1130	11	23	2024-01-29 09:16:47	2024-01-29 09:16:47
1131	78	23	2024-01-29 09:16:47	2024-01-29 09:16:47
1132	72	23	2024-01-29 09:16:47	2024-01-29 09:16:47
1133	75	23	2024-01-29 09:16:48	2024-01-29 09:16:48
1134	79	23	2024-01-29 09:16:48	2024-01-29 09:16:48
1135	66	23	2024-01-29 09:16:48	2024-01-29 09:16:48
1136	7	23	2024-01-29 09:16:49	2024-01-29 09:16:49
1137	8	23	2024-01-29 09:16:49	2024-01-29 09:16:49
1138	60	23	2024-01-29 09:16:50	2024-01-29 09:16:50
1139	9	23	2024-01-29 09:16:50	2024-01-29 09:16:50
1140	2	23	2024-01-29 09:16:50	2024-01-29 09:16:50
1141	3	23	2024-01-29 09:16:51	2024-01-29 09:16:51
1142	19	25	2024-01-29 09:23:18	2024-01-29 09:23:18
1143	78	25	2024-01-29 09:23:19	2024-01-29 09:23:19
1144	45	25	2024-01-29 09:23:20	2024-01-29 09:23:20
1147	15	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1148	6	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1149	5	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1150	4	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1151	69	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1152	70	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1153	71	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1154	11	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1155	10	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1156	12	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1157	74	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1158	7	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1159	8	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1160	9	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1161	2	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1162	3	27	2024-02-26 08:40:44	2024-02-26 08:40:44
1163	29	24	2024-02-26 08:47:23	2024-02-26 08:47:23
1164	51	24	2024-02-26 08:47:27	2024-02-26 08:47:27
1165	27	24	2024-02-26 08:47:27	2024-02-26 08:47:27
1166	39	24	2024-02-26 08:47:28	2024-02-26 08:47:28
1167	36	24	2024-02-26 08:47:28	2024-02-26 08:47:28
1168	23	24	2024-02-26 08:47:28	2024-02-26 08:47:28
1169	33	24	2024-02-26 08:47:29	2024-02-26 08:47:29
1170	42	24	2024-02-26 08:47:29	2024-02-26 08:47:29
1171	44	24	2024-02-26 08:47:30	2024-02-26 08:47:30
\.


--
-- TOC entry 3524 (class 0 OID 16625)
-- Dependencies: 216
-- Data for Name: droits; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.droits (droit_id, code, groupe, nom, created_at, updated_at, statut) FROM stdin;
2	editer	utilisateur	Editer un utilisateur	\N	\N	t
3	supprimer	utilisateur	Supprimer un utilisateur	\N	\N	t
4	lister	categorie	Lister les catégories	\N	\N	t
5	editer	categorie	Editer une catégorie	\N	\N	t
6	supprimer	categorie	Supprimer une catégorie	\N	\N	t
7	lister	produit	Lister les produits	\N	\N	t
8	editer	produit	Editer un produit	\N	\N	t
9	supprimer	produit	Supprimer un produit	\N	\N	t
10	lister	magasin	Lister les magasins	\N	\N	t
11	editer	magasin	Editer un magasin	\N	\N	t
12	supprimer	magasin	Supprimer un magasin	\N	\N	t
13	lister	assurance	Lister les assurances	\N	\N	t
14	editer	assurance	Editer une assurance	\N	\N	t
15	supprimer	assurance	Supprimer une assurance	\N	\N	t
16	lister	fournisseur	Lister les fournisseurs	\N	\N	t
17	editer	fournisseur	Editer un fournisseur	\N	\N	t
18	supprimer	fournisseur	Supprimer un fournisseur	\N	\N	t
19	lister	commande	Lister les commandes	\N	\N	t
20	editer	commande	Editer une commande	\N	\N	t
21	annuler	commande	Annuler une commande	\N	\N	t
22	supprimer	commande	Supprimer une commande	\N	\N	t
23	lister	reception_commande	Lister les récéptions de commande	\N	\N	t
24	editer	reception_commande	Editer une réception de commande	\N	\N	t
25	annuler	reception_commande	Annuler une réception de commande	\N	\N	t
26	supprimer	reception_commande	Supprimer une réception de commande	\N	\N	t
27	lister	achat	Lister les achats	\N	\N	t
28	editer	achat	Editer un achat	\N	\N	t
29	supprimer	achat	Supprimer un achat	\N	\N	t
30	lister	transfert	Lister les transferts	\N	\N	t
31	editer	transfert	Editer un transfert	\N	\N	t
32	supprimer	transfert	Supprimer un transfert	\N	\N	t
33	lister	sortie	Lister les sorties de stock	\N	\N	t
34	editer	sortie	Editer une sortie de stock	\N	\N	t
35	supprimer	sortie	Supprimer une sortie de stock	\N	\N	t
36	lister	entree	Lister les entrées de stock	\N	\N	t
37	editer	entree	Editer une entrée de stock	\N	\N	t
38	supprimer	entree	Supprimer une entrée de stock	\N	\N	t
39	lister	confection_kit	Lister les confections de kit	\N	\N	t
40	editer	confection_kit	Editer une confection de kit	\N	\N	t
41	supprimer	confection_kit	Supprimer une confection de kit	\N	\N	t
42	lister	stock	Afficher l'état du stock	\N	\N	t
43	corriger	stock	Corriger le niveau du stock	\N	\N	t
44	inventaire	stock	Gérer l'inventaire	\N	\N	t
45	creer	vente	Enregistrer une vente	\N	\N	t
46	editer	vente	Editer une vente	\N	\N	t
47	annuler	vente	Annuler une vente	\N	\N	t
48	valider	commande	Valider une commande	\N	\N	t
49	creer	utilisateur	Creer un utilisateur	\N	\N	t
50	lister	utilisateur	Liste des utilisateurs	\N	\N	t
51	creer	achat	Enregistrer un achat	\N	\N	t
52	creer	assurance	Creer une assurance	\N	\N	t
53	creer	commande	Creer une commande	\N	\N	t
54	creer	categorie	Creer une categorie	\N	\N	t
56	creer	entree	Enregistrer une entree en stock	\N	\N	t
57	creer	fournisseur	Creer un fournisseur	\N	\N	t
58	Creer	confection_kit	Creer un kit	\N	\N	t
59	creer	magasin	Creer un magasin	\N	\N	t
60	creer	produit	Creer un produit	\N	\N	t
61	creer	reception_commande	Enregistrer une reception de commande	\N	\N	t
62	creer	sortie	Enregistrer une sortie de produit	\N	\N	t
65	etat_assurance	vente	Situation des assurances	\N	\N	t
64	etat_recette	vente	Etat des recettes	\N	\N	t
63	encaisser	vente	Encaisser une vente	\N	\N	t
67	creer	profil	Creer un profil	\N	\N	t
66	creer	operation	Operation bancaire	\N	\N	t
71	statistique	global	Voir les statistiques globaux	\N	\N	t
70	etatrecette	global	Etat des recettes globales	\N	\N	t
69	etatstock	global	Etat du stock global	\N	\N	t
68	lister	profil	Lister les profils	\N	\N	t
74	si	menu	Section Sante Integree	\N	\N	t
73	dps	menu	Section DPS	\N	\N	t
72	donnee	menu	Acceder aux donnees de base	\N	\N	t
77	usersi	menu	Gerer les utilisateurs des partenaires	\N	\N	t
76	userdps	menu	Gerer les utilisateurs de la DPS	\N	\N	t
75	userfs	menu	Gerer les utilisateurs de la formation sanitaire	\N	\N	t
79	stock	menu	Module de gestion de stock	\N	\N	t
78	caisse	menu	Module de gestion de caisse	\N	\N	t
\.


--
-- TOC entry 3526 (class 0 OID 16634)
-- Dependencies: 218
-- Data for Name: entrees; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.entrees (entree_id, code, date, motif, cout, mag_num, user_id, centre_id, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3528 (class 0 OID 16642)
-- Dependencies: 220
-- Data for Name: factures; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.factures (facture_id, code, date, total, prise_encharge, part_patient, montant_recu, reliquat, user_id, centre_id, assurance_id, patient_id, magasin_id, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3530 (class 0 OID 16647)
-- Dependencies: 222
-- Data for Name: failed_jobs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.failed_jobs (id, uuid, connection, queue, payload, exception, failed_at) FROM stdin;
\.


--
-- TOC entry 3532 (class 0 OID 16656)
-- Dependencies: 224
-- Data for Name: fournisseurs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.fournisseurs (fournisseur_id, nom, adresse, ville, email, telephone, centre_id, created_at, updated_at, statut) FROM stdin;
21	ENICI SARL	Agoe minamadou	Lome	enici@yahoo.fr	+228	1	2023-08-08 05:51:38	2023-08-08 05:51:38	t
11	CAMED	Rue Coketi	Lome	cameg@gmail.com	+228 22 33 44 55	1	2023-08-08 05:50:12	2023-08-08 05:52:17	t
31	OURO-DJOBO Fichal	Agoe Sogbossito	Lome	fichal84@gmail.com	+22891943624	1	2023-08-08 05:54:12	2023-08-08 05:54:19	f
42	IBU Pharm	Zone Portuaire	Lome	inupharma@yahoo.fr	+228	2	2023-11-09 16:59:54	2023-11-09 16:59:54	t
\.


--
-- TOC entry 3534 (class 0 OID 16665)
-- Dependencies: 226
-- Data for Name: initialisations; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.initialisations (ini_id, code, date, motif, user_id, centre_id, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3536 (class 0 OID 16673)
-- Dependencies: 228
-- Data for Name: magasins; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.magasins (magasin_id, libelle, type, centre_id, statut, created_at, updated_at) FROM stdin;
3	Magasin principale	Magasin_Stockage	1	t	2023-08-01 13:16:25	2023-08-01 13:16:25
4	Magasin secondaire	Magasin_Stockage	1	t	2023-08-01 13:17:13	2023-08-01 17:41:09
6	tteeesss	Magasin_Stockage	1	f	2023-08-01 17:41:35	2023-08-01 17:41:39
7	Magasin principale	Magasin_Stockage	2	t	2023-08-08 09:11:04	2023-08-08 09:11:04
8	DP01	Depot_vente	2	t	2023-08-08 09:12:16	2023-08-08 09:12:16
5	Stock KOSSI	Stock_AEC	1	t	2023-08-01 14:13:38	2023-08-30 12:25:28
9	Magasin principale	Magasin_Stockage	5	t	2023-11-09 16:47:09	2023-11-09 16:47:09
10	point de vente	Magasin_Stockage	5	t	2023-11-09 16:47:26	2023-11-09 16:47:26
11	Bernard EDEM	Stock_AEC	5	t	2023-11-09 16:47:42	2023-11-09 16:47:42
12	Magasin principale	Magasin_Stockage	7	t	2023-11-10 12:42:17	2023-11-10 12:42:17
13	Point de vente	Magasin_Stockage	7	t	2023-11-10 12:42:35	2023-11-10 12:42:35
\.


--
-- TOC entry 3538 (class 0 OID 16682)
-- Dependencies: 230
-- Data for Name: migrations; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.migrations (id, migration, batch) FROM stdin;
1	2014_10_12_000000_create_users_table	1
2	2014_10_12_100000_create_password_resets_table	1
3	2019_08_19_000000_create_failed_jobs_table	1
4	2019_12_14_000001_create_personal_access_tokens_table	1
5	2023_07_31_004242_create_categories_table	2
6	2023_07_31_004434_create_produits_table	2
7	2023_07_31_004509_create_magasins_table	2
8	2023_07_31_011321_create_centres_table	2
9	2023_08_07_111322_create_mutuelles_table	3
10	2023_08_07_111342_create_fournisseurs_table	3
11	2023_08_07_111357_create_commandes_table	3
12	2023_08_07_111421_create_receptions_table	3
13	2023_08_07_111436_create_transferts_table	3
14	2023_08_07_111450_create_entrees_table	3
15	2023_08_07_111503_create_sorties_table	3
16	2023_08_07_113747_create_assurances_table	3
17	2023_08_07_125136_create_produit_sorties_table	4
18	2023_08_07_125157_create_produit_entrees_table	4
19	2023_08_07_125224_create_produit_transferts_table	4
20	2023_08_07_125244_create_produit_receptions_table	4
21	2023_08_07_125301_create_produit_commandes_table	4
22	2023_08_15_080409_create_mouvements_table	5
23	2023_08_29_121959_create_stocks_table	5
24	2023_08_29_123015_create_stock_produits_table	5
25	2023_09_02_085127_create_profils_table	6
26	2023_09_02_085550_create_droits_table	6
27	2023_09_02_090032_create_droit_profil_pivot_table	6
28	2023_09_02_090045_create_profil_user_pivot_table	6
29	2023_09_22_135421_create_initialisations_table	7
30	2023_09_22_153148_create_valider_commande_controllers_table	7
31	2023_09_24_193704_create_validations_table	8
32	2023_09_25_121054_create_factures_table	8
33	2023_09_25_121222_create_produit_factures_table	8
34	2023_09_28_175011_create_reception_sis_table	9
35	2023_09_28_175111_create_produit_reception_sis_table	9
36	2023_09_28_175141_create_transfert_sis_table	9
37	2023_10_02_103410_create_news_prsi	10
38	2023_10_02_141529_create_produit_transfert_sis_table	11
39	2023_10_24_074341_create_correction_stocks_table	12
40	2023_10_24_074518_create_produit_correction_stocks_table	12
41	2023_10_30_195305_create_ventes_table	13
42	2023_10_31_113417_create_produit_ventes_table	13
43	2023_10_31_163553_create_patients_table	13
44	2023_10_31_164246_create_reglements_table	14
45	2023_10_31_164401_create_usercons_table	14
46	2023_11_02_174325_create_operation_bancaires_table	15
47	2023_11_02_175449_create_compte_bancaires_table	15
48	2023_11_12_173841_add_dps_to_users	16
49	2023_11_13_185653_create_droit_profils_table	17
50	2023_11_14_153235_create_droit_profils_table	18
51	2023_11_19_144026_create_directions_table	19
52	2023_11_19_144257_add_info_user_to_users	20
53	2023_11_21_133335_delete_colums_on_users	21
54	2023_11_21_133918_delete_colums_on_users	22
55	2023_11_21_170644_add_dps_id_to_centres	23
56	2023_11_23_080251_add_type_to_user	24
57	2023_11_23_115736_create_profil_users_table	25
58	2023_12_26_073412_create_reception_dps_table	26
59	2023_12_26_073445_create_transfert_dps_table	26
60	2023_12_26_073652_create_produit_reception_dps_table	26
61	2023_12_26_073721_create_produit_transfert_dps_table	26
62	2023_12_27_085746_add_dps_id_to_stock_produits	27
63	2023_12_27_090504_add_dps_id_to_mouvements	28
64	2023_12_27_101338_add_dps_id_to_ventes	29
65	2023_12_27_104758_add_dps_id_to_reglements	30
66	2024_01_03_114812_add_dps_id_to_transfert_dps	31
67	2024_01_03_121724_add_reception_dps_id_to_transfert_dps	32
68	2024_01_03_123106_add_reception_dps_id_to_transfert_dps	33
69	2024_01_03_133856_add_etat_liv_to_reception_dps	34
70	2024_01_29_172442_add_dps_id_to_commande	35
\.


--
-- TOC entry 3540 (class 0 OID 16687)
-- Dependencies: 232
-- Data for Name: mouvements; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mouvements (mouvement_id, date, produit_id, libelle, magasin_id, centre_id, qte_initiale, qte_entree, qte_sortie, qte_reelle, idop, created_at, updated_at, idcon, motif, user_id, dps_id) FROM stdin;
239	2023-11-09	801	ABUFENE	3	1	0	23	0	23	002REC11202311	2023-11-09 19:11:01	2023-11-09 19:11:01	501	Reception cmde 27 du lot 	1	1
240	2023-11-09	1196	DIPICOR	3	1	0	23	0	23	002REC11202311	2023-11-09 19:11:01	2023-11-09 19:11:01	502	Reception cmde 27 du lot 	1	1
241	2023-11-09	801	ABUFENE	3	1	23	0	7	16	001TR11202311	2023-11-09 19:11:25	2023-11-09 19:11:25	38	Transfert d article 001TR11202311 du lot 	\N	1
242	2023-11-09	801	ABUFENE	4	1	0	7	0	7	001TR11202311	2023-11-09 19:11:25	2023-11-09 19:11:25	38	Reception Transfert d article  du lot 	\N	1
243	2023-11-09	1196	DIPICOR	3	1	23	0	12	11	001TR11202311	2023-11-09 19:11:25	2023-11-09 19:11:25	39	Transfert d article 001TR11202311 du lot 	\N	1
244	2023-11-09	1196	DIPICOR	4	1	0	12	0	12	001TR11202311	2023-11-09 19:11:25	2023-11-09 19:11:25	39	Reception Transfert d article  du lot 	\N	1
245	2023-11-09	801	ABUFENE	3	1	16	0	6	10	002TR11202311	2023-11-09 19:11:39	2023-11-09 19:11:39	40	Transfert d article 002TR11202311 du lot 	\N	1
246	2023-11-09	801	ABUFENE	5	1	0	6	0	6	002TR11202311	2023-11-09 19:11:39	2023-11-09 19:11:39	40	Reception Transfert d article  du lot 	\N	1
247	2023-11-09	1196	DIPICOR	3	1	11	0	3	8	002TR11202311	2023-11-09 19:11:39	2023-11-09 19:11:39	41	Transfert d article 002TR11202311 du lot 	\N	1
248	2023-11-09	1196	DIPICOR	5	1	0	3	0	3	002TR11202311	2023-11-09 19:11:39	2023-11-09 19:11:39	41	Reception Transfert d article  du lot 	\N	1
249	2023-11-09	801	ABUFENE	4	1	7	0	1	6	015112311	2023-11-09 19:12:14	2023-11-09 19:12:14	36	Vente numero 015112311	\N	1
250	2023-11-09	1196	DIPICOR	4	1	12	0	2	10	015112311	2023-11-09 19:12:14	2023-11-09 19:12:14	37	Vente numero 015112311	\N	1
251	2023-11-10	32571	aaabbb	3	1	0	0	0	0	003REC11202311	2023-11-10 11:16:16	2023-11-10 11:16:16	505	Reception cmde 30 du lot 	1	1
252	2023-11-10	1144	LAROXYL	3	1	0	13	0	13	003REC11202311	2023-11-10 11:16:16	2023-11-10 11:16:16	506	Reception cmde 30 du lot 	1	1
253	2023-11-10	3048	SERINGUE	3	1	0	45	0	45	003REC11202311	2023-11-10 11:16:16	2023-11-10 11:16:16	503	Reception cmde 30 du lot 09	1	1
254	2023-11-10	123	PANADOL	3	1	0	90	0	90	003REC11202311	2023-11-10 11:16:16	2023-11-10 11:16:16	504	Reception cmde 30 du lot 	1	1
255	2023-11-10	286	DACRYOSERUM	13	7	0	23	0	23	001REC11202377	2023-11-10 12:44:38	2023-11-10 12:44:38	507	Reception cmde 31 du lot 	7	1
256	2023-11-10	3048	SERINGUE	13	7	0	45	0	45	001REC11202377	2023-11-10 12:44:38	2023-11-10 12:44:38	508	Reception cmde 31 du lot 	7	1
257	2023-11-10	973	ANALGIN	13	7	0	20	0	20	001REC11202377	2023-11-10 12:44:38	2023-11-10 12:44:38	509	Reception cmde 31 du lot 	7	1
258	2023-11-10	1653	CEFTRIAXONE	13	7	0	13	0	13	001REC11202377	2023-11-10 12:44:38	2023-11-10 12:44:38	510	Reception cmde 31 du lot 	7	1
259	2023-11-10	973	ANALGIN	13	7	20	0	2	18	01112377	2023-11-10 12:45:27	2023-11-10 12:45:27	38	Vente numero 01112377	\N	1
260	2023-11-10	1653	CEFTRIAXONE	13	7	13	0	1	12	01112377	2023-11-10 12:45:27	2023-11-10 12:45:27	39	Vente numero 01112377	\N	1
261	2023-11-10	3048	SERINGUE	13	7	45	0	2	43	01112377	2023-11-10 12:45:27	2023-11-10 12:45:27	40	Vente numero 01112377	\N	1
262	2023-11-10	286	DACRYOSERUM	13	7	23	0	3	20	02112377	2023-11-10 12:46:08	2023-11-10 12:46:08	41	Vente numero 02112377	\N	1
263	2023-11-10	3048	SERINGUE	13	7	43	0	2	41	02112377	2023-11-10 12:46:08	2023-11-10 12:46:08	42	Vente numero 02112377	\N	1
264	2023-11-10	1653	CEFTRIAXONE	13	7	12	0	3	9	02112377	2023-11-10 12:46:08	2023-11-10 12:46:08	43	Vente numero 02112377	\N	1
265	2023-11-10	973	ANALGIN	13	7	18	0	5	13	03112377	2023-11-10 12:46:50	2023-11-10 12:46:50	44	Vente numero 03112377	\N	1
266	2023-11-10	286	DACRYOSERUM	13	7	20	0	2	18	04112377	2023-11-10 12:47:13	2023-11-10 12:47:13	45	Vente numero 04112377	\N	1
267	2023-11-24	801	ABUFENE	5	1	6	0	1	5	011123261	2023-11-24 16:43:50	2023-11-24 16:43:50	46	Vente numero 011123261	\N	1
268	2023-11-24	1196	DIPICOR	5	1	3	0	2	1	011123261	2023-11-24 16:43:51	2023-11-24 16:43:51	47	Vente numero 011123261	\N	1
\.


--
-- TOC entry 3542 (class 0 OID 16700)
-- Dependencies: 234
-- Data for Name: mutuelles; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mutuelles (mutuelle_id, nom, statut, centre_id, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3544 (class 0 OID 16705)
-- Dependencies: 236
-- Data for Name: operation_bancaires; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.operation_bancaires (operation_id, date, type_operation, libelle, operant, initiale, entree, sortie, solde, user_id, centre_id, compte_id, created_at, updated_at) FROM stdin;
3	2023-11-02	Encaissement	initialisation	comptable	0	214000	0	214000	1	1	\N	2023-11-02 19:15:32	2023-11-02 19:17:27
4	2023-11-02	Decaissememnt	Deplacemwnt soglo	comptable	214000	0	5000	209000	1	1	\N	2023-11-02 19:18:05	2023-11-02 19:18:05
5	2024-01-29	Encaissement	Recette du jour	ERic	0	269000	0	269000	33	4	\N	2024-01-29 09:18:31	2024-01-29 09:18:31
6	2024-01-29	Decaissememnt	Deplacement ASC	Kossi	269000	0	2600	266400	33	4	\N	2024-01-29 09:19:17	2024-01-29 09:19:17
\.


--
-- TOC entry 3546 (class 0 OID 16713)
-- Dependencies: 238
-- Data for Name: password_resets; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.password_resets (email, token, created_at) FROM stdin;
\.


--
-- TOC entry 3547 (class 0 OID 16719)
-- Dependencies: 239
-- Data for Name: patients; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.patients (patient_id, code_patient, nom_prenom, sexe, age, assurance_id, created_at, updated_at) FROM stdin;
1	01ADAB231	AZALAKA POINT	Feminin	18	21	2023-11-03 10:23:15	2023-11-03 10:23:15
2	01ADAB231	AZALAKA POINT	Feminin	18	21	2023-11-03 10:23:52	2023-11-03 10:23:52
3	03ADAB231	DERMANE ISSA	Feminin	18	21	2023-11-03 10:25:51	2023-11-03 10:25:51
4	04ADAB231	DERMANE ISSA	Feminin	26	21	2023-11-03 10:27:15	2023-11-03 10:27:15
5	05ADAB231	ALAIN ISSA	Feminin	25	11	2023-11-09 19:12:07	2023-11-09 19:12:07
6	06N'JE237	ANASS TECH	Masculin	37	11	2023-11-10 12:45:20	2023-11-10 12:45:20
7	07ADAB231	BERTRAND	Feminin	18	11	2023-11-24 16:43:40	2023-11-24 16:43:40
\.


--
-- TOC entry 3549 (class 0 OID 16727)
-- Dependencies: 241
-- Data for Name: personal_access_tokens; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.personal_access_tokens (id, tokenable_type, tokenable_id, name, token, abilities, last_used_at, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3551 (class 0 OID 16735)
-- Dependencies: 243
-- Data for Name: produit_commandes; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produit_commandes (produit_commande_id, commande_id, produit_id, libelle, qte, prix_achat, montant, created_at, updated_at, code, reference, qte_liv) FROM stdin;
116	32	2466	AB-ZOLE	3	662	1986	2023-11-23 18:32:19	2023-11-23 18:32:19	002CMDE11202377	4410	0
87	26	549	ACARILBIAL	1	1750	1750	2023-11-04 18:22:20	2023-11-04 18:22:20	001CMDE11202311	667	0
88	26	2987	SERINGUE 2 Pièces	45	77	3465	2023-11-04 18:22:28	2023-11-04 18:22:28	001CMDE11202311	C000326	0
86	26	3144	1/3 TUBES	1	43846	43846	2023-11-04 18:22:16	2023-11-04 18:22:16	001CMDE11202311	D000099	1
90	26	1888	NIFEDIPINE	400	2827	1130800	2023-11-04 18:22:51	2023-11-04 18:22:58	001CMDE11202311	3522	400
89	26	113	ASPEGIC	60	385	23100	2023-11-04 18:22:37	2023-11-04 18:22:37	001CMDE11202311	126	60
91	27	801	ABUFENE	23	2438	56074	2023-11-08 17:15:18	2023-11-08 17:15:18	002CMDE11202311	1191	0
92	27	1196	DIPICOR	23	8831	203113	2023-11-08 17:15:33	2023-11-08 17:15:33	002CMDE11202311	1831	0
93	28	2686	ACETYLSALCYLATE DE LYSINE 0.5 g inj Flacon	130	385	50050	2023-11-09 16:48:24	2023-11-09 16:48:24	001CMDE11202335	C000003	0
94	28	1768	PARACETA-M	100	1212	121200	2023-11-09 16:48:38	2023-11-09 16:48:38	001CMDE11202335	3372	0
95	28	2557	PARACETAMOL	2000	573	1146000	2023-11-09 16:48:43	2023-11-09 16:48:43	001CMDE11202335	4535	0
96	28	3048	SERINGUE	250	62	15500	2023-11-09 16:48:54	2023-11-09 16:48:54	001CMDE11202335	C000397	0
97	28	1511	TICASSE	300	5654	1696200	2023-11-09 16:49:03	2023-11-09 16:49:03	001CMDE11202335	2347	0
98	28	513	ATEPADENE	10	3435	34350	2023-11-09 16:49:16	2023-11-09 16:49:16	001CMDE11202335	615	0
99	28	973	ANALGIN	30	538	16140	2023-11-09 16:49:24	2023-11-09 16:49:24	001CMDE11202335	1478	0
101	28	1653	CEFTRIAXONE	10	2208	22080	2023-11-09 16:49:45	2023-11-09 16:49:45	001CMDE11202335	3128	0
102	29	2167	DECODERM TRI	10	1969	19690	2023-11-09 16:58:00	2023-11-09 16:58:00	001CMDE11202322	4004	0
103	29	1672	SERUM ANTI-D	100	20200	2020000	2023-11-09 16:58:19	2023-11-09 16:58:19	001CMDE11202322	3229	0
104	29	2984	PERFUSEUR EN PVC	200	192	38400	2023-11-09 16:58:34	2023-11-09 16:58:34	001CMDE11202322	C000323	0
105	29	1586	APIOLINE DE CHAPOTEAUT	16	2288	36608	2023-11-09 16:58:48	2023-11-09 16:58:48	001CMDE11202322	2508	0
106	29	2757	EAU POUR PREPARATION INJECTABLE FLACON PLASTIQUE 10 ML	300	38	11400	2023-11-09 16:58:54	2023-11-09 16:58:54	001CMDE11202322	C000077	0
107	29	806	CELESTENE	23	3073	70679	2023-11-09 16:59:11	2023-11-09 16:59:11	001CMDE11202322	1197	0
108	30	32571	aaabbb	34	1000	34000	2023-11-10 11:13:37	2023-11-10 11:13:37	003CMDE11202311	\N	0
117	33	2649	ACCOFIL	23	30731	706813	2023-11-23 19:36:21	2023-11-23 19:36:21	003CMDE11202377	4669	0
118	33	3039	PARACETAMOL CODEINE CAFEINE	34	1288	43792	2023-11-23 19:36:31	2023-11-23 19:36:31	003CMDE11202377	C000385	0
111	30	1144	LAROXYL	13	2877	37401	2023-11-10 11:14:26	2023-11-10 11:14:26	003CMDE11202311	1754	0
109	30	3048	SERINGUE	45	62	2790	2023-11-10 11:13:44	2023-11-10 11:13:44	003CMDE11202311	C000397	45
110	30	123	PANADOL	90	635	57150	2023-11-10 11:14:01	2023-11-10 11:14:01	003CMDE11202311	136	90
112	31	286	DACRYOSERUM	23	2058	47334	2023-11-10 12:42:54	2023-11-10 12:42:54	001CMDE11202377	322	0
113	31	3048	SERINGUE	45	62	2790	2023-11-10 12:43:00	2023-11-10 12:43:00	001CMDE11202377	C000397	0
114	31	973	ANALGIN	20	538	10760	2023-11-10 12:43:07	2023-11-10 12:43:12	001CMDE11202377	1478	0
115	31	1653	CEFTRIAXONE	13	2208	28704	2023-11-10 12:43:31	2023-11-10 12:43:31	001CMDE11202377	3128	0
119	34	3144	1/3 TUBES	4	43846	175384	2023-11-27 20:15:03	2023-11-27 20:15:03	001CMDE112023917	D000099	0
120	34	2466	AB-ZOLE	4	662	2648	2023-11-27 20:15:10	2023-11-27 20:15:10	001CMDE112023917	4410	0
121	34	123	PANADOL	5	635	3175	2023-11-27 20:15:18	2023-11-27 20:15:18	001CMDE112023917	136	0
122	35	3144	1/3 TUBES	12	43846	526152	2024-01-28 11:34:21	2024-01-28 11:34:21	001CMDE012024917	D000099	0
123	35	2335	9-VIT	3	1589	4767	2024-01-28 11:34:27	2024-01-28 11:34:27	001CMDE012024917	4244	0
124	35	32571	aaabbb	43	1000	43000	2024-01-28 11:34:32	2024-01-28 11:34:32	001CMDE012024917	\N	0
125	35	3048	SERINGUE	30	62	1860	2024-01-28 11:34:43	2024-01-28 11:34:43	001CMDE012024917	C000397	0
126	35	2984	PERFUSEUR EN PVC	32	192	6144	2024-01-28 11:34:57	2024-01-28 11:34:57	001CMDE012024917	C000323	0
\.


--
-- TOC entry 3553 (class 0 OID 16741)
-- Dependencies: 245
-- Data for Name: produit_correction_stocks; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produit_correction_stocks (produit_correction_stock_id, correction_stock_id, code_cs, motif, qte, produit_id, libelle, created_at, updated_at, lot, stock_produit_id, pu, cout, magasin_id) FROM stdin;
\.


--
-- TOC entry 3555 (class 0 OID 16749)
-- Dependencies: 247
-- Data for Name: produit_entrees; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produit_entrees ("""produit_entree_id"" ", entree_id, produit_id, libelle, qte, prix_achat, montant, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3557 (class 0 OID 16754)
-- Dependencies: 249
-- Data for Name: produit_factures; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produit_factures (produit_facture_id, facture_id, code, produit_id, reference, libelle, lot, qte, prix_public, base_assurance, total, taux, prise_encharge, part_patient, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3559 (class 0 OID 16762)
-- Dependencies: 251
-- Data for Name: produit_reception_dps; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produit_reception_dps ("""produit_reception_dps_id"" ", reception_dps_id, code, produit_id, libelle, qte_commandee, qte_recue, qte_transferee, remarque, commande_id, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3561 (class 0 OID 16770)
-- Dependencies: 253
-- Data for Name: produit_reception_sis; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produit_reception_sis (produit_reception_si_id, reception_si_id, code, produit_id, libelle, qte_commandee, qte_recue, qte_transferee, remarque, commande_id, created_at, updated_at) FROM stdin;
112	32	001REC1120231	3144	1/3 TUBES	1	1	1	\N	26	2023-11-04 18:25:45	2023-11-04 18:25:45
113	32	001REC1120231	549	ACARILBIAL	1	1	1	\N	26	2023-11-04 18:25:45	2023-11-04 18:25:45
114	32	001REC1120231	2987	SERINGUE 2 Pièces	45	45	45	\N	26	2023-11-04 18:25:45	2023-11-04 18:25:45
115	32	001REC1120231	113	ASPEGIC	60	60	60	\N	26	2023-11-04 18:25:45	2023-11-04 18:25:45
116	32	001REC1120231	1888	NIFEDIPINE	400	400	400	\N	26	2023-11-04 18:25:45	2023-11-04 18:25:45
117	33	001REC1120232	2686	ACETYLSALCYLATE DE LYSINE 0.5 g inj Flacon	130	130	130	\N	28	2023-11-09 18:26:52	2023-11-09 18:26:52
118	33	001REC1120232	1768	PARACETA-M	100	100	100	\N	28	2023-11-09 18:26:52	2023-11-09 18:26:52
119	33	001REC1120232	2557	PARACETAMOL	2000	2000	2000	\N	28	2023-11-09 18:26:52	2023-11-09 18:26:52
120	33	001REC1120232	3048	SERINGUE	250	250	250	\N	28	2023-11-09 18:26:52	2023-11-09 18:26:52
121	33	001REC1120232	1511	TICASSE	300	300	300	\N	28	2023-11-09 18:26:52	2023-11-09 18:26:52
122	33	001REC1120232	513	ATEPADENE	10	10	10	\N	28	2023-11-09 18:26:52	2023-11-09 18:26:52
123	33	001REC1120232	973	ANALGIN	30	30	30	\N	28	2023-11-09 18:26:52	2023-11-09 18:26:52
124	33	001REC1120232	1653	CEFTRIAXONE	10	10	10	\N	28	2023-11-09 18:26:52	2023-11-09 18:26:52
125	34	001REC1120233	2167	DECODERM TRI	10	10	10	\N	29	2023-11-09 18:57:06	2023-11-09 18:57:06
126	34	001REC1120233	1672	SERUM ANTI-D	100	100	100	\N	29	2023-11-09 18:57:06	2023-11-09 18:57:06
127	34	001REC1120233	2984	PERFUSEUR EN PVC	200	200	200	\N	29	2023-11-09 18:57:06	2023-11-09 18:57:06
128	34	001REC1120233	1586	APIOLINE DE CHAPOTEAUT	16	16	16	\N	29	2023-11-09 18:57:06	2023-11-09 18:57:06
129	34	001REC1120233	2757	EAU POUR PREPARATION INJECTABLE FLACON PLASTIQUE 10 ML	300	300	300	\N	29	2023-11-09 18:57:06	2023-11-09 18:57:06
130	34	001REC1120233	806	CELESTENE	23	23	23	\N	29	2023-11-09 18:57:06	2023-11-09 18:57:06
131	35	002REC1120231	801	ABUFENE	23	23	23	\N	27	2023-11-09 19:10:33	2023-11-09 19:10:33
132	35	002REC1120231	1196	DIPICOR	23	23	23	\N	27	2023-11-09 19:10:33	2023-11-09 19:10:33
134	36	003REC1120231	3048	SERINGUE	45	45	45	\N	30	2023-11-10 11:14:51	2023-11-10 11:14:51
135	36	003REC1120231	123	PANADOL	90	90	90	\N	30	2023-11-10 11:14:51	2023-11-10 11:14:51
133	36	003REC1120231	32571	aaabbb	34	30	30	\N	30	2023-11-10 11:14:51	2023-11-10 11:14:57
137	37	004REC1120231	32571	aaabbb	34	4	4	\N	30	2023-11-10 11:15:10	2023-11-10 11:15:10
138	37	004REC1120231	1144	LAROXYL	13	13	13	\N	30	2023-11-10 11:15:10	2023-11-10 11:15:10
139	38	001REC1120237	286	DACRYOSERUM	23	23	23	\N	31	2023-11-10 12:43:56	2023-11-10 12:43:56
140	38	001REC1120237	3048	SERINGUE	45	45	45	\N	31	2023-11-10 12:43:56	2023-11-10 12:43:56
141	38	001REC1120237	973	ANALGIN	20	20	20	\N	31	2023-11-10 12:43:56	2023-11-10 12:43:56
142	38	001REC1120237	1653	CEFTRIAXONE	13	13	13	\N	31	2023-11-10 12:43:56	2023-11-10 12:43:56
\.


--
-- TOC entry 3563 (class 0 OID 16778)
-- Dependencies: 255
-- Data for Name: produit_receptions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produit_receptions (produit_reception_id, reception_id, produit_id, libelle, lot, qte, pa, montant, date_expiration, created_at, updated_at, code, commande_id, pv, unite, reception_si_id) FROM stdin;
483	46	549	ACARILBIAL	\N	1	1750	1750	\N	2023-11-04 18:26:09	2023-11-04 18:26:09	001REC11202311	26	2275	1	32
484	46	2987	SERINGUE 2 Pièces	\N	45	77	3465	\N	2023-11-04 18:26:09	2023-11-04 18:26:09	001REC11202311	26	100	1	32
482	46	3144	1/3 TUBES	3e	1	43846	43846	2024-11-11	2023-11-04 18:26:09	2023-11-04 18:26:34	001REC11202311	26	57000	1	\N
486	46	1888	NIFEDIPINE	\N	400	2827	1130800	2024-01-01	2023-11-04 18:26:09	2023-11-04 18:26:50	001REC11202311	26	3675	1	\N
485	46	113	ASPEGIC	\N	60	385	23100	2023-07-01	2023-11-04 18:26:09	2023-11-04 18:27:07	001REC11202311	26	500	1	\N
487	47	2686	ACETYLSALCYLATE DE LYSINE 0.5 g inj Flacon	\N	130	385	50050	\N	2023-11-09 18:27:18	2023-11-09 18:27:18	001REC11202325	28	500	1	33
488	47	1768	PARACETA-M	\N	100	1212	121200	\N	2023-11-09 18:27:18	2023-11-09 18:27:18	001REC11202325	28	1575	1	33
489	47	2557	PARACETAMOL	\N	2000	573	1146000	\N	2023-11-09 18:27:18	2023-11-09 18:27:18	001REC11202325	28	745	1	33
490	47	3048	SERINGUE	\N	250	62	15500	\N	2023-11-09 18:27:18	2023-11-09 18:27:18	001REC11202325	28	80	1	33
491	47	1511	TICASSE	\N	300	5654	1696200	\N	2023-11-09 18:27:18	2023-11-09 18:27:18	001REC11202325	28	7350	1	33
492	47	513	ATEPADENE	\N	10	3435	34350	\N	2023-11-09 18:27:18	2023-11-09 18:27:18	001REC11202325	28	4465	1	33
493	47	973	ANALGIN	\N	30	538	16140	\N	2023-11-09 18:27:18	2023-11-09 18:27:18	001REC11202325	28	700	1	33
494	47	1653	CEFTRIAXONE	\N	10	2208	22080	\N	2023-11-09 18:27:18	2023-11-09 18:27:18	001REC11202325	28	2870	1	33
495	48	2167	DECODERM TRI	\N	10	1969	19690	\N	2023-11-09 18:57:47	2023-11-09 18:57:47	001REC11202332	29	2560	1	34
496	48	1672	SERUM ANTI-D	\N	100	20200	2020000	\N	2023-11-09 18:57:47	2023-11-09 18:57:47	001REC11202332	29	26260	1	34
497	48	2984	PERFUSEUR EN PVC	\N	200	192	38400	\N	2023-11-09 18:57:47	2023-11-09 18:57:47	001REC11202332	29	250	1	34
498	48	1586	APIOLINE DE CHAPOTEAUT	\N	16	2288	36608	\N	2023-11-09 18:57:47	2023-11-09 18:57:47	001REC11202332	29	2975	1	34
499	48	2757	EAU POUR PREPARATION INJECTABLE FLACON PLASTIQUE 10 ML	\N	300	38	11400	\N	2023-11-09 18:57:47	2023-11-09 18:57:47	001REC11202332	29	50	1	34
500	48	806	CELESTENE	\N	23	3073	70679	\N	2023-11-09 18:57:47	2023-11-09 18:57:47	001REC11202332	29	3995	1	34
501	49	801	ABUFENE	\N	23	2438	56074	\N	2023-11-09 19:10:55	2023-11-09 19:10:55	002REC11202311	27	3170	1	35
502	49	1196	DIPICOR	\N	23	8831	203113	\N	2023-11-09 19:10:55	2023-11-09 19:10:55	002REC11202311	27	11480	1	35
505	50	32571	aaabbb	\N	30	1000	30000	\N	2023-11-10 11:15:45	2023-11-10 11:15:45	003REC11202311	30	2000	\N	36
506	50	1144	LAROXYL	\N	13	2877	37401	\N	2023-11-10 11:15:45	2023-11-10 11:15:45	003REC11202311	30	3740	1	37
503	50	3048	SERINGUE	09	45	62	2790	2023-11-11	2023-11-10 11:15:45	2023-11-10 11:15:57	003REC11202311	30	80	1	\N
504	50	123	PANADOL	\N	90	635	57150	0025-01-01	2023-11-10 11:15:45	2023-11-10 11:16:07	003REC11202311	30	825	1	\N
507	51	286	DACRYOSERUM	\N	23	2058	47334	\N	2023-11-10 12:44:26	2023-11-10 12:44:26	001REC11202377	31	2675	1	38
508	51	3048	SERINGUE	\N	45	62	2790	\N	2023-11-10 12:44:26	2023-11-10 12:44:26	001REC11202377	31	80	1	38
509	51	973	ANALGIN	\N	20	538	10760	\N	2023-11-10 12:44:26	2023-11-10 12:44:26	001REC11202377	31	700	1	38
510	51	1653	CEFTRIAXONE	\N	13	2208	28704	\N	2023-11-10 12:44:26	2023-11-10 12:44:26	001REC11202377	31	2870	1	38
\.


--
-- TOC entry 3565 (class 0 OID 16787)
-- Dependencies: 257
-- Data for Name: produit_sorties; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produit_sorties ("""produit_sortie_id"" ", sortie_id, produit_id, libelle, qte, prix_achat, montant, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3567 (class 0 OID 16792)
-- Dependencies: 259
-- Data for Name: produit_transfert_dps; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produit_transfert_dps (produit_transfert_dps_id, transfer_dps_id, code, produit_id, libelle, qte_recue, qte_transferee, remarque, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3569 (class 0 OID 16800)
-- Dependencies: 261
-- Data for Name: produit_transfert_sis; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produit_transfert_sis (produit_transfert_si_id, transfert_si_id, code, produit_id, libelle, qte_recue, qte_transferee, remarque, commande_id, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3571 (class 0 OID 16808)
-- Dependencies: 263
-- Data for Name: produit_transferts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produit_transferts (produit_transfert_id, produit_id, libelle, qte, prix, montant, created_at, updated_at, code, lot, idsp, ini, transfert_id) FROM stdin;
37	1672	SERUM ANTI-D	25	0	0	2023-11-09 18:58:32	2023-11-09 18:58:32	001TR11202332	\N	\N	100	13
34	51	Analgin inj	5	0	0	2023-11-09 18:58:14	2023-11-09 18:58:14	001TR11202332	\N	\N	15	13
35	1586	APIOLINE DE CHAPOTEAUT	6	0	0	2023-11-09 18:58:19	2023-11-09 18:58:19	001TR11202332	\N	\N	16	13
36	806	CELESTENE	3	0	0	2023-11-09 18:58:23	2023-11-09 18:58:23	001TR11202332	\N	\N	23	13
38	801	ABUFENE	7	0	0	2023-11-09 19:11:13	2023-11-09 19:11:13	001TR11202311	\N	\N	23	14
39	1196	DIPICOR	12	0	0	2023-11-09 19:11:19	2023-11-09 19:11:19	001TR11202311	\N	\N	23	14
40	801	ABUFENE	6	0	0	2023-11-09 19:11:31	2023-11-09 19:11:31	002TR11202311	\N	\N	16	15
41	1196	DIPICOR	3	0	0	2023-11-09 19:11:35	2023-11-09 19:11:35	002TR11202311	\N	\N	11	15
26	2686	ACETYLSALCYLATE DE LYSINE 0.5 g inj Flacon	30	0	0	2023-11-09 18:32:00	2023-11-09 18:32:00	001TR11202325	\N	\N	130	11
27	973	ANALGIN	10	0	0	2023-11-09 18:32:04	2023-11-09 18:32:04	001TR11202325	\N	\N	30	11
28	513	ATEPADENE	5	0	0	2023-11-09 18:32:07	2023-11-09 18:32:07	001TR11202325	\N	\N	10	11
29	2557	PARACETAMOL	100	0	0	2023-11-09 18:32:15	2023-11-09 18:32:15	001TR11202325	\N	\N	2000	11
30	1511	TICASSE	50	0	0	2023-11-09 18:32:20	2023-11-09 18:32:20	001TR11202325	\N	\N	300	11
31	2686	ACETYLSALCYLATE DE LYSINE 0.5 g inj Flacon	10	0	0	2023-11-09 18:32:51	2023-11-09 18:32:51	002TR11202325	\N	\N	100	12
32	973	ANALGIN	5	0	0	2023-11-09 18:32:55	2023-11-09 18:32:55	002TR11202325	\N	\N	20	12
33	1511	TICASSE	25	0	0	2023-11-09 18:33:03	2023-11-09 18:33:03	002TR11202325	\N	\N	250	12
\.


--
-- TOC entry 3573 (class 0 OID 16818)
-- Dependencies: 265
-- Data for Name: produit_ventes; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produit_ventes (produit_vente_id, vente_id, code, produit_id, libelle, mont, pec, net, created_at, updated_at, pu, qte, taux_pdt, base, lot, categorie_id, ini) FROM stdin;
33	21	01112332	51	Analgin inj	2780	0	2780	2023-11-09 18:58:56	2023-11-09 18:58:56	1390	2	0	1390	\N	2	12
34	21	01112332	1586	APIOLINE DE CHAPOTEAUT	2975	0	2975	2023-11-09 18:59:00	2023-11-09 18:59:00	2975	1	0	2975	\N	2	6
7	6	01112311	2335	9-VIT	2066	0	2066	2023-11-01 19:45:21	2023-11-01 19:45:21	2066	1	0	2066	\N	2	3
8	6	01112311	549	ACARILBIAL	4550	0	4550	2023-11-01 19:45:25	2023-11-01 19:45:25	2275	2	0	2275	\N	2	5
10	7	02112311	2335	9-VIT	2066	0	2066	2023-11-01 21:19:14	2023-11-01 21:19:14	2066	1	0	2066	\N	2	2
11	7	02112311	549	ACARILBIAL	4550	0	4550	2023-11-01 21:19:19	2023-11-01 21:19:19	2275	2	0	2275	\N	2	3
12	8	03112311	3022	ARTEMETHER+LUMEFANTRINE (COARTESIANE)	4800	0	4800	2023-11-01 21:21:05	2023-11-01 21:21:05	2400	2	0	2400	\N	2	2
13	9	04112311	2487	CEFTRI 500	3440	0	3440	2023-11-02 00:09:13	2023-11-02 00:09:13	1720	2	0	1720	\N	2	20
14	10	05112311	2487	CEFTRI 500	5160	0	5160	2023-11-02 00:38:00	2023-11-02 00:38:00	1720	3	0	1720	\N	2	18
15	10	05112311	3018	SPARADRAP PERFORE	1000	0	1000	2023-11-02 00:38:07	2023-11-02 00:38:07	1000	1	0	1000	\N	2	46
16	11	06112311	3018	SPARADRAP PERFORE	2000	0	2000	2023-11-02 00:38:35	2023-11-02 00:38:35	1000	2	0	1000	\N	2	45
17	11	06112311	549	ACARILBIAL	2275	0	2275	2023-11-02 00:38:59	2023-11-02 00:38:59	2275	1	0	2275	\N	2	1
18	12	07112311	3018	SPARADRAP PERFORE	2000	1600	400	2023-11-02 16:30:48	2023-11-02 16:30:48	1000	2	80	1000	\N	2	43
19	12	07112311	2487	CEFTRI 500	1720	1376	344	2023-11-02 16:30:56	2023-11-02 16:30:56	1720	1	80	1720	\N	2	15
20	13	08112311	23	ARTEFAN	2640	2640	0	2023-11-02 16:31:14	2023-11-02 16:31:14	2640	1	100	2640	\N	2	30
21	13	08112311	3018	SPARADRAP PERFORE	2000	2000	0	2023-11-02 16:31:20	2023-11-02 16:31:20	1000	2	100	1000	\N	2	41
22	14	09112311	23	ARTEFAN	5280	4224	1056	2023-11-02 16:31:48	2023-11-02 16:31:48	2640	2	80	2640	\N	2	29
23	15	010112311	2466	AB-ZOLE	860	860	0	2023-11-02 16:33:34	2023-11-02 16:33:34	860	1	100	860	\N	2	22
24	15	010112311	2487	CEFTRI 500	5160	5160	0	2023-11-02 16:33:37	2023-11-02 16:33:37	1720	3	100	1720	\N	2	14
25	16	011112311	3018	SPARADRAP PERFORE	3000	3000	0	2023-11-02 17:06:36	2023-11-02 17:06:36	1000	3	100	1000	\N	2	39
26	18	012112311	3018	SPARADRAP PERFORE	2000	1600	400	2023-11-03 10:22:48	2023-11-03 10:22:48	1000	2	80	1000	\N	2	36
27	18	012112311	2466	AB-ZOLE	860	688	172	2023-11-03 10:22:52	2023-11-03 10:22:52	860	1	80	860	\N	2	21
28	19	013112311	3018	SPARADRAP PERFORE	2000	0	2000	2023-11-07 16:43:10	2023-11-07 16:43:10	1000	2	0	1000	\N	2	34
29	19	013112311	2466	AB-ZOLE	860	0	860	2023-11-07 16:43:15	2023-11-07 16:43:15	860	1	0	860	\N	2	20
30	20	014112311	2466	AB-ZOLE	10320	0	10320	2023-11-08 22:16:24	2023-11-08 22:16:24	860	12	0	860	\N	2	19
31	20	014112311	3018	SPARADRAP PERFORE	15000	0	15000	2023-11-08 22:16:33	2023-11-08 22:16:33	1000	15	0	1000	\N	2	32
32	20	014112311	23	ARTEFAN	18480	0	18480	2023-11-08 22:16:46	2023-11-08 22:16:46	2640	7	0	2640	\N	2	27
35	21	01112332	11	paracetamol	2490	0	2490	2023-11-09 18:59:04	2023-11-09 18:59:04	830	3	0	830	\N	2	75
36	22	015112311	801	ABUFENE	3170	0	3170	2023-11-09 19:11:50	2023-11-09 19:11:50	3170	1	0	3170	\N	2	7
37	22	015112311	1196	DIPICOR	22960	0	22960	2023-11-09 19:11:54	2023-11-09 19:11:54	11480	2	0	11480	\N	2	12
38	23	01112377	973	ANALGIN	1400	0	1400	2023-11-10 12:44:53	2023-11-10 12:44:53	700	2	0	700	\N	2	20
39	23	01112377	1653	CEFTRIAXONE	2870	0	2870	2023-11-10 12:44:56	2023-11-10 12:44:56	2870	1	0	2870	\N	2	13
40	23	01112377	3048	SERINGUE	160	0	160	2023-11-10 12:45:00	2023-11-10 12:45:00	80	2	0	80	\N	2	45
41	24	02112377	286	DACRYOSERUM	8025	0	8025	2023-11-10 12:45:55	2023-11-10 12:45:55	2675	3	0	2675	\N	2	23
42	24	02112377	3048	SERINGUE	160	0	160	2023-11-10 12:45:58	2023-11-10 12:45:58	80	2	0	80	\N	2	43
43	24	02112377	1653	CEFTRIAXONE	8610	0	8610	2023-11-10 12:46:02	2023-11-10 12:46:02	2870	3	0	2870	\N	2	12
44	25	03112377	973	ANALGIN	3500	2800	700	2023-11-10 12:46:45	2023-11-10 12:46:45	700	5	80	700	\N	2	18
45	26	04112377	286	DACRYOSERUM	5350	5350	0	2023-11-10 12:47:07	2023-11-10 12:47:07	2675	2	100	2675	\N	2	20
46	27	011123261	801	ABUFENE	3170	0	3170	2023-11-24 16:43:18	2023-11-24 16:43:18	3170	1	0	3170	\N	2	6
47	27	011123261	1196	DIPICOR	22960	0	22960	2023-11-24 16:43:22	2023-11-24 16:43:22	11480	2	0	11480	\N	2	3
\.


--
-- TOC entry 3575 (class 0 OID 16826)
-- Dependencies: 267
-- Data for Name: produits; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.produits (produit_id, reference, nom_commercial, dci, famille_therapeutique, prix_achat, prix_vente, stock_minimal, stock_maximal, user_id, statut, categorie_id, created_at, updated_at, type, unite_achat, unite_vente, stock_alerte, stock_securite) FROM stdin;
1	4	GLUCOR	ACARBOSE	ANTI-DIABETIQUE / COMPRIMÉS / 100MG	4512	5865	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2	5	SECTRAL	ACEBUTOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 200MG	4735	6155	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3	7	CATAFLAM	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / MILLILITRES / 0.015	1773	2305	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
4	8	LUMITER	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	2188	2845	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
5	9	LINCOCINE	LINCOMYCINE	ANTIBIOTIQUE MACROLIDE / GELULE / 500MG	3127	4065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
6	10	STERDEX	OXYTETRACYCLINE+DEXAMETHASONE	AFFECTION OPHTALMIQUE / DOSES / 1.335MG/0.267MG	1246	1620	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
7	11	AVLOCARDYL	PROPANOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 40MG	1873	2435	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
8	12	ACTINAC	ACECLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 100MG	4858	6315	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
9	13	TILCOTIL	TENOXICAM	ANTI-INFLAMMATOIRE (AINS) / Grammes / 20MG	3273	4255	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
10	14	LINCOMYCINE CREAT	LINCOMYCINE	ANTIBIOTIQUE MACROLIDE / GELULE / 500MG	1062	1380	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
11	16	FUROSEMIDE CREAT	FUROSEMIDE	ANTI-HYPERTENSEUR DIURETIQUE DE L'ANSE / COMPRIMÉS / 40MG	638	830	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
12	17	ARTRIN	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	2331	3030	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
13	18	TEGUMA	TERBINAFINE	ANTI-FONGIQUE / COMPRIMÉS / 250MG	15938	20720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
14	19	AIRTAL	ACECLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 100MG	8123	10560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
15	20	TADENAN	PRUNIER D'AFRIQUE	HYPERTROPHIE BENIGNE PROSTATE / Grammes / 50MG	9458	12295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
16	21	VOLTFAST	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / SACHETS / 50MG	2227	2895	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
17	22	PLASMOCID	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	2446	3180	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
18	23	ZERODOL	ACECLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 100MG	2023	2630	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
19	24	HEXAPNEUMINE ENFANTS	CHLORPHENAMINE PHOLCODINE BICLOTYMOL	ANTITUSSIF / Millilitres / 10MG/100MG/150MG	1131	1470	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
20	25	POMEX	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	1500	1950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
21	26	LAMISIL	TERBINAFINE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.01	2100	2730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
22	27	OLFEN VRAC	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / AMPOULE / 75MG	296	385	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
23	28	ARTEFAN	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 40MG/240MG	2031	2640	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
24	29	AURICULARUM	OXYTETRACYCLINE+POLYMYXINE B+NYSTATINE	AFFECTIONS AURICULAIRES / MILLILITRES / 10MG/1.23MG/0.1MUI	4369	5680	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
25	30	BRICANYL	TERBUTALINE	ANTI-ASTHMATIQUE / COMPRIMÉS / 5MGLP	2235	2905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
26	31	TANAGEL	GELATINE	ANTI DIARRHEIQUE / Grammes / 250MG	2331	3030	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
27	32	LONART	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 40MG/240MG	2296	2985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
28	34	FINIGAL	LINDILANE	ANTIPARASITAIRE EXTERNE / Millilitres / 0.01	1485	1930	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
29	35	VITOCIN	OXYTOCINE	OCYTOCIQUE / Millilitres / 5UI	542	705	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
30	36	LUFANTER	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 40MG/240MG	2646	3440	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
31	37	TERGYNAN	TERNIDAZOLE+NEOMYCINE+NYSTATINE+PREDNISOLONE	ANTI-FONGIQUE LOCAL / COMPRIMÉS / 200MG/100MG/100000UI/3MG	1404	1825	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
32	38	ELENOL	LINDILANE+AMYLENE	ANTIPARASITAIRE EXTERNE / Grammes / 1G/0.6G	2038	2650	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
33	39	ARTRIM	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 40MG/240MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
34	40	SYNTOCINON	OXYTOCINE	UTEROTONIQUE / AMPOULE / 5UI/1ML	846	1100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
35	41	LUMATE FORTE	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 40MG/240MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
36	42	LUMET	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 40MG/240MG	1269	1650	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
37	43	LIZOPRIL	LISINOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 10MG	3531	4590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
38	44	DIFENASOL	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / MILLILITRES / 0.001	681	885	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
39	45	BIMALARIL	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 80MG/480MG	2012	2615	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
40	46	COFANTRINE	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 80MG/480MG	2738	3560	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
41	47	DELABARRE	PULPE DE TAMARIN+ TEINTURE SAFRAN	ANTI-INFLAMMATOIRE BUCCAL / Grammes /  	2981	3875	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
42	48	PULMOFLUIDE AD	TERPINE + GUAIFENISINE + CINEOL	EXPEXTORANT / Millilitres / 0	1227	1595	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
43	51	DICOFEN SR	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 100MG	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
86	98	IMODIUM	LOPERAMIDE	ANTI-DIARRHEIQUE / GELULE / 2MG	1731	2250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
44	52	PULMOFLUIDE BAILLY	TERPINE+ GUAIFENISINE+CINEOL	EXPEXTORANT / Millilitres / 0	981	1275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
45	55	DICLO DENK	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 100MG	750	975	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
46	56	GENTALLINE	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / MILLILITRES / 0.003	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
47	57	TERPONE ADULTE	TERPINE+ HE PIN+ HE NIAOULI+HE EUCALYPTUS+	EXPECTORANT / Millilitres / 0	1235	1605	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
48	58	DICLAC	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
49	59	GENTAMICINE TM	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / MILLILITRES / 0.003	373	485	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
50	60	DICLOBERL	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	1688	2195	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
51	61	HELMINTOX	PYRANTEL	ANTI-PARASITAIRE / COMPRIMÉS / 125MG	1069	1390	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
52	62	GENTAMICINE CHAUVIN	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / MILLILITRES / 0.003	735	955	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
53	63	DICLOFEN	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	1969	2560	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
54	64	GENTAMICINE FAURE	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / MILLILITRES / 0.003	669	870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
55	65	TERPONE ENFANT	TERPINE+ HE PIN+ HE NIAOULI+HE EUCALYPTUS+	EXPECTORANT / Millilitres / 0	1173	1525	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
56	66	RANTUDIL	ACEMETACINE	ANTIRHUMASTISMAL / Grammes / 60MG	2685	3490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
57	67	LIZOPRIL H10	LISINOPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 10MG/12.5MG	3885	5050	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
58	68	GENTASOL	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / MILLILITRES / 0.003	681	885	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
59	69	DIFLAMEX	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
60	70	PYRANTOX	PYRANTEL	ANTI-PARASITAIRE / COMPRIMÉS / 125MG	673	875	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
61	71	FANTEM	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	927	1205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
104	117	DICOFEN	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / AMPOULE / 75MG	158	205	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
62	72	LIZOPRIL H20	LISINOPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 20MG/12.5MG	6623	8610	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
63	73	RANTUDIL LP	ACEMETACINE	ANTIRHUMASTISMAL / Grammes / 90MG	4715	6130	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
64	74	DOLOTREN	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	1450	1885	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
65	75	TERPONE SUPPO BEBE	TERPINE+ HE PIN+ HE NIAOULI+HE EUCALYPTUS+	EXPECTORANT / Grammes / 0	708	920	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
66	76	SINTROM	ACENOCOUMAROL	ANTI-THROMBOTIQUE / COMPRIMÉS / 4MG	981	1275	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
67	77	MAXI	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	600	780	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
68	78	GENTALLINE 10	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 10MG	431	560	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
69	79	SHARAZOLE	PANTOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 40MG	3531	4590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
70	80	DOLEX	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	1104	1435	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
71	81	DIAMOX	ACETAZOLAMIDE	ANTI-GLAUCOMATEUX / COMPRIMÉS / 250MG	3188	4145	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
72	82	GENTALLINE 160	GENTAMICINE	ANTIBIOTIQUE AMINOSIDES /   / 160MG	1977	2570	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
73	83	ALMIDE	LODOXAMIDE	ANTI-ALLERGIQUE / Millilitres / 0.001	2392	3110	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
74	84	DICLOFENAC TM	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	623	810	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
75	85	VERMINTEL	PYRANTEL	ANTI-PARASITAIRE / MILLILITRES / 125MG/2.5ML	1369	1780	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
76	86	GENTALLINE 40	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 40MG	785	1020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
77	88	DOLEX SR	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 75MG	2208	2870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
78	89	TANGANIL	ACETYL LEUCINE	ANTI-VERTIGINEUX/DEFICIT NEUROSENSORIEL / COMPRIMÉS / 500MG	3188	4145	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
79	90	UPRADONE	PANTOPRAZOLE+DOMPERIDONE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 40MG/30MG	9362	12170	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
80	91	GENTALLINE 80	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 80MG	1254	1630	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
81	92	OKACIN	LOMEFLOXACINE	ANTIBIOTIQUE QUINOLONES / Millilitres / 3MG	1881	2445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
82	93	TERPONE SUPPO ENFANT	TERPINE+ HE PIN+ HE NIAOULI+HE EUCALYPTUS+	EXPECTORANT / Grammes / 0	823	1070	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
83	94	COMBANTRIN	PYRANTEL	ANTI-PARASITAIRE / COMPRIMÉS / 125MG	1281	1665	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
84	95	EFFERALGAN	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	812	1055	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
85	97	GENTAMICINE 80 TM	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 80MG	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
87	99	DOLKO 	PARACETAMOL	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 1000MG	723	940	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
88	100	PHILCO GENTA	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 80MG	54	70	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
89	101	COMBIFRINIL	PYRANTEL	ANTI-PARASITAIRE / COMPRIMÉS / 250MG	1281	1665	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
90	102	HUMEX RHUME	CHLORPHENAMINE + PSEUDOEPHEDRINE + PARACETAMOL	ETAT GRIPPAL /  / 500MG/60MG GELULE 500MG/4MG	1412	1835	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
91	103	DOLREX	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 100MG	1908	2480	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
92	105	LOPERAMIDE CREAT	LOPERAMIDE	ANTI-DIARRHEIQUE / GELULE / 2MG	1023	1330	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
93	106	DICLIN	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 75MG	427	555	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
94	107	DOLIPRANE	PARACETAMOL	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 1000MG 	796	1035	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
95	108	FEBRILEX 	CHLORPHENAMINE + PSEUDOEDRINE PHENYP + PARACETAMOL	ETAT GRIPPAL /  / PAS DE PRECISION	246	320	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
96	109	SALVACOLINA	LOPERAMIDE	ANTI-DIARRHEIQUE / GELULE / 2MG	608	790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
97	110	BIMALARIL ADOLESCENT	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / Millilitres / 60MG/360MG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
98	111	DICLOFENAC UBI	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Ampoule / 75MG	69	90	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
99	112	APRAMOL	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	573	745	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
100	113	VITAMINE B6 COLLYRE	PYRIDOXINE (VIT B6)	AFFECTION OPHTALMIQUE / MILLILITRES / 0.02	804	1045	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
101	114	TANAKAN	GINKGO BILOBA	ANTI-ISCHEMIQUE / Grammes / 40MG	3892	5060	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
102	115	DIALOID	LOPERAMIDE	ANTI-DIARRHEIQUE / GELULE / 2MG	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
103	116	CIPHACET	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	608	790	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
105	118	TROYSPRIN	ACETYL SALICYLATE DE DL- LYSINE	ANALGESIQUE/ANTI-PYRETIQUE P1 / FLACON / 1000MG	619	805	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
106	119	COARTESIANE	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / Millilitres / 360MG/2160MG	4381	5695	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
107	120	LOPERIUM	LOPERAMIDE	ANTI-DIARRHEIQUE / GELULE / 2MG	2031	2640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
108	121	DYNAPAR AQ	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 75MG/ML	2427	3155	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
109	122	CATARSTAT	PYRIDOXINE+ AC L GLUTAMIQUE+ L- BIASPARTATE	CATARACTE / Millilitres / 10ML	1235	1605	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
110	123	GINKOR FORT	GINKGO BILOBA+ TROXERUTINE+HEPTAMINOL	VASCULOPROTECTEUR / VEINOTONIQUE /   / 14MG/300MG/300MG	4858	6315	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
111	124	ARTOME	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / Millilitre (s) / 20MG/120MG	1696	2205	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
112	125	ANDROTARDYL	TESTOSTERONE	ANDROGENE / Millilitres / 250MG INJECTABLE 1ML	4946	6430	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
113	126	ASPEGIC	ACETYL SALICYLATE DE DL- LYSINE	ANALGESIQUE/ANTI-PYRETIQUE P1 / FLACON / 500MG	385	500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
114	127	HEMI-DAONIL	GLIBENCLAMIDE	ANTI-DIABETIQUE / COMPRIMÉS / 2.5MG	2535	3295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
115	128	ASAQ DENK	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Grammes / 100MG/270MG	2031	2640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
116	129	ALLERGINE	LORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	2612	3395	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
117	130	TESTO ENANT	TESTOSTERONE	ANDROGENE /  / 250MG injectable 1ML	1996	2595	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
118	131	DAONIL	GLIBENCLAMIDE	ANTI-DIABETIQUE / COMPRIMÉS / 5MG	1281	1665	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
119	132	DOLOTEC	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	708	920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
120	133	BILOR	LORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	1854	2410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
121	134	COARSUCAM ADULTE	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Grammes / 100MG/270MG	2942	3825	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
122	135	RHINOSTOP	CHLORPHENAMINE + PSEUDOEPHEDRINE + PARACETAMOL	ETAT GRIPPAL /  / 2,54MG/61,20MG/251MG	1377	1790	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
123	136	PANADOL	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	635	825	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
124	137	CLARITYNE	LORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	2827	3675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
125	138	GLIDIABET	GLIBENCLAMIDE	ANTI-DIABETIQUE / COMPRIMÉS / 5MG	1035	1345	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
126	139	SERUM TETANEA	ANTITOXINE TETANIQUE	SERUM/TETANOS / DOSE / 1500UI	1942	2525	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
127	140	FLUIMUCIL	ACETYLCYSTEINE	MUCOLYTIQUE / SACHETS / 200MG	1519	1975	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
128	141	GLIBERON	GLIBENCLAMIDE	ANTI-DIABETIQUE / COMPRIMÉS / 5MG	1062	1380	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
129	142	LORACTYNE	LORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	3373	4385	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
130	143	PARACETAMOL LUCIEN	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	758	985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
131	144	MUCOMYST	ACETYLCYSTEINE	MUCOLYTIQUE / SACHETS / 200MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
132	145	RHINOSTOP (2)	CHLORPHENAMINE + PSEUDOEPHEDRINE + PARACETAMOL	ETAT GRIPPAL / Millilitres / 1,01MG/20.20MG/101MG	1438	1870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
133	146	LOTIN	LORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / MILLILITRES / 5MG/5ML	619	805	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
134	147	COARSUCAM ENFANT	ARTESUNATE + AMODIAQUINE	ANTIPALUDIQUE / Grammes / 100MG/270MG	2100	2730	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
135	148	GLUCOVANCE	GLIBENCLAMIDE+METFORMINE (CHLOLHYDRATE)	ANTI-DIABETIQUE / COMPRIMÉS / 2.5MG/500MG	2877	3740	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
136	149	PARACETAMOL TM	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	158	205	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
137	150	ACUILIX	QUINAPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 20MG/12.5MG	5300	6890	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
138	151	TIRLOR	LORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	2058	2675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
139	152	CAMOQUIN PLUS ENF	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Grammes / 100MG/300MG	2154	2800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
140	153	GLIBOMET	GLIBENCLAMIDE+METFORMINE (CHLOLHYDRATE)	ANTI-DIABETIQUE / COMPRIMÉS / 2.5MG/400MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
141	154	VACCIN TETAVAX	ANATOXINE TETANIQUE	VACCIN/TETANOS / DOSE / 40UI	2031	2640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
142	155	QUINIMAX	QUININE	ANTIPALUDIQUE / COMPRIMÉS / 125MG	2481	3225	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
143	156	LORHIST	LORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	1235	1605	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
144	157	PARACETS	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	758	985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
145	158	EXOMUC	ACETYLCYSTEINE	MUCOLYTIQUE / SACHETS / 200MG	2331	3030	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
146	159	ARTEDIAM	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Grammes / 100MG/300MG	2562	3330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
147	160	DIAMICRON LM	GLICLAZIDE	ANTI-DIABETIQUE / COMPRIMÉS / 30MG	4646	6040	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
148	161	ARSIQUINOFORME	QUININE	ANTIPALUDIQUE / COMPRIMÉS / 250MG	1908	2480	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
149	162	PARA DENK	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / Unite (s) / 500MG	973	1265	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
150	163	CAMOQUIN PLUS AD	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Grammes / 200MG/600MG	3100	4030	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
151	164	LORINOL	LORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	1077	1400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
152	165	SYNACTHENE IMMEDIAT	TETRACOSACTIDE	HORMONE CORTICOTROPE / AMPOULE / 0.25MG	1023	1330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
153	166	SURQUINA	QUININE	ANTIPALUDIQUE / COMPRIMÉS / 250MG	1785	2320	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
154	167	REMICRON	GLICLAZIDE	ANTI-DIABETIQUE / COMPRIMÉS / 30MG	4035	5245	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
155	168	COARSUCAM NOUR	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Grammes / 25MG/67.5MG	1677	2180	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
156	169	PARACETAMOL CREAT	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	600	780	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
157	170	FALQUIN	QUININE	ANTIPALUDIQUE / COMPRIMÉS / 300MG	1208	1570	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
158	171	TEMESTA	LORAZEPAM	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 1MG	812	1055	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
159	172	PARANTAL	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	538	700	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
160	173	AMAREL 1	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 1MG	2704	3515	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
161	174	PAROL	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	608	790	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
162	175	COARSUCAM PETIT ENFT	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Grammes / 50GM/135MG	1846	2400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
163	176	GLIMEPIRIDE DENK 2	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 2MG	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
164	177	SYNACTHENE RETARD	TETRACOSACTIDE	HORMONE CORTICOTROPE / AMPOULE / 1MG	1915	2490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
165	179	AMAREL 2	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 2MG	4050	5265	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
166	180	CAMOQUIN PLUS PED	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Millilitres / 0	2023	2630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
167	181	TETRACYCLINE GGIA	TETRACYCLINE	ANTIBIOTIQUE CYCLINE / GELULE / 250MG	258	335	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
168	182	GLIMEPIRIDE DENK 3	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 3MG	3885	5050	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
169	183	ARTEQUIN ENFANT	ARTESUNATE+ MEFLOQUINE	ANTIPALUDIQUE / Grammes / 100MG/125MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
170	184	ANTIDOL	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	504	655	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
171	185	QUININE 300 CREAT	QUININE	ANTIPALUDIQUE / COMPRIMÉS / 300MG	642	835	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
172	186	DICLOPAR	DICLOFENAC + PARACETAMOL	ANTI-INFLAMMATOIRE (AINS) / ANTALGIQUE / Grammes / 50MG /500MG	608	790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
173	187	ARTEQUIN ADULTE	ARTESUNATE+ MEFLOQUINE	ANTIPALUDIQUE / Grammes / 200MG/250MG	2912	3785	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
174	188	AMAREL 3	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 3MG	5300	6890	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
175	190	CLARADOL	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	846	1100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
176	191	AMPHOCYCLINE	TETRACYCLINE+AMPHOERICINE B	ANTI-FONGIQUE LOCAL / COMPRIMÉS / 100MG/50MG	688	895	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
177	192	ARTEQUIN PEDIATRIQUE	ARTESUNATE+ MEFLOQUINE	ANTIPALUDIQUE / Grammes / 50MG/125MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
178	193	DI PARA	DICLOFENAC + PARACETAMOL	ANTI-INFLAMMATOIRE (AINS) + ANTALGIQUE / Grammes / 50MG /500MG	431	560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
179	194	AMAREL 4	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 4MG	8946	11630	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
180	195	KARDEGIC	ACETYL SALICYLATE DE DL- LYSINE	ANTI-AGREGANT PLAQUETTAIRE / SACHETS / 75MG	919	1195	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
181	198	ASUNATE DENK 100 PLUS	ARTESUNATE+SULFADOXINE+ PYRIMETHAMINE	ANTIPALUDIQUE / Grammes / 100MG/250MG/12.5MG	1854	2410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
182	199	MYOLASTAN	TETRAZEPAM	MYORELAXANT / Grammes / 50MG	3046	3960	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
183	200	AMARYL M	GLIMEPIRIDE+METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 1MG/250MG	2827	3675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
184	202	PHILCO-QUININE 600	QUININE	ANTIPALUDIQUE / AMPOULE / 600MG/2ML	135	175	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
185	203	SOULADO PLUS	DICLOFENAC + PARACETAMOL + CHLORZOXAZONE	ANTI-INFLAMMATOIRE (AINS) / ANTIPYRETIQUE / Grammes / 50MG/325MG/250MG	1635	2125	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
186	204	COARINATE FDC JUNIOR	ARTESUNATE+SULFADOXINE+ PYRIMETHAMINE	ANTIPALUDIQUE / Grammes / 100MG/250MG/12.5	1054	1370	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
187	205	GLURENOR	GLIQUIDONE	ANTI-DIABETIQUE / COMPRIMÉS / 30MG	2154	2800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
188	206	EFFERALGAN 	PARACETAMOL	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 80MG 	635	825	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
189	207	QUININJECT	QUININE	ANTIPALUDIQUE / AMPOULE / 600MG/2ML	312	405	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
190	208	COARINATE FDC ADULTE	ARTESUNATE+SULFADOXINE+ PYRIMETHAMINE	ANTIPALUDIQUE / Grammes / 200MG/500MG/25MG	2727	3545	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
191	209	NOTEZINE	DIETHYLCARBAMAZINE	ANTI-PARASITAIRE / COMPRIMÉS / 100MG	1412	1835	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
192	211	ASUNATE DENK 200 PLUS	ARTESUNATE+SULFADOXINE+ PYRIMETHAMINE	ANTIPALUDIQUE / Grammes / 200MG/500MG/25MG	2738	3560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
193	212	VINIMAX	QUININE	ANTIPALUDIQUE / AMPOULE / 600MG/2ML	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
194	213	TEDRALAN LP	THEOPHYLLINE	ANTI-ASTHMATIQUE / GELULE / 200MG	1023	1330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
195	214	NERISONE	DIFLUCORTOLONE	CORTICOIDE TOPIQUE / GRAMMES / 0.001	1773	2305	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
196	215	SYSTRAL 	CHLORPHENOXAMINE + SULFOGAIACOLATE+ BENSOATE+ PARACETAMOL	ANTIHISTAMINIQUE/ANTI-ALLERGIQUE / Grammes / 20MG 	996	1295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
197	216	ACYCLOVIR DENK	ACICLOVIR	ANTI-VIRAL / COMPRIMÉS / 200MG	5792	7530	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
198	217	PALUCURE	QUININE+ PARACETAMOL	ANTIPALUDIQUE / Millilitres / 150MG/150MG	1608	2090	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
199	218	NERISONE C	DIFLUCORTOLONE+CHLORQUINALDOL	CORTICOIDE TOPIQUE / GRAMMES / 0.1%/1%	4035	5245	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
200	219	PARAFIZZ	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	1523	1980	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
201	220	TUSSIPHAN	CHLORPHENOXAMINE + SULFOGAIACOLATE+ BENSOATE+ PARACETAMOL	ANTITUSSIF / Millilitres / PAS DE PRECISION 	804	1045	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
202	221	CHILRAL	THEOPHYLLINE+ EPHEDRINE+ PHENOBARBITAL	ANTIASTHMATIQUE / Grammes / 120MG/24MG/8MG	1581	2055	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
203	224	EPITOPIC	DIFLUPREDNATE	CORTICOIDE TOPIQUE / GRAMMES / 0.0005	1246	1620	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
204	225	WARIVIRON	ACICLOVIR	ANTI-VIRAL / COMPRIMÉS / 200MG	5473	7115	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
205	226	LARGACTIL 	CHLORPROMAZINE	NEUROLEPTIQUE / Grammes / 25MG/5ML	3019	3925	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
206	227	VITAMINE B1 RENAUDIN SOLUTION INJECTABLE	THIAMINE (VIT B1)	ANTI-PARESTHESIQUE / AMPOULE / 100MG/2ML	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
207	228	DAFALGAN	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / GELULE / 500MG	758	985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
208	229	BLOKIUM	ATENOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 100MG	4442	5775	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
209	230	LARGACTIL	CHLORPROMAZINE	NEUROLEPTIQUE / COMPRIMÉS / 100MG	3100	4030	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
210	231	DIGOXINE NATIVELLE	DIGOXINE	CARDIOTONIQUES / COMPRIMÉS / 0.25MG	1308	1700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
211	233	GBACTIN	THIAMPHENICOLE	ANTIBIOTIQUE PHENICOLE / COMPRIMÉS / 250MG	1723	2240	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
212	234	ZOVIRAX	ACICLOVIR	ANTI-VIRAL / COMPRIMÉS / 200MG	14677	19080	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
213	235	TENSICARD	ATENOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 100MG	4954	6440	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
214	236	CRISTAL ADULTE	GLYCEROL	LAXATIF / SUPPOSITOIRE / 0	1112	1445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
215	237	ALVIR 200	ACICLOVIR	ANTI-VIRAL / COMPRIMÉS / 200MG	5112	6645	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
216	238	THIOBACTIN	THIAMPHENICOLE	ANTIBIOTIQUE PHENICOLE / COMPRIMÉS / 250MG	2012	2615	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
217	239	ATENOLOL DENK	ATENOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 50MG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
218	240	COLPOSEPTINE	CHLORQUINALDOL+PROMESTRIENE	OESTRO-PROGESTATIF / COMPRIMÉS / 200MG/10G	2365	3075	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
219	241	DOLIPRANE 	PARACETAMOL	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 100MG	873	1135	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
220	242	PALUJECT	QUININE	ANTIPALUDIQUE / AMPOULE / 400MG	300	390	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
221	243	SULFOBACTIN	THIAMPHENICOLE	ANTIBIOTIQUE PHENICOLE / COMPRIMÉS / 250MG	1838	2390	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
222	244	NOVATEN	ATENOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 100MG	5165	6715	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
223	245	VISIODIS 	CHLORURE DE BENZALKONIUM	ANTISEPTIQUE OPHTALMIQUE / Millilitres / 0.01G	615	800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
224	246	SERUM GLUCOSE 10% SOL PERF 500ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.1	585	760	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
225	248	COLTRAMYL	THIOCOLCHICOSIDE	MYORELAXANT / COMPRIMÉS / 4MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
226	249	RABEMAC	RABEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	2188	2845	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
227	250	ALVIR	ACICLOVIR	ANTI-VIRAL TOPIQUE / GRAMMES / 0.05	2208	2870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1283	1966	HERPESVIR	NORSECURINE	ANTIVIRAL /  / 200MG	1923	2500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
228	251	TENORMINE	ATENOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 100MG	5546	7210	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
229	253	MIOREL	THIOCOLCHICOSIDE	MYORELAXANT / COMPRIMÉS / 4MG	2058	2675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
230	254	TENOLOL	ATENOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 100MG	3638	4730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
231	255	COLOSAR DENK	LOSARTAN POTASSIQUE+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/12.5MG	6181	8035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
232	258	STABLON	TIANEPTINE	ANTI-DEPRESSEUR / COMPRIMÉS / 12.5MG	5512	7165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
233	259	CRISTAL ENFANT	GLYCEROL	LAXATIF / SUPPOSITOIRE / 0	981	1275	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
234	261	CRISTAL NOURRISSON	GLYCEROL	LAXATIF / SUPPOSITOIRE / 0	954	1240	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
235	262	TIAPRIDAL	TIAPRIDE	ANTI-PSYCHOTIQUE / COMPRIMÉS / 100MG	3400	4420	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
236	264	TRIATEC	RAMIPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 10MG	12362	16070	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
237	265	MALACUR	DIHYDROARTEMISININE + PIPERAQUINE	ANTIPALUDIQUE / Grammes / 40MG/320MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
238	266	GRISEOPHARM	GRISEOFULVINE	ANTI-FONGIQUE / COMPRIMÉS / 125MG	1635	2125	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
239	267	VISCERALGINE	TIEMONIUM	ANTI-SPASMODIQUE / AMPOULE / 5MG	158	205	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
240	269	GRISEFULINE	GRISEOFULVINE	ANTI-FONGIQUE / COMPRIMÉS / 250MG	1900	2470	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
241	270	DUO-COTECXIN 40/320	DIHYDROARTEMISININE+PIPERAQUINE	ANTIPALUDIQUE / COMPRIMES / 40MG/320MG	3523	4580	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
242	271	P-ALAXIN	DIHYDROARTEMISININE + PIPERAQUINE	ANTIPALUDIQUE / Grammes / 40MG/320MG	2427	3155	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
243	272	BLOKIUM DIU	ATENOLOL+CHLORTALIDONE	ANTI-HYPERTENSEUR BETA-BLOQUANT/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 100GM/25MG	2754	3580	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
244	273	LARMES ARTIFICIELLES	CHLORURE DE SODIUM	AFFECTION OPHTALMIQUE / MILLILITRES / 0.014	908	1180	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
245	274	GRISEO	GRISEOFULVINE	ANTI-FONGIQUE LOCAL / GRAMMES / 0.05	669	870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
246	275	INTETRIX	TILIQUINOL	ANTI-PARASITAIRE / GELULE / 300MG	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
247	276	DARTE Q	DIHYDROARTEMESININE +PIPERAQUINE + TRIMETHOPRIME	ANTIPALUDIQUE / Grammes / 40MG/320MG	3000	3900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
248	277	TRITAZIDE	RAMIPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 5MG/25MG	5300	6890	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
249	278	GRISEQ LAPR	GRISEOFULVINE	ANTI-FONGIQUE LOCAL / GRAMMES / 0.05	669	870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
250	279	CUSIMOLOL	TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.005	1465	1905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
251	280	ARTECOM	DIHYDROARTEMESININE +PIPERAQUINE + TRIMETHOPRIME	ANTIPALUDIQUE / Grammes / 32MG/320MG/90MG	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
252	281	AZANTAC	RANITIDINE	ANTI-ULCEREUX/ANTI-HISTAMINIQUE H2 / COMPRIMÉS / 300MG	12785	16620	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
253	283	TIMOPTOL	TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.0025	2527	3285	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
254	284	RANIMAT	RANITIDINE	ANTI-ULCEREUX/ANTI-HISTAMINIQUE H2 / COMPRIMÉS / 150MG	6815	8860	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
255	285	DOLKO	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / SACHETS / 500MG	758	985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
256	286	HALDOL	HALOPERIDOL	NEUROLEPTIQUE / COMPRIMÉS / 1MG	777	1010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
257	287	RANI DENK 150MG	RANITIDINE	ANTI-ULCEREUX/ANTI-HISTAMINIQUE H2 / COMPRIMÉS / 150MG	2958	3845	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
258	288	ALAXIN PLUS	DIHYDROARTEMESININE + SULFADOXINE+ PYRIMETHAMINE	ANTIPALUDIQUE / Grammes / 60MG/500MG//25MG	1077	1400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
259	289	LYSO 6 	LYSOZYME+PYRIDOXINE	ANTISEPTIQUE BUCCAL / Grammes / 20MG/10MG	2438	3170	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
260	291	LACRYPOS 	CHONDROITINE	SUPPLEMENT LACRYMALE / Millilitres / 0.03	823	1070	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
261	292	ALAXIN S P	DIHYDROARTEMESININE + SULFADOXINE+ PYRIMETHAMINE	ANTIPALUDIQUE / Grammes / 60MG/500MG/25MG	1077	1400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
262	293	HALDOL DECANOAS	HALOPERIDOL DECANOATE	NEUROLEPTIQUE / AMPOULE / 50MG	2427	3155	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
263	294	TENSICARD AM	ATENOLOL+AMLODIPINE	ANTI-HYPERTENSEUR BETA-BLOQUANT/INHIBITEUR CALCIQUE / COMPRIMÉS / 50MG/5MG	8346	10850	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
264	295	FORLAX	MACROGOL 4000	LAXATIF / SACHETS / 10G	2746	3570	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
265	296	NORMOPTIC	TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.005	1281	1665	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
266	299	JOUVENCE ABBE SOURY	HAMAMELIS+VIBURNUM+CALAMUS+PISCIDIA	VASCULOPROTECTEUR / VEINOTONIQUE / Grammes / 0	5254	6830	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
267	300	ALPHACHYMOTRYPSINE	CHYMOTRYPSINE	ANTI INFLAMMATOIRE ENZYMATIQUE / Grammes / COMPRIME 21µKATALS 	1073	1395	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
268	301	VASOBRAL	DIHYDROERGOCRYPTINE+ CAFEINE	ANTIMIGRAINEUX / Millilitres / 0.1G/1G	3435	4465	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
269	302	TENORETIC	ATENOLOL+CHLORTALIDONE	ANTI-HYPERTENSEUR BETA-BLOQUANT/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/12.5MG	3735	4855	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
270	303	PYRALVEX	RHUBARBE+ ACIDE SALICYLIQUE	ANTISEPTIQUE LOCAL / Grammes / 0	2738	3560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
271	304	MAALOX	MAGNESIUM HYDROXIDE+ALUMINIUM HYDROXIDE	ANTI-ACIDE/PANSEMENT GASTRO INTESTINAL / COMPRIMÉS / 400MG/400MG	1385	1800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
272	305	NYOLOL	TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.005	1950	2535	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
273	306	HELICIDINE	HELICIDINE	ANTITUSSIF / Millilitres / 0.1	1335	1735	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
274	307	TENORDATE	ATENOLOL+NIFEDIPINE	ANTI-HYPERTENSEUR BETA-BLOQUANT/INHIBITEUR CALCIQUE / GELULE / 50MG/20MG	9219	11985	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
275	308	HEPTAMYL	HEPTAMINOL	ANTI-HYPOTENSEUR / COMPRIMÉS / 187.8MG	1077	1400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
276	309	SEGLOR	DIHYDROERGOTAMINE	ANTIMIGRAINEUX / Grammes / 5MG	5812	7555	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
277	311	TIMOLOL	TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.005	927	1205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
278	312	ALPHACHYMOTRYPSINE 	CHYMOTRYPSINE	ANTI-INFLAMMATOIRE ENZYMATIQUE / Grammes / 5MG 	1942	2525	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
279	314	HEPTAMINOL RENAUDIN	HEPTAMINOL	ANTI-HYPOTENSEUR / AMPOULE / 0.0626	115	150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
280	315	TAHOR	ATORVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 10MG	13458	17495	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
281	316	TRICOGYN	TINIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	785	1020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
282	317	DIHYDROERGOTAMINE	DIHYDROERGOTAMINE	ANTIMIGRAINEUX / Millilitres / 2MG/ML	2100	2730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
283	318	MYCOSTER	CICLOPIROXOLAMINE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.01	2631	3420	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
284	320	CARLIPO	ATORVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 10MG	3462	4500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
285	321	PARAFIL	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 120MG/5ML	423	550	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
286	322	DACRYOSERUM	ACIDE BORIQUE	VASOCONSTRICTEUR OPHTALMIQUE / Grammes / 0	2058	2675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
287	323	DESOMEDINE	HEXAMIDINE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.001	1212	1575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
288	324	TINAZOL	TINIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	804	1045	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
289	325	SUPRALOX	MAGNESIUM HYDROXIDE+ALUMINIUM HYDROXIDE	ANTI-ACIDE/PANSEMENT GASTRO INTESTINAL / MILLILITRES / 600MG/900MG	2288	2975	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
290	326	HYDERGINE	DIHYDROERGOTOXINE	ANTIMIGRAINEUX / Grammes / 4.5MG	5758	7485	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
291	327	ATORFIT	ATORVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 10MG	4062	5280	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
292	328	MYCOPIROX	CICLOPIROXOLAMINE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.01	2004	2605	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
293	329	TINIDAZOLE TM	TINIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	1385	1800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
294	330	MANNITOL 10% SOL PERF 500ML	MANNITOL	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.1	1065	1385	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
295	331	ENTAMIZOLE	DILOXANIDE+METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 250MG/200MG	2085	2710	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
296	333	MANNITOL 20% SOL PERF 500ML	MANNITOL	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.2	1065	1385	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
297	334	ENTAMIZOLE DS	DILOXANIDE+METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG/400MG	2085	2710	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
298	335	DATIZOLE	TINIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	1212	1575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
299	337	FASIGYNE	TINIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	4688	6095	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
300	338	CARBEN	MEBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 100MG	796	1035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
301	340	ACFOL	ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 5MG	1308	1700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
302	341	TINIFIL	TINIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	369	480	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
303	343	OZIBEN	MEBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 100MG	804	1045	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
304	344	AMTIBA	TINIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	619	805	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
305	346	TOLOXIM	MEBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 100MG	892	1160	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
306	347	TILDIEM	DILTIAZEM	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 60MG	4019	5225	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
307	348	CYTEAL	HEXAMIDINE + CHLORHEXIDINE + CHLOROCRESOL	ANTISEPTIQUE LOCAL / Millilitres / 100MG/20%/300MG	2050	2665	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
308	349	RULID	ROXYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 100MG	4477	5820	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
309	350	VERMOX	MEBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 100MG	1008	1310	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
310	351	WORMIN	MEBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 100MG	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
311	352	HYPERIUM	RILMENIDINE	ANTI-HYPERTENSEUR CENTRAL / COMPRIMÉS / 1MG	7100	9230	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
312	353	MONO TILDIEM	DILTIAZEM	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 200MG	9950	12935	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
313	354	TROSYD	TIOCONAZOLE	ANTIFONGIQUE LOCAL / Grammes / 0.01	2427	3155	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
314	355	HEXOMEDINE TRANSCUTANEE	HEXAMIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 1.5MG	1696	2205	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
315	356	MEBENDAZOLE UBI	MEBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 100MG	154	200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
316	358	PIVALONE	TIXOCORTOL	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE NASAL / DOSES / 0.01	1908	2480	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
317	360	CARBEN 	MEBENDAZOLE	ANTIPARASITAIRE /  / 500MG	823	1070	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
318	361	HEXTRIL	HEXIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.001	1512	1965	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
319	362	ATORLIP	ATORVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 20MG	4227	5495	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
320	363	TOBREX	TOBRAMYCINE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.003	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
321	365	OZIBEN 	MEBENDAZOLE	ANTIPARASITAIRE /  / 500MG	796	1035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
322	366	COLLU-HEXTRIL	HEXITIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.002	1900	2470	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
323	367	VERMOX 	MEBENDAZOLE	ANTIPARASITAIRE / Grammes / 500MG	873	1135	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
324	368	GIVALEX	HEXIDINE+SALICYLATE DE CHOLINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0	1023	1330	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
325	369	WORMIN 	MEBENDAZOLE	ANTIPARASITAIRE / Grammes / 500MG	442	575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
326	370	RAMIDEX	TOBRAMYCINE+DEXAMETHASONE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.3%/0.1%	1323	1720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
327	371	ANGISPRAY	HEXITIDINE+ACIDE PROPIONIQUE+CHLOROBUTANOL	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.182/0.118G/0.5G	2550	3315	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
328	372	PERFALGAN	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 1000MG	1458	1895	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
329	373	PEDILID 300	ROXYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 300MG	1362	1770	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
330	374	COLLUNOVAR	CHLORHEXIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.0011	1588	2065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
331	376	ATROPINE ALCON	ATROPINE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.005	608	790	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
332	377	PREXIDINE	CHLORHEXIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.0012	1465	1905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
333	378	PEDILID	ROXYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / MILLILITRES / 50MG	800	1040	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
334	379	VENOSMIL	HIDROSMINE	ANTI-HEMORROIDAIRE TOPIQUE / GRAMMES / 0.02	1785	2320	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
335	381	CORSODYL	CHLORHEXIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.2	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
336	384	COLLUXID	CHLORHEXIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.001	1212	1575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
337	385	MITOSYL	HUILE DE FOIE DE POISSON+ OXYDE DE ZINC	TOPIQUE PROTECTEUR / TROPHIQUE / Grammes / 20G/27G	2277	2960	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
338	386	RINIALER	RUPATADINE	ANTIHISTAMINIQUE/ANTI-ALLERGIQUE / Grammes / 10MG	5473	7115	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
339	388	REKAFOL	ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 5MG	708	920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
340	389	MITOSYL.	HUILE DE FOIE DE POISSON+ OXYDE DE ZINC	TOPIQUE PROTECTEUR / TROPHIQUE / Grammes / 20G/27G	1185	1540	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
341	392	ASEPT APAISYL	CHLORHEXIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / PASDEPRECISION	1342	1745	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
342	394	VELITEN	RUTINE+ACIDE ASCORBIQUE+TOCOPHEROL	ANTI-HEMORROÏDAIRE/VEINOTONIQUE / COMPRIMÉS / 200MG/200MG/50MG	2842	3695	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
343	395	LUBENTYL EMULS	HUILE DE PARAFFINE	LAXATIF / GRAMMES / 0	1438	1870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
344	396	ASEPT APAILYS	CHLORHEXIDINE	ANTISEPTIQUE / Millilitres / PAS DE PRECISION	1431	1860	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
345	397	ULTRA LEVURE	SACCHAROMYCES BOULARDII	ANTIDIARRHEIQUE / Grammes / 50MG	1438	1870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
346	398	LUBENTYL MAGNESIE	HUILE DE PARAFFINE+ MAGNESIUM HYDROXYDE	LAXATIF / CONSTIPATION / Grammes / 0	1385	1800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
347	400	ATROPINE SULFATE	ATROPINE	ANTI-SPASMODIQUE / AMPOULE / 0.0025	77	100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
348	401	COLLUNOVAR SPRAY	CHLORHEXIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.0011	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
349	403	VIBROCIL GEL	DIMETINDENI+ PHENYLEPHRINUM	DECONGESTIONNANT / SINUSITE / Grammes / 0	1554	2020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
350	404	SEPTIVON	CHLORHEXIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.015	1412	1835	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
351	406	MEBFIL	MEBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 100MG	250	325	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
352	407	ACTAPULGITE P	ATTAPULGITE	ANTI-ACIDE/PANSEMENT GASTRO INTESTINAL / SACHETS / 1000MG	1185	1540	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
353	409	SEPTYL	CHLORHEXIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.001	1735	2255	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
354	410	VEINOSMINE FORTE	DIOSMINE	ANTI-HEMORROÏDAIRE/VEINOTONIQUE / COMPRIMÉS / 450MG	3973	5165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
355	411	TORAS DENK	TORASEMIDE	ANTI-HYPERTENSEUR DIURETIQUE DE L'ANSE / COMPRIMÉS / 5MG	5650	7345	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
356	413	MEBEX	MEBENDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 100MG/5ML	204	265	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
357	414	ELUDRIL	CHLORHEXIDINE+CHLOROBUTANOL	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0	1438	1870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
358	415	DOLORA	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / COMPRIMÉS / 100MG	2296	2985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
359	416	DIOVENOR	DIOSMINE	ANTI-HEMORROÏDAIRE/VEINOTONIQUE / COMPRIMÉS / 600MG	4408	5730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
360	417	GASTROPULGITE	ATTAPULGITE + HYDROXIDE ALU+ CARBONATE DE MAGNESIUM	ANTI ACIDE/ PANSEMENT GASTRO INTESTINAL / Grammes / 2.5G/0.5G	2331	3030	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
361	418	VISIODOSE 	CHLORHEXIDINE + PHENYLEPHRINE	VASOCONSTRICTEUR OPHTALMIQUE / Millilitre (s) / 0,4 ML UNIDOSE 	2269	2950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
362	419	TREMADOL	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / COMPRIMÉS / 50MG	2250	2925	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
363	421	VISCODRIL	DIPENHYDRAMINE+ AMMONIUM	FLUIDIFIANT BRONCHIQUE / Millilitres / 14MG/138MG	1323	1720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
364	422	BUTO-ASMA	SALBUTAMOL	ANTI-ASTHMATIQUE / COMPRIMÉS / 2MG	1546	2010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
365	423	HYDROCORTISONE ROUSSEL	HYDROCORTISONE	CORTICOIDE / COMPRIMÉS / 10MG	1404	1825	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
366	424	OROZAMUDOL	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / COMPRIMÉS / 50MG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
367	425	LOCOID	HYDROCORTISONE	CORTICOIDE TOPIQUE / GRAMMES / 0.001	1812	2355	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
368	426	VENTOLINE	SALBUTAMOL	ANTI-ASTHMATIQUE / DOSES / 100UG	2288	2975	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
369	427	AUREOMYCINE VALDA	AUREOMYCINE	ANTIBIOTIQUE TOPIQUE / GRAMMES / 0.03	396	515	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
370	428	ELUDRIL PRESSURISE	CHLORHEXIDINE+TETRACAINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.05G/0.015G	1015	1320	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
371	429	CORTAPAISYL	HYDROCORTISONE	CORTICOIDE TOPIQUE / GRAMMES / 0.005	1546	2010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
372	430	BRONCORON	SALBUTAMOL	ANTI-ASTHMATIQUE /  / 2MG	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
373	432	AUREOMYCINE PROMOP	AUREOMYCINE	ANTIBIOTIQUE TOPIQUE / GRAMMES / 0.03	327	425	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
374	433	PERSANTINE	DIPYRIDAMOLE	ANTI-THROMBOTIQUE / COMPRIMÉS / 75MG	1473	1915	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
375	434	DUSPATALIN	MEBEVERINE	ANTI-SPASMODIQUE / COMPRIMÉS / 100MG	2138	2780	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
376	435	BACTEOAPAISYL	CHLOHEXIDINE DIGLUCONATE	ANTI-SEPTIQUE TOPIQUE / GRAMMES / 0.005	919	1195	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
377	438	LOXAIR	SALBUTAMOL	ANTI-ASTHMATIQUE / DOSES / 100UG	2112	2745	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
378	439	ALLERGODIL	AZELASTINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE OPHTALMIQUE / MILLILITRES / 0.0005	3577	4650	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
379	443	COLOPRIV	MEBEVERINE	ANTI-SPASMODIQUE / COMPRIMÉS / 100MG	1450	1885	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
380	444	ZAMUDOL LP	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / GELULE / 100MG	3885	5050	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
381	446	ALLERGODIL NASAL	AZELASTINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE NASAL / MILLILITRES / 0.14MG	3442	4475	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
382	447	SALBUTUS	SALBUTAMOL	ANTI-ASTHMATIQUE / MILLILITRES / 2MG/5ML	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
383	448	TRAMADIS	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / GELULE / 50MG	2215	2880	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
384	449	ZOCIN	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	4469	5810	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
385	452	ONCTOSE HYDROCORTSONE	HYDROCORTISONE+LIDOCAINE+MEFENIDROMIUM	CORTICOIDE ASSOCIE / Grammes / 0.250G/1G/2G T/30G	1854	2410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
386	453	DOLODENT	CHLORHYDRATE  D'AMYLENE	ANTI-INFLAMMATOIRE BUCCAL / Grammes / 0	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
387	454	PONSTYL	ACIDE MEFENAMIQUE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 250MG	2031	2640	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
388	455	TANDOL	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / GELULE / 50MG	1246	1620	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
389	456	AZYTER	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / MILLILITRES / 15MG	3531	4590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
390	457	TRABAR	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / Unite (s) / 50MG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
391	459	DOXYNOR	DOXYCYCLINE	ANTIBIOTIQUE CYCLINE / COMPRIMÉS / 100MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
392	460	NEGRAM FORTE	ACIDE NALIDIXIQUE	ANTIBIOTIQUE QUINOLONES / Grammes / 1G	4519	5875	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
393	461	AZICURE	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	3004	3905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
394	462	VIBRA	DOXYCYCLINE	ANTIBIOTIQUE CYCLINE / COMPRIMÉS / 200MG	6058	7875	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
395	464	ANTIHEMORROIDAL CINFA	HYDROCORTISONE+NEOMYCINE+BENZOCAINE+AC TANNIQUE	ANTI-HEMORROIDAIRE TOPIQUE / GRAMMES / 25MG/3.5MG/15MG/10MG	2227	2895	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
396	465	GYNECLINE	DOXYCYCLINE	ANTIBIOTIQUE CYCLINE / COMPRIMÉS / 200MG	1662	2160	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
397	467	AZITRINE	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
398	468	MADECASSOL	HYDROCOTYLE	CORTICOIDE TOPIQUE / GRAMMES / 1G	1273	1655	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
399	470	DOXY 200	DOXYCYCLINE	ANTIBIOTIQUE CYCLINE / COMPRIMÉS / 200MG	1335	1735	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
400	471	AZITHRO MEPHA	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
401	472	LONGAMYCINE	DOXYCYCLINE	ANTIBIOTIQUE CYCLINE / COMPRIMÉS / 200MG	1281	1665	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
402	474	BINOZYT	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	5927	7705	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
403	476	DOXYCYCLINE 200 CREAT	DOXYCYCLINE	ANTIBIOTIQUE CYCLINE / COMPRIMÉS / 200MG	973	1265	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
404	477	AZEE	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	2046	2660	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
405	478	PANADOL EXTRA	PARACETAMOL + CAFEINE	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 500MG/65MG	927	1205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
406	480	TRIDOSIL	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	1019	1325	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
407	481	DONORMYL	DOXYLAMINE	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 15MG	1227	1595	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
408	482	UNIZITRO	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / MILLILITRES / 200MG/5ML	3973	5165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
409	483	EAU OXYGENEE	HYDROGENE PEROXYDE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 10VOLUME	796	1035	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
410	485	ZITHROMAX	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	6950	9035	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
411	486	NOSPA	DROTAVERINE	ANTI-SPASMODIQUE / COMPRIMÉS / 40MG	1146	1490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
412	487	BALSAMORHINOL 	CHLOROBUTANOL+ LEVOMENTHOL+ HE BERGAMATE+HE ORANGE DOUCE	RHINITE CROUTEUSE / Millilitres / 0	2269	2950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
413	490	AZIX	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	4238	5510	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
414	491	NOSPA FORTE	DROTAVERINE	ANTI-SPASMODIQUE / COMPRIMÉS / 80MG	2296	2985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
415	496	THROMIZ	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
416	498	BAUME BENGUE	SALICYLATE DE METHYLE+ MENTHOL	ANTALGIQUE PERCUTANE / Grammes / 7.2G/7.2G	2562	3330	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
417	500	AGYRAX	MECLOZINE	ANTIVERTIGINEUX / DEFICIT NEUROSENSORIEL /  / 25MG	1496	1945	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
418	501	DUPHASTON	DYDROGESTERONE	OESTRO-PROGESTATIF / COMPRIMÉS / 10MG	2012	2615	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
419	502	INONGAN	SALICYLATE DE METHYLE+ CAMPHRE	ANTALGIQUE PERCUTANE / Grammes / 0	1069	1390	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
420	503	HEXAPNEUMINE NOURRISSONS	CHLORPHENAMINE + BICLOTYMOL	ANTITUSSIF / Millilitres / 5MG/100MG	823	1070	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
421	504	NAVIDOXINE	MECLOZINE	ANTI-NAUSEEUX / ANTI EMETIQUE /  / 25MG	1288	1675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
422	505	DECONTRIN	SALICYLATE DE METHYLE+ MENTHOL+CAMPHRE+ TEREBENTINE	ANTALGIQUE PERCUTANE / Grammes / 0	1438	1870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
423	506	CHLORUMAGENE	HYDROXIDE DE MAGNESIUM	LAXATIF / MILLILITRES / 100MG	2827	3675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
424	507	NIFLUGEL	ACIDE NIFLUMIQUE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 0.025	1431	1860	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
425	508	ECOMI	ECONAZOLE	ANTI-FONGIQUE LOCAL / GRAMMES / 0.01	2692	3500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
426	509	SECAMIB	SECNIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 1G	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
427	510	TRAVATAN	TRAVOPROST	ANTI-GLAUCOMATEUX / MILLILITRES / 40UG	12362	16070	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
428	511	AMOSEC	SECNIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 1G	1688	2195	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
429	512	ECONIF	ACIDE NIFLUMIQUE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 250MG	431	560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
430	513	FUNGILYSE	ECONAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.01	1581	2055	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
431	514	ATARAX	HYDROXYZINE	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 100MG	2562	3330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
432	515	FLAGENTYL	SECNIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	2808	3650	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
433	517	DUOTRAV	TRAVOPROST+TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 40MCG/5MG	13112	17045	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
434	518	YENDOL	CHLORPHENAMINE + CAFEINE + PARACETAMOL + SALICYLAMID	ETAT GRIPPAL /  / 3MG/30MG/200MG/500MG	1785	2320	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
435	519	MYCO APAISYL	ECONAZOLE	ANTI-FONGIQUE LOCAL / GRAMMES / 0.01	1458	1895	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
436	520	SECNOL	SECNIDAZOLE	ANTIPARASITAIRE / Grammes / 2G	2454	3190	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
437	521	NIFLURIL	ACIDE NIFLUMIQUE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 250MG	1492	1940	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
438	522	PEVARYL	ECONAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.01	2085	2710	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
439	523	PURSENIDE	SENNOSIDES CALCIQUES	LAXATIF / CONSTIPATION / Grammes / 20MG	696	905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
440	526	RALDOL	CHLORPHENAMINE + DICLOFENAC + PARACETAMOL + MG	ETAT GRIPPAL / Grammes / 4MG/500MG/500MG/100MG	723	940	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
441	527	PERMIXON	SERENOA REPENS	HYPERTROPHIE BENIGNE PROSTATE / Grammes / 160MG	17035	22145	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
442	528	MEPHAQUIN	MEFLOQUINE	ANTIPALUDIQUE /  / 300MG B/4	3004	3905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
443	529	ECOREX	ECONAZOLE	ANTI-FONGIQUE LOCAL / MILLILITRES / 0.01	1881	2445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
444	530	NASACORT	TRIAMCINOLONE	RHINITE ALLERGIQUE / Grammes / 55µG	6862	8920	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
445	531	FLUISEDAL	MEGLUMINE+ POLYSORBATE+ PROMETHAZINE	ANTITUSSIF / Millilitres / 2.6G/0.3G/0.05G	1008	1310	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
446	533	NIFLURIL ADULTE	ACIDE NIFLUMIQUE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 700MG	1315	1710	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
447	534	KENACORT RETARD	TRIAMCINOLONE	CORTICOIDE / AMPOULE / 40MG	1612	2095	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
448	535	PHARMAGRIP 	CHLORPHENIRAMINE+ PARACETAMOL+ PHENYLEPHRINE	ETAT GRIPPAL / Grammes / 3MG/8,2MG/500MG	1342	1745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
449	536	MECAM	MELOXICAM	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 15MG	2235	2905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
450	538	MELOBAX	MELOXICAM	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 15MG	2473	3215	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
451	540	PIPRAM FORT	ACIDE PIPEMIDIQUE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	3331	4330	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
452	541	MELONAX	MELOXICAM	ANTI-INFLAMMATOIRE (AINS) /  / 15MG	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
453	542	DAKIN COOPER	HYPOCHLORITE DE SODIUM	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0	1042	1355	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
454	543	THEINOL	PARACETAMOL + CAFEINE	ANTALGIQUE / ANTIPYRETIQUE / Millilitres / G/0.266G	973	1265	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
455	547	CUTISAN	TRICLOCARBAN	ANTISEPTIQUE LOCAL / Grammes / 0.01	2058	2675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
456	548	CODABROL	PARACETAMOL+CODEINE	ANALGESIQUE/ANTI-PYRETIQUE P2 / COMPRIMÉS / 325MG/15MG	1008	1310	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
457	549	FEBRILEX	CHLORPHENAMINE + PHENYLEPHRINE + PARACETAMOL	ETAT GRIPPAL / Millilitres / 150ML	1015	1320	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
458	550	DECONTRACTYL	MEPHENESINE	MYORELAXANT / GRAMMES / 10MG	1704	2215	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
459	552	SOLUBACTER	TRICLOCARBAN	ANTISEPTIQUE LOCAL / Millilitres / 0.01	2615	3400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
460	553	CODOLIPRANE	PARACETAMOL+CODEINE	ANALGESIQUE/ANTI-PYRETIQUE P2 / COMPRIMÉS / 400MG/20MG	1342	1745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
461	554	HUMEX ENFANT	CHLORPHENAMINE + PHOLCODINE	ANTITUSSIF / Millilitres / 0	1546	2010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
462	555	PRIMALAN	MEQUITAZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	3115	4050	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
463	556	AZACTAM	AZTREONAM	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Grammes / 1G	3492	4540	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
464	557	ADVIL	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / Unite (s) / 200MG	1342	1745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
465	558	ARTANE 2	TRIHEXYPHENIDYLE	ANTI-PARKINSONIEN/ANTI-CHOLINERGIQUE / COMPRIMÉS / 2MG	1235	1605	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
466	559	ALGISEDAL	PARACETAMOL+CODEINE	ANALGESIQUE/ANTI-PYRETIQUE P2 / COMPRIMÉS / 400MG/25MG	1192	1550	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
467	560	LE DIABLE CORICIDE	ACIDE SALICYLIQUE	KERATOLYTIQUE / MILLILITRES / 0.0011	1977	2570	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
468	561	GYNO DERMOFIX	SERTACONAZOLE	ANTI-FONGIQUE LOCAL / COMPRIMÉS / 500MG	3169	4120	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
469	562	ARTANE 5	TRIHEXYPHENIDYLE	ANTI-PARKINSONIEN/ANTI-CHOLINERGIQUE / COMPRIMÉS / 5MG	1235	1605	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
470	563	EFFERALGAN CODEINE	PARACETAMOL+CODEINE	ANALGESIQUE/ANTI-PYRETIQUE P2 / COMPRIMÉS / 500MG/30MG	1385	1800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
471	564	TRIFENE	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 200MG	1015	1320	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
472	565	MERCUROCHROME	MERCURESCEINE	ANTISEPTIQUE LOCAL / Millilitres / 0.02	427	555	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
473	566	DERMOFIX	SERTACONAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 20MG	2023	2630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
474	568	HEXAPNEUMINE ADULTES 	CHLORPHENAMINE + PHOLCODINE + BICLOTYMOL	ANTITUSSIF / Millilitres / 12MG/120MG/200MG	1431	1860	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
475	569	ARTANE 10	TRIHEXYPHENIDYLE	ANTI-PARKINSONIEN/ANTI-CHOLINERGIQUE / AMPOULE / 10MG	3562	4630	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
476	570	APIFEN	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 200MG	708	920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
477	571	SOPHITAL	ACIDE SALICYLIQUE	AFFECTION OPHTALMIQUE / MILLILITRES / 0	3127	4065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
478	572	CIVASTINE	SIMVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 10MG	4150	5395	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
479	573	PARACO-DENK	PARACETAMOL+CODEINE	ANALGESIQUE/ANTI-PYRETIQUE P2 / COMPRIMÉS / 500MG/30MG	1323	1720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
480	574	ENTEROGERMINA	BACILLUS CLAUSII	ANTIDIARRHEIQUE / Grammes / 2MILLIARD/5ML	2242	2915	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
481	576	HEMAGENE TAILLEUR	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 200MG	1696	2205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
482	577	SIMVA-DENK 20	SIMVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 20MG	5738	7460	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
483	578	SKIACOL 	CYCLOPENTOTATE	MYDRIATIQUE LOCAL / Millilitres / 0,5%	715	930	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
484	580	ENA DENK	ENALAPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 10MG	3442	4475	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
485	581	PEDIFEN	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	1050	1365	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
486	582	DEBRIDAT	TRIMEBUTINE	ANTI-SPASMODIQUE / COMPRIMÉS / 100MG	3427	4455	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
487	583	ALGESAL SURACTIVE	ACIDE SALICYLIQUE+ DIETHYLAMINE+ MYRTECAINE	ANTALGIQUE PERCUTANE / Grammes / 0	1881	2445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
488	584	BANEOCIN	BACITRACINE+NEOMYCINE	ANTIBIOTIQUE TOPIQUE / GRAMMES / 250UI/500UI	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
489	587	RENITEC	ENALAPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 20MG	15869	20630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
490	588	SIMVA-DENK 40	SIMVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 40MG	7946	10330	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
491	589	BECONASE	DIPROPIONATE DE BECLOMETHASONE	CORTICOIDE INHALE / DOSES / 50UG	4946	6430	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
492	591	PERIACTINE 	CYPROHEPTADINE	ANTIHISTAMINIQUE/ANTI-ALLERGIQUE / Grammes / 4MG	2235	2905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
493	592	ENA+ HCT DENK	ENALAPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 20MG/12.5MG	6623	8610	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
494	593	NUREFLEX	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	1069	1390	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
495	596	CO-RENITEC	ENALAPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 20MG/12.5MG	7742	10065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
496	597	SURGAM	ACIDE TIAPROFENIQUE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 100MG	2473	3215	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
497	598	BEDELIX	BEIDELLITIC MONTMORILLONITE	ANTI-ACIDE/PANSEMENT GASTRO INTESTINAL / SACHETS / 3G	2835	3685	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
498	599	IBUFEN	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	1323	1720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
499	600	PENTASA	MESALAZINE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 500MG	24231	31500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
500	601	TENSIONORME	BENDROFLUMETHIAZIDE+RESERPINE	ANTI-HYPERTENSEUR DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 2.5MG	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
501	602	LEUCO 4 ADENINE	ADENINE	ANTI ASTHENIQUE / COMPRIMÉS / 30MG	2023	2630	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
502	603	NURABOL 	CYPROHEPTADINE	ANTI-HISTAMINIQUE / Millilitre (s) / 4MG	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
503	604	COLOBUTINE	TRIMEBUTINE	ANTI-SPASMODIQUE / COMPRIMÉS / 100MG	1950	2535	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
504	605	EOSINE AQUEUSE	EOSINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.02	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
505	606	IBUPROFENE TM	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	373	485	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
506	607	VITACIC	ADENOSINE+THYMIDINE+CYTIDINE+URIDINE+GUANYLATE	AFFECTION OPHTALMIQUE / MILLILITRES / 0	846	1100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
507	609	PHYSIOMYCINE	METACYCLINE	ANTIBIOTIQUES CYCLINES /  / 300MG	3496	4545	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
508	610	IBUPROFENE DENK	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	1104	1435	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
509	611	DEBRIDAT PED	TRIMEBUTINE	ANTI-SPASMODIQUE / MILLILITRES / 4.8MG	1492	1940	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
510	612	DERMOBACTER	BENZALKONIUM+CHLORHEXIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 500MG/200MG	1146	1490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
511	613	PAIDOFEBRIL	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / MILLILITRES / 100MG/5ML	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
512	614	ANTINOREX	CYPROHEPTADINE	ANTI-HISTAMINIQUE / Millilitres / 2MG/5ML	954	1240	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
513	615	ATEPADENE	ADENOSINE TRIPHOSPHATE	MYORELAXANT / Grammes / 30MG	3435	4465	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
514	616	GLUCOPHAGE	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 850MG	2085	2710	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
515	617	BRUMED	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / MILLILITRES / 100MG/5ML	708	920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
516	618	NURABOL	CYPROHEPTADINE	ANTI-HISTAMINIQUE /  / 4MG	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
517	619	ADRENALINE	ADRENALINE/LIDOCAINE	CHOC ANAPHYLATIQUE / Grammes / 0	6465	8405	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
518	620	SERUM BICARBONATE 1.4% SOL PERF 250ML	BICARBONATE DE SODIUM	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.014	477	620	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
519	621	NUROFEN	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / MILLILITRES / 100MG/5ML	1512	1965	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
520	622	TRIMAREL	TRIMETAZIDINE	ANTI-ANGOREUX / MILLILITRES / 20MG	3092	4020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
521	623	OVIS	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	385	500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
522	624	METFORMIN DENK	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 1000MG	2385	3100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
523	626	MICROLAX BEBE	SORBITOL+CITRATE DE SODIUM+LAURYLSULFOACETATE DE SODIUM	LAXATIF / MILLILITRES / 2.679G/270MG/38.7MG	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
524	627	ALBEN	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	927	1205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
525	628	RANOPHAGE OD	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 1000MG	1615	2100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
526	630	MICROLAX ADULTE	SORBITOL+CITRATE DE SODIUM+LAURYLSULFOACETATE DE SODIUM	LAXATIF / MILLILITRES / 4.465G/450MG/64.5MG	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
527	631	ALBENDAZOLE TM	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	315	410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
528	632	SPIRALIDE	SPIRAMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 3MUI	3842	4995	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
529	633	ROVAMYCINE	SPIRAMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 1.5MUI	3265	4245	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
530	634	APETAMIN 	CYPROHEPTADINE	ANTI-HISTAMINIQUE / Millilitres / 2MG/5ML 	1704	2215	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
531	635	APPETINE 	CYPROHEPTADINE	ANTI-HISTAMINIQUE / Millilitres / 2MG/5MG	1615	2100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
532	637	CORYPHEDRINE	ACIDE ACETYL SALICILYQUE+CHLORYDRATE D'EPHEDRINE	ETAT GRIPPAL / Grammes / 500MG/15MG	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
533	639	ANDROCUR	CYPROTERONE	ANTI-ANDROGENE / COMPRIMÉS / 50MG	9838	12790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
534	640	DOLVIRAN	ACIDE ACETYL SALICILYQUE+CODEINE	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 400MG/9,6MG/50MG	1246	1620	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
535	643	NEVRINE CODEINE	ACIDE ACETYL SALICILYQUE+CODEINE	ANTALGIQUES ASSOCIES / Grammes / 0	1731	2250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
536	646	NEFORT	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 850MG	1731	2250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
537	647	ASPIRINE	ACIDE ACETYLSALICYLIQUE	ANTI-AGREGANT PLAQUETTAIRE / COMPRIMÉS / 100MG	923	1200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
538	648	SIROFEN	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / MILLILITRES / 100MG/5ML	1635	2125	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
539	650	ASPIRINE AVENTIS	ACIDE ACETYLSALICYLIQUE	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	608	790	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
540	651	BRUFEN	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	1723	2240	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
541	653	ASPIRINE PH8	ACIDE ACETYLSALICYLIQUE	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	708	920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
542	654	METFORAL	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 850MG	2023	2630	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
543	655	BUFALGAN	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	1738	2260	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
544	656	DISTEM	METHOCARBAMOL+PARACETAMOL	ANTALGIQUE OSTEO-ARTICULAIRE / Grammes / 380MG/300MG	2827	3675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
545	657	OLFEN	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 75	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
546	660	SALBUMOL	SALBUTAMOL	ANTI-ASTHMATIQUE / SUPPOSITOIRE / 1MG	1750	2275	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
547	661	METHOTREXATE BELLON	METHOTREXATE	ANTICANCEREUX/IMMUNOMODULATEUR ANALOGUE DE L'ACIDE FOLIQUE / COMPRIMÉS / 2.5MG	3177	4130	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
548	662	VOLTARENE	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 0.01	1350	1755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
549	667	ACARILBIAL	BENZOATE DE BENZYLE	ANTI-PARASITAIRE LOCAL / MILLILITRES / 0.3	1750	2275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
550	670	ASCORIL	SALBUTAMOL+BROMHEXINE+GUAF	BRONCHODILATATEUR/MUCOLITIQUE / Millilitres / 0	1138	1480	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
551	671	SPIFEN	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	1431	1860	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
552	673	ALDOMET	METHYLDOPA	ANTI-HYPERTENSEUR CENTRAL / COMPRIMÉS / 250MG	1642	2135	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
553	674	NEO-CODION NOURRISSONS	BENZOATE DE SODIUM+ T. GRINDELIA+ POLYGALA	ANTITUSSIF / Millilitres / 1.4820G/0.6G/79.28G	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
554	675	ASPIRINE UPSA	ACIDE ACETYLSALICYLIQUE	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 1000MG	1846	2400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
555	678	SUPAFEN	IBUPROFENE+PARACETAMOL	ANTI-INFLAMMATOIRE (AINS)/ANALGESIQUE / COMPRIMÉS / 300MG/400MG	669	870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
556	679	METHYLDOPA CREAT	METHYLDOPA	ANTI-HYPERTENSEUR CENTRAL / COMPRIMÉS / 250MG	1523	1980	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
557	680	NUCLEO CMP FORTE 	CYTIDINE + URIDINE	NEUROPATHIES / Grammes / 5MG/3MG 	4096	5325	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
558	681	POMMADE SALICYLEE	ACIDE ACETYLSALICYLIQUE	ANALGESIQUE PERCUTANE / GRAMMES / 0.15	577	750	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
559	683	PAINEX	IBUPROFENE+PARACETAMOL	ANTI-INFLAMMATOIRE (AINS)/ANALGESIQUE / COMPRIMÉS / 400MG/325MG	662	860	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
560	684	PRORHINEL	BENZODODECINIUM + POLYSORBATE	LAVAGE NASAL / Grammes / 0	927	1205	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
561	686	BAUME ST BERNARD	SALICYLATE D'AMYLE+ CAMPHRE RACEMIQUE+LEVOMENTHOL	ANTALGIQUE PERCUTANE / Grammes / 0	1450	1885	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
562	688	PARAFLAM	IBUPROFENE+PARACETAMOL	ANTI-INFLAMMATOIRE (AINS)/ANALGESIQUE / COMPRIMÉS / 400MG/325MG	354	460	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
563	689	LERIN	METHYLERGOMETRINE	UTEROTONIQUE / AMPOULE / 0.2MG/1ML	304	395	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
564	692	VINCISEPTIL OTICO	BENZYDAMINE+FLUOCINOLONE+TETRACAINE+NEOMYCINE+POLYMYXINE B	AFFECTIONS AURICULAIRES / MILLILITRES / 30MG/300MG/1.33MG/5MG/10UI	1235	1605	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
565	693	METHERGIN	METHYLERGOMETRINE	UTEROTONIQUE / COMPRIMÉS / 0.125MG	1731	2250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
566	694	PROFENOL	IBUPROFENE+PARACETAMOL	ANTI-INFLAMMATOIRE (AINS)/ANALGESIQUE / COMPRIMÉS / 400MG/325MG	1146	1490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
567	695	FRAGMINE 	DALTEPARINE	ANTITHROMBOTIQUE /  / 2500UI	2015	2620	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
568	696	DICLOWAL	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 100MG	1758	2285	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
569	697	BAUME AROMA	SALYCYLATE DE MENTHYLE + HE DE GIROFLE + HE DE PIMENT DE JAMAIQUE	ANTALGIQUE PERCUTANE / Grammes / 10G/3G/0.20G	1342	1745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
570	699	ALKA-SELTZER	ACIDE ACETYLSALICYLIQUE+BICARBONATE DE SODIUM	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 324MG	1750	2275	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
571	700	BRUSTAN	IBUPROFENE+PARACETAMOL	ANTI-INFLAMMATOIRE (AINS)/ANALGESIQUE / COMPRIMÉS / 400MG/325MG	865	1125	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
572	705	ASCABIOL	BENZYL BENZOATE+SULFIRAM	ANTI-PARASITAIRE LOCAL / MILLILITRES / 0.3	2473	3215	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
573	706	IBUMOL	IBUPROFENE+PARACETAMOL	ANTI-INFLAMMATOIRE (AINS)/ANALGESIQUE / COMPRIMÉS / 400MG/500MG	969	1260	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
574	707	A CERUMEN	SEL D'ALKYLAMIDO POLYPEPTIDE+COCCOBETAINE+PEG- 120MGD	CERUMENOLYTIQUE / MILLILITRES / 2ML	2096	2725	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
575	708	DISULONE 	DAPSONE + FER	DAPSONE / Grammes / 100MG/200MG	5173	6725	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
576	711	DYNALGIC	ACIDE ACETYLSALICYLIQUE + CAFEINE	ANTALGIQUE / Grammes / 500MG/50MG	973	1265	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
577	714	DAZEN	SERRAPEPTASE	ANTI INFLAMMATOIRE ENZYMATIQUE / Grammes / 10000UI	3154	4100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
578	715	SOULADO	IBUPROFENE+PARACETAMOL	ANTI-INFLAMMATOIRE (AINS)/ANALGESIQUE / COMPRIMÉS / 400MG/500MG	469	610	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
579	717	DULCIPHAK	METHYLSILANETRIOL+ SALICYLATE DE SOD+ PARAHYDROXYCINNAMIQUE	CATARACTE / Millilitres / 5ML+0,05G	750	975	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
580	718	CIPHACET 	PARACETAMOL	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 300MG	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
581	719	SEDASPIR	ACIDE ACETYLSALICYLIQUE+ CODEINE+ CAFEINE	ANTALGIQUE ASSOCIES / Grammes / 500MG/20MG/50MG	1254	1630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
582	721	FORTICOL	DEANOL ACEGLUMATE + CHLORHYDRATE D'HEPTAMINOL	STIMULANT SYSTEME NERVEUX / Grammes / 0,230G/0,180G 	2535	3295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
583	722	IBUPAR	IBUPROFENE+PARACETAMOL	ANTI-INFLAMMATOIRE (AINS)/ANALGESIQUE / MILLILITRES / 100MG/125MG	1588	2065	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
584	723	COLLYRE LAITIER BLEU	METHYLTHIONINIUM + NAPHAZOLINE	VASOCONSTRICTEUR OPHTALMIQUE / Millilitres / 0	1315	1710	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
585	724	PANOL	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / SUPPOSITOIRE / 300MG	973	1265	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
586	727	SELLTOC 	BETACAROT+ALPHA TOCO+VIT C+SELEN+ACID FOLIQ+PYRIDOX+VIT B	ANTIRADICALAIRE / Grammes / 20MG/15UI/75MG/100MCG/1,5MG+3MG+15MCG	2262	2940	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
587	729	PRIMPERAN	METOCLOPRAMIDE	ANTI-EMETIQUE / COMPRIMÉS / 10MG	2073	2695	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
588	730	NACL 0.9% AMPOULE INJECTABLE	CHLORURE DE SODIUM	TROUBLES ELECTROLYTIQUES/SELS MINERAUX / AMPOULE / 0.009	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
589	731	ASPIRINE USPSA	ACIDE ACETYLSALICLIQUE+VITAMINE C	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 0,330g/0,200g	823	1070	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
590	732	DEFAL	DEFLAZACORT	CORTICOIDE / COMPRIMÉS / 30MG	5281	6865	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
591	738	SERUM SALE 0.9% SOL PERF 500ML	CHLORURE DE SODIUM	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.009	608	790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
592	741	SERUM SALE 0.9% SOL PERF 250ML	CHLORURE DE SODIUM	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.009	500	650	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
593	742	TOPAAL	ACIDE ALGINIQUE+ HYDROXYDE D'ALUMINIUM+ CARBONATE DE MG+SILICE	ANTI-ACIDE/PANSEMENT GASTRO INTESTINAL /  / 200MG/30MG/40MG/130G	1812	2355	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
594	744	PARA SPECIAL POUX 	DEPALLETHRINE+ PIPERONYLE	ANTI-PARASITAIRE EXTERNE / Millilitres / 1,8G/7,2G	1996	2595	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
595	749	VOGALENE	METOPIMAZINE	ANTI-EMETIQUE / GELULE / 15MG	2877	3740	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
596	750	ANGINOVAG	DEQUALINIUM+GLYCYRRHETINIQUE+TYROTHRICINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0	1792	2330	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
597	761	AERIUS	DESLORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 5MG	1988	2585	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
598	763	TRIALGIC	IBUPROFENE + PARACETAMOL + CAFEINE	ANTALGIQUES ASSOCIES / Grammes / 200MG/325MG/30MG	1323	1720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
599	764	ANTICOLIQUE	RHE CO+CARDAMOME+HUILE DE CARVI+FENOUILLE+D'ANIS	ANTISPASMODIQUE / Grammes / 0	742	965	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
600	769	IBEX	IBUPROFENE + PARACETAMOL + CAFEINE	ANTALGIQUES ASSOCIES / Grammes / 200MG/325MG/30MG	662	860	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
601	771	FLAGYL	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 250MG	1712	2225	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
602	772	RODERA	DESLORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 5MG	1473	1915	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
603	774	DYNAPAR	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 0.01	919	1195	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
604	778	OTOFA	RIFAMYCINE	AFFECTIONS AURICULAIRES / MILLILITRES / 2MUI	1873	2435	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
605	779	PARACETAMOL UBI	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 120MG/5ML	531	690	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
606	780	FLUDEX	INDAPAMIDE	ANTI-HYPERTENSEUR DIURETIQUE DE L'ANSE / COMPRIMÉS / 1.5LP	4258	5535	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
607	782	DESLOR	DESLORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 5MG	2781	3615	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
608	784	METAZOLE	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	946	1230	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
609	786	RIFAMYCINE CHIBRET	RIFAMYCINE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.01	1662	2160	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
610	787	INDOBIOTIC	INDOMETACINE+GENTAMICINE	AFFECTION OPHTALMIQUE / MILLILITRES / 5MG/15000UI	2250	2925	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
611	788	NIDAZOL	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	1677	2180	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
612	792	METRONIDAZOLE 500TM	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	454	590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
613	797	ROXYL	ROXYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 300MG	3365	4375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
614	799	FLAZSET KIT	AZITHROMYCINE+FLUCONAZOLE+SECNIDAZOLE	ANTIBIOTIQUE/ANTIFONGIQUE/ANTIPARASITAIRE / Grammes / 500MG/1G/150MG	3312	4305	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
615	802	MINIRINMELT	DESMOPRESSINE	ANTI-ENURESIQUE / COMPRIMÉS / 60UG	13246	17220	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
616	805	VAGILEN	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	1546	2010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
617	807	CYCLO 3 FORT	RUSCUS+HESPERIDINE METHYL CHALCONE+VIT C	ANTI-HEMORROÏDAIRE/VEINOTONIQUE / AMPOULE / PM	2631	3420	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
618	808	BACICOLINE	BACITRACINE+ HYDROCORTISONE+COLISTIMETHATE	ANTI-INFECTIEUX OPHTALMIQUE/CORTICOIDE / Millilitres / 0	1423	1850	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
619	809	INDOCOLLYRE	INDOMETACINE	ANTI-INFLAMMATOIRE (AINS) / MILLILITRES / 0.10G	2154	2800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
620	811	TRIDESONIT	DESONIDE	CORTICOIDE TOPIQUE / GRAMMES / 0.0005	1146	1490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
621	815	INDOCID	INDOMETACINE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 25MG	1288	1675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
622	816	LOCAPRED	DESONIDE	CORTICOIDE TOPIQUE / GRAMMES / 0.001	1227	1595	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
623	820	METRONIDAZOLE UBI	METRONIDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 500MG	708	920	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
624	821	LOCATOP	DESONIDE	CORTICOIDE TOPIQUE / GRAMMES / 0.001	1527	1985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
625	823	INDOMETACINE CREAT	INDOMETACINE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 25MG	935	1215	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
626	827	DENKALGIN	PARACETAMOL +ACIDE ACETYL SALICYLIQ + CAFEINE	ANTALGIQUE / Grammes / 205MG/200MG/50MG	1104	1435	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
627	828	FLAZOLE	METRONIDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 500MG	423	550	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
628	831	MAXIDEX	DEXAMETHASONE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.001	627	815	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
629	833	AMIBAZOL	METRONIDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 125MG/5ML	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
630	839	BAYCUTERNE	DEXAMETHASONE+CLOTRIMAZOLE	ANTI-ECZEMATEUX / Grammes / 6MG/150MG T/15G	2473	3215	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
631	842	DAFALGAN CODEINE	PARACETAMOL+CODEINE	ANALGESIQUE/ANTI-PYRETIQUE P2 / GELULE / 500MG/30MG	1262	1640	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
632	845	PERCUTALGINE	DEXAMETHASONE+ SALICYAMIDE+ SALICYLATE HYDROXYETHYLE	ANTALGIQUE PERCUTANE / Grammes / 0	981	1275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
633	847	METRONIDAZOLE QT	METRONIDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 125MG/5ML	423	550	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
634	849	CATALGINE	ACETYLSALICLYATE DE SODIUM + BICARBONATE DE SODIUM	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 500MG	1185	1540	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
635	850	POLARAMINE	DEXCHLORPHENIRAMINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 2MG	935	1215	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
636	852	FOGYL	METRONIDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 200MG	481	625	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
637	857	SUPPLIN	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 250MG	1712	2225	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
638	859	CATACOL	INOSINE+CHLORHEXIDINE	CATARACTE / MILLILITRES / 0.001	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
639	862	FASTORIK PLUS	PSEUDOEPHEDRINE + PARACETAMOL	ETAT GRIPPAL / Grammes / 178MG/5ML	804	1045	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
640	865	RHUMAGRIP	PSEUDOEPHEDRINE + PARACETAMOL	ETAT GRIPPAL / Grammes / 30MG/500MG	996	1295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
641	866	ANTIGRIPPINE 	PARACETAMOL + CODEINE + CAFEINE + ACIDE ASCORBIQUE	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 0	1192	1550	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
642	872	GYNANFORT	METRONIDAZOLE+NEOMYCINE+NYSTATINE	ANTI-FONGIQUE LOCAL / OVULES / 500MG/65MUI/100MUI	1900	2470	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
643	873	CORRECTOL	INOSINE MONOPHOSPHATE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.001	708	920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
644	874	EXTENCILLINE	BENZATHINE BENZYLPENICILINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 2.4MUI	938	1220	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
645	875	CLOFEN	PARACETAMOL + DICLOFENAC	ANTALGIQUE / Grammes / 500MG/50MG	715	930	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
646	876	KETESSE 	DEXKETOPROFENE TROMETAMOL	ANTI-INFLAMMATOIRE (AINS) / Grammes / 25MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
647	877	ACTIFED	PSEUDOEPHEDRINE+ PARACETAMOL+TRIPROLIDINE	ETAT GRIPPAL / Grammes / 0	919	1195	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
648	879	GYNOMAX	HYDROCORTISONE+METRONIDAZOLE+NEOMYCINE+NYSTATINE	ANTI-FONGIQUE LOCAL / OVULES / 5MG/250MG/100MUI/100MUI	2154	2800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
649	881	INSADOL	INSAPONIFIABLE	PARODONTOPATHIE / Grammes / 0	3038	3950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
650	882	RETARPEN	BENZATHINE BENZYLPENICILINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1.2MUI	900	1170	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
651	883	BEPANTHENE	DEXPANTHENOL	TOPIQUE PROTECTEUR / TROPHIQUE / Grammes / 0.05	4662	6060	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
652	886	MELEX	MEXAZOLAM	ANXIOLYTIQUE / COMPRIMÉS / 1MG	4588	5965	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
653	890	ALGOTROPYL	PARACETAMOL + LE CHLORHYDRATE DE PROMETHAZINE	ANTALGIQUE /ANTIHISTAMINIQUE / Grammes / 200MG/5MG	662	860	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
654	891	PIASCLEDINE 300	INSAPONIFIABLES D'AVOCAT ET DE SOJA	ANTIRHUMASTISMAL/PARODONTOPATHIE / Grammes / 100MG/200MG	3638	4730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
655	892	GYNODAKTARIN	MICONAZOLE	ANTI-FONGIQUE LOCAL / COMPRIMÉS / 400MG	2692	3500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
656	893	BENZATHINE BENZYL UBI	BENZATHINE BENZYLPENICILINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Grammes / 1.2MUI	531	690	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
657	894	CINFATOS JARABE 	DEXTROMETHORPHANE	ANTITUSSIF / Millilitres / 10MG	777	1010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
658	896	RHINOFLUIMUCIL	ACETYLCYSTEINE + SULFAT DE TUAMINOHEPTANE	AFFECTIONS RHINOPHARINGEES / Millilitres / 0	1050	1365	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
659	897	INSULINE INSULATARD	INSULINE RETARD	ANTI-DIABETIQUE / MILLILITRES / 100UI	3365	4375	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
660	900	DAKTARIN	MICONAZOLE	ANTI-FONGIQUE LOCAL / GRAMMES / 0.02	3038	3950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
661	901	SPASMODEX	DIHEXYVERINE	ANTI SPAMODIQUE / Grammes / 10	1158	1505	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
662	902	FLUDITEC TOUX SECHE 	DEXTROMETHORPHANE	ANTITUSSIF / Millilitres / 0.0015	1915	2490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
663	903	INSULINE ACTRAPID	INSULINE RAPIDE	ANTI-DIABETIQUE / MILLILITRES / 100UI	3365	4375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
664	904	LAMALINE	PARACETAMOL + OPIUM + CAFEINE	ANTALGIQUE / Grammes / 300MG/10MG/30MG 	962	1250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
665	906	BENZATHINE BENZYLPENICILLINE UBI	BENZATHINE BENZYLPENICILINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 2.4MUI	708	920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
666	907	DIACOL 	DEXTROMETHORPHANE	ANTITUSSIF / Millilitres / 27MG	1750	2275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
667	909	AMUSTIL	IRGASAN DP 300	ANTISEPTIQUE LOCAL / Grammes / 500MG	2023	2630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
668	914	CALTOUX ENFANT	DEXTROMETHORPHANE	ANTITUSSIF / Millilitres / 5MG	804	1045	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
669	915	TILL	IRGASAN DP 300	ANTISEPTIQUE LOCAL / Millilitres / 0.003	1458	1895	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
670	916	INTERTRIGO	ACIDE BENZOIQUE + RESORCINE	ANTIFONGIQUE / Millilitres / 0,10% / 0,50%	1304	1695	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
671	919	FAZOL	ISOCONAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.02	2685	3490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
672	921	CALTOUX ADULTE	DEXTROMETHORPHANE	ANTITUSSIF / Millilitres / 6,65MG	1077	1400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
673	922	FAZOL G	ISOCONAZOLE	ANTI-FONGIQUE LOCAL / OVULES / 300MG	2923	3800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
674	925	MILIAN AQUEUX 	MILIAN AQUEUX	ANTIFONGIQUE/ANTISEPTIQUE / Millilitres / 0	700	910	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
675	926	SARIDON	PARACETAMOL + PROPYPHENAZONE + CAFEINE	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 250MG/150MG/50MG	804	1045	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
676	927	CINFATOS COMPLEXE	DEXTROMETHORPHANE+ PSEUDOEPHEDRINE+ PARACETAMOL	ANTITUSSIF / Millilitres / 10MG/30MG/250MG	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
677	929	MYNOCINE	MINOCYCLINE	ANTIBIOTIQUES CYCLINES /  / 100MG	5500	7150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
678	931	QUINORAL	QUININE	ANTIPALUDIQUE / COMPRIMÉS / 300MG	2119	2755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
679	932	ARTEQUICK	DIHYDROARTEMESININE +PIPERAQUINE + TRIMETHOPRIME	ANTIPALUDIQUE / Grammes / 31,25MG/187,5MG	1696	2205	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
680	933	INOCLIM	ISOFLAVONES DE SOJA	MENOPAUSE / Grammes / 0	5385	7000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
681	934	CYTOTEC VRAC	MISOPROSTOL	ANTI-ULCEREUX/INHIBITEUR DE LA PROSTAGLANDINE E1 / COMPRIMÉS / 200MG	1292	1680	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
682	936	DOLIRHUME	PARACETAMOL + PSEUDOEPHEDRINE	ETAT GRIPPAL / Grammes / 500MG/30MG	1723	2240	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
683	937	VALIUM	DIAZEPAM	ANXIOLYTIQUE/HYPNOTIQUE / MILLILITRES / 0.01	2177	2830	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
684	939	CYTOTEC	MISOPROSTOL	ANTI-ULCEREUX/INHIBITEUR DE LA PROSTAGLANDINE E1 / COMPRIMÉS / 200MG	14396	18715	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
685	941	PANADOL ACTIFAST	PARACETAMOL + SODIUM	ANTALGIQUE / ANTIPYRETIQUE / Grammes / 500MG/173MG	1192	1550	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
686	942	ARCO	DIHYDROARTEMESININE + NAPHTHOQUINE	ANTIPALUDIQUE /  / 125MG/50MG	2823	3670	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
687	944	RISORDAN	ISORBIDE DINITRATE	ANTI-ANGOREUX / COMPRIMÉS / 20MG	2869	3730	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
688	945	CORVASAL	MOLSIDOMINE	ANTI-ANGOREUX / COMPRIMÉS / 2MG	2712	3525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
689	951	FUCIDINE	ACIDE FUSIDIQUE	ANTIBIOTIQUE DIVERS / COMPRIMÉS / 250MG	7004	9105	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
690	956	PHILCO QUININE	QUININE	ANTIPALUDIQUE / COMPRIMÉS / 300MG	423	550	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
691	957	ALAXIN	DIHYDROARTEMESININE	ANTIPALUDIQUE / Millilitres / 160MG	2827	3675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
692	959	ICAZ LP	ISRADIPINE	ANTIHYPERTENSEUR INHIBITEUR CALCIQUE / Grammes / 2.5MG	8346	10850	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
693	960	NASONEX	MOMETASONE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE NASAL / DOSES / 50µG	7904	10275	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
694	961	PARANTAL C1000	PARACETAMOL + VITAMINE C	ETAT GRIPPAL / Grammes / 500MG/1000MG	804	1045	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
695	962	MALACUR 40/320	DIHYDROARTEMISININE+PIPERAQUINE	ANTIPALUDIQUE / COMPRIMES / 40MG/320MG	2869	3730	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
696	963	TIORFAN NRS	RACECADOTRIL	ANTIDIARRHEIQUE / Grammes / 10MG	4131	5370	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
697	967	MORPHINE SULFATE	MORPHINE	ANALGESIQUE MORPHINIQUE /  / 10MG	8254	10730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
698	969	TIORFAN ENF	RACECADOTRIL	ANTIDIARRHEIQUE / Grammes / 30MG	4131	5370	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
699	971	DOZALGIC C	PARACETAMOL + VITAMINE C	ETAT GRIPPAL / Grammes / 500MG/300MG	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
700	976	CANDITRAL	ITRACONAZOLE	ANTIFONGIQUE / Grammes / 100MG	3477	4520	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
701	978	MONSIN	MUPIROCINE	ANTI INFECTIEUX / Grammes / 0.02	1146	1490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
702	980	VOLTARENE DOLO	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 12.5MG	812	1055	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
703	983	JOSACINE 500	JOSAMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	7877	10240	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
704	985	DOLIPREX	PARACETAMOL + VITAMINE C + PSEUDOEPHEDRINE	ETAT GRIPPAL / Grammes / 500MG/250MG/39MG	1146	1490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
705	986	CATAFLAM 	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Millilitres / 25MG	1254	1630	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
706	989	FUCITHALMIC	ACIDE FUSIDIQUE	AFFECTION OPHTALMIQUE/ANTIBIOTIQUE TOPIQUE / GRAMMES / 0.01	1792	2330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
707	991	CORPRIL	RAMIPRIL	ANTI-HYPERTENSEUR I.E.C. / GELULE / 2.5MG	5385	7000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
708	993	JOSACINE 125	JOSAMYCINE	ANTIBIOTIQUE MACROLIDE / MILLILITRES / 125MG	2181	2835	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
709	997	CUTICELL	PARAFFINE	ANTALGIQUE / Grammes / 40X40	1665	2165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
710	998	JOSACINE 250	JOSAMYCINE	ANTIBIOTIQUE MACROLIDE / MILLILITRES / 250MG	3454	4490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
711	999	CETALGAN	MYRISTOLEATE DE CETYL+ACIDE GRAS POLYINSATURE OMEGA 3	ANTIRHUSMATISMAL/ANTALGIQUE /  / 20.5MG/13.5MG/9.5MG	5785	7520	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
712	1003	NAAXIA	N- ACETYLASPARTYL GLUTAMIQUE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE OPHTALMIQUE / MILLILITRES / 0.049	2154	2800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
713	1008	NAABAK	N- ACETYLASPARTYL GLUTAMIQUE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE OPHTALMIQUE / MILLILITRES / 0.049	2692	3500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
714	1012	HUILE DE PARAFFINE	PARAFFINE LIQUIDE	LAXATIF / MILLILITRES / INCONNU	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
715	1014	KAOMUTH	KAOLIN + HYDROXYDE DE MAGNESIUM	ANTI-ACIDE / ANTIFLATULENT / Grammes / 7,7G/1,1G	2869	3730	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
716	1015	FRAXIPARINE	NADROPARINE CALCIQUE	ANTI-THROMBOTIQUE / AMPOULE / 0.3	4369	5680	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
717	1021	MICOZAL	KETOCONAZOLE	ANTI-FONGIQUE / COMPRIMÉS / 200MG	2077	2700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
718	1022	PRAXILENE	NAFTIDROFURYL	ANTI-ISCHEMIQUE / Gramme (s) / 200MG	2473	3215	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
719	1024	DEROXAT	PAROXETINE	ANTI-DEPRESSEUR / COMPRIMÉS / 20MG	7523	9780	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
720	1025	CO-ARTEMAX	DIHYDROARTEMESININE + PIPERAQUINE + TRIMETHOPRIME	ANTIPALUDIQUE / Grammes / 40MG/320MG	3312	4305	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
721	1029	NIZORAL	KETOCONAZOLE	ANTI-FONGIQUE / COMPRIMÉS / 200MG	8308	10800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
722	1030	BIMALARIL NOURRISSON	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / Millilitre (s) / 20MG/120MG	1008	1310	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
723	1031	PASSIFLORINE	PASSIFLORE+AUBEPINE	SEDATIF / MILLILITRES / 125ML	1042	1355	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
724	1034	EXODERIL	NAFTIFINE HYDROCHLORIDE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 10MG	2112	2745	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
725	1036	KETODERM	KETOCONAZOLE	ANTI-FONGIQUE / SACHETS / 0.02	7692	10000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
726	1037	BIMALARIL ENFANT	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / Millilitres / 40MG/240MG	1688	2195	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
727	1042	NAPROSYNE	NAPROXENE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 1000MG	2596	3375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
728	1046	KNZ	KETOCONAZOLE	ANTI-FONGIQUE / COMPRIMÉS / 200MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
729	1049	PHYTORAL	KETOCONAZOLE	ANTI-FONGIQUE / COMPRIMÉS / 200MG	2077	2700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
730	1050	PENICILLINE G SODIQUE	PENICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000000	200	260	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
731	1057	FLOTAC HCG	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 75MG	4408	5730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
732	1058	ACUPAN	NEFOPAM	ANALGESIQUE NON MORPHINIQUE /  / 20MG	2119	2755	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
733	1059	TORENTAL	PENTOXIFYLLINE	ANTI-ISCHEMIQUE / Grammes / 400MG	2188	2845	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
734	1066	CHIBRO CADRON	NEOMYCINE+DEXAMETHASONE	AFFECTION OPHTALMIQUE / MILLILITRES / 350MUI/109,3MG	1288	1675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
735	1068	PROFENID	KETOPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 100MG	2385	3100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
736	1070	NEOMDEXSOL	NEOMYCINE+DEXAMETHASONE	AFFECTION OPHTALMIQUE / MILLILITRES / 350MUI/109,3MG	681	885	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
737	1071	KETONAL	KETOPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 100MG	1500	1950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
738	1073	DEXAGRANE	NEOMYCINE+ DEXAMETHASONE	ANTI-INFECTIEUX OPHTALMIQUE/CORTICOIDE / Millilitres / 5MG+17UI	1315	1710	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
739	1074	BIPROFENID	KETOPROFENE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 150MG	3365	4375	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
740	1075	PEFLACINE MONODOSE	PERFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	2023	2630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
741	1076	SEKISAN	CLOPERASTINE	ANTITUSSIF / Millilitres / 3.54MG/ML 	1873	2435	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
742	1077	KETONAL DUO	KETOPROFENE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 150MG	3300	4290	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
743	1078	DEXACINE	NEOMYCINE+DEXAMETHASONE+NITRATE DE PHENYL	AFFECTION OPHTALMIQUE / MILLILITRES / 0.54%/0.1%/0.002%	1500	1950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
744	1079	SOPHTAL	ACIDE SALICYLIQUE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.001	750	975	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
745	1081	TRANXENE 10	CLORAZEPATE	ANXIOLYTIQUE / HYPNOTIQUE / Grammes / 10MG	1431	1860	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
746	1083	TRANXENE 5	CLORAZEPATE	ANXIOLYTIQUE/HYPNOTIQUE / GELULE / 5MG	865	1125	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
747	1088	POSITON	NEOMYCINE+NYSTATINE+TRIAMCINOLONE	ANTIBIOTIQUE TOPIQUE / GRAMMES / 250MG/10MUI/100MG	1942	2525	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
748	1089	DONTOMYCINE	SPIRAMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 1.5MUI	2915	3790	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
749	1090	TRANXENE 50	CLORAZEPATE	ANXIOLYTIQUE / HYPNOTIQUE / Grammes / 50MG	7708	10020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
750	1093	KETUM	KETOPROFENE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 0.025	1573	2045	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
751	1098	CEBEMYXINE	NEOMYCINE+POLYMYXINE B	AFFECTION OPHTALMIQUE / MILLILITRES / 3400UI/10000UI	1096	1425	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
752	1104	PEPSANE	DIMETICONE + GAIAZULENE	ANTI ACIDE/ PANSEMENT GASTRO INTESTINAL / Grammes / 0	2481	3225	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
753	1106	CANDI-V6	CLOTRIMAZOLE	ANTI-FONGIQUE LOCAL / COMPRIMÉS / 100MG	2562	3330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
754	1107	OSPEN 	PHENOXYMETHYLPENICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINES / Grammes / 1000000 UI	1854	2410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
755	1108	MAXIDROL	NEOMYCINE+POLYMYXINE B+DEXAMETHASONE	AFFECTION OPHTALMIQUE / MILLILITRES / 10500UI/18000UI/3MG	1192	1550	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
756	1110	RODOGYL	SPIRAMYCINE+METRONIDAZOLE	ANTIBIOTIQUE/ANTI-PARASITAIRE / COMPRIMÉS / 0,75MUI/125MG	5069	6590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
757	1114	PROFENID IV	KETOPROFENE	ANTI-INFLAMMATOIRE (AINS) / AMPOULE / 100MG/2ML	635	825	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
758	1116	STARPEN 1000	PHENOXYMETHYLPENICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Grammes / 1G	1485	1930	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
759	1117	ALDACTONE	SPIRONOLACTONE	ANTI-HYPERTENSEUR DIURETIQUE EPARGNEUR POTASSIQUE / COMPRIMÉS / 50MG	3392	4410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
760	1119	CLOTRI DENK	CLOTRIMAZOLE	ANTI-FONGIQUE LOCAL / COMPRIMÉS / 100MG	1423	1850	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
761	1120	POLYDEXA	NEOMYCINE+POLYMYXINE B+DEXAMETHASONE	AFFECTIONS AURICULAIRES / MILLILITRES / 10MG/10000UI/1MG	1192	1550	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
762	1121	ACTINAC PLUS	ACECLOFENAC + PARACETAMOL	ANTI-INFLAMMATOIRE (AINS) / ANTALGIQUE / Grammes / 100MG/500MG	3796	4935	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
763	1122	CANDI	CLOTRIMAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.01	1138	1480	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
764	1124	POLYGYNAX VIRGO	NEOMYCINE+POLYMYXINE B+NYSYATINE	ANTI-FONGIQUE LOCAL / OVULES / 35MIU/35MUI/100MUI	1827	2375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
765	1127	CAMYSTEN	CLOTRIMAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.01	2119	2755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
766	1130	ALDACTAZINE	SPIRONOLACTONE+ALTIZIDE	ANTI-HYPERTENSEUR DIURETIQUE EPARGNEUR POTASSIQUE/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 25MG/15MG	2931	3810	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
767	1131	POLYGYNAX	NEOMYCINE+POLYMYXINE B+NYSYATINE+DIMETHYLPOLYSILAXANE	ANTI-FONGIQUE LOCAL / OVULES / 35MIU/35MUI/100MUI/2.2G	3285	4270	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
768	1133	STARPEN 400	PHENOXYMETHYLPENICILLINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Millilitres / 400MG	1404	1825	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
769	1136	ULCAR	SUCRALFATE	ANTI-ULCEREUX/CYTOPROTECTEUR GASTRIQUE / COMPRIMÉS / 1000MG	4531	5890	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
770	1137	WARIMAZOL	CLOTRIMAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.01	1996	2595	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
771	1139	VIBROCIL GOUTTE	DIMETINDENI+ PHENYLEPHRINUM	DECONGESTIONNANT / SINUSITE / Millilitres / 0	1342	1745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
772	1142	NEOPRED	NEOMYCINE+PREDNISOLONE	AFFECTION OPHTALMIQUE / MILLILITRES / 3500UI/5.5MG	1496	1945	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
773	1144	ZADITEN	KETOTIFENE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / GELULE / 1MG	5908	7680	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
774	1145	ORACILLINE	PHENOXYMETHYLPENICILLINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Millilitres / 250000UI	4062	5280	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
775	1146	VIBROCIL SPRAY	DIMETINDENI+ PHENYLEPHRINUM	DECONGESTIONNANT / SINUSITE / Millilitres / 0	1342	1745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
776	1147	IMAZOLE-V	CLOTRIMAZOLE	ANTI-FONGIQUE LOCAL / COMPRIMÉS / 100MG	1342	1745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
777	1150	NETROMICINE 100	NETILMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 100MG	2065	2685	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
778	1151	LYSAN	SULFACETAMIDE	ANTI-ACNEIQUE / Millilitres / 0	2146	2790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
779	1155	NETROMICINE 150	NETILMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 150MG	2800	3640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
780	1156	LACTEOL	LACTOBACILLUS LB	ANTIDIARRHEIQUE / Grammes / 0	2058	2675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
781	1157	SMECTA	DIOSMECTITE	ANTI-ACIDE/PANSEMENT GASTRO INTESTINAL / SACHETS / 3G	2835	3685	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
782	1158	NEMYCINE	NETILMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 150MG	2231	2900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
783	1159	PHILCO CLOXA 500MG	CLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 500MG	362	470	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
784	1161	ADIAZINE	SULFADIAZINE	ANTIBIOTIQUE SULFAMIDE / COMPRIMÉS / 500MG	1873	2435	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
785	1165	NETROMICINE 25	NETILMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 25MG	723	940	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
786	1166	BUTAZOLIDINE 	PHENYLBUTAZONE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 100MG	435	565	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
787	1167	CLOXA 500 PHILCO	CLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	385	500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
788	1169	FLAMAZINE	SULFADIAZINE	ANTIBIOTIQUE TOPIQUE / GRAMMES / 0.01	2100	2730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
789	1170	NETROMICINE 50	NETILMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 50MG	1165	1515	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
790	1172	DUPHALAC	LACTULOSE	LAXATIF / SACHETS / 10G/15ML	1873	2435	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
791	1174	SILVEREX T/25G	SULFADIAZINE ARGENTIQUE+CHLORHEXIDINE	AFFECTION DERMIQUE/ANTIBIOTIQUE SULFAMIDE TOPIQUE+ANTISEPTIQUE LOCAL / Grammes / 1% / 0.20%	946	1230	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
792	1176	RINOGRIP	PHENYRAMINE + PARACETAMOL + VITAMINE C	ETAT GRIPPAL / Grammes / 0.025/0.500GG/0.200G	1635	2125	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
793	1178	SILVEREX POT/250G	SULFADIAZINE ARGENTIQUE+CHLORHEXIDINE	AFFECTION DERMIQUE/ANTIBIOTIQUE SULFAMIDE TOPIQUE+ANTISEPTIQUE LOCAL / Grammes / 1%/0.20%	5650	7345	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
794	1181	BETACLOX	CLOXACILLINE+AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 250MG/250MG	3365	4375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
795	1182	BETASERC	BETAHISTINE	ANTI-VERTIGINEUX/DEFICIT NEUROSENSORIEL / COMPRIMÉS / 24MG	6065	7885	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
796	1183	LACTULOSE	LACTULOSE	LAXATIF / MILLILITRES / 0	1450	1885	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
797	1185	COMBIMAL	SULFADOXINE+PYRIMETHAMINE	ANTIPALUDIQUE / COMPRIMÉS / 500MG/25MG	362	470	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
798	1186	EUPHON	CODEINE+ ERYSIMUM	ANTITUSSIF / Millilitres / 15MG/45MG	1262	1640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
799	1187	SERC	BETAHISTINE	ANTI-VERTIGINEUX/DEFICIT NEUROSENSORIEL / COMPRIMÉS / 8MG	5042	6555	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
800	1189	DI-HYDAN	PHENYTOINE	ANTI-EPILEPTIQUE / COMPRIMÉS / 100MG	2596	3375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
801	1191	ABUFENE	BETALANINE	MODULATEUR FONCTION GENITALE / Grammes / 400MG	2438	3170	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
802	1192	POLERY ADULTE	CODEINE+ ERYSIMUM	ANTITUSSIF / Millilitres / 64MG/2.4G	1331	1730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
803	1193	HISTALIX AD	DIPHENHIDRAMINE + AMMONIUM + MENTHE	EXPECTORANT / Millilitres / 14MG /135MG /1,1MG	1473	1915	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
804	1194	PHILCO-MAX	SULFADOXINE+PYRIMETHAMINE	ANTIPALUDIQUE / COMPRIMÉS / 500MG/25MG	131	170	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
805	1196	KINAFON	PHLOROGLUCINOL	ANTI-SPASMODIQUE / COMPRIMÉS / 80MG	1250	1625	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
806	1197	CELESTENE	BETAMETHASONE	CORTICOIDE / COMPRIMÉS / 2MG	3073	3995	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
807	1199	LEVANT	LANSOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / Grammes / 15MG	4715	6130	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
808	1200	MADAR	SULFADOXINE+PYRIMETHAMINE	ANTIPALUDIQUE / COMPRIMÉS / 500MG/25MG	288	375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
809	1202	HISTALIX PED	DIPHENHIDRAMINE + AMMONIUM + MENTHE	EXPECTORANT / Millilitres / 7MG /67,5MG /0,55MG	1377	1790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
810	1203	SPASFON LYOC	PHLOROGLUCINOL	ANTI-SPASMODIQUE / COMPRIMÉS / 80MG	1696	2205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
811	1206	MALOXINE	SULFADOXINE+PYRIMETHAMINE	ANTIPALUDIQUE / COMPRIMÉS / 500MG/25MG	415	540	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
812	1207	DIPROSONE	BETAMETHASONE	CORTICOIDE TOPIQUE / MILLILITRES / 0.0005	2023	2630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
813	1208	LOMET	LANSOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 15MG	1146	1490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
814	1209	FANSIDAR	SULFADOXINE+PYRIMETHAMINE	ANTIPALUDIQUE / COMPRIMÉS / 500MG/25MG	777	1010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
815	1210	SPASFON	PHLOROGLUCINOL+TRIMETHYLPHLOROGLUCINOL	ANTI-SPASMODIQUE / COMPRIMÉS / 80MG/80MG	1438	1870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
816	1212	MONOLITUM	LANSOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 15MG	5412	7035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
817	1215	PULMOSERUM ADULTE	CODEINE + GAIACOL	ANTITUSSIF / Millilitres / 0.08G/0.5G	1235	1605	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
818	1216	LANZOR	LANSOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 15MG	16558	21525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
819	1217	BIAKOF	DIPHENHYDRAMINE + CHLORURE D'AMONIUM + CITRATE DE SOD + MENTHOL	ANTITUSSIF / Millilitres / 125MG/100MG/75/2,5MG	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
820	1222	MALAREICH	SULFADOXINE+PYRIMETHAMINE	ANTIPALUDIQUE / Millilitres / 500MG/25MG/5ML	265	345	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
821	1224	MALASTOP	SULFADOXINE+PYRIMETHAMINE	ANTIPALUDIQUE / COMPRIMÉS / 500MG/25MG	477	620	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
822	1227	ONCTOSE	DIPHENHYDRAMINE + LIDOCAINE	ANTIHISTAMINIQUE/ANESTHESIQUE / Grammes / 1G/2G	1500	1950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
823	1229	ALLERGOSONE	BETAMETHASONE	CORTICOIDE / MILLILITRES / 0.0005	2154	2800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
824	1230	LANSEC	LANSOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 30MG	508	660	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
825	1234	LANZOPRAL	LANSOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 30MG	4715	6130	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
826	1235	ALZOL	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	865	1125	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
827	1238	GYNOSPAN	PHLOROGLUCINOL+TRIMETHYLPHLOROGLUCINOL	ANTI-SPASMODIQUE / COMPRIMÉS / 80MG/80MG	1369	1780	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
828	1240	V-DALGIN	DIPYRONE	ANTALGIQUE / ANTIPYRETIQUE / Millilitres / 1.25G/5ML	1458	1895	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
829	1242	DIPROLENE	BETAMETHASONE	CORTICOIDE TOPIQUE / GRAMMES / 0.0005	1200	1560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
830	1243	BENDEX	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	196	255	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
831	1244	PULMODEXANE 	CODEINE + GAIACOL	ANTITUSSIF / Millilitres / 300MG SANS SUCRE 	1819	2365	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
832	1247	RYTHMODAN	DISOPYRAMIDE	ANTIARYHTMIQUE / Grammes / 100MG	3612	4695	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
833	1249	DERMOSONE	BETAMETHASONE	CORTICOIDE TOPIQUE / GRAMMES / 0.0005	873	1135	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
834	1250	GANIDAN	SULFAGUANIDINE	ANTISEPTIQUE INTESTINAL / Grammes / 500MG	769	1000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
835	1251	UNIMINTH	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	531	690	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
836	1252	COLCHICINE OPOCALCIUM	COLCHICINE	ANTI-GOUTTE / COMPRIMÉS / 1MG	1581	2055	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
837	1253	BETNEVAL	BETAMETHASONE	CORTICOIDE TOPIQUE / GRAMMES / 0.001	1792	2330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
838	1254	ORNITAÏNE	L-ORNITHINE CHLORHYDRATE + BETANINE + SORBITOL	CHOLERETIQUE / HEPATOLOGUE /  / 50MG/1G/3G	2877	3740	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
839	1255	CELESTENE CHRONODOSE	BETAMETHASONE	CORTICOIDE / AMPOULE / 5,7MG	1350	1755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
840	1256	BACTRIM	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / COMPRIMÉS / 400MG/80MG	1519	1975	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
841	1258	GDU L KIT	LANSOPRAZOLE + TINIDAZOLE + CLARITHROMYCINE	ANTI-ULCEREUX / ANTIPARASITAIRE / ANTIBACTERIEN / Grammes / 30MG/500MG/250MG	5300	6890	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
842	1259	VEREX	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	777	1010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
843	1260	TAXOTERE	DOCETAXEL	ANTICANCEREUX/AGENT DU FUSEAU CYTOTOXIQUE / MILLILITRES / 20MG	61812	80355	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
844	1262	BERLOCID	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / COMPRIMÉS / 400MG/80MG	1342	1745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
845	1263	COLCHIMAX 	COLCHICINE+ TIEMONIUM+ OPIUM+	ANTIGOUTTEUX / Grammes / 1MG/50MG/12.5MG 	2665	3465	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
846	1264	VERZOL	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	592	770	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
847	1266	UCLAPRIM	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / COMPRIMÉS / 400MG/80MG	1069	1390	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
848	1267	XALATAN	LATANOPROST	ANTI-GLAUCOMATEUX / MILLILITRES / 0.00005	12246	15920	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
849	1269	WORMIZOL	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	138	180	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
850	1270	COTREX	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / COMPRIMÉS / 400MG/80MG	669	870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
851	1271	DIPROSTENE	BETAMETHASONE	CORTICOIDE / AMPOULE / 6.43MG	3019	3925	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
852	1273	XALACOM	LATANOPROST+TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 50µG/5MG	13246	17220	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
853	1275	ZEBEN	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	354	460	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
854	1276	CRYOCHRONO 	COLDSTICK	VASOCONST / ANTI-PRURIT / ANTALG / ANTI-INFLA / Grammes / 0	5158	6705	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
855	1277	DIPROSALIC	BETAMETHASONE+ACIDE SALICYLIQUE	CORTICOIDE TOPIQUE / MILLILITRES / 0.05%/2%	1881	2445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
856	1278	HUMEX ADULTE	PHOLCODINE	ANTITUSSIF / Millilitres / 200MG	2065	2685	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
857	1279	DOCULYSE	DOCUSATE DE SODIUM	BOUCHON DE CERUMEN / Millilitres / 0.5MG	3538	4600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
858	1280	ZOBENOL	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	750	975	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
859	1281	LEVOPHTA	LEVOCABASTINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE OPHTALMIQUE / MILLILITRES / 0.0005	3312	4305	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
860	1282	COLIMYCINE	COLIMYCINE	POLYMYXINE / Grammes / 1MUI	708	920	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
861	1285	XYZALL	LEVOCETIRIZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 5MG	3892	5060	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
862	1286	AZOL	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	812	1055	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
863	1287	DIPROSEPT	BETAMETHASONE+CLIOQUINOL	CORTICOIDE TOPIQUE / GRAMMES / 0.05G/3G	1854	2410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
864	1288	MOTILIUM	DOMPERIDONE	ANTI-EMETIQUE / COMPRIMÉS / 10MG	2138	2780	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
865	1289	RHINATHIOL TOUX SECHE ENF	PHOLCODINE	ANTITUSSIF / Millilitres / 0.0006	1200	1560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
866	1290	MODOPAR 125	LEVODOPA+BENSERAZIDE	ANTI-PARKINSONIEN / GELULE / 100MG/25MG	6115	7950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
867	1291	DROSETUX 	COMPLEXE HOMEOPATIQUE	ANTITUSSIF / Millilitres / 150ML	2031	2640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
868	1292	PERIDYS	DOMPERIDONE	ANTI-EMETIQUE / COMPRIMÉS / 10MG	1923	2500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
869	1294	DEMACOT	BETAMETHASONE + CLOTRIMAZOLE+ GENTAMICINE	ANTI INFLAMMATOIRE/ANTIFONGIQUE/ANTIBIOTIQUE / Grammes / 64MG/10MG /1MG	1358	1765	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
870	1296	BENZOLE	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	512	665	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
871	1297	ALTIM	CORTIVAZOL	CORTICOIDE / AMPOULE / 3.75MG	3319	4315	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
872	1298	TAVANIC	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	6838	8890	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
873	1299	ZENTEL	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	1200	1560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
874	1300	RHINATHIOL TOUX SECHE AD	PHOLCODINE	ANTITUSSIF / Millilitres / 0.0012	1950	2535	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
875	1301	CINET	DOMPERIDONE	ANTI-EMETIQUE / COMPRIMÉS / 10MG	2923	3800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
876	1302	GLEVO	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	5300	6890	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
877	1303	CROMEDIL	CROMOGLICATE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE OPHTALMIQUE / MILLILITRES / 0.02	2085	2710	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
878	1306	LOXOF	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	9696	12605	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
879	1307	CROMSOL	CROMOGLICATE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE OPHTALMIQUE / MILLILITRES / 0.02	681	885	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
880	1308	RANCONTRIM FORTE	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / COMPRIMÉS / 800MG/160MG	804	1045	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
881	1310	OPTICRON	CROMOGLICATE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE OPHTALMIQUE / MILLILITRES / 0.02	2269	2950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
882	1311	MEPAFLOXIN	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 750MG	5385	7000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
883	1313	CELESTAMINE	BETAMETHASONE+DEXCHLORPHENIRAMINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 0.25MG	1335	1735	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
884	1314	UCLAPRIM FORTE	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / COMPRIMÉS / 800MG/160MG	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
885	1315	CUSICRON	CROMOGLICATE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE OPHTALMIQUE / MILLILITRES / 0.04	1608	2090	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
886	1319	DERMOSONE NEO	BETAMETHASONE+NEOMYCINE	CORTICOIDE TOPIQUE / GRAMMES / 0.05%/0.5%	873	1135	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
887	1321	DOGMATIL	SULPIRIDE	NEUROLEPTIQUE / COMPRIMÉS / 200MG	5273	6855	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
888	1322	PRUREX	CROTAMITON	ANTI-PRURIGINEUX / GRAMMES / 0.1	973	1265	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
889	1324	SYNTHOL	LEVOMENTOL+VERATROLE+ RESORCINOL+ AC SALICYLIQUE	ANTISEPTIQUE BUCCAL / Millilitres / 0	1212	1575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
890	1325	BETOPTIC	BETAXOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.0025	2835	3685	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
891	1326	EURAX	CROTAMITON	ANTI-PRURIGINEUX / GRAMMES / 0.1	1846	2400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
892	1328	BRONCALENE ENFANT	PHOLCODINE + CHLORPHENAMINE	ANTITUSSIF / Millilitres / 50MG/10MG	1669	2170	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
893	1330	Z-ZOLE	ALBENDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 400MG	873	1135	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
894	1334	VITAMINE B12 TM SOLUTION INJECTABLE	CYANOCOBALAMINE (VIT B12)	ANTI-ANEMIQUE / AMPOULE / 1000µG	77	100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
895	1335	BRONCALENE ADULTE	PHOLCODINE + CHLORPHENAMINE	ANTITUSSIF / Millilitres / 80MG/13MG	1854	2410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
896	1336	NOZINAN	LEVOMEPROMAZINE	NEUROLEPTIQUE / COMPRIMÉS / 100MG	7073	9195	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
897	1338	HEXASPRAY	BICLOTYMOL	ANTI-SEPTIQUE LOCAL / MILLILITRES / 750MG	1900	2470	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
898	1342	POLERY ENFT	PHOLCODINE + ERYSIMUM	ANTITUSSIF /  / 1MG/29.6MG	1112	1445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
899	1344	CIPTIPHAR 	CIPROFLOXACINE + TINIDAZOLE	ANTIBIOTIQUE QUINOLONES / ANTIPARASITAIRE / Grammes / 500MG/600MG	3165	4115	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
900	1345	DULCOLAX	BISACODYL	LAXATIF / COMPRIMÉS / 5MG	2269	2950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
901	1346	MEGALIS	TADALAFIL	INHIBITEUR SELECTIF DE LA GUANOSINE / Grammes / 10MG	7112	9245	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
902	1348	BIOCALYPTOL	PHOLCODINE + GUAIACOL	ANTITUSSIF / Millilitres / 131MG/19.750MG	1696	2205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
903	1351	CIPTIN FORTE 	CIPROFLOXACINE + TINIDAZOLE	ANTIBIOTIQUE QUINOLONES / ANTIPARASITAIRE / Grammes / 500MG/600MG	2623	3410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
904	1352	DISLEP	LEVOSULPIRIDE	ANTI-EMETIQUE / COMPRIMÉS / 25MG	4062	5280	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
905	1353	CONTALAX	BISACODYL	LAXATIF / COMPRIMÉS / 5MG	981	1275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
906	1354	NOVALDEX	TAMOXIFENE	ANTI-ESTROGENE / Grammes / 10MG	6965	9055	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
907	1357	FISIOGASTROL	CISAPRIDE	ANTIREFLUX / Grammes / 10MG	7735	10055	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
908	1358	NOLVADEX	TAMOXIFENE	ANTICANCEREUX/IMMUNOMODULATEUR ANTI-ANDROGENE / COMPRIMÉS / 20MG	14835	19285	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
909	1359	CUTIPHILE	BISMUTHLEGER+ BISMUTH+ ZINC	ANTISEPTIQUE LOCAL / Gramme (s) / 1G / 1G /5G	1823	2370	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
910	1363	TROPHIRES SP  ENFANT	PHOLCODINE + TENOATE DE SODIUM	ANTITUSSIF / Millilitres / 3MG/50MG	1138	1480	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
911	1365	LODOZ	BISOPROLOL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR BETA-BLOQUANT/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 10MG/6.25MG	6869	8930	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
912	1367	BRONCHO	TEINTURE DE LOBELIE + DE SQUILE + DE REGLISSE + DE STRAMONIUM	MUCOLYTIQUE/BRONCHODILATATEUR / Millilitres / 12ML/3.6ML/24ML/3.6ML	1323	1720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
913	1368	TROPHIRES SP ADULTE	PHOLCODINE + TENOATE DE SODIUM	ANTITUSSIF / Millilitres / 6.65MG/50MG	1369	1780	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
914	1369	LIDENE	DOXYLAMINE	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 15MG	1669	2170	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
915	1370	LEVOTHYROX	LEVOTHYROXINE	ANTI-THYROIDIEN / COMPRIMÉS / 100µG	1296	1685	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
916	1371	ATRICAN	TENONITROZOLE	ANTIPARASITAIRE / Grammes / 250MG	2604	3385	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
917	1379	PHOSPHALUGEL	PHOSPHATE D'ALUMINIUM	ANTI-ACIDE/PANSEMENT GASTRO INTESTINAL / Grammes / 0.2	2200	2860	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
918	1382	SOMAZINA	CITICOLINA	ANTI-ISCHEMIQUE / Grammes / 1000MG	12185	15840	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
919	1384	VITAMINE K1 ROCHE	PHYTOMENADIONE	HEMOSTATIQUE / AMPOULE / 10MG	2235	2905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
920	1385	RAMET DALIBOUR ACIDE	SULFATE DE CUIVRE + SULFATE DE ZINC	ANTISEPTIQUE LOCAL / Grammes / 0	2523	3280	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
921	1386	OXYBOLDINE	BOLDINE+ SULFATE DE SODIUM+DHGENOPHOSPHATE DE SODIUM	CHOLERETIQUE/HEPATOLOGUE / Grammes / 0.5MG / 54MG / 132MG	1812	2355	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
922	1387	XYLOCAINE	LIDOCAINE	ANESTHESIQUE DE SURFACE / Grammes / 0.02	923	1200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
923	1390	NOSPA VRAC	DROTAVERINE	ANTI-SPASMODIQUE / AMPOULE / 40MG	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
924	1393	PASSEDYL	SULFOGAIACOL	FLUIDIFIANT BRONCHIQUE / Millilitres / 1.174G/2.268G F/125ML	1546	2010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
925	1394	AZOPT	BRINZOLAMIDE	ANTI-GLAUCOMATEUX / MILLILITRES / 10MG/ML	8954	11640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
926	1396	SELSUN	SULFURE DE SELENIUM	ANTI-FONGIQUE TOPIQUE / MILLILITRES / 0.025	2915	3790	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
927	1398	VITABACT	PICLOXYDINE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.0005	812	1055	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
928	1402	ARTHROCINE	SULINDAC	ANTI-INFLAMMATOIRE (AINS) / Grammes / 200MG	5758	7485	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
929	1403	AZARGA	BRINZOLAMIDE+TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 10MG/5MG	11673	15175	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
930	1404	FRUCTINES	PICOSULFATE DE SODIUM	LAXATIF / COMPRIMÉS / 5MG	1750	2275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
931	1405	NOSPALGIN	DROTAVERINE + PARACETAMOL + CODEINE	ANTISPAMODIQUE/ANTALGIQUE / Grammes / 40MG/500MG/8MG	1854	2410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
932	1406	XYLOCAINE ADRENALINE	LIDOCAINE+ADRENALINE	ANESTHESIQUE LOCAL / MILLILITRES / 0.02	1000	1300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
933	1407	ACTAPULGITE	ATTAPULGITE	ANTI-ACIDE/PANSEMENT GASTRO INTESTINAL / SACHETS / 3G	2638	3430	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
934	1411	LEXOMIL	BROMAZEPAM	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 6MG	2288	2975	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
935	1412	SKILAX	PICOSULFATE DE SODIUM	LAXATIF / MILLILITRES / 7.5MG	1192	1550	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
936	1413	SOMAZINA 	CITICOLINA	ANTI-ISCHEMIQUE / Grammes / 500MG	12108	15740	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1149	1763	CUTIMED	HYDROGEL	ANTISEPTIQUE / Grammes / 25G	2088	2715	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
937	1415	HUMEX SPRAY	LIDOCAINE+CHLORURE DE BENZALKONIUM	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.300G/0.030G	1696	2205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
938	1416	CALMIXENE	PIMETHIXENE	ANTIHISTAMINIQUE/ANTI-ALLERGIQUE / Millilitres / 0	1492	1940	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
939	1419	EAU PIPI RENAUDIN	EAU POUR PREPARATION INJECTABLE	EAU POUR PREPARATION INJECTABLE / AMPOULE / 0	58	75	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
940	1420	BACTOPOUMON	BROMEHIXINE + COTRIMOXAZOLE	FLUIDIFIANT BRONCHIQUE+ANTIBIOTIQUE / Millilitres / 2.2MG/480G	1396	1815	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
941	1423	DICETEL	PINAVERIUM	ANTI-SPASMODIQUE / COMPRIMÉS / 100MG	4265	5545	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
942	1424	XYLOCAINE NAPHAZOLINE	LIDOCAINE+NAPHAZOLINE	ANESTHESIQUE LOCAL / MILLILITRES / 0.05	1000	1300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
943	1425	BISOLVON	BROMHEXINE	FLUIDIFIANT BRONCHIQUE / Grammes / 4MG	992	1290	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
944	1426	RANCONTRIM	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / MILLILITRES / 200MG/40MG	1077	1400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
945	1427	CALBEN	ALBENDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 400MG	527	685	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
946	1430	CLOVACAINE	LIGNOCAINE+GERANIUM+ CLOVE OIL	ANTI-INFLAMMATOIRE BUCCAL / Millilitres / 20%/300MG	662	860	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
947	1432	TRIMOPRIM	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / MILLILITRES / 200MG/40MG	838	1090	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
948	1434	XATRAL	ALFUZOSINE	HYPERTROPHIE BENIGNE DE LA PROSTATE / COMPRIMÉS / 2.5MG	5573	7245	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
949	1435	DUPLAMOX	BROMHEXINE + AMOXICILLINE	FLUIDIFIANT BRONCHIQUE + ANTIBIOTIQUE / Grammes / 8MG/500MG	2692	3500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
950	1436	BIBACTIN	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / MILLILITRES / 200MG/40MG	973	1265	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
951	1438	LASILIX	FUROSEMIDE	ANTI-HYPERTENSEUR DIURETIQUE DE L'ANSE / COMPRIMÉS / 20MG	1096	1425	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
952	1439	CARMOX 500	BROMHEXINE + AMOXICILLINE	FLUIDIFIANT BRONCHIQUE+ANTIBIOTIQUE / Grammes / 8MG/500MG	1146	1490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
953	1440	NAXY	CLARITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	5385	7000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
954	1441	COTRIM	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / MILLILITRES / 200MG/40MG	527	685	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
955	1445	MEGATRIM	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / MILLILITRES / 200MG/40MG	454	590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
956	1446	NOVALGIN	METAMIZOLE	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	1158	1505	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
957	1447	ZECLAR	CLARITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	5396	7015	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
958	1448	CARMOX 250	BROMHEXINE + AMOXICILLINE	FLUIDIFIANT BRONCHIQUE+ANTIBIOTIQUE / Millilitres / 8MG	808	1050	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
959	1450	COTRIMOXAZOLE UBI	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / MILLILITRES / 480MG/5ML	708	920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
960	1452	CLARIVA	CLARITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	3531	4590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
961	1456	OTOMIDE	HEXAMIDINE+LIDOCAINE	AFFECTIONS AURICULAIRES / MILLILITRES / 0.10G/0.50G	1996	2595	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
962	1457	BINOCLAR 250	CLARITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	4846	6300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
963	1458	PLASMION	GELATINE FLUIDE	SUBSTITUT DE PLASMA / MILLILITRES / 15G	3904	5075	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
964	1459	VIFEX	BROMHEXINE + SALBUMOL+ GUAIFENESIN	FLUIDIFIANT BRONCHIQUE / Millilitres / 2MG/1MG/50MG	1146	1490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
965	1461	OTORALGYL	LIDOCAINE+PHENYLEPHRINE+PROPIONATE DE SODIUM	AFFECTIONS AURICULAIRES / MILLILITRES / 1G/0.25G/5G	1935	2515	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
966	1462	CLARITHRO	CLARITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	4573	5945	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
967	1464	GAVISCON	ALGINATE DE SODIUM + BICARBONATE DE SODIUM + CARBONATE DE CALCIUM	ANTI-ACIDE/PANSEMENT GASTRO INTESTINAL / Unite (s) / 500MG/267MG/160MG	1146	1490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
968	1465	ECONATE VT	ECONAZOLE	ANTI-FONGIQUE LOCAL / OVULES / 150MG	1119	1455	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
969	1466	PECTRYL	BROMHEXINE+SULFOGAICOL	EXPEXTORANT / Millilitres / 0	1262	1640	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
970	1469	GENTADEXA	GENTAMICINE+DEXAMETHASONE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.003	1008	1310	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
971	1476	GYNOPEVARYL	ECONAZOLE	ANTI-FONGIQUE LOCAL / OVULES / 150MG	2596	3375	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
972	1477	SYNCLAR	CLARITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	3381	4395	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
973	1478	ANALGIN	METAMIZOLE	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	538	700	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
974	1480	CALCIBRONAT	BROMO GALACTOGLUCONATE DE CALCIUM	CALCITHERAPIE / Grammes / 2G	2012	2615	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
975	1482	CALGIN	METAMIZOLE	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	592	770	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
976	1483	PARLODEL	BROMOCRYPTINE	INHIBITEUR DE LA PROLACTINE / COMPRIMÉS / 2.5MG	5827	7575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
977	1484	THERALENE	ALIMEMAZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / MILLILITRES / 0.0005	669	870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
978	1485	RESTRIVA	METAMIZOLE	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	1096	1425	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
979	1486	BINOCLAR 500	CLARITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	11850	15405	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
980	1487	TRIVASTAL	PIRIBEDIL	ANTI-PARKINSONIEN / COMPRIMÉS / 50MG	6146	7990	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
981	1488	GYNOPEVARYL LP	ECONAZOLE	ANTI-FONGIQUE LOCAL / OVULES / 150MG	2535	3295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
982	1490	DIMEGAN	BROMPHENIRAMINE	ANTIHISTAMINIQUE / ANTI-ALLERGIQUE / Grammes / 12MG	1750	2275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
983	1493	INFLACAM	PIROXICAM	ANTI-INFLAMMATOIRE (AINS) / Grammes / 10MG	1704	2215	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
984	1494	MYLEUGYN LP	ECONAZOLE	ANTI-FONGIQUE LOCAL / OVULES / 150MG	1854	2410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
985	1499	THERALENE PECTORAL N	ALIMEMAZINE + AMMONIUM + SULFITE + AC CITRIQUE + VIT C	ANTITUSSIF / Millilitres / 0,0313G	708	920	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
986	1500	FELDENE 	PIROXICAM	ANTI-INFLAMMATOIRE (AINS) / Grammes / 20MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
987	1501	SEDORRHOIDE	BROMURE DE DODECLONIUM+ESCULOSIDE+ENOXOLONE+BENZOCAINE	ANTI-HEMORROIDAIRE TOPIQUE / GRAMMES / 0.4G/046G/0.93G/2G	1588	2065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
988	1504	THERALENE PECTORAL AD	ALIMEMAZINE + AMMONIUM + SULFITE + AC CITRIQUE + VIT C	ANTITUSSIF / Millilitres / 62,5MG	646	840	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
989	1511	CICATRYL	ALLANTOINE+ PARACHLOROMETACRESOL+GUALAZULENE+ VIT E	TOPIQUE PROTECTEUR / TROPHIQUE / Grammes / 20MG/2,4MG/0,14MG/0.2	2385	3100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
990	1513	SIROP ARMAND	BROMURE COMPOSE	ANTISPASMODIQUE / Millilitres / 0	1423	1850	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
991	1515	PIROXEN 	PIROXICAM	ANTI-INFLAMMATOIRE (AINS) / Grammes / 20MG	2031	2640	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
992	1516	URBANYL	CLOBAZAM	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 10MG	1485	1930	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
993	1519	STAVIRAL	ALLO SECURINE	ANTI-VIRAL / GELULE / 200MG	2654	3450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
994	1520	DERMOVAL	CLOBETASOL	CORTICOIDE TOPIQUE / GRAMMES / 0.0005	1146	1490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
995	1522	REUMOXICAM	PIROXICAM	ANTI-INFLAMMATOIRE (AINS) / Grammes / 20MG	5923	7700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
996	1525	NOPRON	NIAPRAZINE	ANXIOLYTIQUE / HYPNOTIQUE / Millilitres / 15MG/5ML	8388	10905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
997	1526	ANAFRANIL 10	CLOMIPRAMINE	ANTI-DEPRESSEUR / COMPRIMÉS / 10MG	2127	2765	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
998	1527	FRIDIAL	BROMURE DE PRIFINIUM	ANTI-SPASMODIQUE / MILLILITRES / 250MG	2985	3880	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
999	1529	GELDENE	PIROXICAM	ANTI-INFLAMMATOIRE (AINS) / Grammes / 0.005	1588	2065	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1000	1530	LONGIFENE	BUCLIZINE	ANTIHISTAMINIQUE / Millilitres / 1MG/ML	2331	3030	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1001	1532	ANAFRANIL 25	CLOMIPRAMINE	ANTI-DEPRESSEUR / COMPRIMÉS / 25MG	4204	5465	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1002	1533	LOXEN	NICARDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 20MG	3408	4430	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1003	1534	FELDENE	PIROXICAM	ANTI-INFLAMMATOIRE (AINS) / Grammes / 20MG	2427	3155	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1004	1536	ZYLORIC 100	ALLOPURINOL	ANTI-GOUTTE / COMPRIMÉS / 100MG	1015	1320	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1005	1541	PIROXICAM CREAT	PIROXICAM	ANTI-INFLAMMATOIRE (AINS) / Grammes / 20MG	1723	2240	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1006	1542	RIVOTRIL	CLONAZEPAM	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 2MG	1281	1665	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1007	1544	SERUM GLUCOSE 10% SOL PERF 250ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.1	500	650	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1008	1545	ZYLORIC 200	ALLOPURINOL	ANTI-GOUTTE / COMPRIMÉS / 200MG	1600	2080	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1009	1548	SERUM GLUCOSE 30% SOL PERF 500ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.3	846	1100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1010	1549	RHINOCORT	BUDESONIDE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE NASAL / DOSES / 64MCG	7815	10160	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1011	1550	ENEAS	ENALAPRIL+NITRENDIPINE	ANTI-HYPERTENSEUR I.E.C./INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG/20MG	4858	6315	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1012	1551	RIVOTRIL 	CLONAZEPAM	ANXIOLYTIQUE / HYPNOTIQUE / Grammes / 1MG/ML	3115	4050	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1013	1552	CORAMINE GLUCOSE	NICETHAMIDE+ GLUCOSE	ANALEPTIQUE /  / 125MG/150MG	3204	4165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1014	1553	SERUM GLUCOSE 30% SOL PERF 250ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.3	688	895	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1015	1554	VITAXICAM	PIROXICAM	ANTI-INFLAMMATOIRE (AINS) /  / 20MG	1827	2375	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1016	1555	PARFENAC	BUFEXAMAC	ANTIPRURIGINEUX / Grammes / 0.05	1615	2100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1017	1556	SERUM GLUCOSE 5% SOL PERF 500ML	GLUCOSE ISOTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.05	531	690	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1018	1557	ZYLORIC 300	ALLOPURINOL	ANTI-GOUTTE / COMPRIMÉS / 300MG	2058	2675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1019	1558	SERUM GLUCOSE 5% TM SOL PERF 250ML	GLUCOSE ISOTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.05	462	600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1020	1559	YOMESANE	NICLOSAMIDE	ANTIPARASITAIRE /TENIACIDE / Grammes / 0.5G	1650	2145	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1021	1560	CATAPRESSAN	CLONIDINE	ANTI-HYPERTENSEUR CENTRAL / Unite (s) / 0.15MG	2481	3225	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1022	1561	LOVENOX	ENOXAPARINE	ANTI-THROMBOTIQUE / AMPOULE / 20MG	3946	5130	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1023	1562	GLYCERINE IODEE	GLYCERINE + IODE	ANTISEPTIQUE BUCCAL / Millilitres / 0	735	955	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1024	1564	TEMGESIC	BUPRENORPHINE	ANALGESIQUE MORPHINIQUE / COMPRIMÉS / 0.2MG	4238	5510	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1025	1567	TREDEMINE	NICLOSAMIDE	ANTIPARASITAIRE /  / 500MG	1538	2000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1026	1570	BONCIPRO	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	3092	4020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1027	1571	MEGAMYLASE	ALPHA AMYLASE	ANTI-INFLAMMATOIRE ENZYMATIQUE / COMPRIMÉS / 3000UI	2250	2925	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1028	1572	GYNOMYK	BUTOCONAZOLE	ANTIFONGIQUE LOCAL / Grammes / 100MG	2542	3305	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1029	1573	ZILDAM	PIROXICAM	ANTI-INFLAMMATOIRE (AINS) / Grammes / 20MG	2065	2685	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1030	1574	TROYNOXA	ENOXAPARINE	ANTI-THROMBOTIQUE / AMPOULE / 40MG	2773	3605	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1031	1575	ADALATE	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	2615	3400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1032	1576	CIPFIL	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	415	540	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1033	1579	ROXAM	PIROXICAM	ANTI-INFLAMMATOIRE (AINS) / Grammes / 20MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1034	1580	MIGRALGINE	CAFEINE + PARACETAMOL+ CODEINE	ANTIFONGIQUES ASSOCIES / Grammes / 62.5MG/400MG/20MG	1335	1735	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1035	1582	MAXILASE	ALPHA AMYLASE	ANTI-INFLAMMATOIRE ENZYMATIQUE / COMPRIMÉS / 3000UI	2304	2995	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1036	1584	BACTIFLOX	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 750MG	5738	7460	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1037	1587	BEUFLOX	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 750MG	2038	2650	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1038	1588	ESTULIC	GUANFACINE	ANTIHYPERTENSEUR CENTRAL / Grammes / 2MG	2481	3225	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1039	1589	NIFEDIPINE DENK	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 20MG	1723	2240	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1040	1590	CETRAXAL	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 750MG	5431	7060	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1041	1591	FIXICAL	CALCIUM	CARENCE CALCIQUE / Grammes / 500MG	3638	4730	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1042	1592	PIROXEN	PIROXICAM	ANTI-INFLAMMATOIRE (AINS) / Grammes / 20MG	846	1100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1043	1595	CIPROL	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 750MG	4546	5910	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1044	1596	CHRONO-ADALATE	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 30MG	12408	16130	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1045	1599	CALCIMAX	CALCIUM + MULTIVITAMINE	CALCITHERAPIE / Millilitre (s) / 0	2092	2720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1046	1600	CIPRONAT	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 750MG	3154	4100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1047	1604	SERVIFLOX	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 750MG	5942	7725	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1048	1605	NIFPRESS	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / GELULE / 10MG	1235	1605	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1049	1606	NICICALCIUM ENFANT	CALCIUM+NICOTINATE DE CALCI+VIT C+CHLORURE DE MAGN	ANTI ASTHENIQUE / Grammes / 100MG/5MG/50MG/20MG	1738	2260	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1050	1610	BIOFAR CALCIUM VIT D3	CALCIUM+VIT D3 (VIT C)	CARENCE CALCIQUE / Grammes / 0	2077	2700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1051	1613	IDEOS	CALCIUM+VITAMINE D3	CARENCE CALCIQUE / Grammes / 0	7135	9275	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1052	1617	STAPHYMYCINE	FLUCLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	3258	4235	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1053	1619	RHINAMIDE	EPHEDRINE	RHINITE ALLERGIQUE/SINUSITE / Millilitres / 1G	1062	1380	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1054	1620	ZOFLOX	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 750MG	4415	5740	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1055	1621	FLOXAPEN 500	FLUCLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	4177	5430	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1056	1623	GYNERGEINE	ERGOTAMINE+ CAFEINE	ANTIMIGRAINEUX / Grammes / 1MG/100MG	1662	2160	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1057	1625	XANAX	ALPRAZOLAM	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 0.50MG	1935	2515	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1058	1626	VASCOR	TRIMETAZIDINE	ANTI-ANGOREUX / COMPRIMÉS / 20MG	3592	4670	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1059	1627	FUCLO 500	FLUCLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	2915	3790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1060	1628	TENSTAB	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 20MG	3054	3970	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1061	1631	MIGRETIL	ERGOTAMINE+CAFEINE+BELLADONA+PARACETAMOL	ANTI-MIGRAINEUX / COMPRIMÉS / 1MG/100MG/0.1MG/400MG	1588	2065	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1062	1632	FIXICAL D3	CALCIUM+VITAMINE D3	CARENCE CALCIQUE / Grammes / 500MG	3904	5075	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1063	1633	FLOXAPEN 125	FLUCLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 125MG/5ML	3231	4200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1064	1635	CARY	ERYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	915	1190	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1065	1636	VASTAREL	TRIMETAZIDINE	ANTI-ANGOREUX / COMPRIMÉS / 35MG	5677	7380	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1066	1638	CILOXAN	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / GRAMMES / 0.003	3004	3905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1067	1639	EFFCAL	CALCIUM + VITAMINE D3	CALCITHERAPIE / Grammes / 400MG/20UI	1077	1400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1068	1640	METEOSPASMYL	ALVERINE + SIMETICONE	ANTISPASMODIQUE / Grammes / 60MG/500MG	2038	2650	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1069	1641	APTHROMYCIN	ERYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1070	1643	STAPHYPEN	FLUCLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 125MG/5ML	2738	3560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1071	1644	NIFCAL	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	2023	2630	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1072	1646	ERY 500	ERYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	3127	4065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1073	1647	CIPROXINE	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 100MG	6058	7875	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1074	1648	CALCID DENK	CALCIUM + VITAMINE D3(CHOLECALCIFEROL)	CALCITHERAPIE / Grammes / 1000MG/880IU	3531	4590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1075	1650	AMBROX DENK	AMBROXOL	MUCOLYIQUE / Grammes / 60MG	2738	3560	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1076	1651	ERYFLUID	ERYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / MILLILITRES / 0.04	1146	1490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1077	1652	FLOXAPEN 250	FLUCLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 250MG/5ML	4846	6300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1078	1654	HEXOMEDINE	HEXAMIDINE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 1MG	2119	2755	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1079	1656	FUCLO 250	FLUCLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 250MG/5ML	3354	4360	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1080	1657	TYFLOX	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 200MG	3973	5165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1081	1658	DIASTOP	CALCIUM CARBONATE+ KAOLIN+ ANISE+LEMON	ANTIDIARRHEIQUE / Millilitres / 0	804	1045	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1082	1659	TRINITRINE SIMPLE LALEUF	TRINITRINE	ANTI-ANGOREUX / COMPRIMÉS / 0.15MG	1519	1975	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1083	1660	ERY 125	ERYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / SACHETS / 125MG	1800	2340	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1084	1663	ERY 250	ERYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / SACHETS / 250MG	1812	2355	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1085	1665	CALCIUM 10% AMPOULE INJECTABLE	GLUCONATE CALCIUM	TROUBLES ELECTROLYTIQUES/SELS MINERAUX / AMPOULE / 0.1	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1086	1666	MUXOL	AMBROXOL	FLUIDIFIANT BRONCHIQUE / Millilitres / 0,3%	1800	2340	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1087	1667	CIPROFLOXACINE TM	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 200MG	454	590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1088	1668	FIRMAC	ERYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / MILLILITRES / 125MG/5ML	965	1255	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1089	1669	ASTAPH	FLUCLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 250MG/5ML	1988	2585	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1090	1670	CYCLADOL  	PIROXICAM-B-CYCLODEXTRINE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 20MG	4919	6395	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1091	1672	CIPROFLOXACINE UBI	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 100MG	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1092	1673	MUCODRAINOL	AMBROXOL	FLUIDIFIANT BRONCHIQUE / Millilitres / 30MG/5ML	1446	1880	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1093	1674	CALCIUM SANDOZ	CALCIUM GLUCONATE ET CARBONATE	CALCITHERAPIE / Grammes / 500MG	1500	1950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1094	1675	BIAFINE	TROLAMINE	PROTECTEUR TOPIQUE / GRAMMES / 0.670G	1385	1800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1095	1676	TRIFLUCOZOLE	FLUCONAZOLE	ANTI-FONGIQUE / COMPRIMÉS / 150MG	1758	2285	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1096	1677	PANFUREX	NIFUROXAZIDE	ANTI DIARRHEIQUE / Gramme (s) / 200MG	2269	2950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1097	1678	CYCLADOL 	PIROXICAM	ANTI-INFLAMMATOIRE (AINS) / Grammes / 20MG	4919	6395	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1098	1679	MUKESTAT	FLUCONAZOLE	ANTI-FONGIQUE / COMPRIMÉS / 150MG	1465	1905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1099	1681	MYDRIATICUM	TROPICAMIDE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.005	1288	1675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1100	1683	FORCAN	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 50MG	492	640	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1101	1684	SELEXID	PIVMECILLINAM	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Grammes / 200MG	3038	3950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1102	1687	BROXOL	CHLORPHENAMINE	BRONCHODILATATEUR/MUCOLITIQUE / Millilitres / 0	1412	1835	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1103	1688	RIBATRAN	TRYPSINE+RIBONUCLEASE PANCREAT+CHYMOTRYPSINE	ANTI-INFLAMMATOIRE ENZYMATIQUE / COMPRIMÉS / 200/20/2000µKATALS	2596	3375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1104	1691	FLUCAZOL	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 100MG	1500	1950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1105	1692	ESIDREX	HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 25MG	585	760	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1106	1693	RADIOSELECTAN UV 76%	AMIDOTRIZOATE+AMIDOTRIZOATE DE MEGLUMINE+CALCIEDETATE	PRODUIT DE CONTRASTE / MILLILITRES / 0.76	2131	2770	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1107	1694	DIFLUCAN	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	5846	7600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1108	1696	MYCODECYL	UNDECYLENIQUE ACIDE	ANTIFONGIQUE / Grammes / 0	1927	2505	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1109	1697	SANMIGRAN	PIZOTIFENE	ANTIMIGRAINEUX / Grammes / 0.50MG	3831	4980	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1110	1698	SPREGAL	ESDEPALLETHRINE+BUTOXIDE DE PIPERONYLE	ANTI-PARASITAIRE LOCAL / MILLILITRES / 0.663%/5.305%	2827	3675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1111	1700	DIFFU-K	CHLORURE DE POTASSIUM	TROUBLES ELECTROLYTIQUES/SELS MINERAUX / GELULE / 600MG	1308	1700	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1112	1701	INEXIUM	ESOMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	7169	9320	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1113	1702	ZELITREX	VALACICLOVIR	ANTI-VIRAL / COMPRIMÉS / 500MG	11850	15405	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1114	1703	NEO-CODION ENFANT	CAMPHOSULFONATE DE CODEINE	ANTITUSSIF / Millilitres / 0.1098G	1131	1470	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1115	1707	CIFRAN OD 	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONES / Grammes / 1000MG	6004	7805	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1116	1708	EUPHYTOSE	VALERIANE+ PASSIFLORE+ AUBEPINE+BALLOTE	SEDATIF / Grammes / 0	2623	3410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1117	1709	NEO-CODION ADULTE	CAMPHOSULFONATE DE CODEINE	ANTITUSSIF / Millilitres / 0.1722G	1362	1770	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1118	1710	CIFRAN	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 250MG	4573	5945	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1119	1711	KCL 10% AMPOULE INJECTABLE	CHLORURE DE POTASSIUM	TROUBLES ELECTROLYTIQUES/SELS MINERAUX / MILLILITRES / 0.1	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1120	1712	DIARYL	NIFUROXAZIDE	ANTI DIARRHEIQUE / Grammes / 200MG	1485	1930	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1121	1713	PROGYNOVA	ESTRADIOL	OESTRO-PROGESTATIF / COMPRIMÉS / 2MG	3604	4685	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1122	1714	DEPAKINE 200	VALPROATE DE SODIUM	ANTI-EPILEPTIQUE / COMPRIMÉS / 200MG	2112	2745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1123	1716	CATEX	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	4369	5680	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1124	1717	CLIMENE	ESTRADIOL+CYPROTERONE	OESTRO-PROGESTATIF / COMPRIMÉS / 2MG/1MG	4696	6105	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1125	1719	BETADINE	POVIDONE IODEE	ANTI-SEPTIQUE TOPIQUE / GRAMMES / 10G	812	1055	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1126	1721	DEPAKINE CHRONO 500	VALPROATE DE SODIUM	ANTI-EPILEPTIQUE / COMPRIMÉS / 500MG CHRONO	6577	8550	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1127	1722	ALCOOL IODE	ETHANOL + IODE	ANTISEPTIQUE LOCAL / Millilitres / 0	838	1090	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1128	1723	MODUCREN	AMILORIDE+TIMOLOL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR BETA-BLOQUANT/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 2.5MG/10MG/25MG	3346	4350	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1129	1725	ATACAND	CANDESARTAN	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II / COMPRIMÉS / 16MG	15169	19720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1130	1726	FLUCESS	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	4238	5510	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1131	1729	CYPLOX	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1132	1731	NOMYC	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	3092	4020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1133	1733	CORDARONE	AMIODARONE	ANTI-ARYTHMIQUE / COMPRIMÉS / 200MG	7038	9150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1134	1737	FUNZOL	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	2119	2755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1135	1739	ALCOOL DE MENTHE	ETHANOL + MENTHE	ANTISEPTIQUE LOCAL / Millilitres / 0	192	250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1136	1741	RONZOLE	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	1546	2010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1137	1742	TRIFLUCID	ETHANOL + TRICLOSAN	ANTISEPTIQUE / Millilitres / 0	1188	1545	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1138	1745	APAZIDE	NIFUROXAZIDE	ANTI DIARRHEIQUE / Millilitres / 40MG	1185	1540	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1139	1746	FLOXIN	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 750MG	3354	4360	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1140	1747	FLUZON	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1141	1748	STRESAM	ETIFOXINE CHLORHYDRATE	ANXIOLYTIQUE / GELULE / 50MG	1581	2055	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1142	1751	ANOMEX	HYDROCORTISONE+LIDOCAÏNE+OXYDE DE ZINC+ALLANTOÏNE	ANTI-HEMORROÏDAIRE/VEINOTONIQUE / SUPPOSITOIRE / 0.25%/3%/5%/0.5%	3973	5165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1143	1753	PROCTOLOG	TRIMEBUTINE+RHUSCOGENINE	ANTI-HEMORROÏDAIRE/VEINOTONIQUE / SUPPOSITOIRE / 120MG/10MG	1677	2180	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1144	1754	LAROXYL	AMITRIPTYLINE	ANTI-DEPRESSEUR / COMPRIMÉS / 25MG	2877	3740	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1145	1755	BETADINE TULLE	POVIDONE IODEE	ANTI-SEPTIQUE TOPIQUE / PANSEMENT / 0.1	1838	2390	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1146	1757	EFFORTIL	ETILEFRINE	ANTI-HYPOTENSEUR / COMPRIMÉS / 5MG	1712	2225	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1147	1758	ENTERAL	NIFUROXAZOLE	ANTI-INFECTUEUX INTESTINAL / Grammes / 200MG	1077	1400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1148	1759	CETRAXAL OTICO	CIPROFLOXACINE	AFFECTIONS AURICULAIRES / MILLILITRES / 2MG	3092	4020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1150	1764	ERCEFURYL	NIFUROXAZOLE	ANTI-INFECTUEUX INTESTINAL / Grammes / 200MG	2031	2640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1151	1765	BETADINE DERMIQUE JAUNE	POVIDONE IODEE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.1	1008	1310	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1152	1766	CETRAXAL PLUS	CIPROFLOXACINE+FLUOCINOLONE	AFFECTIONS AURICULAIRES / MILLILITRES / 3MG/0.25MG	3523	4580	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1153	1768	TRIFLUCAN	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 50MG	13035	16945	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1154	1769	INTRASITE	HYDROGEL	ANTISEPTIQUE / Grammes / 0	3292	4280	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1155	1773	BETADINE VERT	POVIDONE IODEE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.1	1062	1380	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1156	1775	CIPROZOLE 	CIPROFLOXACINE + TINIDAZOLE	ANTIBIOTIQUE QUINOLONES / ANTIPARASITAIRE / Grammes / 250MG/300MG	4381	5695	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1157	1779	BETADINE SCRUB	POVIDONE IODEE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.04	927	1205	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1158	1780	CIFRAN CT 	CIPROFLOXACINE + TINIDAZOLE	ANTIBIOTIQUE QUINOLONES / ANTIPARASITAIRE / Grammes / 500MG/600MG	6058	7875	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1159	1781	COOLZ	HYDROXYDE D'AL + TRISILICAT DE MG + HYDROX DE MG + SIMETHICONE	ANTI ACIDE/ PANSEMENT GASTRO INTESTINAL / Millilitres / 300MG/50MG/25MG/10MG	2338	3040	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1160	1783	CAPSULIDE	NIMESULIDE	ANTI-INFLAMMATOIRE (AINS) /  / 100MG	396	515	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1161	1784	AMAPINE	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	1615	2100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1162	1786	SLIDUM	NIMESULIDE	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 100MG	2473	3215	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1163	1787	CIPROMED-TZ 	CIPROFLOXACINE + TINIDAZOLE	ANTIBIOTIQUE QUINOLONES / ANTIPARASITAIRE /  / 500MG/600MG 	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1164	1789	NEXEN	NIMESULIDE	ANTI-INFLAMMATOIRE (AINS) /  / 100MG	4362	5670	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1165	1791	AMLIBON	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	10596	13775	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1166	1792	BETADINE BLEUE	POVIDONE IODEE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0	919	1195	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1167	1793	DEPAKINE 500	VALPROATE DE SODIUM	ANTI-EPILEPTIQUE / COMPRIMÉS / 500MG	5254	6830	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1168	1794	COVATINE	CAPTODIAMINE	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 50MG	2031	2640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1169	1795	RHEUMA DENK	ETOFENAMATE	ANTALGIQUE PERCUTANE / Grammes / 100MG	1758	2285	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1170	1797	LYSANXIA 10	PRAZEPAM	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 10MG	1881	2445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1171	1799	DAZEL KIT	FLUCONAZOLE + AZITHROMICYNE + SECNIDAZOLE	ANTIFONGIQUE/ANTIBACTERIEN/ANTIPARASITAIRE / Grammes / 150MG/1G/1G	3531	4590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1172	1800	AMLOR	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	10200	13260	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1173	1801	DEPAKINE	VALPROATE DE SODIUM	ANTI-EPILEPTIQUE / MILLILITRES / 200MG/ML	3181	4135	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1174	1802	ZENAVAN	ETOFENAMATE	ANTALGIQUE PERCUTANE / Grammes / 50MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1175	1803	TAGAMET	CIMETIDINE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / Grammes / 200MG	3442	4475	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1176	1805	LOPRIL	CAPTOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 25MG	5104	6635	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1177	1806	NIM	NIMESULIDE	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 100MG	2692	3500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1178	1807	SAFORELLE	EXTRAITS DE BARDANE	ANTIFONGIQUE ANTIBACTERIEN / Millilitres / 0	2792	3630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1179	1808	BILTRICIDE	PRAZIQUANTEL	ANTI-PARASITAIRE / COMPRIMÉS / 600MG	6269	8150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1180	1809	LOFRAL	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	7065	9185	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1181	1811	PANOTILE	FLUDROCORTISONE+POLYMYXINE B+NEOMYCINE+LIDOCAINE	AFFECTIONS AURICULAIRES / MILLILITRES / 8MG/8000UI/80MG/320MG	1146	1490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1182	1812	MAGNESIA CINFA	HYDROXYDE D'ALUMINIUM	PANSEMENT GASTRO INTESTINAL / MILLILITRES / 1G	1485	1930	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1183	1813	NOVOGESIC	NIMESULIDE	ANTI-INFLAMMATOIRE (AINS) / Millilitres / 50MG	1288	1675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1184	1815	MEDROL	PREDNISOLONE	CORTICOIDE / COMPRIMÉS / 16MG	3354	4360	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1185	1816	STALOD	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	4858	6315	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1186	1817	TENSOPREL	CAPTOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 25MG	7277	9460	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1187	1818	CIPRO	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 0.003	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1188	1820	TAREG	VALSARTAN	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II / COMPRIMÉS / 160MG	18800	24440	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1189	1821	DIP	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	6181	8035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1190	1823	CAPOCARD	CAPTOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 25MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1191	1824	APURONE	FLUMEQUINE	ANTIBIOTIQUE QUINOLONES / Grammes / 400MG	7000	9100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1192	1826	AGREAL	VERALIPRIDE	MODULATEUR FONCTION GENITALE / Grammes / 100MG	4781	6215	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1193	1827	AMPUCARE	EXTRAITS DE PLANTES	ANTI-INFLAMMATOIRE /GERMICIDE/ANTIFONGIQUE / Millilitres / 0	3023	3930	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1194	1829	ALOX	HYDROXYDE DE MAGNESIUM+HYDROXYDE D'ALUMINIUM	ANTI ACIDE/ PANSEMENT GASTRO INTESTINAL / Unite (s) / 400MG/400MG	1323	1720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1195	1830	CORTANCYL	PREDNISOLONE	CORTICOIDE / COMPRIMÉS / 20MG	2119	2755	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1196	1831	DIPICOR	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	8831	11480	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1197	1833	LOCASALENE	FLUMETASONE + ACIDE SALICYLIQUE	CORTICOIDE ASSOCIE / Grammes / 0.02G/3G	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1198	1834	CIPRODYNE	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 250MG	2208	2870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1199	1835	ISOPTINE LP	VERAPAMIL	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 240MG	5450	7085	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1200	1836	AMADAY	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	6269	8150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1201	1838	ULCETRAX	FAMOTIDINE	ANTI-ULCEREUX/INHIBITEUR DE LA PROSTAGLANDINE E1 / Grammes / 20MG	3869	5030	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1202	1839	VITAMINE A FAURE COLLYRE	RETINOL (VIT A)	AFFECTION OPHTALMIQUE / MILLILITRES / 15000UI	892	1160	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1203	1840	NIBIOL FORTE	NITROXOLINE	ANTIBIOTIQUE OXYQUINOLEINES /  / 100MG	1131	1470	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1204	1841	SOLUPRED	PREDNISOLONE	CORTICOIDE / COMPRIMÉS / 20MG	2738	3560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1205	1844	MAGNESIE	HYDROXYDE DE MAGNESIUM + SACCHAROSE	LAXATIF / Grammes / 4,09G/0,40G	2988	3885	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1206	1845	FAMOTIDINE DENK	FAMOTIDINE	ANTI-ULCEREUX/INHIBITEUR DE LA PROSTAGLANDINE E1 / Grammes / 40MG	3442	4475	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1207	1846	ASOMEX	AMLODIPINE	ANTIHYPERTENSEUR INHIBITEUR CALCIQUE / Grammes / 2,5MG	7065	9185	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1208	1847	CIPROX	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 250MG	1750	2275	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1209	1848	COTIPRED	PREDNISOLONE	CORTICOIDE / COMPRIMÉS / 20MG	3542	4605	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1210	1849	LOCACORTENE	FLUMETASONE + NEOMYCINE	CORTICOIDE + ANTIBIOTIQUE / Grammes / 0.02G/3.410	2888	3755	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1211	1850	LUTENYL	NOMEGESTROL	OESTRO-PROGESTATIF / Unite (s) / 5MG	3073	3995	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1212	1851	HIPOTENSIL	CAPTOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 25MG	3931	5110	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1213	1856	LIPANTHYL	FENOFIBRATE	HYPOLIPEMIANT / COMPRIMÉS / 200MG	7946	10330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1214	1857	PRIMOLUT NOR	NORETHISTERONE	OESTRO-PROGESTATIF / Unite (s) / 10MG	1500	1950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1215	1858	BEVIDOXINE B1, B6, B12	VITAMINE B1 + VITAMINE B6 + VITAMINE B12	SYSTEME NERVEUX PERIPHERIQ ET CENTRAL / Grammes / 100MG/200MG/250MG	1988	2585	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1216	1859	CAPTOPRIL DENK	CAPTOPRIL	ANTIHYPERTENSEUR INHIBITEUR DE L'ENZYME DE CONVERSION / Grammes / 25MG	5500	7150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1217	1863	ALKOCORTENBIOFORM	FLUMETHASONE + CLIOQUINOL	ANTIALLERGIQUE CORTICOIDE / Grammes / 0.02G/3G	3973	5165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1218	1865	FLOXSOL	NORFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 0.003	681	885	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1219	1867	SOLU-MEDROL	METHYLPREDNISOLONE	CORTICOIDE / AMPOULE / 120MG	2827	3675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1220	1868	NEUROBION	VITAMINE B1 + VITAMINE B6 + VITAMINE B12	NEVRALGIE/NEPHRITE / Grammes / 200MG/200MG/1MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1221	1869	ALCIPRO	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 250MG	1235	1605	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1222	1870	ROHYPNOL	FLUNITRAZEPAM	ANXIOLYTIQUE / HYPNOTIQUE / Grammes / 1MG	854	1110	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1223	1871	LOMEXIN	FENTICONAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.02	2100	2730	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1224	1872	NORFLOXACINE TM	NORFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 0.003	542	705	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1225	1875	PRINCI B FORT	THIAMINE (VIT B1) + PYRIDOXINE (VIT B6) + CYANOCOBALAMINE (VIT B12)	ANTI-PARESTHESIQUE / Grammes / 250MG/250MG/1MG	3054	3970	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1226	1876	CHIBROXINE	NORFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 0.003	1996	2595	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1227	1877	GONIOSOL	HYDROXYETHYLCELLULOSE + NITRATE DE PHENYLMERCURE	DIAGNOSTIC EN OPHTAMOLOGIE / Millilitres / 1,3G/0,002G	3204	4165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1228	1878	CAPTOPRIL HCT DENK	CAPTOPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/25MG	3442	4475	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1229	1879	TERLOMEXIN	FENTICONAZOLE	ANTI-FONGIQUE LOCAL / OVULES / 200MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1230	1881	NOROXINE	NORFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	3912	5085	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1231	1882	VITAMINE B12 ALLERGAN COLLYRE	CYANOCOBALAMINE (VIT B12)	AFFECTION OPHTALMIQUE / MILLILITRES / 0.0005	2569	3340	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1232	1883	FER UCB	FER	ANTI-ANEMIQUE / Grammes / 178MG/5ML	2746	3570	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1233	1884	ECAZIDE	CAPTOPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/25MG	7050	9165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1234	1885	UROCTAL	NORFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	5988	7785	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1235	1886	ANTIBIO-SYNALAR	FLUOCINOLONE + POLYMYXINE B+ NEOMYCINE	ANTI INFLAMMATOIRE/ANTI INFECTIEUX AURICULAIRE / Millilitres / 0	1262	1640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1236	1887	ARGYROL	VITTELINATE D'ARGENT	ANTISEPTIQUE OPHTALMIQUE / Millilitres / 0.01	804	1045	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1237	1890	FUMAFER	FER	ANTI-ANEMIQUE / COMPRIMÉS / 66MG	1369	1780	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1238	1892	CERULYSE	XYLENE	CERUMENOLYTIQUE / MILLILITRES / 500 MG	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1239	1893	FLEX NOR	NORFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	1015	1320	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1240	1894	AMCARD	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	3969	5160	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1241	1895	FLUSKIN	FLUOCINONIDE	CORTICOIDE TOPIQUE / GRAMMES / 50MG	873	1135	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1242	1896	CAPTOHEXAL	CAPTOPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/25MG	2623	3410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1243	1897	SODROL	METHYLPREDNISOLONE	CORTICOIDE / AMPOULE / 40MG	1050	1365	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1244	1899	NORFEN	NORFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	3796	4935	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1245	1901	CARDIURINE	CAPTOPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/25MG	2515	3270	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1246	1903	DEPOMEDROL	PREDNISOLONE	CORTICOIDE / AMPOULE / 40MG	1227	1595	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1247	1904	NORFIX	NORFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1248	1905	FERRO DENK	FER	ANTI-ANEMIQUE / Grammes / 50MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1249	1906	FASTORIK	XYLOMETAZOLINE	VASOCONSTRITEUR /DECONGEST NASAL / Millilitres / 0,05%	881	1145	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1250	1907	FLUCON	FLUOROMETHOLONE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.1G	892	1160	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1251	1910	TEGRETOL	CARBAMAZEPINE	ANTI-EPILEPTIQUE / COMPRIMÉS / 200MG	3904	5075	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1252	1913	CIPRODAC	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	4035	5245	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1253	1914	ZYMAFLUOR	FLUORURE DE SODIUM	ELEMENT MINERAL DENTAIRE / Grammes / 0.25	823	1070	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1254	1917	CIPRO DENK	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1255	1918	NORFLOXINE CINFA	NORFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	4415	5740	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1256	1921	TARDYFERON 80MG	FER	ANTI-ANEMIQUE / COMPRIMES / 80MG	1862	2420	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1257	1923	CIPRO DOR	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	1358	1765	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1258	1927	CIPROBIOTIC	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	1527	1985	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1259	1928	OFLOCET	OFLOXACINE	ANTIBIOTIQUE QUINOLONE / DOSES / 1.5G	3638	4730	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1260	1930	FERROSTRANE	FER	ANTI-ANEMIQUE / MILLILITRES / 0.0068	1588	2065	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1261	1931	NORMET	NORFLOXACINE+METRONIDAZOLE	ANTIBIOTIQUE/ANTIPARASITAIRE / Gramme (s) / 200MG/200MG	2208	2870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1262	1932	DERINOX	PREDNISOLONE + NAPHAZOLINE	DECONGESTIONNANT/RHINITE ALLERGIQUE / Millilitres / 0	1335	1735	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1263	1935	NEO MERCAZOLE	CARBIMAZOLE	ANTI-THYROIDIEN / COMPRIMÉS / 20MG	2912	3785	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1264	1936	OFLOCINE	OFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 200MGIV	3092	4020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1265	1938	CIPROMED	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1266	1939	PROZAC	FLUOXETINE	ANTI-DEPRESSEUR / GELULE / 20MG	4688	6095	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1267	1940	LOPINE	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	3973	5165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1268	1943	ASTYFER	FER + ACIDE AMINE + VITAMINES	ANTI-ANEMIQUE / Grammes / 0	2138	2780	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1269	1944	OTRIVINE	XYLOMETAZOLINE	VASOCONSTRITEUR /DECONGEST NASAL / Grammes / 0	1546	2010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1270	1947	CIPRIND	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	2473	3215	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1271	1948	NEO-MEDROL	PREDNISOLONE + NEOMYCINE	ANTI-ACNEIQUE / Millilitres / 0	1704	2215	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1272	1951	FLUANZOL LP	FLUPENTIXOL DECANOATE	ANTI-PSYCHOTIQUE / AMPOULE / 100MG/ML	5454	7090	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1273	1954	OPATANOL	OLOPATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE OPHTALMIQUE / MILLILITRES / 1MG/ML	4231	5500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1274	1955	DETURGYLONE	PREDNISOLONE+ OXYMETAZOLINE	DECONGESTIONNANT/RHINITE ALLERGIQUE / Millilitres / 0	1800	2340	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1275	1957	NORZOL	NORFLOXACINE+TINIDAZOLE	ANTIBIOTIQUE/ANTIPARASITAIRE / Gramme (s) / 400MG/600MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1276	1958	TARDYFERON B9	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 50MG/350MCG	1977	2570	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1277	1959	MICROFLOX	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	1342	1745	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1278	1960	MODECATE	FLUPHENAZINE	NEUROLEPTIQUE / Grammes / 25MG/ML	4212	5475	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1279	1961	IPEPRAZOLE	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	1146	1490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1280	1962	FOLIFER	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 90MG/1MG	3162	4110	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1281	1963	XYLOVIT	XYLOMETAZOLINE	VASOCONSTRITEUR /DECONGEST NASAL / Millilitres / 0.0005	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1282	1965	PYOSTACINE	PRISTINAMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	11981	15575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1284	1967	Q BACT	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	500	650	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1285	1968	OMEPRAL	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	4415	5740	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1286	1969	OROFER	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / GELULE / 100MG/550MCG	1615	2100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1287	1972	RHINATHIOL ENFT	CARBOCISTEINE	MUCOLYTIQUE/FLUDIFIANT / Millilitres / 0.02	1342	1745	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1288	1973	CEBUTID	FLURBIPROFENE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 100MG	2227	2895	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1289	1974	UTROGESTAN	PROGESTERONE	OESTRO-PROGESTATIF / COMPRIMÉS / 100MG	4238	5510	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1290	1975	TUSSISSEDAL	NOSCAPINE + PROMETHAZINE	ANTITUSSIF / Millilitres / 100MG/50MG	1146	1490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1291	1977	FOLIRON	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / GELULE / 150MG/0.5MG	796	1035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1292	1978	SHAROME	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	4415	5740	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1293	1979	XYLO MEPHA	XYLOMETAZOLINE	VASOCONSTRITEUR /DECONGEST NASAL / Millilitres / 0.0005	858	1115	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1294	1982	ANTADYS	FLURBIPROFENE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 100MG	2215	2880	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1295	1985	FEFOL	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / GELULE / 150MG/0.5MG	1854	2410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1296	1988	GASEC	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / Grammes / 10MG	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1297	1989	FERFOLTONE	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / GELULE / 300MG/100MG	538	700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1298	1990	BRONCHOBOS	CARBOCISTEINE	MUCOLYTIQUE / Millilitres / 2,5%	1838	2390	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1299	1993	NYSTATINE LDI	NYSTATINE	ANTI-FONGIQUE / COMPRIMÉS / 500000UI	269	350	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1300	1994	MOPRAL	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / Grammes / 10MG	6665	8665	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1301	1995	FERRIC CIT AMM UBI	FER + ACIDE FOLIQUE	ANTI-ANEMIQUE / Millilitres / 200ML	1458	1895	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1302	1996	BRULEX	ZINC+BAUME DE PEROU+PHENAZONE+PHENOL+SALICYLATE DE SOD	PROTECTEUR TOPIQUE / GRAMMES / 5G/1G/0.5G/30MG/3.6MG	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1303	1997	ORELOX	CEFPODOXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 40MG/5ML	6650	8645	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1304	1998	PROGESTOGEL	PROGESTERONE	OESTRO-PROGESTATIF / GRAMMES / 25MG	1642	2135	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1305	1999	BRONKIREX	CARBOCISTEINE	MUCOLYIQUE / Millilitres / 0.02	962	1250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1306	2000	OXYPLASTINE	ZINC OXYDE	TOPIQUE PROTECTEUR / TROPHIQUE / Grammes / 0.46	1723	2240	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1307	2001	OMEGEN	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	969	1260	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1308	2002	PREGNATAL	FER + ACIDE FOLIQUE + MULTIVITAMINE	ANTI-ANEMIQUE/ANTI-ASTHENIQUE / Grammes / 0	2288	2975	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1309	2003	BETAZIDIM 1G	CEFTAZIDIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / FLACON / 1G	7065	9185	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1310	2004	EULEXINE	FLUTAMIDE	ANTICANCEREUX/IMMUNOMODULATEUR ANTI-ANDROGENE / COMPRIMÉS / 250MG	21292	27680	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1311	2005	CARBOMUC	CARBOCISTEINE	MUCOLYIQUE / Millilitres / 0.02	1146	1490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1312	2006	PROGESTERONE RET PHA	PROGESTERONE	OESTRO-PROGESTATIF / AMPOULE / 500MG/2ML	1696	2205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1313	2007	MYCOSTATINE	NYSTATINE	ANTI-FONGIQUE / MILLILITRES / 100000UI	981	1275	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1314	2008	ZOMIG	ZOLMITRIPTAN	ANTIMIGRAINEUX / Grammes / 2.5MG	4573	5945	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1315	2009	OMEGEN.	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / Grammes / 10MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1316	2010	BIOFER	FER+ACIDE FOLIQUE+VITAMINE B12	ANTI-ANEMIQUE / COMPRIMÉS / 525MG/5MG/1.5MG/12.5MG/75MG	1750	2275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1317	2012	STILNOX	ZOLPIDEM	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 10MG	2154	2800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1318	2013	MESPORIN	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 2G	7065	9185	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1319	2014	NASAX	FLUTICASONE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE NASAL / DOSES / 100MCG	4715	6130	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1320	2015	DAFRAZOL	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	7400	9620	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1321	2016	CIPHASTEINE	CARBOCISTEINE	MUCOLYIQUE / Millilitres / 0.02	892	1160	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1322	2017	SYNERGON	PROGESTERONE+ESTRONE	OESTRO-PROGESTATIF / AMPOULE / 10MG/1MG	1077	1400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1323	2020	OXALAIR	FLUTICASONE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE NASAL / DOSES / 125MCG	5085	6610	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1324	2021	OESTROGEL	OESTRADIOL ANHYDRE	OESTRO-PROGESTATIF / GRAMMES / 1.5MG	1827	2375	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1325	2023	FLUDITEC	CARBOCISTEINE	FLUDIFIANT/MUCOLYTIQUE / Millilitres / 0.02	1200	1560	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1326	2027	COLPOTROPHINE	PROMESTRIENE	OESTRO-PROGESTATIF / OVULES / 10G	1615	2100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1327	2029	FLIXONASE	FLUTICASONE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE NASAL / DOSES / 50MCG	2462	3200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1328	2031	MEDIBRONC	CARBOCISTEINE	MUCOLYTIQUE/FLUDIFIANT / Millilitres / 0.02	1996	2595	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1329	2033	ROCEPHINE	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	5696	7405	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1330	2036	PHENERGAN	PROMETHAZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 25MG	585	760	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1331	2037	GASPRAL	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	3973	5165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1332	2038	ACCUZON	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1531	1990	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1333	2039	FLIXOTIDE	FLUTICASONE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE NASAL / DOSES / 50MCG	1485	1930	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1334	2040	OFLOMAC	OFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 200MG	1600	2080	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1335	2042	FORTEVIT	FER + ACIDE FOLIQUE + VIT	ANTI-ANEMIQUE / Millilitres / 0	946	1230	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1336	2045	FLOMIST	FLUTICASONE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE NASAL / DOSES / 50MCG	2788	3625	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1337	2046	C-TRI	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1338	2048	QUINOLOX	OFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 200MG	6181	8035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1339	2051	CARBOTOUX ENFANT	CARBOCISTEINE	FLUIDIFIANT BRONCHIQUE / Millilitres / 0.02	804	1045	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1340	2052	FER C B9	FER + ACIDE FOLIQUE + VIT + VIT B12 + MENERAL	ANTI-ANEMIQUE/VITAMINES / Millilitres / 125ML	3754	4880	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1341	2053	CETAZONE	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	2208	2870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1342	2054	OFLOXACINE TM	OFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 200MG	2215	2880	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1343	2057	CIPLACEF	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1058	1375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1344	2058	RHINATHIOL ENFANT	CARBOCISTEINE	MUCOLYTIQUE/FLUDIFIANT / Millilitres / 2% SANS SUCRE	1546	2010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1345	2059	UROFLOX	OFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 200MG	1738	2260	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1346	2060	ALLERGYL	PROMETHAZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / MILLILITRES / 5MG/5ML	408	530	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1347	2061	IREX 12	FER + ACIDE FOLIQUE + VIT B	ANTI-ANEMIQUE / Grammes / 0	1315	1710	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1348	2062	UROBACID	OFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	5385	7000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1349	2063	OMEZYN	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	2450	3185	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1350	2064	AMLOTENSINE	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	1369	1780	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1351	2065	IMMUNOX	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1019	1325	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1352	2066	BRONCATHIOL	CARBOCISTEINE	MUCOLYIQUE / Millilitres / 0.05	1677	2180	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1353	2067	AVAMYS	FLUTICASONE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE NASAL / DOSES / 27.5MCG	2615	3400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1354	2069	OMIZEC	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1355	2070	OFLOX	OFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	1300	1690	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1356	2071	IRONORM	FER + ACIDE FILOQUE + VIT B1 + VIT B2 + VIT C + NICOTINAMIDE	ANTI-ANEMIQUE / Grammes / 0	2023	2630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1357	2072	BRONCHOKOD	CARBOCISTEINE	MUCOLYTIQUE / Millilitres / 0.05	1838	2390	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1358	2075	OFRAMAX	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	2023	2630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1359	2076	SERETIDE DISKUS	FLUTICASONE+SALMETEROL	ANTI-ASTHMATIQUE / DOSES / 100UG/50UG	7604	9885	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1360	2077	FERLIX	FER + ACIDE FOLIQUE + VIT B12	ANTI-ANEMIQUE / Millilitres / 200MG/0.5MG/1.75MG	1235	1605	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1361	2080	KINAL ENFANT	PROMETHAZINE+ PARACETAMOL	ANTALGIQUE ASSOCIES / Grammes / 10MG/400MG	442	575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1362	2083	OMPRANYT	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	9288	12075	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1363	2085	GYNOFER	FER + ACIDE FOLIQUE + VIT B12	ANTI-ANEMIQUE / Unite (s) / 200MG/1.5MG/50MCG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1364	2086	AMLOPRESS Z	LOSARTAN+AMLODIPINE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG/50MG	2031	2640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1365	2087	ZOSEC	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1366	2093	KINAL NOURRISSONS	PROMETHAZINE+ PARACETAMOL	ANTALGIQUE ASSOCIES / Grammes / 5MG/200MG	354	460	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1367	2095	TIBERAL	ORNIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	2331	3030	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1368	2098	PROBITOR	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	6535	8495	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1369	2099	LESCOL LP	FLUVASTATINE	HYPOLIPEMIANT / Grammes / 80MG	20158	26205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1370	2102	MESPORIN 	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 250MG IM 	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1371	2103	BRISTOPEN	OXACILLINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Grammes / 500MG	3223	4190	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1372	2104	PROTON	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	9112	11845	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1373	2108	OXALLINE	OXACILLINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Gramme (s) / 500MG	2288	2975	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1374	2109	BELMAZOL	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	5300	6890	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1375	2110	ROCEPHINE 	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 250MG IM 	2815	3660	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1376	2112	MONURIL	FOSFOMYCINE TROMETAMOL	ANTIBIOTIQUE DIVERS / SACHETS / 3G	5112	6645	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1377	2113	OXAPEN	OXACILLINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Gramme (s) / 500MG	2569	3340	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1378	2119	ISOFRA	FRAMYCETINE	ANTIBIOTIQUE AMINOSIDE / MILLILITRES / 800MUI	1035	1345	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1379	2120	ACCUZON 250	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / FLACON / 250MG	658	855	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1380	2121	OEDES	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	2508	3260	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1381	2123	RHINATHIOL AD	CARBOCISTEINE	MUCOLYTIQUE/FLUDIFIANT / Millilitres / 0.05	1473	1915	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1382	2124	PEFLACINE 400	PERFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	6331	8230	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1383	2125	CETAZONE 250	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / FLACON / 250MG	1062	1380	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1384	2127	PRAZOL	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	3973	5165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1385	2128	CIPLACEF 	CEFTRIAXONE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Grammes / 250MG IM IV 	635	825	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1386	2129	OSPAMOX	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Grammes / 1000MG	2896	3765	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1387	2130	FRAKIDEX	FRAMYCETINE+DEXAMETHASONE	AFFECTION OPHTALMIQUE / MILLILITRES / 15750UI/5MG	1212	1575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1388	2133	LOMAC	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	1015	1320	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1389	2134	CARBOTOUX ADULTE	CARBOCISTEINE	FLUDIFIANT/MUCOLYTIQUE / Millilitres / 0.05	946	1230	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1390	2135	OFRAMAX 	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 250MG IM IV 	1342	1745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1391	2139	OXACILLINE UBI	OXACILLINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Millilitres / 250MG/5ML	796	1035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1392	2141	COVERSYL	PERINDOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 10MG	12804	16645	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1393	2144	POLYFRA	FRAMYCETINE+POLYMYXINE B	AFFECTION OPHTALMIQUE / MILLILITRES / 3400UI/10000UI	1546	2010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1394	2150	FEBEX	FER + ACIDE FOLIQUE + VIT B12 + DI CALCIQUE PHOSPHATE	ANTI-ANEMIQUE / Grammes / 300MG/1,5MG/15MCG/100MG	1154	1500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1395	2151	ZIMOR	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	6535	8495	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1396	2155	RHINATHIOL	CARBOCISTEINE + PROMETAZINE	MUCOLYTIQUE/FLUDIFIANT / Millilitres / 2%/0.05G	812	1055	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1397	2157	FEDATE	FER + ACIDE FOLIQUE + VIT B6 + VIT B12	ANTI-ANEMIQUE / Millilitres / 200ML	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1398	2161	LACRYFLUID	CARBOMERE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.0013	2100	2730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1399	2167	FERCEFOL	FER + ACIDE FOLIQUE + VIT C	ANTI-ANEMIQUE / Grammes / 100MG/4MG/200MG	973	1265	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1400	2169	TINSET	OXATOMIDE	ANTIHISTAMINIQUE / ANTI-ALLERGIQUE /  / 30MG	3542	4605	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1401	2170	GEL LARMES	CARBOMERE	AFFECTION OPHTALMIQUE / GRAMMES / 0.3G	2119	2755	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1402	2171	AMOXI DENK	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 500MG	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1403	2176	LACRYVISC	CARBOMERE	AFFECTION OPHTALMIQUE / GRAMMES / 0.03	3012	3915	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1404	2178	RENNIE	CARBONATE DE CALCIUM+ CARBONATE DE MAGNESIUM	ANTI ACIDE/ PANSEMENT GASTRO INTESTINAL / Grammes / 0	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1405	2179	CEFTRIAZ	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	2627	3415	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1406	2180	SERESTA 10	OXAZEPAM	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 10MG	962	1250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1407	2184	GLUCIDORAL	CARBUTAMIDE	ANTIDIABETIQUE / Grammes / 500MG	838	1090	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1408	2185	SERESTA 50	OXAZEPAM	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 50MG	1385	1800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1409	2188	GRAMIDIL	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	1335	1735	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1410	2189	PAXELADINE	OXELADINE	ANTITUSSIF / Millilitres / 0.002	1096	1425	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1411	2190	CEFTRIAZ 250	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / FLACON / 250MG 	1000	1300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1412	2192	NOCERTONE	OXETORONE	ANTIMIGRAINEUX /  / 60MG	3969	5160	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1413	2195	BIPRETERAX	PERINDOPRIL+INDAPAMIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 10MG/2.5MG	13465	17505	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1414	2196	TOPLEXIL	OXOMEMAZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / MILLILITRES / 0.33MG/ML	1738	2260	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1415	2197	TITANOREINE	CARRAGHENATES+DIOXYDE DE TITANE+OXYDE DE ZINC	ANTI-HEMORROÏDAIRE/VEINOTONIQUE / SUPPOSITOIRE / 0.3G/0.2G/0.4G	1535	1995	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1416	2199	AGRAM	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	962	1250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1417	2201	SULBACTOMAX	CEFTRIAXONE+SULBACTAM	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG/500MGIMIV	2842	3695	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1418	2203	DITROPAN	OXYBUTYNINE	ANTI-ENURESIQUE / COMPRIMÉS / 5MG	4688	6095	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1419	2205	AMITRON	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	796	1035	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1420	2206	ZINNAT 125 	CEFUROXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 125MG 	3462	4500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1421	2207	TIMOSOL	TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.005	681	885	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1422	2208	CARTEOL 1%	CARTEOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.01	2350	3055	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1423	2209	BIOFERON	FER + ACIDE FOLIQUE + VIT B12	ANTI-ANEMIQUE / Grammes / 0	796	1035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1424	2210	PRETERAX	PERINDOPRIL+INDAPAMIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 2.5MG/0.625MG	7946	10330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1425	2211	AMIFER	FER + ACIDE FOLIQUE + VIT B12	ANTI-ANEMIQUE / Millilitres / 0	2154	2800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1426	2213	XORIMAX	CEFUROXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 250MG 	5165	6715	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1427	2214	AMODEX	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	919	1195	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1428	2215	ANUSOL	OXYDE ANHYDRE+RESORCINE+OXYDE DE ZINC+BAUME DE PEROU	ANTI-HEMORROIDAIRE TOPIQUE / GRAMMES / 0	2146	2790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1429	2217	CARTEOL 2%	CARTEOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.02	2535	3295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1430	2219	ZINNAT 250	CEFUROXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 250MG 	5962	7750	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1431	2220	BACTOX	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	1438	1870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1432	2221	RANFERON	FER + ACIDE FOLIQUE + VITAMINE B12	ANTI-ANEMIQUE / Millilitres / 200MG/1.5MG/50MCG	1942	2525	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1433	2222	XORIMAX 	CEFUROXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 500MG 	9765	12695	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1434	2224	CARTEOL LP 1%	CARTEOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.01	4723	6140	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1435	2225	TOBRADEX	TOBRAMYCINE+DEXAMETHASONE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.3%/0.1%	2138	2780	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1436	2227	ZAMUR 	CEFUROXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 500MG 	6623	8610	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1437	2228	RED IRON	FER + ACIDE FILOQUE + VITAMINE B12 + SORBITOL	ANTI-ANEMIQUE / Millilitres / 200MG/1.5MG/50UG/1.25MG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1438	2229	DIGESTIF MARGA	OXYDE D'ALUMINIUM+HYDROXYDE DE MAGNESIUM+CARBONATE DE CA+	PANSEMENT GASTRO INTESTINAL / COMPRIMÉS / 100MG/60MG/50MG	1838	2390	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1439	2231	ZINNAT 125	CEFUROXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Millilitres / 125MG 	6727	8745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1440	2232	FLEMOXINE	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	1350	1755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1441	2233	SPORALIM	TOLNAFTATE	ANTI-FONGIQUE LOCAL / MILLILITRES / 0.01	804	1045	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1442	2234	ROCGEL	OXYDE D'ALU+SORBATE DE POTAS+PARAHYDROXYDE BENZOATE	ANTI ACIDE/ PANSEMENT GASTRO INTESTINAL / Gramme (s) / 1.2G	2438	3170	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1443	2236	SPORILIM	TOLNAFTATE	ANTI-FONGIQUE LOCAL / MILLILITRES / 0.01	1315	1710	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1444	2237	HICONCIL	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	1427	1855	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1445	2238	MUTESA	OXYDE D'ALUMINIUM+OXYDE DE MG+OXETACAINE	ANTI ACIDE/ PANSEMENT GASTRO INTESTINAL / Millilitres / 3.8G/1.350G/0.187G F	2208	2870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1446	2239	CELEBREX	CELECOXIB	ANTI-INFLAMMATOIRE (AINS) / Grammes / 100MG 	7012	9115	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1447	2241	MOXYDAR	OXYDE D'ALUMINIUM+ PHOSPHATE D'ALUMINIUM + MAGNESIUM HYDROX	ANTI ACIDE/ PANSEMENT GASTRO INTESTINAL / Gramme (s) / 0	2296	2985	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1448	2242	CELEBREX 	CELECOXIB	ANTI-INFLAMMATOIRE (AINS) / Grammes / 200MG	5846	7600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1449	2243	REDIN PLUS	FER + ACIDE FOLIQUE + ZINC + SELENIUM + HISTIDINE + LYSINE + CHOLINE	ANTI-ANEMIQUE / Grammes / 100MG/5MG/30MG/50MCG/4MG/25MG	1181	1535	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1450	2245	CARTEOL LP 2%	CARTEOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.02	4723	6140	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1451	2247	COVERAM	AMLODIPINE + PERINDOPRIL	ANTIHYPERTENSEUR INHIBITEUR CALCIQUE/I.E.C. / COMPRIMÉS / 10MG/10MG	13688	17795	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1452	2248	ALOPLASTINE	OXYDE DE ZINC	DERMATOLOGIE TOPIQUE / Grammes / 0	1146	1490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1453	2250	BACTYL 	CETHEXONIUM + CHLORURE DE SODUIM	ANTISEPTIQUE / Millilitres / 0.00025	785	1020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1454	2251	ZENGLOBIN	FER + ACIDE FOLIQUE + ZINC + VIT B12 + NIACINAMIDE	ANTI-ANEMIQUE / Millilitres / 150MG/0.5MG/0.5MG/3MG/25MG	2008	2610	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1455	2253	LINMOX	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	946	1230	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1456	2254	CARPILO	CARTEOLOL+ PILOCARPINE	ANTIGLAUCOMATEUX / Millilitres / 0	1881	2445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1457	2257	VIRLIX	CETIRIZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	3215	4180	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1458	2259	MUCINUM	CASCARA	LAXATIF / CONSTIPATION / Grammes / 40MG	838	1090	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1459	2261	RESPIBIEN	OXYMETAZOLINE	DECONGESTIONNANT / Millilitres / 65µG	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1460	2264	ZETRY	CETIRIZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1461	2265	BIODROXIL	CEFADROXIL	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 1000MG	6446	8380	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1462	2266	ATURGYL	OXYMETAZOLINE	DECONGESTIONNANT / Millilitres / 0.0005	881	1145	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1463	2269	ZYLPREX	CETIRIZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	1881	2445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1464	2270	DERMACIDE	OXYQUINOL+AC SALICYLIQUE+LAURYLSULFATE+SODIUM	ANTISEPTIQUE LOCAL / Grammes / 0	1788	2325	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1465	2271	EFFEDERM	TRETIINOINE	ANTI-ACNEIQUE / Grammes / 0.0005	1623	2110	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1466	2272	ORACEFAL	CEFADROXIL	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 1G	3231	4200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1467	2273	ALERID CITIRIZINE	CETIRIZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	1269	1650	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1468	2274	RANOXYL	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	1342	1745	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1469	2277	ORADROXYL	CEFADROXIL	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 1G	2781	3615	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1470	2278	ZYRTEC	CETIRIZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	2942	3825	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1471	2281	POSICYCLINE	OXYTETRACYCLINE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.01	1185	1540	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1472	2282	CUTACNYL	PEROXYDE DE BENZOYLE	ANTI-ACNEIQUES TOPIQUES / Grammes / 0.1	1600	2080	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1473	2283	BICEF	CEFADROXIL	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 500MG	2419	3145	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1474	2284	LOCACID	TRETIINOINE	ANTI-ACNEIQUE / Grammes / 0.001	1465	1905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1475	2286	CLAMOXYL	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000MG	742	965	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1476	2289	CURTEC	CETIRIZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1477	2290	ISOBAR	TRIAMTERENE+CHLOROTHIAZIDE	ANTI-HYPERTENSEUR DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 150MG/5MG	2992	3890	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1478	2291	ETRICET	CETIRIZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	1546	2010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1479	2295	CETAVLON	CETRIMIDE	ANTIBIOTIQUE TOPIQUE / GRAMMES / 0.005	1235	1605	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1480	2296	LYSOPAINE 	CETYLPYRIDINIUM + LYSOZYME	ANTISEPTIQUE ORO BUCAL / Grammes / 1.5MG/20.MG B/18	2677	3480	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1481	2297	ALODONT	CETYLPYRIDIUM CHLORURE+CHLOROBUTANOL+EUGENOL	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0	1104	1435	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1482	2298	CARBOLEVURE ENF 	CHARBON + LEVURE	ADSORBANT INTESTINAL / Grammes / 0	696	905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1483	2299	CARBOLEVURE AD	CHARBON + LEVURE	ADSORBANT INTESTINAL / Grammes / 109MG/108.5MG	1008	1310	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1484	2300	CARBACTIVE	CHARBON ACTIVE	ADSORBANT INTESTINAL / GELULE / 120MG	1581	2055	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1485	2301	CARBOSYLANE	CHARBON ACTIVE + SIMETICONE	ADSORBANT INTESTINAL / Grammes / 140MG/45MG	2023	2630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1486	2302	BIDCEF	CEFADROXIL	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 500MG	3292	4280	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1487	2305	FERROMIX	FER + LEVURE + CUIVRE + ZINC + HUILE DE FENOUIL + CARVI	ANTI-ANEMIQUE/ANTI-ASTHENIQUE / Millilitres / 300MG/25MG/7MG/8MG/0.0025MG/0.025ML	973	1265	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1488	2307	CARBOPHOS	CHARBON VEGETAL	ADSORBANT INTESTINAL /  / 400MG	1777	2310	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1489	2309	TOTHEMA	FER + MAGANESE + CUIVRE	ANTI-ANEMIQUE / Grammes / 50MG/1.33MG/0.70MG	2746	3570	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1490	2310	SAIFORAL	CEFADROXIL	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / GELULE / 500MG	2827	3675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1491	2311	CARBOFIP	CHARBON VEGETAL + FRUCTOOLIGOSACHARIDES	ADSORBANT INTESTINAL / Grammes / 400MG/100MG	3108	4040	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1492	2314	EUCARBON	CHARBON VEGETAL+	ADSORBANT INTESTINAL/LAXATIF / Grammes / 0	1900	2470	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1493	2317	ECLARAN	PEROXYDE DE BENZOYLE	ANTI-ACNEIQUES TOPIQUES / Grammes / 0.1	1527	1985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1494	2318	FEZOMIN-C	FER + VIT B12 + ACIDE FOLIQUE + VIT C + VIT B6 + ZINC + CUIVRE + MAGANESE	ANTI-ANEMIQUE/VITAMINES / Grammes / 300MG/15MCG/1MG/100MG/3MG/100MG	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1495	2319	CHLORAMPHENICOL GGIA	CHLORAMPHENICOL	ANTIBIOTIQUE PHENICOLE / GELULE / 250MG	308	400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1496	2321	PANNOGEL	PEROXYDE DE BENZOYLE	ANTI-ACNEIQUES TOPIQUES / Grammes / 0.1	1296	1685	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1497	2322	CHLORAMPHENICOL	CHLORAMPHENICOL	ANTIBIOTIQUE PHENICOLE / GELULE / 250MG	646	840	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1498	2324	AUGMENTIN 500	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 500MG/62.5MG	3481	4525	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1499	2326	VITAMINE B12 GERDA	FER + VITAMINE B12	ANTI-ANEMIQUE / Millilitres / 3.590G/83.4µG	1500	1950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1500	2328	CLAVULIN	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 500MG/62.5MG	3231	4200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1501	2329	LIBRAX	CHLORDIAZEPOXIDE + CLIDINIUM	ANXIOLYTIQUE SPASMOLYTIQUE / Grammes / 5MG/2,5MG	1385	1800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1502	2331	TIMOFEROL	FER + VITAMINE C	ANTI-ANEMIQUE / Grammes / 50MG/30MG	1115	1450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1503	2334	AMOXICLAV-DENK	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 500MG/62.5MG	3092	4020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1504	2338	ENHANCIN	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 500MG/62.5MG	3435	4465	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1505	2339	ZANIDIP	LERCANIDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	8273	10755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1506	2340	AMINOHAEM	FER + ZINC + ACIDE FOLIQUE + VITAMINES	ANTI-ANEMIQUE / Grammes / 0	2296	2985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1507	2341	FLEMING	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 500MG/62.5MG	3708	4820	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1508	2343	DOLOSAL	PETHIDINE	ANALGESIQUE / Grammes / 100MG	1565	2035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1509	2344	CLAVOR	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 500MG/62.5MG	4858	6315	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1510	2346	FEROX	FER CARBONYLE + SELENIUM + VIT E + ACIDE FOLIQUE + VIT B12 + ZINC	ANTI-ANEMIQUE / Millilitres / 200ML	2400	3120	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1511	2347	TICASSE	AMOXICILLINE + AC CLAVULANIQUE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Grammes / 875MG/125MG	5654	7350	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1512	2348	AFTAGEL	CHLORHYDRATE DE LIDOCAINE+SULFATE DE ZINC	ANESTHESIQUE LOCAL / GRAMMES / 0.6G/0.5G	1758	2285	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1513	2350	COAMOX	AMOXICILLINE + AC CLAVULANIQUE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Grammes / 875MG/125MG	4858	6315	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1514	2351	VITAFER FORTE	FER CITRATE + ACIDE FOLIQUE + VITAMINE B12	ANTI-ANEMIQUE / Millilitres / 0	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1515	2352	CURAM	AMOXICILLINE + AC CLAVULANIQUE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Grammes / 875MG/125MG	5519	7175	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1516	2354	VITAFER LP	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / GELULE / 45MG/500MCG	1412	1835	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1517	2357	KLACIN BID	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Grammes / 875MG/125MG	4504	5855	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1518	2358	CEBESIME	CHLORIDRATE D'OXYBUPROCAÏNE + CHLORURE DE SODUIM	ANESTHESIE LOCAL OCCULAIRE / Millilitres / 0.004	565	735	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1519	2359	TELFAST	FEXOFENADINE	ANTIHISTAMINIQUE / Grammes / 180MG	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1520	2360	CEFOVIT	CEFALEXINE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 500MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1521	2362	CHIBRO-PROSCAR	FINASTERIDE	HYPERTROPHIE BENIGNE DE LA PROSTATE / COMPRIMÉS / 5MG	16219	21085	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1522	2363	CEFAMOR	CEFALEXINE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Millilitres / 125MG/5ML	1146	1490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1523	2364	VEINOBIASE	PETIT HOUX+ CASSIS+ ACIDE ASCORBIQUE	VASCULOPROTECTEUR / VEINOTONIQUE / Grammes / 60MG/550MG/200MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1524	2366	DAFLON	FLAVONOIDE PURIFIEE	ANTI-HEMORROÏDAIRE/VEINOTONIQUE / COMPRIMÉS / 500MG	3154	4100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1525	2368	PAIDOTERIN	CHLORPHENAMINE + PSEUDOEPHEDRINE +DIPHENHYDRAMINE + G + GL	ETAT GRIPPAL / Millilitres / 0	1704	2215	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1526	2370	IDARAC	FLOCTAFENINE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 200MG	1615	2100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1527	2373	FLUVERMAL	FLUBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 100MG	1677	2180	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1528	2374	AMOXICILLINE UBI	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 125MG/5ML	485	630	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1529	2375	CEFALORAL	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 200MG	3231	4200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1530	2378	OROKEN	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / Unite (s) / 200MG	6250	8125	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1531	2380	SECEF	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 200MG	5300	6890	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1532	2383	MEPHIXIME	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 400MG	6296	8185	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1533	2384	RHINOFEBRAL	CHLORPHENAMINE + VITAMINE C + PARACETAMOL	ETAT GRIPPAL / Grammes / 3.2MG/100MG/240MG	1650	2145	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1534	2387	ACLAV	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 100MG/12.5MG	3181	4135	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1535	2388	CEFIM	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / GELULE / 200MG	4950	6435	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1536	2390	AUGMENTIN ENFANT	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 100MG/12.5MG	3073	3995	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1537	2394	AUGMENTIN NOURRISSON	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 100MG/12.5MG	1642	2135	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1538	2395	POMMADE H EC	PHENAZONE + HAMAMELIS + ACIDE TANNIQUE	BRULURE CUTANE EPISTAXIS / Grammes / 187.5MG/187.5MG/3.125MG	1212	1575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1539	2399	LITACOLD	CHLORPHENINAMINE+PHENYLEPHRINE+PARACET	ETAT GRIPPAL / Millilitres / 1MG/2,5MG/125MG	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1540	2404	NOVACEF	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 50MG/5ML	1919	2495	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1541	2405	AURIPAX	PHENAZONE+LIDOCAINE	AFFECTIONS AURICULAIRES / MILLILITRES / 4%/1%	1212	1575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1542	2407	CLAVICIN	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000MG/200MG	1323	1720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1543	2416	AUGMENTIN	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 500MG/100MG	1350	1755	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1544	2419	FUMAFER GGIA	FER	ANTI-ANEMIQUE / COMPRIMÉS / 66MG	269	350	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1545	2421	KEFOTAX	CEFOTAXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1GIMIV	2415	3140	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1546	2422	OTIPAX	PHENAZONE+LIDOCAINE	AFFECTIONS AURICULAIRES / MILLILITRES / 4%/1%	1296	1685	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1547	2424	CLAVUMOCID	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 1000MG/125MG	3973	5165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1548	2426	CLAFORAN	CEFOTAXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1GIM	5827	7575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1549	2428	LRJ	PHENIRAMINE+TETRYZOLINE	AFFECTION OPHTALMIQUE / MILLILITRES / 30MG/5MG	2473	3215	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1550	2429	KLACIN PED	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Millilitres / 156,25MG/5ML	2427	3155	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1551	2430	FERBEKOD	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 200MG/0.25MG	1042	1355	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1552	2434	RINOMICINE	CHLORPHENAMINE + PHENYLEPHR + SALICYL + PARA + CAFEINE +VIT C	ETAT GRIPPAL / Grammes / 4MG/6MG/200MG/100MG/30MG/300MG	1138	1480	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1553	2435	AUGMACILLIN	AMOXICILLINE + AC CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Millilitres / 200MG	1750	2275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1554	2438	FERVEX SS	PHENIRAMINE + VITAMINE C + PARACETAMOL	ETAT GRIPPAL / Grammes / 10MG/100MG/280MG	1958	2545	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1555	2439	AMOXICILLINE CREAT	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 125MG/5ML	973	1265	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1556	2444	KLACIN PED FORT	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Millilitres / 312,5MG	3638	4730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1557	2448	FERVEX	PHENIRAMINE + VITAMINE C + PARACETAMOL	ETAT GRIPPAL / Grammes / 25MG/200MG/500MG	1662	2160	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1558	2449	MOXAFORTE	AMOXICILLINE + FLUCLOXACILLINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Grammes / 500MG	3531	4590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1600	2541	CIPLOX	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	846	1100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1559	2450	CEPODEM	CEFPODOXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 100MG	3727	4845	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1560	2452	SURDEX	CHLORPHENAMINE + PHENYLEPHRINE + PARACETAMOL	ETAT GRIPPAL / Millilitres / 1MG/2.5MG/125MG	785	1020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1561	2454	FERVEX ENFANT	PHENIRAMINE + VITAMINE C + PARACETAMOL	ETAT GRIPPAL / Grammes / 25MG/200MG/500MG	1642	2135	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1562	2455	HELICOCIN	AMOXICILLINE + METRONIDAZOLE	ANTIBIOTIQUE/ANTIPARASITAIRE / Grammes / 750MG/500MG	4442	5775	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1563	2458	KALEORID LEO	CHLORURE DE POTASSIUM	NORMOKALIEMIANT / COMPRIMÉS / 600MGLP	900	1170	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1564	2459	FUNGIZONE	AMPHOTERICINE B	ANTI-FONGIQUE / GELULE / 250MG	5235	6805	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1565	2462	PHENOBARBITAL GGIA	PHENOBARBITAL	ANTI-EPILEPTIQUE / COMPRIMÉS / 100MG	377	490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1566	2463	FUNGIZONE PIPETTE	AMPHOTERICINE B	ANTI-FONGIQUE / MILLILITRES / 100MG	3292	4280	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1567	2468	MILIAN ALCOOLISEE	MILIAN ALCOOL	ANTIFONGIQUE/ANTISEPTIQUE / Millilitres / 0	731	950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1568	2470	BACTROBAN	MUPIROCINE	ANTI INFECTIEUX / Grammes / POMMADE 2%	2692	3500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1569	2471	ARTESIANE	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 20MG	431	560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1570	2473	MALATHER	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 20MG	265	345	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1571	2476	ARTEM	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 40MG	408	530	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1572	2477	AMPICILLINE UBI	AMPICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	538	700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1573	2478	PALUTHER	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 40MG	927	1205	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1574	2479	CIMETIDINE CREAT	CIMETIDINE	ANTI-ULCEREUX/INHIBITEUR DE LA PROSTAGLANDINE E1 / Grammes / 400MG	923	1200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1575	2480	GARDENAL	PHENOBARBITAL	ANTI-EPILEPTIQUE / COMPRIMÉS / 100MG	1112	1445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1576	2481	ROSAMPLINE	AMPICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000MG	196	255	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1577	2482	ARTEMETHER UBI	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 20MG	354	460	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1578	2487	BACQURE	IMIPENEME+CILASTATINE	ANTIBIOTIQUE BETA-LACTAMINE CARBAPENEME / AMPOULE / 500MG/500MGIV	7065	9185	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1579	2488	SULFARLEM	ANETHOLTRITHIONE	CORRECTEUR HYPOSIALIQUE / COMPRIMÉS / 25MG	923	1200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1580	2494	DIFRAREL 100	ANTHOCYANOSIDE DE VACCINIUM MYRTILLUS+B CAROTENE	ANTI-HEMORROÏDAIRE/VEINOTONIQUE / COMPRIMÉS / 100MG/5MG	2427	3155	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1581	2496	AMETHER DENK	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 80MG	700	910	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1582	2498	DIFRAREL E	ANTHOCYANOSIDE DE VACCINIUM MYRTILLUS+TOCOPHEROL	ANTI-HEMORROÏDAIRE/VEINOTONIQUE / COMPRIMÉS / 50MG/50MG	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1583	2501	ETHAMER	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 80MG	377	490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1584	2504	SERUM ANTI D (RHOGAM)	IMMUNOGLOBULINE ANTI D	SERUM/PREVENTION ALLO-IMMUNISATION FOETO-MATERNELLE / Grammes / 1	36458	47395	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1585	2505	GVITHER	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 80MG	808	1050	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1586	2508	APIOLINE DE CHAPOTEAUT	APIUM PETROSELINUM	MODULATEUR FONCTION GENITALE / Grammes / 0	2288	2975	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1587	2510	ARMETHER DENK	ARTEMETHER	ANTIPALUDIQUE /  / 40MG	1854	2410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1588	2511	ARTENAM	ARTEMETHER	ANTIPALUDIQUE / Grammes / 50MG	3038	3950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1589	2514	ARTEMETHER+LUMEFANTRINE TM	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	1696	2205	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1590	2516	COARTEM	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / Unite (s) / 20MG/120MG	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1591	2518	LUFANTER PEDIATRIQUE	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / Unite (s) / 20MG/120MG	696	905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1592	2519	CLAVAM	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 250MG/125MG	1415	1840	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1593	2520	ARTEFAN PEDIATRIQUE	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / Unite (s) / 20MG/120MG	619	805	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1594	2522	ARTEMETHER TM	ARTEMETHER	ANTIPALUDIQUE /  / 50MG	1808	2350	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1595	2526	COLART	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	2127	2765	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1596	2532	LUMART PLUS	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	2781	3615	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1597	2534	LUMARTEM	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	1269	1650	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1598	2536	NIFLURIL ENFANT	ACIDE NIFLUMIQUE	ANTI-INFLAMMATOIRE (AINS) / Grammes / 400MG	1138	1480	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1599	2539	ACIDE FOLIQUE GGIA	ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 5MG	308	400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1601	2542	INFLADOL	DICLOFENAC + PARACETAMOL	ANTI INFLAMMATOIRE (AINS) / ANTALGIQUE / Grammes / 25MG / 220MG	1615	2100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1602	2545	CARDULAR	DOXAZOSINE	HYPERTROPHIE BENIGNE DE LA PROSTATE / COMPRIMÉS / 2MG	8831	11480	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1603	2546	VICKS PECTORAL NF	PENTOXYVERINE	ANTITUSSIF / Millilitres / F/150 ML	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1604	2548	HYTACAND	CANDESARTAN CILEXETIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 16MG/12.5MG	16619	21605	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1605	2553	NEO-CODION CP	CAMPHOSULFONATE DE CODEINE	ANTITUSSIF / Grammes / 25MG	1035	1345	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1606	2554	AFATA	ACECLOFENAC + PARACETAMOL	ANTI INFLAMMATOIRE (AINS) / ANTALGIQUE / Grammes / 100MG/500MG	3092	4020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1607	2555	ALCOOL IODEE	ETHANOL + IODE	ANTISEPTIQUE LOCAL / Millilitres / 0	408	530	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1608	2558	ALVITE	FER + COMPLEXE VITAMINES B	ANTI-ANEMIQUE/ANTI-ASTHENIQUE / Millilitres / 0	1800	2340	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1609	2562	CEFALINE HAUT	PARACETAMOL + CAFEINE	ANTALGIQUE / Grammes / 500MG/50MG	1581	2055	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1610	2564	C-TAX	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 200MG	1854	2410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1611	2567	MUMFER	FER	ANTI-ANEMIQUE / MILLILITRES / 50MG/5ML	1915	2490	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1612	2570	MOGADON	NITRAZEPAM	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 5MG	712	925	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1613	2571	MODURETIC	AMILORIDE+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR DIURETIQUE EPARGNEUR POTASSIQUE/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 5MG/50MG	2523	3280	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1614	2576	KLACIN	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Grammes / 500MG/125MG	4381	5695	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1615	2580	HEPAGRUME	CHOLINE+ BETAINE+ ARGININE+INOSITOL+SORBITOL	ANTI-ASTHENIQUE / CHOLERETIQUE / HEPATOLOGUE / Grammes / 600MG /350MG /100MG	2338	3040	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1616	2581	HEPANEPROL	ARTICHAUT	CHOLERETIQUE / HEPATOLOGUE / Grammes / 2G	1988	2585	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1617	2584	CUSIVIRAL	ACICLOVIR	AFFECTION OPHTALMIQUE / GRAMMES / 0.03	4369	5680	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1618	2593	FURO DENK	FUROSEMIDE	ANTI-HYPERTENSEUR DIURETIQUE DE L'ANSE / COMPRIMÉS / 40MG	1027	1335	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1619	2610	CHLORURE ETHYLE	CHLOLURE ETHYLE	ANESTHESIE LOCAL DERMIQUE / Millilitres / AUTRES	3488	4535	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1620	2611	HAEMUP	FER + ACIDE FILOQUE + VIT B12 + CUPRIQUE + MAGAN	ANTI-ANEMIQUE / AUTRES / PM	2031	2640	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1621	2623	SPEDIFEN	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 200MG	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1622	2995	CHLORAMPHENICOL CREAT	CHLORAMPHENICOL	ANTIBIOTIQUE PHENICOLE / GELULE / 250MG	485	630	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1623	3082	MAG 2	CARBONATE DE MAGNESIUM	SUPPLEMENT MINERAL / Gramme (s) / 100MG	2719	3535	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1624	3085	FERMATHRON	HYALURONATE DE SODIUM	VISCOSUPPLEMENTS / Gramme (s) / 2,3%69mg /3ml	96154	125000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1625	3086	UTEPLEX	ACIDE URIDINE 5 TRIPHOSPHORIQUE	DESORDRES MUSCULOSQUELETIQUES / Gramme (s) / 2MG	5800	7540	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1626	3087	AMLO-DENK	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	5827	7575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1627	3088	AMLOPRESS	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	585	760	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1628	3091	SYNTOCINON INJ VRAC	OXYTOCINE	UTEROTONIQUE / AMPOULE / 5UI/1ML	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1629	3092	SHARLUM	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1630	3095	ASU DENK	ARTESUNATE+SULFAMETHOXYPYRAZINE+PYRIMETHAMINE	ANTIPALUDIQUE / Gramme (s) / 200/500/25mg	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1631	3097	CARDIOCALM	AUBEPINE	MED DE PHYTOTHERAPIE A VISEE SEDATIVE / Gramme (s) / 0	1758	2285	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1632	3098	LIORESAL	BACLOFENE	MYORELAXANT / COMPRIMÉS / 10MG	5162	6710	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1633	3101	AMUCHINA	CHLOROXYDANT ELECTROLYTIQUE	ANTISEPTIQUE LOCAL / Gramme (s) / 250ml	1212	1575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1634	3102	BECILAN	VITAMINE B6	SUPPLEMENT VITAMINIQUE / Gramme (s) / 250 ug	2692	3500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1635	3104	CLOMID	CLOMIFENE CITRATE	INDUCTEUR DE L'OVULATION / Gramme (s) / 50 mg	2515	3270	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1636	3106	DYNAPAR 50/500	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1637	3107	DYNAPAR EC	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	408	530	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1638	3108	DYNAPAR SR	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 100 mg	708	920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1639	3109	SYMPATHYL	ESCHSCHOILZIA + AUBEPINE+ MAGNESIUM	PHYTOTHERAPIE/ELEMENTS MINERAUX A VISEE SEDATIVE / Gramme (s) / 20 mg	1662	2160	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1640	3111	ESOZ	ESOMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	3865	5025	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1641	3112	LOSAR DENK	LOSARTAN POTASSIQUE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II / COMPRIMÉS / 100MG	10154	13200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1642	3113	FLOXYFRAL	FLUVOXAMINE MALEATE	ANTI-DEPRESSEUR / COMPRIMÉS / 100MG	5319	6915	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1643	3114	ALDALIX	FUROSEMIDE+ALDACTONE	ANTIHYPERTENSEUR DIURETIQUE EPARGNEUR POTASSIQUE / Gramme (s) / 0	5523	7180	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1644	3116	MAGNE B6	LACTATE DE MAGNESIUM+PYRIDOXINE	ELEMENT MINERAL / Gramme (s) / 48 mg/5mg	1704	2215	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1645	3117	OROMAG	LACTATE+CITRATE DE MAGNESIUM	ELEMENT MINERAL / Gramme (s) / 120 mg	2119	2755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1646	3119	SHAROLEV	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	4858	6315	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1647	3120	ACTIMAG	MAGNESIUM	SUPPLEMENT MINERAL / Millilitre (s) / 100 ml	2854	3710	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1648	3121	MAGNORAL	MAGNESIUM	ELEMENT MINERAL / Gramme (s) / 0	2119	2755	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1649	3122	MAXIMAG	MAGNESIUM	ELEMENT MINERAL / Gramme (s) / 0	3169	4120	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1650	3123	UVIMAG B6	MAGNESIUM+VIT B6	ELEMENT MINERAL ET VITAMINIQUE / Gramme (s) / 0	2227	2895	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1651	3124	PROVIRON	MESTEROLONE	SUPPLEMENT EN ANDROGENES / Gramme (s) / 25 mg	3523	4580	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1652	3126	KETAFLOX	OFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 200MG	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1653	3128	CEFTRIAXONE	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 500MGIV	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1654	3129	MAGNES DENK	OXYDE DE MAGNESIUM	ELEMENT MINERAL / Gramme (s) / 150 mg	3969	5160	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1655	3130	PAVEN	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 1000MG	1192	1550	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1656	3131	KLIPAL	PARACETAMOL+CODEINE	ANALGESIQUE/ANTI-PYRETIQUE P2 / COMPRIMÉS / 600MG/50MG	1500	1950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1657	3132	EXOFENE	PEROXYDE DE ZINC+DIMETICONE	ANTISEPTIQUE LOCAL / Gramme (s) / 160 g	1696	2205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1658	3133	METEOXANE	PHLOROGLUCINOL+SIMETHICONE	ANTISPASMODIQUE+ANTIFLATULANT /  / 125/80 mg	1796	2335	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1659	3134	NOOTROPYL	PIRACETAM	PSYCHOSTIMULANT/NOOTROPIQUE / Gramme (s) / 3g/15ml	2419	3145	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1660	3137	TECPRIL	RAMIPRIL	ANTI-HYPERTENSEUR I.E.C. / GELULE / 5MG	6181	8035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1661	3138	RINGER LACTATE SOL PERF 500ML	RINGER LACTATE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / PM	454	590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1662	3140	SERUM BICARBONATE	SERUM BICARBONATE	SERUM/TETANOS / MILLILITRES / 0.014	477	620	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1663	3142	TEBINISIL	TERBINAFINE	ANTI-FONGIQUE / COMPRIMÉS / 250MG	7065	9185	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1664	3144	VIT B DENK	VITAMINE B1 ET B6	SUPPLEMENT VITAMINIQUE / Gramme (s) / 100/200 mg	531	690	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1665	3145	EFLAVYL	VITAMINE E	SUPPLEMENT VITAMINIQUE / Gramme (s) / 200 mg	2419	3145	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1666	3146	TOCOFEROL	VITAMINE E	SUPPLEMENT VITAMINIQUE / Gramme (s) / 200 mg	2031	2640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1667	3147	VITAMINE E FORTE	VITAMINE E	SUPPLEMENT VITAMINIQUE / Gramme (s) / 400 UI	2031	2640	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1668	3148	DEXERYL	GLYCEROL+VASELINE+PARAFFINE LIQUIDE	ANTI-ECZEMATEUX TOPIQUE / GRAMMES / 15G/8G/2G	1342	1745	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1669	3221	COLESTOP	ATORVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 20MG	9712	12625	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1670	3224	DIAGLIM	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 2MG	3354	4360	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1671	3228	SERUM ANTI D (RHOPHYLAC)	IMMUNOGLOBULINE ANTI D	SERUM/PREVENTION ALLO-IMMUNISATION FOETO-MATERNELLE / Gramme (s) / 300µG	40619	52805	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1672	3229	SERUM ANTI-D	IMMUNOGLOBULINE ANTI D	SERUM/PREVENTION ALLO-IMMUNISATION FOETO-MATERNELLE / AMPOULE / 300µG	20200	26260	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1673	3230	SERUM ANTI D (IMMUNORHO)	IMMUNOGLOBULINE ANTI D	SERUM/PREVENTION ALLO-IMMUNISATION FOETO-MATERNELLE / Gramme (s) / 300µG	24723	32140	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1674	3231	ZAART	LOSARTAN POTASSIQUE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II / COMPRIMÉS / 100MG	3808	4950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1675	3233	ADRIBLASTINE	DOXORUBICINE	ANTICANCEREUX/CYTOTOXIQUE ANTI-TOPOISOMERASES II / AMPOULE / 50MG	42869	55730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1676	3234	FARMORUBICINE	EPIRUBICINE	ANTICANCEREUX/CYTOTOXIQUE ANTI-TOPOISOMERASES II / AMPOULE / 50MG	72000	93600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1677	3235	CAMPTO	IRINOTECAN	ANTINEOPLASIQUE / Gramme (s) / 40 MG	36154	47000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1678	3237	AKINETON LP	BIPERIDENE	ANTI-PARKINSONIEN/ANTI-CHOLINERGIQUE / COMPRIMÉS / 4MG	2388	3105	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1679	3238	PARKINANE LP	TRIHEXYPHENIDYLE	ANTI-PARKINSONIEN/ANTI-CHOLINERGIQUE / GELULE / 2MG	1296	1685	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1680	3240	MESTINON	PYRIDOSTIGMINE BROMURE	ANTI-MYASTHENIE / COMPRIMÉS / 60MG	3773	4905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1681	3253	MODOPAR 250	LEVODOPA+BENSERAZIDE	ANTI-PARKINSONIEN / GELULE / 200MG/50MG	7746	10070	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1682	3255	AEROCORT	BECLOMETASONE+SALBUTAMOL	ANTI-ASTHMATIQUE / DOSES / 100UG/50UG	2535	3295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1683	3257	GAMALATE B6	GAMALATE	PSYCHOSTIMULANT / Gramme (s) / COMPRIME	2765	3595	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1684	3259	MERONIA	MEROPENEME	ANTIBIOTIQUE BETA-LACTAMINE CARBAPENEME / AMPOULE / 500MG	11462	14900	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1685	3261	LASILIX SPECIAL	FUROSEMIDE	ANTI-HYPERTENSEUR DIURETIQUE DE L'ANSE / COMPRIMÉS / 500MG	22981	29875	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1686	3263	Kinazol	KETOCONAZOLE	ANTI-FONGIQUE TOPIQUE / MILLILITRES / 	3308	4300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1687	3264	ARTESIANE KIT	ARTEMETHER	ANTIPALUDIQUE /  / 300 mg	2385	3100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1688	3265	CEFACLOR	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 500MGIMIV	2538	3300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1689	3270	AMOXICO	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	3312	4305	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1690	3271	METRONIDAZOLE TM	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 250MG	12	15	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1691	3272	ACIDE ACETYL SALICYLIQUE UBI	ACIDE ACETYLSALICYLIQUE	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	65	85	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1692	3274	VITAMINE B COMPLEX TM	VITAMINE B	SUPPLEMENT VITAMINIQUE / Millilitre (s) / 1 MG/ 1ML	69	90	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1693	3275	ALBENDAZOLE UBI	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	77	100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1694	3277	QUININE TM	QUININE	ANTIPALUDIQUE / AMPOULE / 300MG/2ML	88	115	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1695	3278	IBUPROFENE UBI	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	108	140	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1696	3280	ALBEX	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1697	3282	MEBENDAZOLE QT	MEBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 100MG	135	175	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1698	3283	AMPICILLINE TM	AMPICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000MG	154	200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1699	3284	UMERAN	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / AMPOULE / 75MG	154	200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1700	3286	NOVACAN-150	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	231	300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1701	3288	ARTEMAL	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 20MG	254	330	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1702	3289	SANIVER	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	265	345	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1703	3290	TIMIZOL	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / COMPRIMÉS / 800MG/160MG	300	390	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1704	3291	UBENZOLE	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	315	410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1705	3293	TACIZOL	ALBENDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 400MG	354	460	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1706	3296	TRAMADOL	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / AMPOULE / 100MG/2ML	369	480	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1707	3297	SULFADOXINE + PYRIMETHAMINE TM	SULFADOXINE+PYRIMETHAMINE	ANTIPALUDIQUE / COMPRIMÉS / 500MG/25MG	373	485	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1708	3298	KETOPROFENE UBI	KETOPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 100MG	400	520	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1709	3299	ELERON	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 100MG/550MCG	423	550	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1710	3300	AMOXICILLINE SANDOZ	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 500MG	431	560	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1711	3301	METRIS	METRONIDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 500MG	431	560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1712	3302	COTRIMOXAZOLE UBI FORT	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / COMPRIMÉS / 800MG/160MG	442	575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1713	3303	ACIDE FOLIQUE TM	ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 5MG	454	590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1714	3304	FUSIDERM	ACIDE FUSIDIQUE	ANTIBIOTIQUE TOPIQUE / GRAMMES / 0.02	454	590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1715	3306	ARTESIANE 40 MG	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 40MG	477	620	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1716	3308	SERUM GLUCOSE 5% UBI SOL PERF 250ML	GLUCOSE ISOTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.05	500	650	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1717	3309	SERUM GLUCOSE 10% UBI SOL PERF 250ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.1	508	660	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1718	3310	SERUM SALE 0.9% UBI SOL PERF 250ML	CHLORURE DE SODIUM	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.009	508	660	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1719	3312	PLUFENTRINE	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	538	700	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1720	3313	R-LUME	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / Unite (s) / 20MG/120MG	538	700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1721	3314	PROKEFEN	KETOPROFENE	ANTI-INFLAMMATOIRE (AINS) / AMPOULE / 100MG/2ML	565	735	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1722	3315	SERUM SALE 0.9% UBI SOL PERF 500ML	BICARBONATE DE SODIUM	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.009	577	750	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1723	3316	SERUM GLUCOSE 5% UBI SOL PERF 500ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.05	581	755	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1724	3317	RINGER LACTATE UBI SOL PERF 500ML	RINGER LACTATE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / PM	585	760	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1725	3318	SERUM GLUCOSE 10% UBI SOL PERF	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.1	585	760	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1726	3319	COFANTRINE DISPERSIBLE	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	600	780	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1727	3322	AMOXICILLINE TM	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 500MG	677	880	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1728	3323	FUMARATE FERREUX TM	FER	ANTI-ANEMIQUE / COMPRIMÉS / 200MG	677	880	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1729	3326	DIFENAZOL	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / MILLILITRES / 0.001	681	885	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1730	3327	GEBEDOL TABS	DICLOFENAC + PARACETAMOL	ANTI-INFLAMMATOIRE (AINS) / ANTALGIQUE / Gramme (s) / 50 / 500	708	920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1731	3328	GLIBENCLAMIDE TM	GLIBENCLAMIDE	ANTIDIABETIQUE / Gramme (s) / 5 MG	758	985	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1732	3329	TRAVISIL Pastilles Citron	EXTRAITS DE PLANTES	ANTITUSSIF / Gramme (s) / PM	777	1010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1733	3330	TRAVISIL Pastilles Menthe	EXTRAITS DE PLANTES	ANTITUSSIF / Gramme (s) / PM	777	1010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1734	3331	TRAVISIL Pastilles Miel	EXTRAITS DE PLANTES	ANTITUSSIF / Gramme (s) / PM	777	1010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1735	3332	TRAVISIL Pastilles Orange	EXTRAITS DE PLANTES	ANTITUSSIF / Gramme (s) / PM	777	1010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1736	3333	COQUELUSEDAL NOURRISSON	EXTRAITS DE GRINDELIA + EXTRAITS DE GELSEMIUM	ANTITUSSIF / Gramme (s) / 10 MG / 5 MG	796	1035	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1737	3334	DIMETANE	PHOLCODINE	ANTITUSSIF / Millilitre (s) / PM	804	1045	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1738	3335	LAMONTE-BG	BECLOMETHASONE + GENTAMYCINE + CLOTRIMAZOLE	ANTIFONGIQUE / ANTIBIOTIQUE / Gramme (s) / PM	831	1080	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1739	3336	FUMARATE FERREUX + ACIDE FOLIQUE TM	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 200MG/0.25MG	846	1100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1740	3338	COQUELUSEDAL PARACETAMOL	PARACETAMOL 100 MG + EXTRAITS DE GELSEMIUM	ANTITUSSIF / ANTIPYRETIQUE / Gramme (s) / 100 MG / 20 MG	858	1115	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1741	3340	COQUELUSEDAL ENFANT	EXTRAITS DE GRINDELIA + EXTRAITS DE GELSEMIUM	ANTITUSSIF / Gramme (s) / 20 MG / 10 MG / 10 MG	873	1135	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1742	3341	FANGID CREME	CLOTRIMAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.01	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1743	3342	LEXOFEN 600	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 600 MG	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1744	3343	AMBROLITE-GS	AMBROXOL	FLUIDIFIANT BRONCHIQUE / Millilitre (s) / PM	896	1165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1745	3344	ARCONIFED	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 20MG	927	1205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1746	3345	RUBIX	MENTHOL + HUILE D'EUCALYPTUS	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / PM	946	1230	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1747	3346	ARTIMED	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	977	1270	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1748	3348	ACENLAND	ACECLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 100MG	1000	1300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1749	3349	KOLICURE	SIMETHICONE + HUILES	ANTITUSSIF / Millilitre (s) / PM	1000	1300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1750	3351	COTRIMOXAZOLE TM	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDES / Gramme (s) / 480 MG	1015	1320	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1751	3352	COSPHERUNAT	ARTESUNATE + AMODIAQUINE	ANTIPALUDIQUE / Gramme (s) / 50 MG / 125 MG	1027	1335	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1752	3353	OMEPRAZOLE UBI	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	1036	1347	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1753	3355	DIMET	METFORMINE	ANTIDIABETIQUE / Gramme (s) / 500 MG	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1754	3356	LEXOFEN PLUS	IBUPROFENE+PARACETAMOL	ANTI-INFLAMMATOIRE (AINS)/ANALGESIQUE / COMPRIMÉS / 400MG/500MG	1062	1380	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1755	3358	CACHEWORM	MEBENDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 100MG/5ML	1062	1380	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1756	3359	FLUISEDAL SANS PROMETHAZINE	BENZOATE DE MEGLUMINE + POLYSORBATE 20	FLUDIFIANT/MUCOLYTIQUE / Millilitre (s) / PM	1069	1390	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1757	3360	IMMU-C	ZINC + VITAMINE C + ECHINACEA	SUPPLEMENT VITAMINIQUE / MINERAL / Gramme (s) / PM	1077	1400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1758	3361	T-FER	FER + LYSINE + ZINC + VITAMINES B1, B2, B6, B12	ANTI-ANEMIQUE / Millilitre (s) / PM	1077	1400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1759	3362	VOVGEL CREME	DICLOFENAC SODIQUE + HUILE DE LIN + MENTHOL	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / PM	1104	1435	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1760	3363	COQUELUSEDAL ADULTE	EXTRAITS DE GRINDELIA + EXTRAITS DE GELSEMIUM	ANTITUSSIF / Gramme (s) / 40 MG / 20 MG / 40 MG	1115	1450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1761	3365	ZYNOVIT	FER + ACIDE FOLIQUE + NICOTINAMIDE + CALCIUM	ANTI-ANEMIQUE / Gramme (s) / PM	1135	1475	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1762	3366	TUSSIDANE SANS SUCRE	DEXTROMETHORPHANE	ANTITUSSIF CENTRAL / Millilitre (s) / PM	1146	1490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1763	3367	FEROZYN	FER + CYANOCOBALAMINE + ACIDE FOLIQUE	ANTI-ANEMIQUE / Gramme (s) / 200 MG	1150	1495	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1764	3368	SUTRILNEO	TORASEMIDE	ANTI-HYPERTENSEUR DIURETIQUE DE L'ANSE / COMPRIMÉS / 5MG	1154	1500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1765	3369	TAMIN	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 1000MG	1188	1545	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1766	3370	RECTOSOL	OXYDE DE BISMUTH + RESORCINE + LODURE DE ZINC + BAUME	ANTIHEMORROIDAIRE TOPIQUE / Gramme (s) / PM	1200	1560	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1767	3371	ACENLAND-P	ACECLOFENAC + PARACETAMOL	ANTI-INFLAMMATOIRE (AINS) / ANTALGIQUE / Gramme (s) / 100 MG / 500 MG	1212	1575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1768	3372	PARACETA-M	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 1000MG	1212	1575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1769	3373	POLYVITA-M	VITAMINES B COMPLEX + VITAMINE A + VITAMINE E	SUPPLEMENT VITAMINIQUE / Millilitre (s) / 5 ML	1212	1575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1770	3374	NIFETAB-RETARD	NIFEDIPINE	ANTIHYPERTENSEUR INHIBITEUR CALCIQUE / Gramme (s) / 20 MG	1231	1600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1771	3375	RILIF PLUS	ACECLOFENAC + PARACETAMOL	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 100MG/500MG	1231	1600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1772	3376	VAGYNAX	POLYMIXINE B SULFATE + NYSTATINE	ANTIBIOTIQUE / ANTIFONGIQUE / Gramme (s) / PM	1231	1600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1773	3378	AZITHRO nourrisson	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / SACHETS / 100MG	1235	1605	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1774	3379	NIPRESS	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	1235	1605	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1775	3381	ANTALGEX T	PARACETAMOL + TRAMADOL	ANTALGIQUE / ANALGESIQUE NON MORPHINIQUE / Gramme (s) / 325 / 37,5	1246	1620	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1776	3382	AMLOCLASS 10 MG	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	4415	5740	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1777	3383	FLEXDOL	IBUPROFENE + METHOCARBAMOL	ANTI-INFLAMMATOIRE (AINS) / MYORELAXANT / Gramme (s) / 200 MG / 500 MG	1262	1640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1778	3384	ANOXACIN	OXACILLINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Gramme (s) / 500 MG	2427	3155	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1779	3385	FALCIART	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 80MG/480MG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1780	3386	ENOXA 4000	ENOXAPARINE	ANTI-THROMBOTIQUE / AMPOULE / 40MG	4831	6280	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1781	3387	PEVAGINE	ECONAZOLE	ANTI-FONGIQUE LOCAL / OVULES / 150MG	2427	3155	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1782	3388	TONLUM	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / Unite (s) / 20MG/120MG	1942	2525	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1783	3389	DEXTROCIDINE	DEXTROMETHORPHANE	ANTITUSSIF / Millilitre (s) / 0,3 G / 100 ML	1273	1655	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1784	3390	SUPER CAL ZINC	CALCIUM+MAGNESIUM+ZINC	CARENCE MINERALE / Gramme (s) / PM	3773	4905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1785	3391	HEMAFER FOL	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 100MG/375MCG	2915	3790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1786	3392	MUCOLEX Junior	CARBOCYSTEINE	MUCOLYIQUE / Millilitre (s) / PM	1281	1665	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1787	3393	RABETOK-D	RABEPRAZOLE+DOMPERIDONE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG/30MG	4846	6300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1788	3394	CAZITHRO	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	2427	3155	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1789	3395	ZIPFERON	FER + ACIDE FOLIQUE + VIT C + B12 + ZINC + MULTIVITAMINES	ANTI-ANEMIQUE / Millilitre (s) / PM	1942	2525	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1790	3396	ZAMOX	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / SACHETS / 500MG/62.5MG	3269	4250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1791	3399	CACHART	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 80MG/480MG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1792	3400	DROX	CEFADROXIL	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 250MG/5ML	2446	3180	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1793	3401	MONAAMI	ACIDE MEFENAMIQUE + DICYCLOMINE	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 250 / 10	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1794	3402	CORTIS	DIPROPIONATE DE BECLOMETHASONE	CORTICOIDE INHALE / DOSES / 250UG	4858	6315	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1795	3403	CAPTOPRIL TM	CAPTOPRIL	ANTIHYPERTENSEUR INHIBITEUR DE L'ENZYME DE CONVERSION / Gramme (s) / 25MG	3369	4380	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1796	3404	LEO RUB	DICLOFENAC+MENTHOL+METHYLE SALICYLATE+HUILE DE LIN	ANTI INFLAMMATOIRE / Gramme (s) / PM	1485	1930	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1797	3405	TRAXOL 500 MG	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 500MGIV	1942	2525	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1798	3406	ENOXA 2000	ENOXAPARINE	ANTI-THROMBOTIQUE / AMPOULE / 20MG	3373	4385	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1799	3407	TRAXOL 250 MG	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / Gramme (s) / PM	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1800	3408	AMLOSTAR	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	4908	6380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1801	3409	PAMAGIN-C	CETIRIZINE+PHENYLEPHRINE+DEXTROMETORPHANE+ACETAMINOPHENE+ZINC	ANTI-HISTAMINIQUE / Millilitre (s) / PM	1588	2065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1802	3411	AZITHRIN	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	4908	6380	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1803	3413	DOMIZYN	DOMPERIDONE	ANTI-EMETIQUE / COMPRIMÉS / 10MG	1327	1725	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1804	3414	SYNTHOLKINE PATCH CHAUFFANT FORMAT STANDARD	LEVOMENTOL+VERATROLE+ RESORCINOL+ AC SALICYLIQUE	ANTALGIQUE/MYORELAXANT / Metre (s) / PM	2515	3270	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1805	3415	HEMAFER INJ VRAC	COMPLEXE D'HYDROXYDE DE POLYMALTOSE DE FER	ANTI-ANEMIQUE / Millilitre (s) / PM	2119	2755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1806	3416	KOACT	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Gramme (s) / 500MG/125MG	3419	4445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1807	3417	SYNTHOLKINE PATCH CHAUFFANT GRAND FORMAT	LEVOMENTOL+VERATROLE+ RESORCINOL+ AC SALICYLIQUE	ANTALGIQUE/MYORELAXANT / Metre (s) / PM	2515	3270	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1808	3418	TRAMACETAL	TRAMADOL + PARACETAMOL	ANTALGIQUE / ANALGESIQUE NON MORPHINIQUE / Gramme (s) / 325MG/37,5MG	1988	2585	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1809	3419	CIPTINZ	CIPROFLOXACINE + TINIDAZOLE	ANTIBIOTIQUE MACROLIDE/ANTIPARASITAIRE / Gramme (s) / 500/600 MG	1592	2070	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1810	3420	FERROLEX	SULFATE DE GLYCINE DE FER + VIT.B12 + ZINC + ACIDE FOLIQUE	ANTI-ANEMIQUE / Millilitre (s) / PM	1327	1725	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1811	3421	TRIBUTINE	TRIMEBUTINE	ANTI-SPASMODIQUE / GELULE / 150MG	2515	3270	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1812	3423	ASTYMIN-SN	ACIDES AMINES ESSENTIELS ET NON ESSENTIELS A CRISTALLINS PURS AVEC DU XYLITOL	NUTRITION PARENTERALE / Millilitre (s) / 250ML	3420	4446	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1813	3424	THIOTACID	ACIDE TIOCTIQUE, ACIDE ALPHLIPOIQUE + BENFOTIANUNE	ANTI-ANEMIQUE / Gramme (s) / 300mg/40mg/250mg	5023	6530	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1814	3426	HEMOTIN EPO	ERYTHROPOIETINE	ANTI-ANEMIQUE SPECIFIQUE / Millilitre (s) / 2000UI/ml	10596	13775	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1815	3427	UMEXIM	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / GELULE / 100MG	2519	3275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1816	3428	LILGRO	DEXTROMETHORPHANE + BROMHEXINE + MENTOL + ACIDE CITRIQUE	ANTITUSSIF / Millilitre (s) / PM	1327	1725	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1817	3429	IRYS	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 2MG	3442	4475	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1818	3430	PNEUMOXOL	CHLORHYDATE D'AMBROXOL	MUCOLYTIQUE / Millilitre (s) / 30MG/5ML	2031	2640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1819	3431	GENUPHIL	SULFATE DE GLUCOSAMINE, CHLORURE DE	ANTI-RHUMATISMAL / Gramme (s) / 375/375/300	5004	6505	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1820	3432	AMOXYN	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINES / Gramme (s) / 500mg	3462	4500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1821	3433	METROLEX-F	METRONIDAZOLE + FURAZOLIDONE	ANTIPARASITAIRE / ANTIBIOTIQUE / Millilitre (s) / PM	1327	1725	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1822	3434	MEDITONSIN	ACONITINUM SULFURICUM D5+ TROPINUM D5+ ERCURE D8	ANTI-ALLERGIQUE / Gramme (s) / PM	2542	3305	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1823	3437	CARDIACTIV	ACIDES GRAS POLYSATURES+CRATAEGUS	CARDIOTONIQUE MYORELAXANT SEDATIF / Millilitre (s) / 40/20/2%	1604	2085	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1824	3438	MUCOLEX Adulte	CARBOCYSTEINE	MUCOLYIQUE / Millilitre (s) / PM	1327	1725	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1825	3439	SOLACY	SOUFRE + VITAMINE A	ELEMENT MINERAL / Gramme (s) / PM	3488	4535	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1826	3440	LA PIPERA 	PIPERACILLINE+TAZOBACTAM	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / FLACON / 4000MG/500MG	11101	14431	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1827	3441	RAMIZID HCT	RAMIPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 2.5MG/12.5MG	2562	3330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1828	3442	ZAMOX NOURRISSON	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 100MG/12.5MG	2085	2710	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1829	3443	FESTIV	PEPSINE + PAPAINE + MAGNESIUM	CHOLERETIQUE/HEPATOLOGUE / Millilitre (s) / 30 ML	1604	2085	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1830	3444	TRAVISIL	EXTRAITS DE PLANTES	ANTITUSSIF / Millilitre (s) / PM	1342	1745	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1831	3447	MINOLIP	SIMVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 40MG	3527	4585	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1832	3448	UTRIXONE	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	2592	3370	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1833	3449	CLARITRON	CLARITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	5231	6800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1834	3450	UZET	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	2592	3370	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1835	3451	HISTALIX Pédiatrique	DIPHENHIDRAMINE + AMMONIUM + MENTHE	EXPECTORANT / Millilitre (s) / 7 MG / 67,5 MG / 0,55 MG	1377	1790	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1836	3452	AMLOCLASS 5 mg	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	3531	4590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1837	3453	ACOFAN	ACECLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 100MG	2119	2755	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1838	3454	CETAFOR	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 500MGIMIV	2600	3380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1839	3455	TRIAXONE	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1608	2090	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1840	3456	CACHNERVE	ACIDE ALPHALIPOIQUE + ACIDE GAMMA LINOLENIQUE	NEUROPATHIES PERIPHERIQUES / Gramme (s) / PM	5285	6870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1841	3457	TELMIKAA H	TELMISARTAN+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 40MG/12.5MG	11481	14925	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1842	3458	BECLAV	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINES / Millilitre (s) / 500 mg/125	3531	4590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1843	3460	BABY GREPS	EXTRAITS DE MENTHE, ANIS, FENOUIL ET CAMOMILLE	ANTISPASMODIQUE / Millilitre (s) / PM	2119	2755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1844	3461	IZ-500	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	2646	3440	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1845	3462	ALCER 40 mg	PANTOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 40MG	5300	6890	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1846	3463	BECLAV-SUSP	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Millilitre (s) / 250/62.5	3531	4590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1847	3465	NECIN-3	POLYMYXINE B+BACITRACINE+NEOMYCINE	ANTIBIOTIQUE TOPIQUE / GRAMMES / 5000UI/400UI/3400UI	1677	2180	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1848	3468	ANTICID PLUS	HYDROXIDE DE MAGNESIUM	ANTI ACIDE/ PANSEMENT GASTRO INTESTINAL / MILLILITRES / 400MG/400MG	1385	1800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1849	3469	BIFOSA 70	ALENDRONATE SODIQUE	ANTI-OSTEOPOROSE / COMPRIMÉS / 70MG	5300	6890	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1850	3470	XONE	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	2169	2820	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1851	3471	IPOZOLE	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	3531	4590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1852	3472	SYNTHOLKINE GEL CREME	LEVOMENTOL+VERATROLE+ RESORCINOL+ AC SALICYLIQUE	ANTALGIQUE/MYORELAXANT / Gramme (s) / PM	2646	3440	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1853	3473	ACLOP	ACECLOFENAC + PARACETAMOL	ANTI-INFLAMMATOIRE (AINS) / ANTALGIQUE / Gramme (s) / 100MG/500MG	1412	1835	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1854	3474	ESOMED-40	ESOMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 40MG	5300	6890	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1855	3475	ANTIPLATT	CLOPIDOGREL	ANTI-AGREGANT PLAQUETTAIRE / COMPRIMÉS / 75MG	12362	16070	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1856	3477	PLASIR	CITRATE DE SILDENAFIL	CARDIOTONIQUES / Gramme (s) / 50 MG	3531	4590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1857	3479	DOPANORE	METHYLDOPA	ANTI-HYPERTENSEUR CENTRAL / COMPRIMÉS / 250MG	1412	1835	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1858	3480	SYNTHOLKINE ROLL ON	LEVOMENTOL+VERATROLE+ RESORCINOL+ AC SALICYLIQUE	ANTALGIQUE/MYORELAXANT / Millilitre (s) / PM	2646	3440	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1859	3481	ULCIZONE	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	2208	2870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1860	3482	LIVOZED	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	5300	6890	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1861	3483	AZITHRO	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / GELULE / 250MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1862	3484	ZYLTAN	LOSARTAN POTASSIQUE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II / COMPRIMÉS / 50MG	3531	4590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1863	3487	KEFROX 250	CEFUROXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / COMPRIMES / 250MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1864	3488	ACFRAN	FER+VITAMINES+ACIDE FOLIQUE	ANTI-ANEMIQUE / Millilitre (s) / PM	2208	2870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1865	3489	CACEF COMPRIME	CEFPODOXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 200MG	3531	4590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1866	3490	OLIGOSOL MAGNESIUM	MAGNESIUM	ELEMENT MINERAL / Gramme (s) / PM	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1867	3491	APROVEL	IRBESARTAN	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II / COMPRIMÉS / 150MG	12069	15690	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1868	3492	ARTIZ FORTE	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 40MG/240MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1869	3494	OFLOR	OFLOXACINE + ORNIDAZOLE	ANTIBIOTIQUE QUINOLONES / ANTIPARASITAIRE / Gramme (s) / 200mg/500mg	5300	6890	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1870	3495	ALOFACT	ACECLOFENAC + PARACETAMOL	ANTI-INFLAMMATOIRE (AINS) + ANTALGIQUE / Gramme (s) / 100 mg/500 mg	3535	4595	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1871	3496	SOLCER	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / AMPOULE / 40MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1872	3497	AMIDERM CREME	GENTAMYCINE+BETHAMETHAZONE+TOLNAFTATE	ANTIBIOTIQUE TOPIQUE / GRAMMES / PM	1415	1840	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1873	3499	VIKTHRO	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	3535	4595	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1874	3501	CLARTEC	LORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / MILLILITRES / 5MG/5ML	2208	2870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1875	3502	INDOZONE-S	CEFTRIAXONE+SULBACTAM	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG/500MGIMIV	2654	3450	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1876	3505	TORAS-Denk	TORASEMIDE	ANTI-HYPERTENSEUR DIURETIQUE DE L'ANSE / COMPRIMÉS / 10MG	5385	7000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1877	3506	CEFEZONE-S	CEFTRIAXONE+SULBACTAM	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG/500MGIMIV	2692	3500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1878	3508	PHOSPHONORM	COMPLEXE D'HYDROXIDE DE CHLORURE D'ALUMINIUM	CARENCE MINERALE / Unite (s) / 300 mg	12423	16150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1879	3509	NAUSELIUM	DOMPERIDONE	ANTI-EMETIQUE / MILLILITRES / 1MG/ML	1458	1895	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1880	3510	KOACT 1000 MG	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINES / Gramme (s) / 875MG/125MG	3550	4615	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1881	3511	LESSTROL 20	ATORVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 20MG	5519	7175	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1882	3512	POLIFER	CITRATE D'AMMONUIM+FOLIQUE+THIAMINE+PYRIDOXINE	ANTI-ANEMIQUE / Millilitre (s) / 250 ML	1750	2275	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1883	3513	VITOREX	FENUGREC+ACIDE ASCORBIQUE+TOCOPHEROL+B	CARENCE MINERALE / Millilitre (s) / PM	2723	3540	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1884	3514	NABYOL FORTE	NITROXOLINE	ANTIBIOTIQUE OXYQUINOLEINES / Gramme (s) / 100MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1885	3516	LEVOTOP	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	5562	7230	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1886	3517	AFSC-KIT	AZITHROMYCINE+FLUCONAZOLE+SECNIDAZOLE	ANTIBIOTIQUE/ANTIFONGIQUE/ANTIPARASITAIRE / Gramme (s) / 4CP	2738	3560	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1887	3521	TRAMFIZ	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / GELULE / 50MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1888	3522	NIFEDIPINE	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 20MG	2827	3675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1889	3523	NEAGYL 80 MG	PHLOROGLUCINOL	ANTI-SPASMODIQUE / COMPRIMÉS / 80MG	1458	1895	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1890	3524	ZOCEF	CEFUROXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Gramme (s) / 500 mg	5650	7345	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1891	3525	IVEFERAN	FER SUCROSE	ANTI-ANEMIQUE / Millilitre (s) / 100mg/5ml	15896	20665	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1892	3526	VERSINO	DICLOFENAC + PARACETAMOL + CHLORPHENIRAMINE + MAGNESIUM	ANTI-INFLAMMATOIRE (AINS) + ANTALGIQUE / Gramme (s) / 50MG/500MG/4MG/100	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1893	3527	VIKLEVO	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	5738	7460	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1894	3528	ALFER-SUSPENSION	FER+ACIDE FOLIQUE+VIT C +B12+ ZINC	ANTI-ANEMIQUE / Millilitre (s) / 200 ML	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1895	3529	PEPTICA	HYDROXYDE DE MAGNESIUM+HYDROXYDE D'ALUMINIUM	PANSEMENT GASTRO INTESTINAL / MILLILITRES / 200MG/50MG	1465	1905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1896	3530	MEROCLASS	MEROPENEME	ANTIBIOTIQUE BETA-LACTAMINE CARBAPENEME / AMPOULE / 500MG	16346	21250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1897	3531	CEFTRIAXONE Sodique TM	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1469	1910	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1898	3533	ANTI-KALIUM	POLYSTYRENE-CO-DIVINYLBENZENE+ACIDE SULFONIQUE+SEL SODIUM	HYPOKALIEMIANT / SACHETS / 300MG	13769	17900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1899	3534	HISTALIX Adulte	DIPHENHIDRAMINE + AMMONIUM + MENTHE	EXPECTORANT / Millilitre (s) / 14 MG / 135 MG / 1,1 MG	1473	1915	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1900	3535	FERMED	COMPLEXE D'HYDROXYDE FERRIQUE-SACCHAROSE	CARENCE MINERALE / Millilitre (s) / 100 mg	15154	19700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1901	3536	PROMONGYL	SECNIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 1G	1473	1915	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1902	3538	IPPROTON	OMEPRAZOLE	ANTI-ULCEREUX/CYTOPROTECTEUR GASTRIQUE / Millilitre (s) / 40 mg	25615	33300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1903	3541	STRIPRIL	LISINOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 5MG	5888	7655	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1904	3542	PREZAR	LOSARTAN POTASSIQUE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II / COMPRIMÉS / 50MG	6092	7920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1905	3543	FENO TG	FENOFIBRATE MICRNISE SUPRABIODISPONIBLE	HYPERTRIGLYCERIDEMIE / Gramme (s) / 160 mg	6181	8035	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1906	3544	CC-NEFRO	CALCIUM CARBONATE	TROUBLES ELECTROLYTIQUES/SELS MINERAUX / COMPRIMÉS / 500MG	6227	8095	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1907	3545	LEZYNCET	LEVOCETIRIZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 5MG	2873	3735	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1908	3546	DIPREZAR	LOSARTAN POTASSIQUE+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/12.5MG	6358	8265	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1909	3547	BISPIRAZOLE	SPIRAMYCINE+METRONIDAZOLE	ANTIBIOTIQUE/ANTI-PARASITAIRE / COMPRIMÉS / 1.5MUI/250MG	3569	4640	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1910	3548	DIAMIN	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 1000MG	2215	2880	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1911	3550	AUROPODOX	CEFPODOXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 100MG	2881	3745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1912	3551	ENOXA 6000	ENOXAPARINE	ANTI-THROMBOTIQUE / AMPOULE / 60MG	6446	8380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1913	3552	ROX-MYCIN	ROXYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 150MG	2223	2890	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1914	3553	CLIPTOL	IBUPROFENE + LEVOMENTHOL	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 5G/3G	2896	3765	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1915	3554	CIPROZED 750	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 750MG	3531	4590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1916	3555	TRAMACLASS	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / Gramme (s) / 100MG	2231	2900	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1917	3557	ALFER TABLET	FER+ACIDE FOLIQUE+VIT C +B12+ ZINC	ANTI-ANEMIQUE / Unite (s) / PM	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1918	3558	ACINET	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINES / Gramme (s) / 625MG	2908	3780	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1919	3560	ZAMOX ENFANT	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 100MG/12.5MG	2923	3800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1920	3562	AMBROX-DENK	AMBROXOL	FLUIDIFIANT BRONCHIQUE / Unite (s) / 60 MG	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1921	3564	RABETOK	RABEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	3019	3925	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1922	3565	ENOXA 8000	ENOXAPARINE	ANTI-THROMBOTIQUE / AMPOULE / 80MG	7481	9725	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1923	3566	ZEXIM 100	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 100MG/5ML	3708	4820	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1924	3567	IBUPAIN	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 800MG	2296	2985	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1925	3568	GUAFLEX	EXTRAITS DE FEUILLES DE GOYAVIER + HUILE DE FENOUIL	ANTITUSSIF / Millilitre (s) / PM	1485	1930	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1926	3570	AZITHRO ENFANT	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / SACHETS / 200MG	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1927	3572	R-LUME INJECTABLE	ARTEMETHER	ANTIPALUDIQUE / Gramme (s) / 80MG	2308	3000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1928	3573	LE-CET	LEVOCETIRIZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 5MG	1485	1930	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1929	3575	ZEXIM 200	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 200MG/5ML	3708	4820	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1930	3577	GLEMA	GLIMEPIRIDE	ANTIDIABETIQUE / Gramme (s) / 2 mg	3712	4825	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1931	3578	STRUCTUM	CHONDROITINESULFATE SODIQUE	ANTI-ARTHROSIQUE / Gramme (s) / 50mg	8142	10585	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1932	3579	MYONIT SR	TRINITRATE DE GLYCERINE	ANTI-ANGOREUX / COMPRIMÉS / 2.6MG	3127	4065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1933	3580	VITAL-CALCIUM	CARBONATE DE CALCIUM	CARENCE CALCIQUE / Gramme (s) / 400MG	2308	3000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1934	3581	DIABETAN	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 2MG	3735	4855	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1935	3582	XOLFOVEL	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	8150	10595	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1936	3583	LEORUB	MENTHOL + DICLOFENAC + METHYLE SALICYLATE + HUILE DE LIN	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 5% / 1% / 10% / 3%	0	0	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1937	3584	NEULEPTIL	PROPERICIAZINE	ANTI-PSYCHOTIQUE / COMPRIMÉS / 25MG	3150	4095	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1938	3585	STACEF	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1939	3586	VITAL-MAG	CARBONATE DE MAGNESIUM	CARENCE EN MAGNESIUM / Gramme (s) / 187,5MG	2308	3000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1940	3588	CRANBERRY	CANNEBERGE	ANTISEPTIQUE URINAIRE / Gramme (s) / 250 mg	3750	4875	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1941	3589	RENERVE PLUS	METHYLECOBALAMINE+ACIDE ALPHALIPOIQUE+ACIDE FOLIQUE	NEUROPATHIES / Gramme (s) / PM	8154	10600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1942	3590	HEMAFER	COMPLEXE D'HYDROXYDE DE POLYMALTOSE DE FER	ANTI-ANEMIQUE / Unite (s) / 100 mg	2915	3790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1943	3591	APOTEL MAX	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 1000MG	2323	3020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1944	3592	ACLOGEL	ACECLOFENAC + LINSEED OIL + MENTHOL + METHYL-SALICYLATE	ANTI-INFLAMMATOIRE (AINS) / ANTALGIQUE / Gramme (s) / PM	1500	1950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1945	3593	IMUCLAV comprime	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINES / Gramme (s) / 875 mg / 125 mg	3808	4950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1946	3594	TRIAM-Denk	TRIAMCINOLONE	CORTICOIDE / Gramme (s) / 40 mg	8831	11480	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1947	3595	APOTEL PLUS	PARACETAMOL + LIDOCAÏNE	ANTALGIQUE / ANTIPYRETIQUE / Gramme (s) / 600MG/20MG	2323	3020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1948	3596	CAZITHRO SIROP	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / MILLILITRES / 200MG/5ML	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1949	3597	ACEM	CLARITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	3842	4995	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1950	3598	DIACEREIN	DIACERHEINE	ANTI-RHUMATISMAL / Gramme (s) / 50 mg	8873	11535	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1951	3599	FOLICAL-M	ACIDE FOLINIQUE	ANTI-ANEMIQUE SPECIFIQUE / AMPOULE / 50MG/5ML	3846	5000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1952	3600	SPASMO-APOTEL	PARACETAMOL+BUTYLBROMURE DE HYOSCINE	ANTALGIQUE / ANTISPASMODIQUE / Gramme (s) / 600MG/20MG	2323	3020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1953	3601	GEMZAR	GEMCITABINE	ANTICANCEREUX/ANaTIMETABOLITE / AMPOULE / 1000MG	85200	110760	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1954	3603	L-MESITRAN	ACIDE ASCORBIQUE+MEDICAL GRADE HONEY+MEDILAN+PEG+PEG 4000+VIT	CICATRISANT / Gramme (s) / PM	8946	11630	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1955	3604	ACINET 1 G	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 1000MG/125MG	3885	5050	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1956	3605	MICAZOLE	MICONAZOLE	ANTI-FONGIQUE LOCAL / GRAMMES / 0,01	2354	3060	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1957	3607	TRAUSAN	CITICOLINE	ANTI-ISCHEMIQUE / Millilitre (s) / 10 g	9031	11740	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1958	3608	DETENSIEL	BISOPROLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 10MG	3523	4580	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1959	3609	CYCLOPHOSPHAMIDE (ENDOXAN)	CYCLOPHOSPHAMIDE	ANTI-NEOPLASIQUE / AMPOULE / 500MG	2308	3000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1960	3610	MEGAMAG	ASPARTATE DE MAGNESIUM DIHYDRATE	CARENCE EN MAGNESIUM / Gramme (s) / 400MG	2358	3065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1961	3611	COLOSAR	LOSARTAN POTASSIQUE+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/12.5MG	9273	12055	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1962	3613	INDOZONE	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1769	2300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1963	3614	ACUMOL	ACECLOFENAC + PARACETAMOL	ANTI-INFLAMMATOIRE (AINS) + ANTALGIQUE / Gramme (s) / 100 / 500MG	2385	3100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1964	3615	LOSAR	LOSARTAN POTASSIQUE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II / COMPRIMÉS / 50MG	9273	12055	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1965	3616	PROSTAFIP	PEPINS DE COURGE+FEUILLE D'ORPIE+SELENIUM	HYPERTROPHIE BENIGNE DE LA PROSTATE / COMPRIMÉS / PM	3923	5100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1966	3617	FLURO-M	5-FLUOROURACILE	ANTICANCEREUX/ANaTIMETABOLITE / AMPOULE / 50MG	3077	4000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1967	3618	FIZO	RABEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	2385	3100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1968	3619	KEFROX	CEFUROXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Millilitre (s) / 50 ML	1769	2300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1969	3621	ACTISOUFRE	SULFURE DE SODIUM NON HYDRATE	DECONGESTIONNANT/RHINITE ALLERGIQUE / Millilitre (s) / PM	3973	5165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1970	3622	RENERVE PLUS BT	BENFOTHIAMINE + METHYLECOBALAMINE + ACIDE ALPHA	NEUROPATHIES / Gramme (s) / PM	9462	12300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1971	3623	ALIROSA	EXTRAITS D'AIL + GRAINS D'ONAGI	TRAITEMENT DE LA MENOPAUSE / Gramme (s) / PM	2415	3140	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1972	3625	VINCRISTINE (ONCOVIN)	VINCRISTINE	ANTICANCEREUX/AGENT DU FUSEAU CYTOTOXIQUE / AMPOULE / 1MG	3488	4535	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1973	3626	BIFOSA 35	ALENDRONATE SODIQUE	ANTI-OSTEOPOROSE / COMPRIMÉS / 35MG	3973	5165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1974	3627	TELMIKAA 40	TELMISARTAN	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 40MG	9712	12625	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1975	3629	DOXORUBICINE (ADRIBLASTINE)	DOXORUBICINE	ANTICANCEREUX/CYTOTOXIQUE ANTI-TOPOISOMERASES II / AMPOULE / 50MG	26269	34150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1976	3630	IFICOSANOL	POLICOSANOLS+MALTODEXTRINE	HYPOLIPEMIANT / Gramme (s) / PM	4012	5215	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1977	3631	CHINTER	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	1800	2340	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1978	3633	EPIRUBICINE (FARMORUBICINE)	EPIRUBICINE	ANTICANCEREUX/CYTOTOXIQUE ANTI-TOPOISOMERASES II / AMPOULE / 50MG	38462	50000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1979	3634	FLANID	ACIDE TIAPROFENIQUE	ANTI-INFLAMMATOIRE (AINS) / Unite (s) / 100 mg	1819	2365	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1980	3635	ZYLTAN H	LOSARTAN POTASSIQUE+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/12.5MG	4150	5395	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1981	3636	NEUPOGEN	FILGRASTIM	ANTI-NEOPLASIQUE / AMPOULE / 50MG	72000	93600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1982	3638	FLUOXINE	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	1500	1950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1983	3641	ALFENAC	ACECLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 100MG	1854	2410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1984	3643	BRONQUIDIAZINA	SULFAMETHOXAZOLE+TRIMETHOPRIME+BROMHEXINE HCL	ANTIBIOTIQUE EXPECTORANT / Unite (s) / 100	1854	2410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1985	3647	FLANID 	ACIDE TIAPROFENIQUE	ANTI-INFLAMMATOIRE (AINS) / Unite (s) / 200mg	1888	2455	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1986	3648	GEBEDOL FORTE TABS	DICLOFENAC + ACETOMINOPHEN + CHLORZOXAZONE	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 50 / 500 / 250	1504	1955	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1987	3651	PLAZADOL	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / GELULE / 50MG	1504	1955	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1988	3653	BEZINC	VITAMINES B COMPLEX+VITAMINE A+VITAMINE C+CALCIUM+ZINC	SUPPLEMENT VITAMINIQUE / Unite (s) / PM	1923	2500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1989	3656	CEFEZONE	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1923	2500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1990	3657	BECOX	VIT B COMPLEXE	SUPPLEMENT VITAMINIQUE / Millilitre (s) / PM	1538	2000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1991	3658	IMUCLAV BID SYRUP	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Unite (s) / 200 MG/ 28,5mg	1923	2500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1992	3660	FEKEY	FER + ACIDE AMINE + VITAMINES	ANTI-ANEMIQUE / Millilitre (s) / PM	1538	2000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1993	3661	IMUCLAV DRY SYRUP	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Unite (s) / 125 mg/31,25 mg	1923	2500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1994	3664	FUROXIM	CEFUROXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Millilitre (s) / 750 MG	1546	2010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1995	3665	IMUCLAV INJECTABLE	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000MG/200MG	1923	2500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1996	3666	IZ-200	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / MILLILITRES / 200MG/5ML	1923	2500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1997	3670	MUCOXINE	ACETYLCYSTEINE	MUCOLYTIQUE / SACHETS / 200MG	1935	2515	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
1998	3671	AEROL	SALBUTAMOL	ANTI-ASTHMATIQUE / DOSES / 100UG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
1999	3672	FALCIART DT	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / Unite (s) / 20MG/120MG	1588	2065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2000	3675	TROFOCARD	L-ASPARTATE HCL DE MAGNESIUM	ELEMENT MINERAL / Gramme (s) / PM	4154	5400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2001	3679	MYONIT SR 6,4	TRINITRATE DE GLYCERINE	ANTI-ANGOREUX / COMPRIMÉS / 6.4MG	4288	5575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2002	3681	ZEXIM 400	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / GELULE / 400MG	4323	5620	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2003	3682	BIDONTOGYL	SPIRAMYCINE+METRONIDAZOLE	ANTIBIOTIQUE/ANTI-PARASITAIRE / COMPRIMÉS / 1.5MUI/250MG	4415	5740	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2004	3684	CIPOTAX	CIPROFLOXACINE + TINIDAZOLE	ANTIBIOTIQUE QUINOLONES / ANTIPARASITAIRE / Gramme (s) / 500 MG / 600 MG	4415	5740	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2005	3687	LESSTROL 10	ATORVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 10MG	4415	5740	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2006	3689	LEVORAY	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	4415	5740	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2007	3691	AUROPODOX 200 MG	CEFPODOXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 200MG	4574	5946	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2008	3693	CACEF SIROP	CEFPODOXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 50MG	4592	5970	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2009	3695	FIXIM	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 200MG	4635	6025	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2010	3700	AUROMETFORMIN 850 MG	METFORMINE	ANTIDIABETIQUE / Gramme (s) / 850 MG	5962	7750	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2011	3701	AUROMETFORMIN 1000 MG	METFORMINE	ANTIDIABETIQUE / Gramme (s) / 1000 MG	4751	6176	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2012	3706	BIAFOK	DIPHENHIDRAMINE + CHLORURE D'AMMONIUM	ANTI-ALLERGIQUE / Millilitre (s) / PM	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2013	3709	ZOUCEF	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1758	2285	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2014	3711	ZOLINE	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	4415	5740	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2015	3714	COAPROVEL	IRBESARTAN+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 150MG/12.5MG	12246	15920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2016	3721	BD-FEN	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	1650	2145	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2017	3722	NAGFEN	KETOPROFENE	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 2,5%	2473	3215	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2018	3723	ACEFLAMEX	ACECLOFENAC	ANTI-INFLAMMATOIRE (AINS) / Unite (s) / 100MG	1769	2300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2019	3724	ARTHEPA	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 80MG	677	880	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2020	3725	POVIDONE	POVIDONE IODEE	ANTI-SEPTIQUE LOCAL / MILLILITRES / PM	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2021	3726	SERUM GLUCOSE 5% TM SOL PERF 500ML	GLUCOSE ISOTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.05	442	575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2022	3727	SERUM GLUCOSE 10% TM SOL PERF 500ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.1	442	575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2023	3728	RINGER LACTATE TM SOL PERF 500ML	RINGER LACTATE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / PM	442	575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2024	3729	VITAMINE C TM	ACIDE ASCORBIQUE	VITAMINES ET SELS MINERAUX / AMPOULE / 500MG	46	60	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2025	3731	TAMADOL	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / AMPOULE / 100MG/2ML	369	480	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2026	3732	NOCOLIC	SARJIKAKSHARA + ANETHUM GRAVEOLANS	ANTISPASMODIQUE / Millilitre (s) / PM	512	665	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2027	3756	BIPERIDYS	DOMPERIDONE	ANTI-EMETIQUE / COMPRIMÉS / 20MG	1935	2515	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2028	3757	ACLIN GEL	CLINDAMYCINE PHOSPHATE	ANTIBIOTIQUE LOCAL / Gramme (s) / 0.1	2562	3330	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2029	3758	SILAGENCYL	SILAGENCYL	ANTISEPTIQUE LOCAL / Millilitre (s) / PM	3443	4476	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2030	3759	OLIGOSPHERE FER	SULFATEB FERREUX + ACIDE FOLIQUE + CELLULOSE MICROCRISTALLINE	ANTI-ANEMIQUE / Gramme (s) / 44 MG / 0,2 MG / 305,8 MG	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2031	3760	KLINUP GEL	ALCOOL 90°	ANTI-SEPTIQUE TOPIQUE / MILLILITRES / PM	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2032	3761	PRELUZELLE	EXTRAITS DE SODJA + EXTRAITS DE LUZERNE + EXTRAITS DE TREFLE ROUGE + CELLULOSE MICROCRISTALLINE	MENOPAUSE / Gramme (s) / PM	3550	4615	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2033	3762	ADORA	CEFADROXIL	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 500MG	2377	3090	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2034	3763	EXEPHIN	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	2038	2650	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2035	3765	GATIFLOX	GATIFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	1358	1765	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2036	3766	ECONATE G CREME	NITRATE D'ECONAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.01	1119	1455	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2037	3767	NISPORE 50	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 50MG	2719	3535	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2038	3768	NISPORE 150	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	2038	2650	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2039	3769	FIXOCARD	AMLODIPINE + ATENOLOL	ANTIHYPERTENSEUR INHIBITEUR CALCIQUE + BETABLOQUANT / Gramme (s) / 5 MG /50 MG	2546	3310	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2040	3770	WINPAIN	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / Gramme (s) / 100 MG / 2 ML	1019	1325	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2041	3771	VITABION	VIT B1 + VIT B6 + VIT B12	NEVRALGIE/NEVRITE / Gramme (s) / 100 MG / 100 MG / 1 MG	1700	2210	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2042	3772	GENES VIT MAGNESIUM 300	MAGNESIUM + VIT B1 + VIT B6 + VIT B12	ELEMENT MINERAL / Gramme (s) / PM	2108	2740	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2043	3773	NEALGYL	PHLOROGLUCINOL	ANTI-SPASMODIQUE / COMPRIMÉS / 80MG	1458	1895	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2044	3774	ARTESUN	ARTESUNATE	ANTIPALUDIQUE / AMPOULE / 60MG	1104	1435	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2045	3775	D-ARTEPP 40/320	DIHYDROARTEMISININE+PIPERAQUINE	ANTIPALUDIQUE / COMPRIMES / 40MG/320MG	2427	3155	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2046	3776	ZOLOFT	SERTRALINE	ANTI-DEPRESSEUR / GELULE / 50MG	10042	13055	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2047	3778	DEPAKOTE	DIVALPROATE DE SODIUM	ANTI-DEPRESSEUR / COMPRIMÉS / 500MG	28696	37305	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2048	3782	ALPHAGAN	BRIMONIDINE	ANTI-GLAUCOMATEUX / MILLILITRES / 2MG/ML	6077	7900	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2049	3783	HYDREA	HYDROXYCARBAMIDE	ANTICANCEREUX/IMMUNOMODULATEUR CYTOTOXIQUE / GELULE / 500MG	3885	5050	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2050	3784	CHLORAMINOPHENE	CHLORAMBUCIL	ANTICANCEREUX/AGENT ALKYLANT / GELULE / 2MG	12300	15990	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2051	3785	PREVISCAN	FLUINDIONE	ANTI-THROMBOTIQUE / COMPRIMÉS / 20MG	2396	3115	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2052	3786	NOVATEN-AM	ATENOLOL+AMLODIPINE	ANTI-HYPERTENSEUR BETA-BLOQUANT/INHIBITEUR CALCIQUE / COMPRIMÉS / 50MG/5MG	8046	10460	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2053	3787	COLINIL	SIMETHICONE	ADSORBANT INTESTINAL / MILLILITRES / PM	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2054	3792	INSTACLOP	CLOPIDOGREL	ANTI-AGREGANT PLAQUETTAIRE / COMPRIMÉS / 75MG	6004	7805	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2055	3793	APRAMOL 	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	785	1020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2056	3794	NEFROCARNIT	LEVOCARNITINE	DEFICIT EN CARNITHINE DANS LES DIALYSES / Gramme (s) / 1G/5ML	6923	9000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2057	3796	ADALATE LA	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 30MG	8004	10405	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2058	3797	AVELOX	MOXIFLOXACINE	ANTIBIOTIQUE QUINOLONES / Gramme (s) / 400 MG	7577	9850	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2059	3798	AZIBACT	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	2981	3875	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2060	3799	BD LOX	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 750MG	4238	5510	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2061	3800	BIOFAR COMPLEXE VIT B	COMPLEXE VIT B	NEUROPATHIES / Gramme (s) / PM	1731	2250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2062	3801	BION3 ADULTE	3PROBIOTIQUES+VITAMINES B COMPLEX+ACIDE FOLIQUE+VIT A, D3, E+FER+CALCIUM+MAGNESIUM	NEUROPATHIES / Gramme (s) / PM	5000	6500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2063	3802	BION3 JUNIOR	3PROBIOTIQUES+VITAMINES B COMPLEX+ACIDE FOLIQUE+VIT A, D3, E+FER+CALCIUM+MAGNESIUM	NEUROPATHIES / Gramme (s) / PM	4731	6150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2064	3803	CACIP	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	692	900	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2065	3804	CALCHEK	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	3373	4385	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2066	3806	CAPRAZOLE	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	3415	4440	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2067	3807	CARBOTOUX	CARBOCYSTEINE	MUCOLYTIQUE / Gramme (s) / 375 MG	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2068	3808	CEFTRIAXONE LDP	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / Gramme (s) / 250 MG	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2069	3811	CELLTRIAXON	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2070	3813	COMBIART	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2071	3814	CROISCARD	CALCIUM + VITAMINE D3	CARENCE CALCIQUE / Gramme (s) / 500 MG/250MCG	1238	1610	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2072	3815	CROISARD-E	CALCIUM + VITAMINE D3	CARENCE CALCIQUE / Gramme (s) / 500MG/250MCG/125UI	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2073	3816	DELIVREX	OXYTOCINE	OCYTOCIQUE / Millilitre (s) / 5 UI / ML	796	1035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2074	3817	FERRAVIT	FER, ACIDE FOLIQUE, VIT B12, ZINC	ANTI-ANEMIQUE / Millilitre (s) / PM	1750	2275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2075	3818	FERVITAL	ACIDE FOLIQUE+CITRATE D'AMMONIUM FERRIQUE+VIT B12	ANTI-ANEMIQUE / Millilitre (s) / PM	973	1265	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2076	3819	FLUB	FLUBENDAZOLE	ANTI-PARASITAIRE / MILLILITRES / PM	1350	1755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2077	3821	FLUCAP	FLUCONAZOLE	ANTI-FONGIQUE / COMPRIMÉS / 150MG	881	1145	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2078	3822	GATISTAR	GATIFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 0.003	2227	2895	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2079	3824	HYDROSOL POLYVITAMINE	VIT E, PP, A, B1,B2, B5, B6, C,D	SUPPLEMENT VITAMINIQUE / Millilitre (s) / PM	927	1205	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2080	3825	IMOX	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	1058	1375	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2081	3826	INIGAST	ESOMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	6181	8035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2082	3828	INTRALGINE	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / AMPOULE / 1000MG	1335	1735	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2083	3829	IOPROST	LATANOPROST	ANTI-GLAUCOMATEUX / MILLILITRES / 0.00005	8081	10505	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2084	3830	LARIDOX	SULFADOXINE+PYRIMETHAMINE	ANTIPALUDIQUE / COMPRIMÉS / 500MG/25MG	223	290	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2085	3831	LARITEM	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / Unite (s) / 20MG/120MG	450	585	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2086	3833	LARITHER	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 40MG	412	535	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2087	3835	LEVO DENK	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	4415	5740	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2088	3837	LEVOBACT	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 250MG	4035	5245	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2089	3840	METAGARD	TRIMETAZIDINE	ANTI-ANGOREUX / COMPRIMÉS / 35MG	1658	2155	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2090	3841	NEMOZOLE	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	304	395	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2091	3842	NEWFLEX WARM UP	DERIVES DE PLANTES	ANTI-INFLAMMATOIRE / ANTALGIQUE / Gramme (s) / PM	2508	3260	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2092	3843	NIZODERM	KETOCONAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.02	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2093	3844	ORCHAPRED	PREDNISOLONE PHOSPHATE	ANTI-ALLERGIQUE TOPIQUE / GRAMMES / 0.005	2154	2800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2094	3845	ORCHAZID	KETOTIFENE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE OPHTALMIQUE / MILLILITRES / 0.00025	2154	2800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2095	3846	OVAZOL	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	1146	1490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2096	3847	OZOLAMIDE	DORZOLAMIDE	ANTI-GLAUCOMATEUX / MILLILITRES / 0.02	4442	5775	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2097	3848	PALMATHER	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 40MG	312	405	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2098	3850	PANADOL FEMINA	PARACETAMOL+BUTYLBROMURE DE HYOSCINE	ANTALGIQUE / ANTISPASMODIQUE / Gramme (s) / 500 MG / 10 MG	1165	1515	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2099	3851	PANADOL RHUME-GRIPPE	PARACETAMOL+PHENYLEPHRINE+CAFEINE	ETAT GRIPPAL / Gramme (s) / 500 MG / 5 MG / 25 MG	1165	1515	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2100	3852	PANTO DENK	PANTOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	3654	4750	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2101	3854	POLYFRESH 0.20%	HYALURONATE DE SODIUM	LUBRIFIANT OCULAIRE / Millilitre (s) / 0,2%	2692	3500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2102	3856	POVI BD	POVIDONE IODEE	ANTI-SEPTIQUE LOCAL / MILLILITRES / PM	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2103	3857	RAPICLAV	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Gramme (s) / 875 MG / 125 MG	3750	4875	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2104	3858	REGULIX	DROTAVERINE	ANTI-SPASMODIQUE / COMPRIMÉS / 40MG	708	920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2105	3860	RHINEX SIROP	CHLORPHENAMINE + PSEUDOEPHEDRINE + PARACETAMOL	ETAT GRIPPAL / Millilitre (s) / PM	912	1185	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2106	3861	SALIFEN	DICLOFENAC+ SALICYLATE DE METHYLE+MENTHOL	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 0.01	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2107	3862	SENSITELIAL	KARITE, JOJOBAVASELINE, CIRE D'ABEILLE, HUILE DE NOYAU D'ABRICOT, GLYCERINE, LACTATE DE SODIUM	ANTI-ALLERGIQUE / PSORIASIS / Millilitre (s) / PM	4412	5735	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2108	3864	SEZOL	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2109	3867	STERICEF	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE / Gramme (s) / 250 MG	754	980	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2110	3870	STRATENE	METRONIDAZOLE+SPIRAMYCINE	ANTIBIOTIQUE / Gramme (s) / 250 MG / 1,5 UI	3208	4170	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2111	3871	STRIMOL EXTRA	PARACETAMOL + CAFEINE	ANTALGIQUE / ANTIPYRETIQUE / Gramme (s) / PM	173	225	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2112	3873	TRAMADOL DENK	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / Unite (s) / 50MG	1854	2410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2113	3874	TRIGOPAX	CICLOPIROXOLAMINE+PHYTOSTEROL	ANTIFONGIQUE / ANTI-INFLAMMATOIRE / Millilitre (s) / PM	4692	6100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2114	3875	TWINZOL	DORZOLAMIDE+TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 2%/0.5%	6058	7875	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2115	3876	UNISPIRA	SPIRAMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 3MUI	2296	2985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2116	3877	VEGEBOM BAUME 45	EXTRAITS DE PLANTES	ANTALGIQUE / Gramme (s) / PM	1192	1550	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2117	3878	VEGEBOM	EXTRAITS DE PLANTES	ANTALGIQUE / Millilitre (s) / PM	1323	1720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2118	3879	VEGEBOM BAUME 100	EXTRAITS DE PLANTES	ANTALGIQUE / Gramme (s) / PM	2119	2755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2119	3880	ZERODOL-P	ACECLOFENAC + PARACETAMOL	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 100 MG / 500 MG	2423	3150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2120	3881	ZERODOL LP	ACECLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 200MG	2735	3555	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2121	3882	ZITRAM	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / AMPOULE / 100MG/2ML	519	675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2122	3883	ZITRAM SR 100	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / COMPRIMÉS / 100MG	1862	2420	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2123	3884	ZITRAM SR 200	TRAMADOL HYDROCHLORIDE	ANALGESIQUE NON MORPHINIQUE / Gramme (s) / 200 MG	3650	4745	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2124	3885	BIOFAR FER+ACIDE FOLIQUE	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 14MG/200MCG	2031	2640	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2125	3886	BIOFAR MAGNESUIN COMPLEXE VIT B	MAGNESIUM + VIT B1, B2,B6, B12	CARENCE MAGNESIQUE + NEUROPATHIES / Gramme (s) / PM	2038	2650	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2126	3887	BIOFAR CALCIUM MAGNESIUM	CALCIUM + MAGNESIUM	CARENCE CALCIQUE ET MAGNESIQUE / Gramme (s) / PM	2335	3035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2127	3888	HYALGAN	HYALURONATE DE SODIUM	ANTI-RHUMATISMAL / AMPOULE / 20MG/2ML	22308	29000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2128	3889	DYNAPAR AQ INJ VRAC	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / AMPOULE / 75MG	488	635	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2129	3890	IPPROTON INJ VRAC	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / AMPOULE / 40MG	2562	3330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2130	3891	LOXEN INJ VRAC	NICARDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / AMPOULE / 10MG	1212	1575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2131	3892	MIOREL INJ VRAC	THIOCOLCHICOSIDE	MYORELAXANT / AMPOULE / 4MG/2ML	173	225	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2132	3893	NOZINAN INJ VRAC	LEVOMEPROMAZINE	NEUROLEPTIQUE / AMPOULE / 25MG/ML	262	340	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2133	3894	RIVOTRIL INJ VRAC	CLONAZEPAM	ANXIOLYTIQUE/HYPNOTIQUE / AMPOULE / 1MG/ML	519	675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2134	3895	R-LUME INJ VRAC	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 80MG	385	500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2135	3896	SALBUMOL ING VRAC	SALBUTAMOL	ANTI-ASTHMATIQUE/UTERO RELAXANT / Gramme (s) / 0,5 MG / 1ML	200	260	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2136	3897	SOMAZINA INJ VRAC	CITICOLINA	ANTI-ISCHEMIQUE / Gramme (s) / 500 MG	2423	3150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2137	3899	SPASFON INJ VRAC	PHLOROGLUCINOL+TRIMETHYLPHLOROGLUCINOL	ANTI-SPASMODIQUE / AMPOULE / 40MG/0.04MG	319	415	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2138	3900	SPASMO-APOTEL INJ VRAC	PARACETAMOL+BUTYLBROMURE DE HYOSCINE	ANTALGIQUE / ANTISPASMODIQUE / Gramme (s) / 600 MG / 20 MG	773	1005	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2139	3902	TAGAMET INJ VRAC	CIMETIDINE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / Gramme (s) / 200 MG	346	450	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2140	3903	TANGANIL INJ VRAC	ACETYL LEUCINE	ANTI-VERTIGINEUX/DEFICIT NEUROSENSORIEL / AMPOULE / 500MG	315	410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2141	3904	TIAPRIDAL INJ VRAC	TIAPRIDE	ANTI-PSYCHOTIQUE / AMPOULE / 100MG	242	315	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2142	3905	TRAMACLASS INJ VRAC	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / AMPOULE / 100MG/2ML	446	580	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2143	3906	TRIAM-DENK INJ VRAC	TRIAMCINOLONE	CORTICOIDE / AMPOULE / 40MG	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2144	3907	WINPAIN INJ VRAC	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / AMPOULE / 100MG/2ML	104	135	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2145	3908	ADRENALINE INJ VRAC	ADRENALINE	SYMPATHOMIMETIQUE / AMPOULE / 1MG	646	840	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2146	3909	ACUPAN INJ VRAC	NEFOPAM	ANALGESIQUE NON MORPHINIQUE / AMPOULE / 20MG	423	550	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2147	3910	ALPHACHYMOTRIPSINE INJ VRAC	CHYMOTRYPSINE	ANTI-INFLAMMATOIRE ENZYMATIQUE / Gramme (s) / 5 MG	388	505	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2148	3911	ANAFRANIL INJ VRAC	CLOMIPRAMINE	ANTI-DEPRESSEUR / AMPOULE / 25MG	277	360	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2149	3912	APOTEL INJ VRAC	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 1000MG	777	1010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2150	3913	APOTEL PLUS INJ VRAC	PARACETAMOL + LIDOCAÏNE	ANTALGIQUE / ANTIPYRETIQUE / Gramme (s) / 600 MG / 20 MG	777	1010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2151	3914	ARTANE INJ VRAC	TRIHEXYPHENIDYLE	ANTI-PARKINSONIEN/ANTI-CHOLINERGIQUE / AMPOULE / 10MG	712	925	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2152	3915	ATARAX INJ VRAC	HYDROXYZINE	ANXIOLYTIQUE/HYPNOTIQUE / AMPOULE / 100MG/2ML	385	500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2153	3916	BECOX INJ VRAC	VIT B COMPLEXE	SUPPLEMENT VITAMINIQUE / Gramme (s) / PM	131	170	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2154	3917	DIGOXINE NATIVELLE VRAC	DIGOXINE	CARDIOTONIQUES / AMPOULE / 0.5MG	950	1235	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2155	3918	DISLEP INJ VRAC	LEVOSULPIRIDE	ANTI-EMETIQUE / AMPOULE / 25MG	677	880	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2156	3919	DOLOSAL INJ VRAC	PETHIDINE	ANALGESIQUE MORPHINIQUE / AMPOULE / 100MG	315	410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2157	3920	MORPHINE 10MG	MORPHINE	ANALGESIQUE MORPHINIQUE / AMPOULE / 10MG	827	1075	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2158	3921	VITABION ING VRAC	VIT B1 + VIT B6 + VIT B12	ANALGESIQUE NON MORPHINIQUE / Gramme (s) / 100 MG / 100 MG / 1 MG	342	445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2159	3922	XELODA	CAPECITABINE	ANTICANCEREUX/ANaTIMETABOLITE / COMPRIMÉS / 500MG	307215	399380	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2160	3923	TAMOXIFENE BIOGARAN	TAMOXIFENE	ANTICANCEREUX/IMMUNOMODULATEUR ANTI-ANDROGENE / COMPRIMÉS / 20MG	7885	10250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2161	3964	METAPLATIN	OXALIPLATINE	ANTICANCEREUX/AGENT ALKYLANT / AMPOULE / 100MG	105577	137250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2162	3965	BLEOMYCINE	BLEOMYCINE	ANTICANCEREUX/ANTIBIOTIQUE CYTOTOXIQUE / AMPOULE / 15MG	33077	43000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2163	3966	ALKERAN	MELPHALAN	ANTICANCEREUX/AGENT ALKYLANT / COMPRIMÉS / 2MG	66923	87000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2164	3967	SANDIMMUN	CICLOSPORINE	ANTIMITOTIQUE / Unite (s) / 100 mg	171185	222540	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2165	3970	ALTRAFLAM	ACECLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 100MG	1615	2100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2166	3972	VOVNAC	ACECLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 100MG	2649	3444	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2167	4004	DECODERM TRI	ACETATE DE 21-FLUPREDNIDENE	ANTI-INFLAMMATOIRE/ANTI-MYCOSIQUE/ANTIBACTERIEN / Millilitre (s) / 1MG/20MG	1969	2560	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2168	4006	CLOPRINE	ACIDE ACETYLSALICYLIQUE+CLOPIDOGREL	ANTI-AGREGANT PLAQUETTAIRE / COMPRIMÉS / 150/75MG	3531	4590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2169	4007	JUVAMINE VIT C	ACIDE ASCORBIQUE	SUPPLEMENT MINERAL/COMPLEMENT VITAMINIQUE / Gramme (s) / 1000 MG	2777	3610	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2170	4009	VIKVIT	ACIDE ASCORBIQUE	COMPLEMENT VITAMINIQUE / Gramme (s) / 1000 MG	1327	1725	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2171	4010	CaC1000 ORANGE JUNIOR	ACIDE ASCORBIQUE + CALCIUM	VITAMINE ET SELS MINERAUX / Gramme (s) / 1000/1000 MG	1246	1620	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2172	4011	CaC1000 SANDOZ	ACIDE ASCORBIQUE + GLUCONATE DE CALCIUM	VITAMINE ET SELS MINERAUX / Gramme (s) / 1000/1000MG	1269	1650	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2173	4012	VERRUMAL	ACIDE SALICYLIQUE+DIMETHYSULFOXYDE+FLUOROURACILE	KERATOLYSE/ACTION ANTIVIRALE / Millilitre (s) / 10/8/0.5MG	2869	3730	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2174	4013	ASTYMIN	ACIDE AMINES + VITAMINES	NUTRITION PARENTERALE / Millilitre (s) / 110	1996	2595	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2175	4014	ASTYMIN FORTE	ACIDE AMINES + VITAMINES	NUTRITION PARENTERALE /  / 20	1942	2525	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2176	4015	ASTYMIN-C	ACIDES AMINES+VITAMINES+ACIDES ASCORBIQUE	NUTRITION PARENTERALE / Millilitre (s) / 1	927	1205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2177	4016	LILGRO-H	ADHATODA VASIKA+ALPINIA GALENGA+GLYCYRHIZA GLABRA+PIPER LONGUM	ANTITUSSIF / Millilitre (s) / 100	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2178	4017	VIALEBEX	ALBUMINE HUMAINE	MACROMOLECULE / Millilitre (s) / 200MG/ML	18677	24280	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2179	4019	OSTEON	ALENDRONATE	OSTEOPOROSE /  / 70 MG	22077	28700	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2180	4020	ALMAX	ALMAGATE	ANTI ACIDE/ PANSEMENT GASTRO INTESTINAL /  / 1G	2223	2890	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2181	4021	ALMAX FORTE	ALMAGATE	ANTI ACIDE/ PANSEMENT GASTRO INTESTINAL /  / 1.5G	2827	3675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2182	4022	SEKROL	AMBROXOL	FLUIDIFIANT BRONCHIQUE/EXPECTORANT / Millilitre (s) / 30MG/5ML	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2183	4024	EURYTHMIC	AMIODARONE	ANTI-ARYTHMIQUE / COMPRIMÉS / 200MG	5562	7230	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2184	4025	AMLONG	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	2019	2625	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2185	4027	AMLONOVA 10	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	1658	2155	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2186	4028	AMLONOVA 5	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	654	850	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2187	4029	AMLOSTAR PLUS	ATENOLOL+AMLODIPINE	ANTI-HYPERTENSEUR BETA-BLOQUANT/INHIBITEUR CALCIQUE / COMPRIMÉS / 50MG/5MG	6185	8040	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2188	4030	AMTOR	AMLODIPINE + ATORVASTATINE	ANTIHYPERTENSEUR INHIBITEUR CALCIQUE/HYPOLIPEMIANT /  / 5MG/10MG	5738	7460	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2189	4031	CORDISTAT	AMLODIPINE + ATORVASTATINE	ANTIHYPERTENSEUR INHIBITEUR CALCIQUE/HYPOLIPEMIANT /  / 5MG/10MG	3973	5165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2190	4032	RAASAR-AM	LOSARTAN+AMLODIPINE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG/50MG	5738	7460	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2191	4033	ALFAMOX	AMOXICILLINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES /  / 1G	2858	3715	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2192	4036	CIANMOX	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	462	600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2193	4041	BACTOCLAV	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINES / Gramme (s) / 875MG/125MG	4000	5200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2194	4044	KLAVMOX	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES /  / 875MG/125MG	3978	5172	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2195	4049	KOACT 156.25 MG	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Millilitre (s) / 125MG/31.25MG	2315	3010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2196	4050	KOACT 312.5 MG	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Millilitre (s) / 250MG/62.5MG	2827	3675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2197	4051	SOTAMOX	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000MG/200MG	1942	2525	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2198	4052	ARNEMAL	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 80MG	295	383	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2199	4053	TONTHER	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 80MG	368	478	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2200	4059	DANMETHER	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	2446	3180	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2201	4060	DANMETHER PDR	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / SACHETS / 20MG/120MG	812	1055	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2202	4061	DANMETHER PED	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / SACHETS / 20MG/120MG	2181	2835	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2203	4064	AVAS	ATORVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 10MG	4035	5245	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2204	4066	LOLIP	ATORVASTATINE	HYPOLIPEMIANT / COMPRIMÉS / 10MG	3665	4765	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2205	4068	ATORFIT PLUS	ATORVASTATINE+CLOPIDOGREL	HYPOLIPELIANT/ANTIAGREGANT PLAQUETTAIRE / COMPRIMÉS / 10MG/75MG	10596	13775	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2206	4070	AZIC	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	1769	2300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2207	4073	AZIPAR 250	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	2427	3155	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2208	4074	AZIPAR 500	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	2427	3155	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2209	4075	MACROMAX	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	3838	4990	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2210	4076	UNOZIT 250	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	2296	2985	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2211	4077	UNOZIT 500	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	2738	3560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2212	4079	ACTOVZN	AZITHROMYCINE+FLUCONAZOLE+SECNIDAZOLE	ANTIBIOTIQUE/ANTIFONGIQUE/ANTIPARASITAIRE /  / 4CP	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2213	4080	BETASTENE	BETAMETHASONE	CORTICOIDE / MILLILITRES / 0.0005	1919	2495	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2214	4081	BILAXTEN	BILASTINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 20MG	2754	3580	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2215	4082	BIBLOC	BISOPROLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 5MG	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2216	4084	EXICOF	BROMHEXINE+CHLORURE D'AMMONIUM+DIPHENYLAMINE+GUAIFENESINE+MENTHOL	ANTITUSSIF / Millilitre (s) / 4/100/8/50/1MG/5ML	692	900	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2217	4085	SPASMOMEN	BROMURE D'OTILONIUM	ANTI-SPASMODIQUE / COMPRIMÉS / 25MG	4238	5510	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2218	4086	EFFERCAL	CALCIUM + VITAMINE D3	CARENCE CALCIQUE /  / 500MG/125CG	1327	1725	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2219	4087	CARVEDI DENK	CARVEDILOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 6.25MG	3092	4020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2220	4090	POZINEG 1000	CEFEPIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES /  / 1000MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2221	4091	POZINEG 2000	CEFEPIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES /  / 2000MG	4619	6005	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2222	4092	GRAMOCEF-O	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / GELULE / 400MG	5385	7000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2223	4093	TAXIM-O	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 200MG	4362	5671	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2224	4094	TOCFIM	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 100MG/5ML	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2225	4095	TOCFIM 200	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 200MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2226	4096	SWICH 200MG	CEFPODOXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 200MG	4745	6168	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2227	4097	ARTXON	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2228	4098	CEFOCIAN-S	CEFTRIAXONE+SULBACTAM	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG/500MGIMIV	2288	2975	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2229	4099	CEFOCIAN	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1519	1975	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2230	4101	ONECEF	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1327	1725	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2231	4102	TRAXOL 1G	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	2154	2800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2232	4103	ONECEF+SB	CEFTRIAXONE+SULBACTAM	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG/500MGIMIV	2654	3450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2233	4104	AUROXETIL	CEFUROXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES /  / 500MG	5627	7315	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2234	4107	CELEBID	CELECOXIB	ANTI INFLAMMATOIRE (AINS) /  / 100MG	3496	4545	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2235	4108	PAMAGIN	CETIRIZINE+PHENYLEPHRINE+DEXTROMETORPHANE+ACETAMINOPHENE+ZINC+MENTHOL	ANTIHISTAMINIQUE/ANTI-ALLERGIQUE /  / 500/5/15/7.5MG	1588	2065	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2236	4110	ELUDRIL PRO	CHLORHEXIDINE+CHLOROBUTANOL	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.5G/50MG	1854	2410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2237	4112	TRONOTHANE	CHLORHYDRATE DE PRAMACAINE	ANESTHESIQUE DE SURFACE / Gramme (s) / 0.01	1900	2470	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2238	4113	CIDINE	CINITAPRIDE	PROKINETIQUE /  / 1MG	3312	4305	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2239	4114	CICIAN	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 250MG	500	650	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2240	4116	DANCIFLOX	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	1051	1366	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2241	4117	GUNCIPRO FORTE	CIPROFLOXACINE + TINIDAZOLE	ANTIBIOTIQUE QUINOLONES / ANTIPARASITAIRE /  / 500MG/600MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2242	4118	KILCIP	CIPROFLOXACINE + TINIDAZOLE	ANTIBIOTIQUE QUINOLONES / ANTIPARASITAIRE /  / 500MG/600MG	3538	4600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2243	4119	PROFIZ FORTE	CIPROFLOXACINE + TINIDAZOLE	ANTIBIOTIQUE QUINOLONES / ANTIPARASITAIRE /  / 500MG/600MG	3531	4590	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2244	4120	PLAEVZ	CITRATE DE SILDENAFIL	CARDIOTONIQUES /  / 50MG	3531	4590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2245	4121	JESPER-50	CLOMIFENE CITRATE	INDUCTEUR DE L'OVULATION /  / 50MG	2649	3444	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2246	4122	ARTEROPIRINE	CLOPIDOGREL	ANTI-AGREGANT PLAQUETTAIRE / COMPRIMÉS / 75MG	3312	4305	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2247	4124	CUIVRE OLIGOSOL	CUIVRE	ELEMENT MINERAL /  / AMPOULE BUVABLE	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2248	4125	OLIGOSOL (Cu,Or,Ag)	CUIVRE+OR+ARGENT	ELEMENT MINERAL/ANTI-ASTHENIQUE/ANTI-INFECTIEUX / Millilitre (s) / Solution buvable	1527	1985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2249	4126	ACTI 5	DEANOL PIDOLATE+MAGNESIUM+ACIDE ASCORBIQUE	DEFICIT EN MAGNESUIM /  / 100MG/416MG/225MG	2896	3765	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2250	4127	NEWFLEX GEL CHAUFFANT ET DELASSANT	DERIVES DE PLANTES	ANTI-INFLAMMATOIRE / ANTALGIQUE / Millilitre (s) / GEL	2538	3300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2251	4128	NEWFLEX GEL RAFRAICHISSANT INSTANTANE	DERIVES DE PLANTES	ANTI-INFLAMMATOIRE / ANTALGIQUE / Millilitre (s) / GEL	2538	3300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2252	4129	NEWFLEX WARM UP GEL	DERIVES DE PLANTES	ANTI-INFLAMMATOIRE / ANTALGIQUE / Millilitre (s) / GEL	2508	3260	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2253	4130	SAGADES	DESLORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 5MG	2692	3500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2254	4132	DICLO PHARMA 5	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	1577	2050	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2255	4134	DICLO PHARMA 5 INJ VRAC	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / AMPOULE / 75MG	320	416	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2256	4135	DICLOFENAC ID SANDOZ	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) /  / 75MG	650	845	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2257	4136	LYSOFLAM	DICLOFENAC+LINOFENIC ACID+MENTHOL+METHYL+SALICYLATE	ANTI-INFLAMMATOIRE (AINS) / ANTALGIQUE / Gramme (s) / GEL	3535	4595	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2258	4137	DICLO PCI	DICLOFENAC + PARACETAMOL	ANTI-INFLAMMATOIRE (AINS) / ANTALGIQUE /  / 50MG/325MG	615	800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2259	4139	PARAGESIC	DICLOFENAC + PARACETAMOL + CHLORZOXAZONE	ANTI-INFLAMMATOIRE (AINS) / ANTALGIQUE /  / 50/325/250MG	731	950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2260	4140	VOLINI	DICLOFENAC SODIQUE+HUILE DE LIN	ANTI-INFLAMMATOIRE (AINS) / Gramme (s) / 0.01	946	1230	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2261	4141	PANCI-D	PANTOPRAZOLE+DOMPERIDONE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 10MG/40MG	1462	1900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2262	4142	SPASMOTROY VRAC	DROTAVERINE	ANTI-SPASMODIQUE / AMPOULE / 40MG	177	230	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2263	4143	MARIMER ISOTONIQUE	EAU DE MER DILUEE ISOTONIQUE	DECONGESTIONNANT NASAL / MILLILITRES / 9G/L	2538	3300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2264	4144	MARIMER HYPERTONIQUE	EAU DE MER DILUEE HYPERTONIQUE	DECONGESTIONNANT NASAL / MILLILITRES / 22G/L	2769	3600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2265	4145	KESTINE	EBASTINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 20MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2266	4149	DICYNONE	ETAMSYLATE	HEMOSTATIQUE / GELULE / 500MG	3488	4535	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2267	4150	DICYNONE VRAC	ETAMSYLATE	HEMOSTATIQUE / AMPOULE / 250MGIMIV	431	560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2268	4151	ARCOXIA	ETORICOXIB	ANTI-INFLAMMATOIRE (AINS) /  / 60MG	6462	8400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2269	4156	HEPAZYME	EXTRAITS DE PLANTES : CAPRIER EPINEUX, CHICOREE SAUVAGE, TAMARIS, WHITE MARUDA	HEPATOPROTECTEUR, DRAINAGE HEPATIQUE /  / GELULE	919	1195	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2270	4157	HEPAFYT	EXTRAITS DE PLANTES+CHOLINE BITARTRATE+INOSITOL+LCYSTEINE+METHIONINE+SILYMARINE+VIT B12	HEPATOPROTECTEUR /  / 300/50/20/15/20/100MG/1.5CG	1327	1725	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2271	4158	EMERGYL	EXTRAITS DE 30 PLANTES MEDECINALES	IMMUNOSTIMULANT,ANTI-INFLAMMATOIRE,ANTIPYRETIQUE / Gramme (s) / 500G	8819	11465	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2272	4159	DERMOXEN FLOREXIL	EXTRAITS DE PLANTES	ANTISEPTIQUE / Millilitre (s) / SOLUTION LOCALE	2285	2970	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2273	4160	DAFENAC VRAC	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	281	365	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2274	4161	POWERGESIC VRAC	DICLOFENAC + PARACETAMOL + CHLORZOXAZONE	ANTI-INFLAMMATOIRE (AINS) / ANTIPYRETIQUE /  / 50MG/500MG	846	1100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2275	4162	DERMOXEN PRONEEM	EXTRAITS DE PLANTES	ANTISEPTIQUE / Millilitre (s) / 200ML	3269	4250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2276	4164	DERMOXEN SKIN PROTECTION 	EXTRAITS DE PLANTES	ANTISEPTIQUE / Millilitre (s) / 140ML	3835	4985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2277	4165	DERMOXEN VITEXYL	EXTRAITS DE PLANTES	ANTISEPTIQUE / Millilitre (s) / 140ML	6862	8920	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2278	4166	VENTESYL	EXTRAITS DE PLANTES	MUCOLYTIQUE,ANTIHISTAMINIQUE,ANTIINFECTIEUX / Millilitre (s) / 100ML	1338	1740	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2279	4167	FACTANE	FACTEUR III HUMAIN DE LA COAGULATION	HEMOSTATIQUE / Millilitre (s) / 100UI/ML	88304	114795	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2280	4168	GYNOFER B12	FER+ACIDE FOLIQUE+ZINC+VITAMINE B12	ANTI-ANEMIQUE / Millilitre (s) / 150MG/1,5MG/61,8MG/15MCG	1427	1855	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2281	4170	RANFERON PLUS 	FER+ACIDE FOLIQUE+VITAMINE B12+VITAMINE C+ZINC	ANTI-ANEMIQUE /  / 305MG/1,125MG/10MG/112,5MG/5	2192	2850	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2282	4172	FIFER	FER+ACIDE FOLIQUE+VITAMINES	ANTI-ANEMIQUE / Millilitre (s) / 200ML	1546	2010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2283	4174	ERESTRID	FINASTERIDE	HYPERTROPHIE BENIGNE DE LA PROSTATE / COMPRIMÉS / 5MG	3092	4020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2284	4177	CANAFLUCAN	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	1919	2495	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2285	4178	FLUCIAN	FLUCONAZOLE	ANTI-FONGIQUE / COMPRIMÉS / 150MG	308	400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2286	4179	FLUCOMYC	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	238	310	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2287	4180	FLUCONA-DENK	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 100MG	1804	2345	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2288	4182	FLUGEN	FLUCONAZOLE	ANTI-FONGIQUE / COMPRIMÉS / 100MG	1273	1655	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2289	4184	CALMZ	FLUOXETINE	ANTI-DEPRESSEUR / GELULE / 20MG	4419	5745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2290	4185	OPHTACINE	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / MILLILITRES / 0.003	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2291	4186	OCUGUARD	GINKGO BILOBA+ZINC+NICOTINAMIDE+SELENIUM+VIT A,B12,C,E	VASCULOPROTECTEUR / VEINOTONIQUE /  / 40MG/13,5MG/10MG	2358	3065	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2292	4187	JUVAMINE GINSENG TONUS	GINSENG+MATE+GUARANA	SUPPLEMENT MINERAL/COMPLEMENT VITAMINIQUE /  / 56/67/130	4104	5335	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2293	4188	JUVAMINE GINSENG TAURINE	GINSENG+TAURINE+VITC+CAFEINE+GUARANA	SUPPLEMENT MINERAL/COMPLEMENT VITAMINIQUE /  / 130/200/120/100	3204	4165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2294	4189	GLIM FORTE	GLICLAZIDE+METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 80MG/800MG	4154	5400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2295	4190	ADRIDE 2	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 2MG	2915	3790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2296	4191	ADRIDE 4	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 4MG	4685	6090	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2297	4192	DIAPRIDE	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 2MG	2692	3500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2298	4194	ADRIDE-M	GLIMEPIRIDE+METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 500MG	2915	3790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2299	4195	AMARYL M SR	GLIBENCLAMIDE+METFORMINE (CHLOLHYDRATE)	ANTI-DIABETIQUE / COMPRIMÉS / 2MG/500MG	4362	5670	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2300	4196	GRAMY-AE	GRANISETRON	ANTI-EMETIQUE SPECIFIQUE / Millilitre (s) / 1MG/ML	4419	5745	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2301	4197	GUDOO	HUILEDE HATAPUSHPA+DE MENTHE+DE SOWA+SARJIKAKSHARA	ANTITUSSIF / Millilitre (s) / 120ML	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2302	4198	ANFEN	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	79	103	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2303	4200	RUFEN VARC	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	138	180	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2304	4202	GENFORTE	IBUPROFENE+PARACETAMOL	ANTI-INFLAMMATOIRE (AINS)/ANALGESIQUE / COMPRIMÉS / 400MG/500MG	619	805	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2305	4203	KILMOL	IBUPROFENE+PARACETAMOL	ANTI-INFLAMMATOIRE (AINS)/ANALGESIQUE / COMPRIMÉS / 400MG/325MG	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2306	4204	TEGELINE	IMMUNOGLOBULINE HUMAINE DE TYPE G INTACTE	DEFICITS IMMUNITAIRES/IMMUNOMODULATEUR / Millilitre (s) / 50MG/ML	140023	182030	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2307	4206	IMMUNOPLEX-N	INTERFERON ALPHA	IMMUNOSTIMULATEUR /  / 200UI	7869	10230	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2308	4207	KAZOL	KETOCONAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.02	1104	1435	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2309	4208	PROFENID IM	KETOPROFENE	ANTI-INFLAMMATOIRE (AINS) / AMPOULE / 100MG/2ML	1273	1655	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2310	4210	LINEX	LACTOBACILLUS	ANTIDIARRHEIQUE /  / 12 MILLIONS UFC	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2311	4211	OZAPRAL	LANSOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 30MG	4681	6085	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2312	4213	CEXOLAN	LATANOPROST	ANTI-GLAUCOMATEUX / MILLILITRES / 0.00005	8469	11010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2313	4214	ALEVO 250	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 250MG	2296	2985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2314	4215	ALEVO 500	LEVOFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	2296	2985	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2315	4216	LISINOVA 10	LISINOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 10MG	1465	1905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2316	4217	LISINOVA 20	LISINOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 20MG	2435	3165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2317	4218	LISINOVA 5	LISINOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 5MG	1265	1645	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2318	4219	LORACTIV	LORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	662	860	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2319	4221	LORATADINE SANDOZ	LORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 10MG	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2320	4223	ANGIZAAR	LOSARTAN POTASSIQUE	ANTIHYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II /  / 25MG	3365	4375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2321	4225	COZAAR	LOSARTAN POTASSIQUE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II / COMPRIMÉS / 50MG	3531	4590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2322	4226	ANGIZAAR-H	LOSARTAN POTASSIQUE+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/12.5MG	5385	7000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2323	4227	HYZAAR	LOSARTAN POTASSIQUE+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/12.5MG	4035	5245	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2324	4228	RAASAR-H	LOSARTAN POTASSIQUE+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR ANTAGONISTE DE L'ANGIOTENSINE II/DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/12.5MG	3973	5165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2325	4230	JUVAMINE MAGNESIUM B6B2	MAGNESIUM+VIT B6+VITB2	SUPPLEMENT MINERAL/COMPLEMENT VITAMINIQUE /  / 300MG	3365	4375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2326	4231	OLIGOSOL MANGANESE	MANGANESE	ELEMENT MINERAL/ANTI-ALLERGIQUE /  / 14	1385	1800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2327	4233	NURONEM	MEROPENEME	ANTIBIOTIQUE BETA-LACTAMINE CARBAPENEME / AMPOULE / 1000MG	17500	22750	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2328	4234	ZAXTER	MEROPENEME	ANTIBIOTIQUE BETA-LACTAMINE CARBAPENEME / AMPOULE / 1000MG	16777	21810	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2329	4235	DIAFORMINE	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 500MG	708	920	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2330	4239	CARDOL-XL 100	METOPROLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 100MG	5738	7460	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2331	4240	CARDOL-XL 50	METOPROLOL	ANTIHYPERTENSEUR BETABLOQUANT /  / 50MG	3973	5165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2332	4241	MET-XL 50	METOPROLOL	ANTIHYPERTENSEUR BETABLOQUANT / COMPRIMES / 50MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2333	4242	MET XL	METOPROLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 100MG	3973	5165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2334	4243	OVUMIX	METRONIDAZOLE+NITRATEDE MICONAZOL+SULFATE DE NEOMYCINE+GOTU KOLA+SULFATE DE POLYMICINE	ANTIFONGIQUE/ANTIBACTERIEN/ANTIPARASITAIRE /  / 6	2223	2890	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2335	4244	9-VIT	MULTIVITAMINE	COMPLEMENT VITAMINIQUE /  / 1	1589	2066	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2336	4245	TEMERIT	NEBIVOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 5MG	6623	8610	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2337	4246	LOOBID	OFLOXACINE + ORNIDAZOLE	ANTIBIOTIQUE QUINOLONES / ANTIPARASITAIRE /  / 200MG/500MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2338	4248	ORNILOX	OFLOXACINE + ORNIDAZOLE	ANTIBIOTIQUE QUINOLONES / ANTIPARASITAIRE /  / 200MG/500MG	4038	5250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2339	4249	FORTALINE	OMEGA-3	ANTI-OXYDANT / Millilitre (s) / 1.6G	5381	6995	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2340	4251	MEGAZA	OMEGA-3	ANTI-OXYDANT /  / 1G	3181	4135	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2341	4253	SOLCER SR	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	3535	4595	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2342	4254	PIRSEC	OMEPRAZOL+BICARBONATE DE SODIUM	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON /  / 20MG/1100MG	5300	6890	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2343	4256	SETRONAX	ONDANSETRON	ANTI-EMETIQUE SPECIFIQUE / COMPRIMÉS / 4MG	8835	11485	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2344	4257	SETRONAX INJ VRAC	ONDANSETRON	ANTI-EMETIQUE SPECIFIQUE / AMPOULE / 8MG/4ML	4947	6431	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2345	4258	UPRAJECT	PANTOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / AMPOULE / 40MG/10ML	2377	3090	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2346	4260	EFFERALGAN TAB	PARACETAMOL	ANTALGIQUE / ANTIPYRETIQUE /  / 1G	812	1055	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2347	4261	FEVASTIN	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 1000MG	1104	1435	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2348	4262	NESTEFFER	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 120MG/5ML	1281	1665	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2349	4263	NESTEFFER 1000	PARACETAMOL	ANTALGIQUE / ANTIPYRETIQUE /  / 1000MG	842	1095	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2350	4264	NESTEFFER 500	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	796	1035	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2351	4265	TRYPTIMOL	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 250MG/5ML	450	585	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2352	4267	ULTRAMOL VRAC	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	87	113	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2353	4268	ANAPAIN EXTRA	PARACETAMOL + CAFEINE	ANTALGIQUE / ANTIPYRETIQUE /  / 500MG/30MG	167	217	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2354	4269	DOLIMEX MIGRAINE	PARACETAMOL + CAFEINE	ANTALGIQUE / ANTIPYRETIQUE /  / 500MG/50MG	1677	2180	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2355	4271	DOLIPRANE VITAMINE C	PARACETAMOL + VITAMINE C	ETAT GRIPPAL /  / 500MG/150MG	927	1205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2356	4272	DOLOSPAM	PARACETAMOL+BUTYLBROMURE DE HYOSCINE	ANTALGIQUE / ANTISPASMODIQUE /  / 500MG/10MG	1127	1465	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2357	4273	TRACEDOL	PARACETAMOL + TRAMADOL	ANTALGIQUE / ANALGESIQUE NON MORPHINIQUE /  / 325/37.5	2038	2650	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2358	4274	TRAMACEL-P	PARACETAMOL + TRAMADOL	ANTALGIQUE / ANALGESIQUE NON MORPHINIQUE /  / 325/50	1154	1500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2359	4276	SPASLESS	PHLOROGLUCINOL+TRIMETHYLPHLOROGLUCINOL	ANTI-SPASMODIQUE / SUPPOSITOIRE / 150MG/150MG	1458	1895	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2360	4278	SPASLESS INJ VRAC	PHLOROGLUCINOL+TRIMETHYLPHLOROGLUCINOL	ANTI-SPASMODIQUE / AMPOULE / 40MG/0.03MG	312	406	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2361	4279	GENES VIT JUNIOR	PHOSPHORE, MAGNESIUM, ZINC, FER, MANGANESE, CUIVRE, MOLYBDENE, VIT B COMPLEX, VIT C, VIT D3, VIT	POUSSEE DE CROISSANCE /  / 10	1923	2500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2362	4280	CEBROTONIN	PIRACETAM	PSYCHOSTIMULANT/NOOTROPIQUE /  / 800MG	2854	3710	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2363	4281	CARTISAFE FORTE	POTASSIUM SULFATE DE GLUCOSAMINE+CARBONATE DE CALCIUM+METHYL SULPHONYLMETHANE+VITAMINE D3	ANTIARTHROSIQUE+ANTIOSTEOPOROSIQUE /  / 750MG/250MG/200MG/125UI	4827	6275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2364	4282	BIOFAR POTASSIUM MAGNESIUM	POTASSIUM+MAGNESIUM+VITAMINE B1, B2, B6, B12	SUPPLEMENT MINERAL/COMPLEMENT VITAMINIQUE /  / 20	2092	2720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2365	4283	APROGEST	PROGESTERONE	OESTRO-PROGESTATIF / COMPRIMÉS / 200MG	2825	3673	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2366	4285	RASGIL 1.25	RAMIPRIL	ANTI-HYPERTENSEUR I.E.C. / GELULE / 1.25MG	2869	3730	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2367	4286	RASGIL 10	RAMIPRIL	ANTI-HYPERTENSEUR I.E.C. / GELULE / 10MG	4768	6198	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2368	4287	RASGIL 2.5	RAMIPRIL	ANTI-HYPERTENSEUR I.E.C. / GELULE / 2.5MG	3311	4304	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2369	4288	RASGIL 5	RAMIPRIL	ANTI-HYPERTENSEUR I.E.C. / GELULE / 5MG	3973	5165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2370	4289	RASGIL HTZ	RAMIPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 5MG/12.5MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2371	4293	OLIGOSOL SELENIUM	SELENIUM	ELEMENT MINERAL /  / 28	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2372	4294	GENES VIT  PLUS	SELENIUM, RUNTINE, MANGANESE, MAGNESIUM, CALCIUM, VIT A, VIT DU COMPLEXE B, VIT C, VIT E, ZINC	ANTIOXYDANT, VIEILLISSEMENT CUTANE, ASTHENIE SEXUELLE, VEINO-PROTECTEUR, ANTI-STRESS /  / 12	2615	3400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2373	4295	GENES VIT GROSSESSE	SELENIUM, ZINC, CUIVRE, MANGANESE, FER, PHOSPHORE, MAGNESIUM, CALCIUM, VIT A, VIT DU COMPLEXE B, VIT C, VIT D3, VIT E	COMPLEXE POLYORTANINE ET MINERAL DURANT LA GROSSESSE ET L’ALLAITEMENT /  / 12	2769	3600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2374	4296	DYNAPROST	SERENOA SERRULATA	HYPERTROPHIE BENIGNE PROSTATE /  / 1600MG	4865	6325	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2375	4297	SIMEPAR	SILYMARIN+NICOTINAMIDE+CALCIUM+VIT (B1+B2+B6+B12)	HEPATOPROTECTEUR /  / 20	3354	4360	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2376	4298	FLATORIL	SIMETICONE+CLEBOPRIDE	PROKINETIQUE+ANTIFLATULENT /  / 200/0.5MG	3092	4020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2377	4299	PAPOFFER	SIMETICONE+DIATASE FONGIQUE+PAPAÏNE	PROKINETIQUE+ANTIFLATULENT /  / 200/60/20 MG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2378	4300	SOTALEX	SOTALOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 80MG	2192	2850	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2379	4301	SPINOX	SPIRONOLACTONE	ANTI-HYPERTENSEUR DIURETIQUE EPARGNEUR POTASSIQUE / COMPRIMÉS / 50MG	3973	5165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2380	4303	BURNCOOL	SULFADIAZINE ARGENTIQUE+CHLORHEXIDINE	AFFECTION DERMIQUE/ANTIBIOTIQUE SULFAMIDE TOPIQUE+ANTISEPTIQUE LOCAL / GRAMMES / 1%/0.20%	1766	2296	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2381	4304	CURAPEL	SULFADIAZINE + CHITOSANE	ANTIBIOTIQUE SULFAMIDES+CICATRISANT / Gramme (s) / 300/600MG	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2382	4308	TRICOZ	TRIMETAZIDINE	ANTI-ANGOREUX / COMPRIMÉS / 35MG	3973	5165	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2383	4310	HYDROSOL POLYVITAMINE EUROLAB	VIT E,PP,A,B1,B2,B6,C,D3	SUPPLEMENT VITAMINIQUE / Millilitre (s) / 30	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2384	4311	BIOFAR VIT C	VITAMINE C NATURELLE	COMPLEMENT VITAMINIQUE /  / 20	2092	2720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2385	4312	BIOFAR VIT ACE SE-ZN	VITAMINE A,C,E,B9,B6+SELENIUM+ZINC	SUPPLEMENT MINERAL/COMPLEMENT VITAMINIQUE /  / 20	1912	2485	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2386	4314	OLIGOSOL ZINC	ZINC	ELEMENT MINERAL/ANTIDIARRHEIQUE /  / 14	1385	1800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2387	4315	BIOFAR ZINC ORGANIQUE	ZINC ORGANIQUE+VITAMINE C NATURELLE	SUPPLEMENT MINERAL/COMPLEMENT VITAMINIQUE /  / 20	2658	3455	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2388	4316	ZINC-NICKEL-COBALTOLIGOSOL	ZINC  NICKEL COBALT	ELEMENT MINERAL /  / 28	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2389	4317	JUVAMINE COLD 22	11 ELEMENTS MINERAUX+11VITAMINES	SUPPLEMENT MINERAL/COMPLEMENT VITAMINIQUE /  / 30	4592	5970	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2390	4318	BIOFAR MULTIVITAMINE 12 FLAVONOÏDE	12 VITAMINES	COMPLEMENT VITAMINIQUE /  / 20	2100	2730	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2391	4319	BIOFAR MULTIVITAMINE MINERAUX	12 VITAMINES + 12 MINERAUX	SUPPLEMENT MINERAL/COMPLEMENT VITAMINIQUE /  / 20	2704	3515	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2392	4320	BIOFAR MULTIVITAMINE KIDS	12 VITAMINES+IODE+CALCIUM	COMPLEMENT VITAMINIQUE /  / 20	2062	2680	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2393	4321	EURONAC	ACETYLCYSTEINE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.05	2358	3065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2394	4322	DEPTRIN	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDES /  / 480MG	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2395	4323	FLOTRAL	ALFUZOSINE	HYPERTROPHIE BENIGNE DE LA PROSTATE / COMPRIMÉS / 10MG	4177	5430	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2396	4324	NEOTHAZONE	BETAMETHASONE+ NEOMYCINE	DERMOCORTICOIDE ASSOCIE / Millilitre (s) / 00.033MG	973	1265	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2397	4325	ESMERON	BROMURE DE ROCURONIUM	ANESTHESIQUES GENERAUX / AMPOULE / 50MG/5ML	3428	4456	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2398	4326	DRENOXOL	CHLORHYDATE D'AMBROXOL	MUCOLYIQUE / Millilitre (s) / 30MG/10ML	1988	2585	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2399	4328	VAGIMILT	CLINDAMYCINE + CLOTRIMAZOLE	ANTIBACTERIEN/ANTIFONGIQUE /  / 100MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2400	4329	DUOSKIN	DIFLUCORTOLONE+ISOCONAZOLE	DERMOCORTICOIDE/ANTIFONGIQUE LOCAL / Gramme (s) / 1/10MG	3092	4020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2401	4330	FLURIFEN	FLURBIPROFENE	ANTI-INFLAMMATOIRE (AINS) /  / 100MG	2104	2735	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2402	4331	TIENAM	IMIPENEME+CILASTATINE	ANTIBIOTIQUE BETA-LACTAMINE CARBAPENEME / AMPOULE / 500MG/500MGIV	7946	10330	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2403	4332	CORALAN VRAC	IVABRADINE	ANTI-ANGOREUX / COMPRIMÉS / 5MG	3891	5058	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2404	4334	JANUMET VRAC	SITAGLIPTINE+METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 50/850MG	3154	4100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2405	4336	CEFTRI	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2406	4337	CLAVIMOX	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000MG/200MG	1323	1720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2407	4342	ASOMEX VRAC	AMLODIPINE	ANTIHYPERTENSEUR INHIBITEUR CALCIQUE /  / 2.5MG	1413	1837	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2408	4344	AMLO-DENK VRAC	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	1165	1515	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2409	4346	FIXOCARD VRAC	ATENOLOL+AMLODIPINE	ANTI-HYPERTENSEUR BETA-BLOQUANT/INHIBITEUR CALCIQUE / COMPRIMÉS / 50MG/5MG	509	662	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2410	4347	AMOXYN VRAC	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	331	430	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2411	4349	TENSOPREL VRAC	CAPTOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 25MG	1213	1577	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2412	4350	CAPTOPRIL TM VRAC	CAPTOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 25MG	677	880	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2413	4351	CAPTOPRIL DENK VRAC	CAPTOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 25MG	550	715	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2414	4352	CAPTOHEXAL VRAC	CAPTOPRIL+HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / COMPRIMÉS / 50MG/25MG	525	682	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2415	4353	TEGRETOL VRAC	CARBAMAZEPINE	ANTI-EPILEPTIQUE / COMPRIMÉS / 200MG	781	1015	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2416	4354	LARGACTIL VRAC	CHLORPROMAZINE	NEUROLEPTIQUE / AMPOULE / 25MG/5ML	604	785	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2417	4355	TRANXENE 50 VRAC	CLORAZEPATE	ANXIOLYTIQUE/HYPNOTIQUE / AMPOULE / 50MG	2798	3638	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2418	4356	FERMED VRAC	COMPLEXE D'HYDROXYDE FERRIQUE-SACCHAROSE	CARENCE MINERALE /  / 100MG	3031	3940	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2419	4357	POLARAMINE VRAC	DEXCHLORPHENIRAMINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / AMPOULE / 5MG	256	333	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2420	4358	DICLIN VRAC	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / AMPOULE / 75MG	214	278	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2421	4359	RYTHMODAN VRAC	DISOPYRAMIDE	ANTI-ARYTHMIQUE /  / 100MG	2708	3521	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2422	4360	IVEFERAN VRAC	FER SUCROSE	ANTI-ANEMIQUE /  / 100MG/5ML	3179	4133	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2423	4361	MODECATE VRAC	FLUPHENAZINE	NEUROLEPTIQUE / AMPOULE / 25MG/ML	1404	1825	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2424	4362	DAONIL VRAC	GLIBENCLAMIDE	ANTI-DIABETIQUE / COMPRIMÉS / 5MG	535	695	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2425	4363	HEMI-DAONIL VRAC	GLIBENCLAMIDE	ANTI-DIABETIQUE / COMPRIMÉS / 2.5MG	845	1098	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2426	4364	GLIBENCLAMIDE TM VRAC	GLIBENCLAMIDE	ANTI-DIABETIQUE / COMPRIMÉS / 5MG	152	198	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2427	4365	GLIBOMET VRAC	GLIBENCLAMIDE+METFORMINE (CHLOLHYDRATE)	ANTI-DIABETIQUE / COMPRIMÉS / 2.5MG/400MG	1092	1420	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2428	4366	DIAMICRON LM VRAC	GLICLAZIDE	ANTI-DIABETIQUE / COMPRIMÉS / 30MG	2199	2859	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2429	4367	HALDOL VRAC	HALOPERIDOL	NEUROLEPTIQUE / AMPOULE / 5MG/ML	165	214	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2430	4369	RISORDAN VRAC	ISORBIDE DINITRATE	ANTI-ANGOREUX / COMPRIMÉS / 20MG	957	1244	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2431	4370	ZADITEN VRAC	KETOTIFENE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / GELULE / 1MG	985	1280	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2432	4371	MODOPAR 125 VRAC	LEVODOPA+BENSERAZIDE	ANTI-PARKINSONIEN / GELULE / 100MG/25MG	1019	1325	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2433	4372	MODOPAR 250 VRAC	LEVODOPA+BENSERAZIDE	ANTI-PARKINSONIEN / GELULE / 200MG/50MG	1291	1678	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2434	4373	GLUCOPHAGE VRAC	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 850MG	701	911	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2435	4374	DIMET VRAC	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 500MG	637	828	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2436	4376	AUROMETFORMIN 850 VRAC	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 850MG	339	441	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2437	4377	AUROMETFORMIN 1000 VRAC	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 1000MG	475	618	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2438	4378	LOXEN VRAC	NICARDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 50MG	1787	2323	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2439	4379	NIFETAB-RETARD VRAC	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 20MG	369	480	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2440	4380	NIFEDIPINE TM VRAC	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 20MG	283	368	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2441	4381	VITOCIN VRAC	OXYTOCINE	UTEROTONIQUE / AMPOULE / 5UI/1ML	181	235	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2442	4382	DELIVREX VRAC	OXYTOCINE	UTEROTONIQUE / AMPOULE / 5UI/1ML	159	207	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2443	4383	PARAFIZZ VRAC	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	397	516	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2444	4384	GARDENAL VRAC	PHENOBARBITAL	ANTI-EPILEPTIQUE / COMPRIMÉS / 10MG	269	350	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2445	4385	DI-HYDAN VRAC	PHENYTOINE	ANTI-EPILEPTIQUE / COMPRIMÉS / 100MG	433	563	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2446	4386	VITAMINE K1 ROCHE VRAC	PHYTOMENADIONE	HEMOSTATIQUE / AMPOULE / 10MG	745	968	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2447	4387	PHENERGAN VRAC	PROMETHAZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / AMPOULE / 0.025	346	450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2448	4388	AVLOCARDYL VRAC	PROPANOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 40MG	937	1218	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2449	4389	NEULEPTIL VRAC	PROPERICIAZINE	ANTI-PSYCHOTIQUE / COMPRIMÉS / 25MG	630	819	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2450	4390	AZANTAC VRAC	RANITIDINE	ANTI-ULCEREUX/ANTI-HISTAMINIQUE H2 / AMPOULE / 50MG	593	771	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2451	4391	BRONCORON VRAC	SALBUTAMOL	ANTI-ASTHMATIQUE / COMPRIMÉS / 2MG	442	574	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2452	4392	COTRIMOXAZOLE TM VRAC	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / COMPRIMÉS / 400MG/80MG	102	132	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2453	4393	DOGMATIL VRAC	SULPIRIDE	NEUROLEPTIQUE / AMPOULE / 100MG	254	330	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2454	4394	BRICANYL VRAC	TERBUTALINE	ANTI-ASTHMATIQUE / AMPOULE / 0.5MG/ML	202	263	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2455	4395	CHILRAL VRAC	THEOPHYLLINE+ EPHEDRINE+ PHENOBARBITAL	ANTI-ASTHMATIQUE /  / 120MG/24MG/8MG	395	514	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2456	4396	DEPAKINE 200 VRAC	VALPROATE DE SODIUM	ANTI-EPILEPTIQUE / COMPRIMÉS / 200MG	528	686	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2457	4397	DEPAKINE 500 VRAC	VALPROATE DE SODIUM	ANTI-EPILEPTIQUE / COMPRIMÉS / 500MG	1314	1708	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2458	4401	PACLITAXEL	PACLITAXEL	ANTICANCEREUX/AGENT DU FUSEAU CYTOTOXIQUE / Unite (s) / 150 mg	24208	31470	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2459	4403	VELSO	VELPATASVIR+SOFOSBUVIR	ANTIVIRAL/HEPATITE C / COMPRIMÉS / 100MG/400MG	309058	401775	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2460	4404	LUPRODEX	LEUPROLIDE ACETATE	ANTICANCEREUX/IMMUNOMODULATEUR ANALOGUE DE LA GNRH / AMPOULE / 3,75MG	61769	80300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2461	4405	SSB 400MG	SOFOSBUVIR	ANTIVIRAL/HEPATITE C / COMPRIMÉS / 400MG	176615	229600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2462	4406	SOFOS 400MG	SOFOSBUVIR	ANTIVIRAL/HEPATITE C / COMPRIMÉS / 400MG	211738	275260	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2463	4407	DASVIR 60MG	DACLATASVIR	ANTIVIRAL/HEPATITE C / COMPRIMÉS / 60MG	88300	114790	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2464	4408	DAKASVIR 60MG	DACLATASVIR	ANTIVIRAL/HEPATITE C / COMPRIMÉS / 60MG	110385	143500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2465	4409	SOFOPAS	SOFOSBUVIR + LEDIPASVIR	ANTIVIRAL/HEPATITE C / COMPRIMÉS / 400MG/90MG	340000	442000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2466	4410	AB-ZOLE	ALBENDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 200MG	662	860	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2467	4412	ACUDROX	CEFADROXIL	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 250MG/5ML	977	1270	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2468	4413	ACUIGEN	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / MILLILITRES / 0.003	662	860	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2469	4414	ALBACT	OFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 200MG	2365	3075	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2470	4415	ALLOPURINOL SANDOZ	ALLOPURINOL	ANTI-GOUTTE / COMPRIMÉS / 300MG	5988	7785	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2471	4416	AMICOZ	MICONAZOLE	ANTI-FONGIQUE LOCAL / GRAMMES / 0.02	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2472	4417	AMILO	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	3877	5040	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2473	4419	AMLOTOME	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	173	225	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2474	4420	AMOXICILLINE	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 125MG/5ML	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2475	4423	ARTEERON	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 80MG	335	435	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2476	4424	ARTLUF FORTE	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 80MG/480MG	1942	2525	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2477	4425	AUROXONE	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1608	2090	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2478	4426	AVAZIR	TOBRAMYCINE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.003	1481	1925	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2479	4427	AZIFAIR	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	2138	2780	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2480	4429	AZIRON	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / MILLILITRES / 200MG/5ML	1635	2125	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2481	4432	AZIROX	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	2827	3675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2482	4433	BAXIM	CEFOTAXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1GIMIV	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2483	4434	BERLTHYROX	LEVOTHYROXINE	ANTI-THYROIDIEN / COMPRIMÉS / 100µG	2119	2755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2484	4436	CAPTENOL	ATENOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 100MG	1681	2185	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2485	4437	CEFEXOL	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 100MG/5ML	1546	2010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2486	4438	CEFICAP	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 100MG/5ML	3312	4305	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2487	4440	CEFTRI 500	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 500MGiv	1323	1720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2488	4441	CIPROCON	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 0.003	1235	1605	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2489	4442	CIPROFLOXACINE KABI	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 200MG	1988	2585	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2490	4444	CLANEKSI FORTE	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000MG/200MG	1308	1700	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2491	4445	CLAVUMOCCID	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 250MG/31.25MG	4458	5795	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2492	4446	CLAVUNOVA	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 500MG/100MG	819	1065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2493	4449	CO-AVAZIR	TOBRAMYCINE+DEXAMETHASONE	AFFECTION OPHTALMIQUE / MILLILITRES / 0.3%/0.1%	1212	1575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2494	4450	CORALAN	IVABRADINE	ANTI-ANGOREUX / COMPRIMÉS / 5MG	26492	34440	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2495	4451	COTRIMOXAZOLE	COTRIMOXAZOLE	ANTIBIOTIQUE SULFAMIDE / MILLILITRES / 240MG	973	1265	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2496	4455	DAFRAZOL IV	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / AMPOULE / 40MG	2473	3215	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2497	4456	DERZOL	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	2119	2755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2498	4458	DESLORA-DENK 5	DESLORATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 5MG	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2499	4459	DICLODEX	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / MILLILITRES / 0.001	1231	1600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2500	4460	DOLIMEX PERF	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 1000MG	1412	1835	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2501	4461	EFFERMOL	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 1000MG	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2502	4462	EQUIRAB	VIRUS ANTIRABIQUE INACTIVE	VACCIN/RAGE / DOSE / 1000UI	6708	8720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2503	4463	FAIRCEF	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1365	1775	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2504	4466	FAIRDIPIN	AMLODIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 5MG	246	320	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2505	4467	FAIRGLIB	GLIBENCLAMIDE	ANTI-DIABETIQUE / COMPRIMÉS / 5MG	438	570	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2506	4468	FAIRGLIM	GLIMEPIRIDE	ANTI-DIABETIQUE / COMPRIMÉS / 1MG	438	570	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2507	4470	FAIRMET	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 500MG	269	350	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2508	4473	FAIRPRIL	ENALAPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 5MG	431	560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2509	4474	FAIRZOL	FLUCONAZOLE	ANTI-FONGIQUE / COMPRIMÉS / 150MG	314	408	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2510	4475	FEDROX	CEFADROXIL	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 250MG/5ML	1965	2555	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2511	4476	FLOCIP	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	3223	4190	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2512	4477	FLUKOCIN	FLUCLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2513	4478	FLUOMAC	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	338	440	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2514	4479	FOSMOL	FOSFOMYCINE TROMETAMOL	ANTIBIOTIQUE DIVERS / SACHETS / 3G	3515	4570	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2515	4480	GANYMOL 125	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / SUPPOSITOIRE / 125MG	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2516	4481	GANYMOL 250	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / SUPPOSITOIRE / 250MG	973	1265	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2517	4482	GENCLAV	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / Unite (s) / 250MG/31.25MG	2208	2870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2518	4485	GLOSOL	TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.005	1308	1700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2519	4486	GLYCIRON	GLYCEROL	LAXATIF / SUPPOSITOIRE / 0	2650	3445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2520	4487	GYNO MYCOLEX	MICONAZOLE	ANTI-FONGIQUE LOCAL / COMPRIMÉS / 400MG	2212	2875	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2521	4488	IBUPROFENE	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / MILLILITRES / 100MG/5ML	1000	1300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2522	4489	IMMUNORHO	IMMUNOGLOBULINE ANTI D	SERUM/PREVENTION ALLO-IMMUNISATION FOETO-MATERNELLE / AMPOULE / 300µG	26227	34095	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2523	4490	ISOLONE	PREDNISOLONE	CORTICOIDE / COMPRIMÉS / 5MG	1554	2020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2524	4491	IVEPRAL	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / AMPOULE / 40MG	1592	2070	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2525	4492	JANUMET	SITAGLIPTINE+METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 50MG/850MG	22092	28720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2526	4494	KLAVMOX 1000/200	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000MG/200MG	1150	1495	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2527	4495	KLAVMOX 1,2G	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000MG/200MG	1150	1495	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2528	4496	LACOMA	LATANOPROST	ANTI-GLAUCOMATEUX / MILLILITRES / 0.00005	6623	8610	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2529	4497	LACOMA-T	LATANOPROST+TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 50µG/5MG	7508	9760	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2530	4498	LARINATE	ARTESUNATE	ANTIPALUDIQUE / AMPOULE / 60MG	1123	1460	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2531	4499	LARITH XL	CLARITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	3769	4900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2532	4500	LONOLOL	ATENOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 50MG	475	617	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2533	4501	LUFENART FORTE	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 80MG/480MG	1546	2010	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2534	4503	MEDOMOX	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 250MG/5ML	885	1150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2535	4504	MEDOXOM	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2536	4506	METRODEX	METRONIDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 125MG/5ML	1150	1495	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2537	4507	METRONIDAZOLE	METRONIDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 125MG/5ML	415	540	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2538	4508	METRONIDAZOLE BIOSEDRA	METRONIDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 500MG	708	920	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2539	4509	METROVEN	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2540	4511	MIZOLGAN	METAMIZOLE	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	796	1035	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2541	4512	MYCOLEX	MICONAZOLE	ANTI-FONGIQUE LOCAL / GRAMMES / 0.02	750	975	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2542	4513	NEODEX	NEOMYCINE+DEXAMETHASONE	AFFECTION OPHTALMIQUE / MILLILITRES / 350MUI/109,3MG	1188	1545	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2543	4515	NEUDOR	DORZOLAMIDE	ANTI-GLAUCOMATEUX / MILLILITRES / 0.02	3708	4820	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2544	4516	NORCINE 0,3%	NORFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 0.003	1608	2090	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2545	4517	NOURIC	ALLOPURINOL	ANTI-GOUTTE / COMPRIMÉS / 100MG	1327	1725	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2546	4518	NOVAMETHER 40 MG	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 40MG	1498	1948	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2547	4519	NOVAMETHER 80 MG	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 80MG	4254	5530	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2548	4520	NOVAZONE	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1731	2250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2549	4521	NOVEX	ENOXAPARINE	ANTI-THROMBOTIQUE / AMPOULE / 20MG	3442	4475	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2550	4525	NYSTAKIL	NYSTATINE	ANTI-FONGIQUE LOCAL / COMPRIMÉS / 100000UI	1077	1400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2551	4527	OFUSIDIC	ACIDE FUSIDIQUE	ANTIBIOTIQUE TOPIQUE / MILLILITRES / 0.01	2692	3500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2552	4528	OMEGARD	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	808	1050	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2553	4529	ONDANSETRON-DENK	ONDANSETRON	ANTI-EMETIQUE SPECIFIQUE / COMPRIMÉS / 4MG	3973	5165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2554	4530	OPTON	ESOMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	3885	5050	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2555	4531	OROCEF	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 50MG/5ML	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2556	4533	PANCI-40	PANTOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / AMPOULE / 40MG/10ML	1546	2010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2557	4535	PARACETAMOL	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 120MG/5ML	573	745	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2558	4536	PARACETAMOL KABI	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 1000MG	1412	1835	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2559	4537	PARAEFFER	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	762	990	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2560	4538	PARAFUSIV	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 500MG	812	1056	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2561	4540	PHARMALGAN	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 1000MG	1165	1515	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2562	4542	PROPOFOL FRESENIUS	PROPOFOL	ANESTHESIQUES GENERAUX / MILLILITRES / 200MG	7946	10330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2563	4543	PYLIRON	HYDROCORTISONE+LIDOCAÏNE+OXYDE DE ZINC+ALLANTOÏNE	ANTI-HEMORROÏDAIRE/VEINOTONIQUE / SUPPOSITOIRE / 0.25%/3%/5%/0.5%	1327	1725	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2564	4544	Q-WORM	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	623	810	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2565	4545	RABELOC	RABEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 20MG	2423	3150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2566	4546	RECLAV	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000MG/200MG	1545	2009	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2567	4547	RETIFEN	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / MILLILITRES / 0.001	1104	1435	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2568	4548	RHOCLONE	IMMUNOGLOBULINE ANTI D	SERUM/PREVENTION ALLO-IMMUNISATION FOETO-MATERNELLE / AMPOULE / 300µG	20308	26400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2569	4549	RILIF	ACECLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 100MG	4054	5270	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2570	4550	ROIPAR	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	827	1075	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2571	4551	RONFENAC	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / SUPPOSITOIRE / 100MG	1412	1835	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2572	4552	ROX-CLAV	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 500MG/100MG	1104	1435	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2573	4554	ROXIME	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 200MG	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2574	4555	ROXONE	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1750	2275	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2575	4556	ROXONE PLUS	CEFTRIAXONE+SULBACTAM	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG/500MGIMIV	3092	4020	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2576	4557	SERDOREL	CLOPIDOGREL	ANTI-AGREGANT PLAQUETTAIRE / COMPRIMÉS / 75MG	13245	17218	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2577	4558	SOCLAV	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 100MG/12.5MG	2208	2870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2578	4562	SOLEXIM	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 200MG	2842	3695	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2579	4563	SOLEXIM-N	CEFIXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 50MG/5ML	2208	2870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2580	4564	SPASMOBUTINE	TRIMEBUTINE	ANTI-SPASMODIQUE / MILLILITRES / 0.787G	1900	2470	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2581	4565	SPASMOTROY	DROTAVERINE	ANTI-SPASMODIQUE / COMPRIMÉS / 40MG	1015	1320	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2582	4567	STERIMAR BEBE	EAU DE MER DILUEE ISOTONIQUE	DECONGESTIONNANT NASAL / MILLILITRES / 9G/L	2992	3890	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2583	4568	STERIMAR CUIVRE	EAU DE MER DILUEE ISOTONIQUE + CUIVRE	DECONGESTIONNANT NASAL / MILLILITRES / 9G/L	3954	5140	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2584	4569	STERIMAR HYGIENE DU NEZ	EAU DE MER DILUEE ISOTONIQUE	DECONGESTIONNANT NASAL / MILLILITRES / 9G/L	2481	3225	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2585	4570	STERIMAR HYPERTONIQUE	EAU DE MER DILUEE HYPERTONIQUE	DECONGESTIONNANT NASAL / MILLILITRES / 22G/L	4181	5435	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2586	4571	STERIMAR MANGANESE	EAU DE MER DILUEE ISOTONIQUE + MANGANESE	DECONGESTIONNANT NASAL / MILLILITRES / 9G/L	3846	5000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2587	4572	TAMUXXAIR	SALBUTAMOL	ANTI-ASTHMATIQUE / DOSES / 100UG	1838	2390	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2588	4573	T-DOL	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / AMPOULE / 100MG/2ML	973	1265	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2589	4574	TOPCEF	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	2146	2790	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2590	4575	TRONID	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	1881	2445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2591	4576	TROYPANTO	PANTOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / COMPRIMÉS / 40MG	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2592	4577	UMEFLOX	OFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 200MG	2962	3850	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2593	4578	UMETAC	RANITIDINE	ANTI-ULCEREUX/ANTI-HISTAMINIQUE H2 / AMPOULE / 50MG	3692	4800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2594	4579	UMOXIL	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 250MG/5ML	838	1090	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2595	4580	VAXCEL CEFTRIAXONE	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	2312	3005	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2596	4582	ZEPOTIL 100	CEFPODOXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 100MG	3088	4015	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2597	4583	ZEPOTIL 200	CEFPODOXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / COMPRIMÉS / 200MG	3535	4595	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2598	4584	ZEPOTIL SUSPENSION 50	CEFPODOXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 50MG/5ML	3477	4520	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2599	4585	ZITROTIL	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	2654	3450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2600	4586	ACILOC	RANITIDINE	ANTI-ULCEREUX/ANTI-HISTAMINIQUE H2 / AMPOULE / 50MG	2738	3560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2601	4588	ANASTROZOLE-DENK	ANASTROZOLE	ANTICANCEREUX/IMMUNOMODULATEUR INHIBITEUR DES AROMATASES / COMPRIMÉS / 1MG	15454	20090	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2602	4589	APDROPS	MOXIFLOXACINE	ANTIBIOTIQUE QUINOLONES / MILLILITRES / 5MG/ML	1988	2585	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2603	4593	BEXITROL F	FLUTICASONE PROPIONATE+SALMETEROL	ANTI-ASTHMATIQUE / DOSES / 250µG/25µG/DOSE	3535	4595	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2604	4595	B-VIT FORT	THIAMINE (VIT B1) + PYRIDOXINE (VIT B6) + CYANOCOBALAMINE (VIT B12)	ANTI-PARESTHESIQUE / COMPRIMÉS / 250MG/250MG/1MG	885	1150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2605	4596	CETAMYL	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / Unite (s) / 500MG	769	1000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2606	4597	SERUM SALE 0.9% DOPHARMA SOL PERF 500ML	CHLORURE DE SODIUM	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.009	396	515	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2607	4598	SERUM SALE 0,9% DOPHARMA SOL PERF 250ML	CHLORURE DE SODIUM	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.009	338	440	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2608	4599	CIPROFLOXACINE 200MG DO PHARMA	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 200MG	454	590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2609	4601	CREACLAV	AMOXICILLINE+ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 500MG/62.5MG	2604	3385	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2610	4605	CREATOL EFF	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	619	805	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2611	4606	CORNEREGEL	DEXPANTHENOL	CICATRISANT / GRAMMES / 0.05	1854	2410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2612	4607	DOSTINEX	CABERGOLINE	INHIBITEUR DE LA PROLACTINE / COMPRIMÉS / 0.5MG	25038	32550	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2613	4608	EVIDAN	DOMPERIDONE	ANTI-EMETIQUE / COMPRIMÉS / 10MG	1412	1835	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2614	4610	SERUM GLUCOSE 10% DOPHARMA SOL PERF 250ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.1	362	470	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2615	4611	SERUM GLUCOSE 10% DOPHARMA SOL PERF 500ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.1	454	590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2616	4612	SERUM GLUCOSE 5% DOPHARMA SOL PERF 250ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.05	350	455	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2617	4613	SERUM GLUCOSE 5% DOPHARMA SOL PERF 500ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.05	423	550	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2618	4614	INSTACLOP PLUS	ACIDE ACETYLSALICYLIQUE+CLOPIDOGREL	ANTI-AGREGANT PLAQUETTAIRE / GELULE / 75MG/75MG	6623	8610	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2619	4615	IO-PAT	OLOPATADINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE OPHTALMIQUE / MILLILITRES / 1MG/ML	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2620	4616	LAMOTRIGINE	LAMOTRIGINE	ANTI-EPILEPTIQUE / COMPRIMÉS / 2MG	3731	4850	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2621	4621	LETROZOLE-DENK	LETROZOLE	ANTICANCEREUX/IMMUNOMODULATEUR INHIBITEUR DES AROMATASES / COMPRIMÉS / 2.5MG	17573	22845	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2622	4622	LIPOVAS	ATORVASTATINE	HYPOLIPEMIANT / Unite (s) / 10MG	3354	4360	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2623	4625	METRONIDAZOLE DO PHARMA	METRONIDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 500MG	454	590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2624	4627	MOXICON	MOXIFLOXACINE	ANTIBIOTIQUE QUINOLONES / MILLILITRES / 5MG/ML	1635	2125	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3085	D000035	ACTIMOVE MANUS DROIT-XL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4542	5905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2625	4628	NATRIXAM	INDAPAMIDE+AMLODIPINE	ANTIHYPERTENSEUR INHIBITEUR CALCIQUE/DIURETIQUE DE L’ANSE / COMPRIMÉS / 1.5MG/5MG	5077	6600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2626	4630	PARACETAMOL DO PHARMA	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 1000MG	1073	1395	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2627	4631	RAMIZID	RAMIPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 10MG	7196	9355	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2628	4633	RBC	FER	ANTI-ANEMIQUE / Unite (s) / 100MG	8750	11375	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2629	4634	RINGER LACTATE DOPHARMA SOL PERF 250ML	RINGER LACTATE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / PM	362	470	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2630	4635	RINGER LACTATE DOPHARMA SOL PERF 500ML	RINGER LACTATE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / PM	442	575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2631	4636	SRO-ZINC	ZINC+SRO	ANTIDIARRHEIQUE / COMPRIMÉS / 20.8G/20MG	462	600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2632	4637	TEMERIT DUO	NEBIVOLOL HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR BETABLOQUANT / COMPRIMÉS / 5/12.5 MG	6712	8725	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2633	4639	TRIPLIXAM	PERINDOPRIL+INDAPAMIDE+AMLODIPINE	ANTIHYPERTENSEUR IEC/DIURETIQUE DE L’ANSE/NHIBITEUR CALCIQUE / COMPRIMÉS / 5MG/1.25MG/5MG	10154	13200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2634	4643	TRIVERAM	ATORVASTATINE+PERINDOPRIL ARGININE+AMLODIPINE	ANTIHYPERTENSEUR/HYPOCHOLESTEROLEMIANT / COMPRIMÉS / 10MG/5MG/5MG	9622	12509	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2635	4648	ZOLEDRO-DENK	ACIDE ZOLEDRONIQUE	ANTICANCEREUX/INHIBITEUR DES DESORDRES OSSEUX / MILLILITRES / 4MG/5ML	64019	83225	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2636	4650	CICLOVIRAL	ACICLOVIR	ANTI-VIRAL TOPIQUE / Gramme (s) / 0.05	4000	5200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2637	4653	IBUX	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / Millilitre (s) / 100MG/5ML	1323	1720	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2638	4654	CRONOPEN	AZITHROMYCINE	ANTIBIOTIQUE MACROLIDE / Unite (s) / 500MG	2219	2885	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2639	4655	RENNIXA	FUROSEMIDE	ANTI-HYPERTENSEUR DIURETIQUE DE L'ANSE / Unite (s) / 20MG	1096	1425	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2640	4656	FINAGEN 5	FINASTERIDE	HYPERTROPHIE BENIGNE DE LA PROSTATE / Unite (s) / 5MG	10892	14160	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2641	4657	PANTEK PLUS	IBUPROFENE + PARACETAMOL	ANTI-INFLAMMATOIRE (AINS)/ANALGESIQUE / Millilitre (s) / 100MG/162,5MG	681	885	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2642	4658	ALSAV	ALBENDAZOLE	ANTI-PARASITAIRE / Unite (s) / 400MG	381	495	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2643	4660	TERFINA	TERBINAFINE	ANTI-FONGIQUE TOPIQUE / Gramme (s) / 0.01	1441	1873	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2644	4661	UROFAST	FOSFOMYCINE TROMETAMOL	ANTIBIOTIQUE DIVERS / Unite (s) / 3G	3885	5050	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2645	4663	CISPLATINE	CISPLATINE	ANTICANCEREUX/AGENT ALKYLANT / AMPOULE / 1MG/ML	14308	18600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2646	4664	CARBOPLATINE 150MG	CARBOPLATINE	ANTICANCEREUX/AGENT ALKYLANT / Unite (s) / 150MG/15ML	13462	17500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2647	4665	CARBOPLATINE 450MG	CARBOPLATINE	ANTICANCEREUX/AGENT ALKYLANT / Unite (s) / 450MG/45ML	40769	53000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2648	4666	ETOPOSIDE	ETOPOSIDE	ANTICANCEREUX/CYTOTOXIQUE INHIBITEUR DES TOPO-ISOMERASES II / Unite (s) / 100MG/5ML	35904	46675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2649	4669	ACCOFIL	FILGRASTIM	ANTICANCEREUX/STIMULANT DE L'HEMATOPOIESE / Unite (s) / 30MU	30731	39950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2650	4709	AMADAY PL	AMLODIPINE + PERINDOPRIL	ANTIHYPERTENSEUR INHIBITEUR CALCIQUE/I.E.C. / Unite (s) / 5MG/4MG	5519	7175	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2651	4713	HEMAX	ERYTHROPOIETINE	ANTI-ANEMIQUE SPECIFIQUE / Unite (s) / 2000 UI	7508	9760	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2652	4715	THYROZOL	THIAMAZOLE	ANTI-THYROIDIEN / Unite (s) / 20MG	2781	3615	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2653	4716	ACFAMOL	METHYLPREDNISOLONE	CORTICOIDE / Unite (s) / 40MG	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2654	4717	ACTOPENUM	MEROPENEME	ANTIBIOTIQUE BETA-LACTAMINE CARBAPENEME / Unite (s) / 500MG	5300	6890	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2655	4719	SULBACEF	CEFTRIAXONE + SULBACTAM	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / Unite (s) / 1000MG/500MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2656	4720	PROSTALEN	ALFUZOSINE	HYPERTROPHIE BENIGNE DE LA PROSTATE / Unite (s) / 10 MG	5300	6890	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2657	4721	FLUZYN	FLUOXETINE	ANTI-DEPRESSEUR / Unite (s) / 20 MG	2650	3445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2658	4722	CLAVOX	AMOXICILLINE + ACIDE CLAVULANIQUE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Unite (s) / 1000MG/200MG	1492	1940	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2659	4728	PANTONEX DR-40	PANTOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / Unite (s) / 40MG	2562	3330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2660	4729	NADICLOX	ACIDE FUSIDIQUE	ANTIBIOTIQUE TOPIQUE / Gramme (s) / 0.02	1438	1870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2661	4732	GENPAR	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / Millilitre (s) / 1000MG	1104	1435	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2662	4733	GENSET	CETIRIZINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / Millilitre (s) / 5MG/5ML	708	920	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2663	4734	RAMITHIAZIDE	RAMIPRIL+ HYDROCHLOROTHIAZIDE	ANTI-HYPERTENSEUR I.E.C./DIURETIQUE THIAZIDIQUE / Unite (s) / 5MG/12,5MG	2296	2985	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2664	4736	VAXCEL CEFOBACTAM	CEFOPERAZONE+SULBACTAM	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Unite (s) / 500MG/500MG	4227	5495	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2665	4737	AXCEL CEFUROXIME 250	CEFUROXIME	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Unite (s) / 250MG	3692	4800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2666	4738	CASODEX 50	BICALUTAMIDE	ANTICANCEREUX/IMMUNOMODULATEUR ANTI-ANDROGENE / Unite (s) / 50MG	44150	57395	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2667	4739	PLASMOCUR 20/160	DIHYDROARTEMISININE+PIPERAQUINE	ANTIPALUDIQUE / Unite (s) / 20MG/160MG	1062	1380	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2668	4740	PLASMOCUR 40/320	DIHYDROARTEMISININE+PIPERAQUINE	ANTIPALUDIQUE / Unite (s) / 40MG/320MG	1588	2065	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2669	4741	SULBACEF 500/250	CEFTRIAXONE+SULBACTAM	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Unite (s) / 500MG/250MG	1588	2065	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2670	4742	ZANEXTRA 20/10	ENALAPRIL+LERCANIDIPINE	ANTIHYPERTENSEUR INHIBITEUR CALCIQUE/I.E.C. / Unite (s) / 20MG/10MG	8973	11665	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2671	4743	ZANEXTRA 20/20	ENALAPRIL+LERCANIDIPINE	ANTIHYPERTENSEUR INHIBITEUR CALCIQUE/I.E.C. / Unite (s) / 20MG/20MG	8973	11665	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2672	4744	CLOPI DENK 75	CLOPIDOGREL	ANTIAGREGANT PLAQUETTAIRE / Unite (s) / 75MG	5738	7460	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2673	4745	PAN 20	PANTOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / Unite (s) / 20MG	1104	1435	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2674	4746	PAN 40	PANTOPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / Unite (s) / 40MG	1765	2295	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2675	4747	OLYFRESH	CARMELLOSE SODIQUE	AFFECTION OPHTALMIQUE/LUBRIFIANT OCULAIRE / Millilitre (s) / 0,5%	1765	2295	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2676	4748	PLASMOLYZ 20/120	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMES / 20MG/120MG	388	505	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2677	4749	PLASMOLYZ 80/480	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMES / 80MG/480MG	1150	1495	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2678	4750	EFFERMOL 500	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMES / 500MG	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2679	4751	RABIVAX-S	VIRUS ANTIRABIQUE INACTIVE	VACCIN/RAGE / DOSE / 1000UI	6846	8900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2680	4752	VACCIN ANTITETANIQUE	ANATOXINE TETANIQUE	VACCIN/TETANOS / DOSE / 40UI	1923	2500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2681	4753	ANTITOXINE TETANIQUE	ANTITOXINE TETANIQUE	SERUM/TETANOS / DOSE / 1500UI	2692	3500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2682	4754	EURARTESIM 40/320	DIHYDROARTEMISININE+PIPERAQUINE	ANTIPALUDIQUE / COMPRIMES / 40MG/320MG	2562	3330	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2683	4755	VACCIN HEPATITE B ADULTE	ANTIGENE HEPATITE B	VACCIN/HEPATITE B / DOSE / 20µG	4531	5890	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2684	C000001	ARTEMETHER+LUMEFANTRINE 20/120 B/12 FM FOND MONDIAL	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	173	225	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2685	C000002	NETILMICINE 50mg inj amp 2ml	NETILMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 50MG	1192	1550	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2686	C000003	ACETYLSALCYLATE DE LYSINE 0.5 g inj Flacon	ACETYL SALICYLATE DE DL- LYSINE	ANALGESIQUE/ANTI-PYRETIQUE P1 / AMPOULE / 500MG	385	500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2687	C000004	COARTEM 20/120/ B/18 FM FONDS MONDIAL	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	262	340	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2688	C000005	COARTHEM 20/120 B/24 FOND MONDIAL	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	346	450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2689	C000006	ACETYLSALICYLATE DE LYSINE 1800mg (eq 1g d'Aspirine) INJ Flacon	ACETYL SALICYLATE DE DL- LYSINE	ANALGESIQUE/ANTI-PYRETIQUE P1 / AMPOULE / 1000MG	442	575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2690	C000007	ARTEMETHER + LUMEFANTRINE 20/120 B/6 FOND MONDIAL	ARTEMETHER+LUMEFANTRINE	ANTIPALUDIQUE / COMPRIMÉS / 20MG/120MG	85	110	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2691	C000008	NICARDIPINE 10mg / ml inj Flacon de 10 ml	NICARDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / MILLILITRES / 10MG	1385	1800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2692	C000009	COLCHICINE 1 MG/COMP	COLCHICINE	ANTI-GOUTTE / COMPRIMÉS / 1MG	846	1100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2693	C000010	ACIDE ACETYLSALICYLIQUE 500MG/COMP BLISTER/10	ACIDE ACETYLSALICYLIQUE	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	58	75	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2694	C000011	COTRIMOXAZOLE 120MG/COMP BLISTERS	COTRIMOXAZOLE	ANTIBIOTIQUE SULFAMIDES / Grammes / 120MG	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2695	C000012	ACIDE ACETYLSALICYLIQUE COMPRIME 500 MG	ACIDE ACETYLSALICYLIQUE	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	115	150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2696	C000013	NICARDIPINE 20mg comp B/30	NICARDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 20MG	3269	4250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2697	C000014	COTRIMAZOLE	COTRIMOXAZOLE	ANTIBIOTIQUE SULFAMIDE / MILLILITRES / 240MG	385	500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2698	C000015	ACIDE ASCORBIQUE 500MG SOLUTION INJRCTABLE	ACIDE ASCORBIQUE	VITAMINES ET SELS MINERAUX / AMPOULE / 500MG	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2699	C000016	COTRIMOXAZOLE 240MG/5ML SUSP BUV FLACON 100 ML	COTRIMOXAZOLE	ANTIBIOTIQUE SULFAMIDE / MILLILITRES / 240MG	538	700	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2700	C000017	ACIDE ASCORBIQUE 500MG INJ AMP 5ML	ACIDE ASCORBIQUE	VITAMINE ET SELS MINERAUX /  / 500 MG	154	200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2701	C000018	COTRIMOXAZOLE 480MG/CP BLISTER	SULFAMETHOXAZOLE+TRIMETHOPRIME	ANTIBIOTIQUE SULFAMIDE / COMPRIMÉS / 400MG/80MG	231	300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2702	C000019	NIFEDIPINE 20mg / Comp LP Blister	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 20MG	692	900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2703	C000020	ACIDE FOLIQUE 5MG/COMP BLISTER/10	ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 5MG	58	75	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2704	C000021	VITAMINE B12 1000µG SOLUTION INJECTABLE	CYANOCOBALAMINE (VIT B12)	ANTI-ANEMIQUE / AMPOULE / 1000µG	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2705	C000022	NIFEDIPINE 10mg / Comp Blister B / 30	NIFEDIPINE	ANTI-HYPERTENSEUR INHIBITEUR CALCIQUE / COMPRIMÉS / 10MG	231	300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2706	C000023	ACIDE NALIDIXIQUE COMPRIME 500MG	ACIDE NALIDIXIQUE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	596	775	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2707	C000024	CYCLOPHOSPHAMIDE 500 MG INJ(ENDOXAN) B/10	CYCLOPENTOTATE	ANTIMITOTIQUE / Millilitres / 500 MG	6346	8250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2708	C000025	NORFLOXACINE 400Mg / cp Blister B / 10	NORFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 400MG	1077	1400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2709	C000026	ACIDE NIFLUMIQUE GELULE 250MG	ACIDE NIFLUMIQUE	ANTI-INFLAMMATOIRES NON STEROIDIENS / Grammes / 250 MG	481	625	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2710	C000027	NYSTATINE 	NYSTATINE	ANTI-FONGIQUE LOCAL / COMPRIMÉS / 100000UI	354	460	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2711	C000028	NYSTATINE	NYSTATINE	ANTI-FONGIQUE / MILLILITRES / 100000UI	962	1250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2712	C000029	DEXAMETHASONE 4MG	DEXAMETHASONE	CORTICOIDE / AMPOULE / 4MG	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2713	C000030	ACIDE NIFLUMIQUE 3% POMMADE TUBE 60G	ACIDE NIFLUMIQUE	ANTI-INFLAMMATOIRES NON STEROIDIENS LOCAUX / Grammes / 60G	38	50	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2714	C000031	ACIDE NIFLUMIQUE 400MG SUPPOS B/8	ACIDE NIFLUMIQUE	ANTI-INFLAMMATOIRES NON STEROIDIENS / Grammes / 400 MG	1077	1400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2715	C000032	DEXTROSE 5% SOL PERF 250ML	GLUCOSE ISOTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.05	462	600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2716	C000034	DEXTROSE 10% SOL PERF 250ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.1	538	700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2717	C000035	ACIDE VALPROIQUE 500MG/COMP B/40	ACIDE VALPROIQUE	ANTI-EPILEPTIQUE / COMPRIMÉS / 500MG	3792	4930	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2718	C000036	DEXTROSE 10% SOL PERF 500ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.1	581	755	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2719	C000037	ADRENALINE 1MG INJ AMP 1 ML	ADRENALINE	SYMPATHOMIMETIQUE / AMPOULE / 1MG	231	300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2720	C000038	OMEPRAZOLE 200Mg/Gélule B / 30	OMEPRAZOLE	ANTI-ULCEREUX/INHIBITEUR DE LA POMPE A PROTON / GELULE / 20MG	346	450	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2721	C000039	DEXTROSE 30% SOL PERF 250ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.3	796	1035	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2722	C000040	DEXTROSE 30% SOL PERF 500ML	GLUCOSE HYPERTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.3	846	1100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2723	C0000405	VACCIN ANTI-MENINGOCOCCIQUE TETRAVALENT ACYW135	ANTIGENES MENINGOCOQUES ACYW135	VACCIN/MENINGITE / DOSE / 10µG/5µG/5µG/5µG	548	712	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2724	C000041	ALBENDAZOLE 400MG	ALBENDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 400MG	346	450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2725	C000042	OXACILINE 1g IM / IV inj Flacon	OXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Grammes / 1g IM IV	1312	1705	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2726	C000043	DEXTROSE 5% INJ FLACON PLASTIQUE PP 1000ML	DEXTROSE	SOLUTES / Millilitres / 0.05	846	1100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2727	C000045	DEXTROSE 5% SOL PERF 500ML	GLUCOSE ISOTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.05	519	675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2728	C000046	ALBENDAZOLE 400MG/COMP BLISTERS B/1	ALBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 400MG	77	100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2729	C000047	DIAZEPAM 10MG INJ AMP 2ML	DIAZEPAM	ANXIOLYTIQUE/HYPNOTIQUE / AMPOULE / 10MG/2ML	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2730	C000048	DIAZEPAM COMPRIME 5MG	DIAZEPAM	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 5MG	58	75	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2731	C000049	AMINOPHYLLINE 100MG/CP B/20	AMINOPHYLLINE	ANTI-ASTHMATIQUE / COMPRIMÉS / 20MG	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2732	C000050	DICLOFENAC 25MG/COMP BLISTER B/10	DICLOFENAC	ANTI INFLAMMATOIRE / Grammes / 25 MG	219	285	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2733	C000051	DICLOFENAC 50MG/COMP BLISTER B/10	DICLOFENAC	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 50MG	285	370	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2734	C000052	DIGOXINE 0,25 MG/COMP BLISTER	DIGOXINE	CARDIOTONIQUES / COMPRIMÉS / 0.25MG	173	225	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2735	C000053	AMINOPHYLLINE 250 MG INJ AMP 10 ML	AMINOPHYLLINE	ANTI-ASTHMATIQUE / MILLILITRES / 250MG/10ML	127	165	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2736	C000054	OXACILINE 250mg Pdre Susp Buv Flacon 60ml	OXACILLINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Millilitres / 250 Mg	1292	1680	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2737	C000055	AMIODARONE HCL 200MG/CP B/28	AMIODARONE	ANTI-ARYTHMIQUE / COMPRIMÉS / 200MG	6327	8225	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2738	C000056	DIGOXINE 0,5 MG INJ AMP 2ML B/1	DIGOXINE	CARDIOTONIQUES / AMPOULE / 0.5MG	108	140	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2739	C000057	OXACILLINE 500Mg / gél B / 10	OXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENICILLINES / Grammes / 500 mg	538	700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2740	C000058	AMITRIPTYLINE 4% GTTES BUV. FLACON /20ML	AMITRIPTYLINE	ANTI-DEPRESSEUR / MILLILITRES / 40MG/ML	1623	2110	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2741	C000059	DOBUTAMINE 12,5MG/ML INJ FLACON DE 20	DOBUTAMINE	SYMPATHOMIMETIQUE / AMPOULE / 12.5MG	2662	3460	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2742	C000060	OXYTOCINE 10UI INJECTABLE Amp 1 ml	OXYTOCINE	UTEROTONIQUE / AMPOULE / 10UI/1ML	65	85	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2743	C000061	DOPAMINE CHLORHYDRATE 200 MG INJ AMP 5 ML	DOPAMINE	SYMPATHOMIMETIQUE / AMPOULE / 200MG	442	575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2744	C000062	ARTESUNATE GRANULE 25MG/SACHET + AMODIAQUINE 50 MG/5ML SP	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Grammes / 25/50MG	615	800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2745	C000063	DOXYCYCLINE 100MG/COMP BLISTER	DOXYCYCLINE	ANTIBIOTIQUE CYCLINE / COMPRIMÉS / 100MG	442	575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2746	C000064	AMOXICILLINE 125MG/5ML SUSP FLACON 100ML	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 125MG/5ML	538	700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2747	C000065	AMOXICILLINE 125MG/5ML SUSP BUV FLACON 60ML	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 125MG/5ML	385	500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2748	C000066	DOXYCYCLINE 100MG/GEL BLISTER	DOXYCYCLINE	ANTIBIOTIQUE CYCLINE / GELULE / 100MG	208	270	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2749	C000067	DOXYCYCLINE 200MG/COMP BLISTER	DOXYCYCLINE	ANTIBIOTIQUE CYCLINE / COMPRIMÉS / 200MG	369	480	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2750	C000068	OXYTOCINE 5UI INJECTABLE Amp 2ml	OXYTOCINE	UTEROTONIQUE / AMPOULE / 5UI/1ML	135	175	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2751	C000069	AMOXICILLINE 250MG/5ML SUSP BUV FLACON 60ML	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 250MG/5ML	538	700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2752	C000070	DOTAVERINE 40MG/2ML INJ	DROTAVERINE	ANTI-SPASMODIQUE / AMPOULE / 40MG	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2753	C000071	AMOXICILLINE 500MG/COMP BLISTERS B/10	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / COMPRIMÉS / 500MG	423	550	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2754	C000072	DROTAVERINE 40MG/COM BLISTER	DROTAVERINE	ANTI-SPASMODIQUE / COMPRIMÉS / 40MG	854	1110	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2755	C000073	PANCURONIUM 2MG	PANCURONIUM	ANESTHESIQUES GENERAUX / AMPOULE / 2MG/ML	923	1200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2756	C000075	AMOXICILLINE 500MG/GEL BLISTER B/10	AMOXICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GELULE / 500MG	288	375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2757	C000077	EAU POUR PREPARATION INJECTABLE FLACON PLASTIQUE 10 ML	EAU POUR PREPARATION INJECTABLE	EAU POUR PREPARATION INJECTABLE / MILLILITRES / 0	38	50	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2758	C000078	PARACETAMOL 0,5 g Enft NRS inj flacon	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / AMPOULE / 500MG	1077	1400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2759	C000079	PARACETOMOL 1g Adulte Inj Flacon	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / AMPOULE / 1000MG	985	1280	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2760	C000080	AMPHOTERICINE B 100MG/ML SUSP BUV FL/40ML	AMPHOTERICINE B	ANTI-FONGIQUE / MILLILITRES / 100MG	2462	3200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2761	C000081	ENOXAPARINE SODIQUE 4000UI/0,4ML SERINGUES PREREMPLIES	ENOXAPARINE	ANTI-THROMBOTIQUE / AMPOULE / 40MG	4896	6365	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2762	C000082	PARACETAMOL 500mg / CP Blister / 20	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / COMPRIMÉS / 500MG	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2763	C000083	EPHEDRINE 30MG/1 ML AMP	EPHEDRINE	SYMPATHOMIMETIQUE / AMPOULE / 30MG	462	600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2764	C000084	PARACETAMOL CODEINE Comp Efferv B/16	PARACETAMOL+CODEINE	ANALGESIQUE/ANTI-PYRETIQUE P2 / COMPRIMÉS / 500MG/30MG	1385	1800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2765	C000085	AMPHOTERICINE B 50MG (PERFUSION LENTE) FL 40ML	AMPHOTERICINE B	ANTI-FONGIQUE / MILLILITRES / 50MG	2269	2950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2766	C000086	EPOETIN BETA 2000UI	EPOETINE BETA	ANTI-ANEMIQUE / Millilitres / 2000UI/0,3ML	11962	15550	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2767	C000087	PARACETAMOL CODEINE Comp Secs Blister B/10	PARACETAMOL+CODEINE	ANALGESIQUE/ANTI-PYRETIQUE P2 / COMPRIMÉS / 500MG/30MG	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2768	C000088	AMPICILLINE 1G (STANDACILLINE) INJ FLACON	AMPICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1000MG	135	175	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2769	C000089	ERYTHROMYCINE PROPIONATE 250MG/COMP BLISTER	ERYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 250MG	692	900	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2770	C000090	ERYTHROMYCINE PROPIONATE 500MG/COMP BLISTER	ERYTHROMYCINE	ANTIBIOTIQUE MACROLIDE / COMPRIMÉS / 500MG	1154	1500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2771	C000091	AMPICILLINE 500MG INJ FLACON	AMPICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 500MG	231	300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2772	C000092	PARACETAMOL CODEINE Comp Secs Blister B/16	PARACETAMOL+CODEINE	ANALGESIQUE/ANTI-PYRETIQUE P2 / COMPRIMÉS / 500MG/30MG	1346	1750	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2773	C000093	ARTEMETHER 20MG/ML INJ IM AMP 1ML PEDIATRIQUE B/1	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 20MG	346	450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2774	C000095	ARTEMETHER 80MG/ML AMPL INJ 1ML B/1	ARTEMETHER	ANTIPALUDIQUE / AMPOULE / 80MG	462	600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2775	C000097	ETAMSYLATE 250MG/2ML INJ IM IV B/6	ETAMSYLATE	HEMOSTATIQUE / AMPOULE / 250MGIMIV	369	480	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2776	C000098	ARTESUNATE 100MG+AMODIAQUINE 270MG CP ADULTE B/6CP	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Grammes / 100/270MG	577	750	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2777	C000099	PARACETAMOL Enfant 150mg Suppositoires B / 10	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / SUPPOSITOIRE / 150MG	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2778	C000100	FENTANYL 100 µG INJ AMP 2ML	FENTANYL	ANALGESIQUE MORPHINIQUE / AMPOULE / 100µG	673	875	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2779	C000101	PARACETAMOL Nourrisson 80mg Suppositoires B/10	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / SUPPOSITOIRE / 80MG	692	900	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2780	C000102	FER FUMARATE + ACIDE FOLIQUE 200-0.25 MG/CP B/100	FER+ACIDE FOLIQUE	ANTI-ANEMIQUE / COMPRIMÉS / 200MG/0.25MG	77	100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2781	C000103	PARACETAMOL Pédiatrique Sol Buv Flacon 90ml	PARACETAMOL	ANTALGIQUE / ANTIPYRETIQUE / Millilitres / 0	846	1100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2782	C000104	ARTESUNATE 100MG+AMODIAQUINE 270MG CP B/3CP ENFT	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Grammes / 100/270MG	385	500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2783	C000105	FLUCONAZOLE 150MG/GEL BLISTER B/1	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 150MG	431	560	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2784	C000106	PETHIDINE Chlorhydrate 100mg inj amp 2ml	PETHIDINE	ANALGESIQUE MORPHINIQUE / AMPOULE / 100MG/2ML	423	550	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2785	C000107	ARTESUNATE 25MG+AMODIAQUINE 67,5MG CP B/3CP NOURRISSON	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Grammes / 25/67,5MG	231	300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2786	C000108	FLUCONAZOLE 50MG/GEL BLISTER B/4	FLUCONAZOLE	ANTI-FONGIQUE / GELULE / 50MG	462	600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2787	C000109	PHENOBARBITAL 100 MG / CP	PHENOBARBITAL	ANTI-EPILEPTIQUE / COMPRIMÉS / 100MG	154	200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2788	C000110	FLUPHENAZINE DECANOATE 25 MG/ML INJ AMP	FLUPHENAZINE	NEUROLEPTIQUE / AMPOULE / 25MG/ML	577	750	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2789	C000111	PHENOBARBITAL 200MG / ML INJ AMP 1ML	PHENOBARBITAL	ANTI-EPILEPTIQUE / AMPOULE / 200MG	115	150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2790	C000112	ARTESUNATE 50MG+AMODIAQUINE 135MG CP B/3 PETIT ENFANT	ARTESUNATE+ AMODIAQUINE	ANTIPALUDIQUE / Grammes / 50/153MG	300	390	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2791	C000113	FUMARATE FERREUX 200MG BLISTER	FER	ANTI-ANEMIQUE / COMPRIMÉS / 66MG	77	100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2792	C000114	PHENOBARBITAL 50 MG / COMP	PHENOBARBITAL	ANTI-EPILEPTIQUE / COMPRIMÉS / 50MG	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2793	C000115	FUROSEMIDE 20 MG INJ AMP 2 ML	FUROSEMIDE	ANTI-HYPERTENSEUR DIURETIQUE DE L'ANSE / AMPOULE / 20MG	96	125	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2794	C000116	ATENOLOL COMPRIME 50MG	ATENOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 50MG	154	200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2795	C000117	FUROSEMIDE 40 MG/COMP BLISTER	FUROSEMIDE	ANTI-HYPERTENSEUR DIURETIQUE DE L'ANSE / COMPRIMÉS / 40MG	123	160	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2796	C000118	PHENOXYMETHYLPENICILLINE 1MUI / Comp Blister	PHENOXYMETHYLPENICILLINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Grammes / 1 MUI	423	550	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2797	C000119	GELATINE FLUIDE INJ FLACON PLASTIQUE 500 ML	GELATINE FLUIDE	SUBSTITUT DE PLASMA / MILLILITRES / 3G	2308	3000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2798	C000120	PHENOXYMETHYLPENICILLINE 250mg / Comp	PHENOXYMETHYLPENICILLINE	ANTIBIOTIQUE BETA LACTAMINE PENICILLINES / Grammes / 250 MG	538	700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2799	C000121	ATROPINE SULFATE 1MG	ATROPINE SULFATE	ANTI-SPASMODIQUE / AMPOULE / 1MG	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2800	C000122	GENTAMICINE 0,3% COLLYRE FLACON 5ML	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / MILLILITRES / 0.003	692	900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2801	C000123	PHLOROGLUCINOL 40MG INJ AMP 1ML	PHLOROGLUCINOL	ANTI-SPASMODIQUE / AMPOULE / 40MG	385	500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2802	C000124	BENZATHINE-BENZYLPENICILLINE 1,2MUI INJ FLACON	BENZATHINE BENZYLPENICILINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1.2MUI	96	125	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2803	C000125	AIGUILLE à Ponction Lombaire 20 Gx3 "1/2unité	AIGUILLE	DISPOSITIFS MEDICAUX / Grammes / 20G	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2804	C000126	GENTAMICINE 0,3% PDE OPHT TUBE/5G	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / GRAMMES / 0.003	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2805	C000127	PHLOROGLUCINOL 80MG / COMP BLISTER	PHLOROGLUCINOL	ANTI-SPASMODIQUE / COMPRIMÉS / 80MG	938	1220	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2806	C000128	BENZATHINE-BENZYLPENICILLINE 2,4MUI INJ FLACON	BENZATHINE BENZYLPENICILINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 2.4MUI	154	200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2807	C000129	GENTAMICINE 10MG INJ AMP 2ML	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 10MG	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2808	C000130	BENZOIQUE ACIDE 6%+SALICYLIQUE ACIDE 3% PDE 30G	ACIDE BENZOIQUE+SALICYLIQUE	ANTI-ECZEMATEUX TOPIQUE / GRAMMES / 6%/3%	500	650	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2809	C000131	BENZOATE DE BENZYLE 25% SOL US EXT FLACON 1 LITRE	BENZOATE DE BENZYLE	ANTI-PARASITAIRE LOCAL / MILLILITRES / 0.25	3546	4610	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2810	C000132	GENTAMICINE 40 MG INJ AMP 2 ML	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 40MG	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2811	C000133	AIGUILLE à Ponction Lombaire 22 Gx1"1/2 unité	AIGUILLE	DISPOSITIFS MEDICAUX / Grammes / 22 G	769	1000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2812	C000134	PHYTOMENADIONE 10mg inj amp 1ml (Vit K1)	PHYTOMENADIONE	HEMOSTATIQUE / AMPOULE / 10MG	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2813	C000135	GENTAMICINE 80 MG INJ AMP 2 ML B/25	GENTAMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 80MG	115	150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2814	C000136	BENZYLPENICILLINE (PENICILLINE G) 1M UI INJ FLACON	BENZYLPENICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / GRAMMES / 1MUI	165	215	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2815	C000137	AIGUILLE à Ponction Lombaire 25GX3"1/2 unité	AIGUILLE	DISPOSITIFS MEDICAUX / Grammes / 25 G	769	1000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2816	C000138	GLIBENCLAMIDE 5MG/COMP BLISTER B/20	GLIBENCLAMIDE	ANTI-DIABETIQUE / COMPRIMÉS / 5MG	77	100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2817	C000139	BETAMETHASONE 0,05% CREME TUBE /30G	BETAMETHASONE	CORTICOIDE TOPIQUE / GRAMMES / 0.0005	1308	1700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2818	C000140	BETAMETHASONE 0,1% CREME TUBE /15G	BETAMETHASONE	CORTICOIDE TOPIQUE / GRAMMES / 0.001	423	550	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2819	C000141	GLUCOSE 5% MONOHYDRATE SOLUTION PR PERFUSION POCHE 50 ML	GLUCOSE ISOTONIQUE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 5%/50ML	485	630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2820	C000142	POLYVIDONE IODEE 10% Sol Us Ext Flacon 200ml	POVIDONE IODEE	ANTI-SEPTIQUE LOCAL / MILLILITRES / 0.1	923	1200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2821	C000143	BETAMETHASONE 4MG INJ AMP	BETAMETHASONE	CORTICOIDE / AMPOULE / 4MG	654	850	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2822	C000144	GLUCOSE 5% MONOHYDRATE SOLUTION PR PERFUSION; POCHE 100 ML	GLUCOSE HYPERTONIQUE	SOLUTES / Millilitres / 5% POCHE 100 ML	531	690	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2823	C000145	AIGUILLE Hypodermique 21 GX40mm unité	AIGUILLE	DISPOSITIFS MEDICAUX / Grammes / 21 G	38	50	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2824	C000147	GRISEOFULVINE 250MG/COMP BLISTER	GRISEOFULVINE	ANTI-FONGIQUE / COMPRIMÉS / 250MG	538	700	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2825	C000148	BROMAZEPAM 6MG/COMP B/30	BROMAZEPAM	ANXIOLYTIQUE/HYPNOTIQUE / COMPRIMÉS / 6MG	1723	2240	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2826	C000149	AIGUILLE Hypodermique 23GX30mmunité	AIGUILLE	DISPOSITIFS MEDICAUX / Grammes / 23 G	38	50	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2827	C000150	GRISEOFULVINE 500MG/COMP BLISTER	GRISEOFULVINE	ANTI-FONGIQUE / COMPRIMÉS / 500MG	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2828	C000151	PERMANGANATE DE POTASSIUM 500mg / cp	POTASSIUM PERMANGANATE	ANTI-SEPTIQUE / COMPRIMÉS / 500MG	308	400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2829	C000152	BUPIVACAINE 0,5%	BUPIVACAINE	ANESTHESIQUES GENERAUX / AMPOULE / 0.005	1058	1375	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2830	C000153	AIGUILLE Hpodermique 25GX16mm unité	AIGUILLE	DISPOSITIFS MEDICAUX / Grammes / 25 G	38	50	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2831	C000154	HALOPERIDOL 10MG/COMP	HALOPERIDOL	NEUROLEPTIQUE / COMPRIMÉS / 10MG	192	250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2832	C000155	PROMETHAZINE 25 MG / Comp Blister	PROMETHAZINE	NEUROLEPTIQUE/ANTI-HISTAMINIQUE / COMPRIMÉS / 25MG	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2833	C000156	HALOPERIDOL 5MG INJ AMP 1 ML	HALOPERIDOL	NEUROLEPTIQUE / AMPOULE / 5MG/ML	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2834	C000157	PROMETHAZINE 50mg inj amp 2ml	PROMETHAZINE	ANXIOLYTIQUE/HYPNOTIQUE / AMPOULE / 50MG/2ML	154	200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2835	C000158	BUPIVACAINE ADRENALINEE	BUPIVACAINE+ADRENALINE	ANESTHESIQUES GENERAUX / AMPOULE / 0.005	1462	1900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2836	C000159	HALOPERIDOL 5MG/COMP	HALOPERIDOL	NEUROLEPTIQUE / COMPRIMÉS / 5MG	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2837	C000160	BANDE DE Crêpe 8cm x4m unité	BANDE DE CREPE	DISPOSITIFS MEDICAUX / Grammes / 8cm x4m	308	400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2838	C000161	PROPARACETAMOL 1g inj Flacon	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / AMPOULE / 1000MG	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2839	C000162	HEPARINE SODIQUE 25000UI INJ FLACON 5 ML	HEPARINE SODIQUE	ANTITHROMBOTIQUE / Grammes / 25000 UI	846	1100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2840	C000163	BUPIVACAINE POUR RACHIANESTHESIE 	BUPIVACAINE POUR RACHIANESTHESIE	ANESTHESIQUES GENERAUX / AMPOULE / 0.005	1169	1520	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2841	C000164	PROPOFOL 200MG	PROPOFOL	ANESTHESIQUES GENERAUX / MILLILITRES / 200MG	1231	1600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2842	C000165	BANDE DE Crêpe 10 cm x 4m unité	BANDE DE CREPE	DISPOSITIFS MEDICAUX / Grammes / 10cm x 4 m	500	650	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2843	C000166	HEPTAMINOL 6.26% INJ AMP 5 ML	HEPTAMINOL	ANTI-HYPOTENSEUR / AMPOULE / 0.0626	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2844	C000167	BUPRENORPHINE 0.3MG INJ AMP 1ML	BUPRENORPHINE	ANALGESIQUE MORPHINIQUE / AMPOULE / 0.3MG	1154	1500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2845	C000168	HYDROCORTISONE 100 MG INJ FLACON	HYDROCORTISONE	CORTICOIDE / AMPOULE / 100MG	346	450	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2846	C000169	PROPRANOLOL 40mg / Comp	PROPRANOLOL	ANTI-HYPERTENSEUR BETA-BLOQUANT / COMPRIMÉS / 40MG	58	75	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2847	C000170	BUTYLSCOPOLAMINE 10MG/COMP BLISTERS B/1000	BUTYLSCOPOLAMINE	ANTI-SPASMODIQUE / COMPRIMÉS / 10MG	315	410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2848	C000171	HYDROXYDE D'ALLUMINIUM ET DE MAGNESIUM 500 MG COMP BLISTER B/10	HYDROXYDE DE MAGNESIUM+HYDROXYDE D'ALUMINIUM	ANTI ACIDE/ PANSEMENT GASTRO INTESTINAL / Unite (s) / 400MG/400MG	1385	1800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2849	C000172	VITAMINE B6 100MG SOLUTION INJECTABLE	PYRIDOXINE (VIT B6)	ANTI-PARESTHESIQUE / AMPOULE / 100MG/2ML	96	125	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2850	C000173	BANDE DE GAZE Hydrophile 5cm x 5m	bande de gaze	DISPOSITIFS MEDICAUX / Grammes / 5cmx 5m	85	110	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2851	C000174	BUTYLSCOPOLAMINE 20MG AMP INJ 2ML B/100	BUTYLSCOPOLAMINE	ANTI-SPASMODIQUE / AMPOULE / 20MG	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2852	C000175	IBUPROFENE 400 MG/COMP BLISTERS B/20	IBUPROFENE	ANTI-INFLAMMATOIRE (AINS) / COMPRIMÉS / 400MG	231	300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2853	C000176	GLUCONATE DE CALCIUM 10% AMPOULE INJECTABLE	GLUCONATE CALCIUM	TROUBLES ELECTROLYTIQUES/SELS MINERAUX / AMPOULE / 0.1	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2854	C000177	IMMUNOGLOBULINE ANTI D 300µG	IMMUNOGLOBULINE ANTI D	SERUM/PREVENTION ALLO-IMMUNISATION FOETO-MATERNELLE / AMPOULE / 300µG	22127	28765	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2855	C000178	VITAMINE B6 250MG SOLUTION INJECTABLE	PYRIDOXINE (VIT B6)	ANTI-PARESTHESIQUE / AMPOULE / 250MG/5ML	135	175	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2856	C000179	BANDE DE GAZE Hydrophile 5 cmx10m	bande de gaze	DISPOSITIFS MEDICAUX / Grammes / 5cmx 10m	96	125	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2857	C000180	CAPTOPRIL 25MG /COMP BLISTERS	CAPTOPRIL	ANTI-HYPERTENSEUR I.E.C. / COMPRIMÉS / 25MG	115	150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2858	C000181	PYRIDOXINE 25mg / comp	PYRIDOXINE (VIT B6)	ANTI-PARESTHESIQUE / COMPRIMÉS / 250MG	269	350	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2859	C000182	IMMUNOGLOBULINE ANTI D 100µG	IMMUNOGLOBULINE ANTI D	SERUM/PREVENTION ALLO-IMMUNISATION FOETO-MATERNELLE / AMPOULE / 100µG	18804	24445	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2860	C000183	BANDE DE GAZ Hydrophyile 7cmx5m	bande de gaze	DISPOSITIFS MEDICAUX / Grammes / 7cmx5m	154	200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2861	C000184	CARBAMAZEPINE 200MG/COMP	CARBAMAZEPINE	ANTI-EPILEPTIQUE / COMPRIMÉS / 200MG	192	250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2862	C000185	QUININE 200mg / 2ml amp inj	QUININE	ANTIPALUDIQUE / AMPOULE / 200MG/2ML	135	175	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2863	C000186	IMMUNOGLOBULINE ANTI D 200 µG(1000UI) INJ flacon	IMMUNOGLOBULINE ANTI D	SERUM/TETANOS / Grammes / 200µG	15815	20560	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2864	C000187	BANDE DE GAZE Hydrophile 7.5cmx10m	bande de gaze	DISPOSITIFS MEDICAUX / Grammes / 7.5 cmx 10m	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2865	C000188	QUININE 300mg / 1ml amp inj	QUININE	ANTIPALUDIQUE / AMPOULE / 300MG/1ML	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2866	C000189	INDOMETACINE 25 MG/COMP BLISTER	INDOMEMETACINE	ANTI-INFLAMMATOIRES NON STEROIDIENS LOCAUX / Grammes / 25 MG	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2867	C000190	CARBOCYSTEINE 5% SIROP FLACON F1 100ML	CARBOCYSTEINE	MUCOLYTIQUE / Grammes / 0.05	1212	1575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2868	C000191	bande de gaze hydrophile 10cmx5m	bande de gaze	DISPOSITIFS MEDICAUX / Grammes / 10cm x 5m	115	150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2869	C000192	QUININE 600mg/2ml inj amp	QUININE	ANTIPALUDIQUE / AMPOULE / 600MG/2ML	154	200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2870	C000193	INSULINE RAPIDE 100UI	INSULINE RAPIDE	ANTI-DIABETIQUE / Millilitre (s) / 100UI	3365	4375	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2871	C000195	CEFTRIAXONE 1G INJ IM-IV B/1	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 1000MG	1019	1325	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2872	C000197	bande de gaze 10cm x10m	bande de gaze	DISPOSITIFS MEDICAUX / Grammes / 10cm x 10m	212	275	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2873	C000198	QUININE Résorcine 400mg inj amp	QUININE	ANTIPALUDIQUE / AMPOULE / 400MG	115	150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2874	C000199	CEFTRIAXONE 250 MG IM IV NJ B/1	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINES / Grammes / 250MG IM IV	615	800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2875	C000200	bande elastique 10 cm x4 m unité	bande elastique	DISPOSITIFS MEDICAUX / Grammes / 10cm x4m	500	650	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2876	C000201	INSULINE INSULATARD 40UI	INSULINE RETARD	ANTI-DIABETIQUE / MILLILITRES / 40UI	1669	2170	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2877	C000202	CEFTRIAXONE 500MG INJ IM IV FLACON	CEFTRIAXONE	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / AMPOULE / 500MGIV	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2878	C000203	QUININE Sulfate 100mg / cp Blister	QUININE	ANTIPALUDIQUE / COMPRIMÉS / 100MG	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2879	C000204	INSULINE MIXTARD 100UI	INSULINE MIXTE	ANTI-DIABETIQUE / MILLILITRES / 100UI	2969	3860	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2880	C000205	bande elastique 20 cm x 4 m unité	bande elastique	DISPOSITIFS MEDICAUX / Grammes / 20 cm x4m	538	700	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2881	C000206	QUININE Sulfate 300mg / Comp Blister	QUININE	ANTIPALUDIQUE / COMPRIMÉS / 300MG	327	425	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2882	C000207	CHARBON ACTIF 500MG/COMP	CHARBON ACTIVE	ADSORBANT INTESTINAL / Grammes / 500MG	269	350	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2883	C000208	INSULINE ORDINAIRE 40UI	INSULINE RAPIDE	ANTI-DIABETIQUE / MILLILITRES / 40UI	1700	2210	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2884	C000209	bande platree 10 cm x 3 m sachet /2	bande platrée	DISPOSITIFS MEDICAUX / Grammes / 10 cm x 3 m	942	1225	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2885	C000211	CHLORAMPHENICOL 0,5% COLLYRE FLACON 10ML	CHLORAMPHENICOL	ANTIBIOTIQUE PHENICOLE / MILLILITRES / 0.005	692	900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2886	C000212	RINGER LACTATE SOL PERF 1000ML	RINGER LACTATE	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / PM	923	1200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2887	C000213	bande platree 15 cm x 3 m sachet/2	bande platrée	DISPOSITIFS MEDICAUX / Unite (s) / 15cm x3m 	1469	1910	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2888	C000214	CHLORAMPHENICOL 250MG/GELULE BLISTER	CHLORAMPHENICOL	ANTIBIOTIQUE PHENICOLE / GELULE / 250MG	331	430	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2889	C000215	SALBUTAMOL 0,5mg inj amp 1ml	SALBUTAMOL	ANTI-ASTHMATIQUE / AMPOULE / 0.5MG/ML	96	125	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2890	C000216	CHLORAMPHENICOL 500MG INJ SUSP HUILEUSE AMP 2ML	CHLORAMPHENICOL	ANTIBIOTIQUE PHENICOLE / AMPOULE / 500MG	923	1200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2891	C000217	CHLORPHENIRAMINE MALEATE 4MG/COMP	CHLORPHENAMINE	ANTI-HISTAMINIQUE/ANTI-ALLERGIQUE / COMPRIMÉS / 4MG	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2892	C000218	CHLORPROMAZINE 100MG / COMP BLISTER	CHLORPROMAZINE	NEUROLEPTIQUE / COMPRIMÉS / 100MG	115	150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2893	C000219	CHLORPROMAZINE 50MG INJ AMP 2ML	CHLORPROMAZINE	NEUROLEPTIQUE / AMPOULE / 50MG	154	200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2894	C000220	CIMETIDINE 400MG/COMP BLISTER	CIMETIDINE	ANTI-ULCEREUX/ANTI-HISTAMINIQUE H2 / Grammes / 400MG	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2895	C000221	CIPROFLOXACINE 200MG/100ML INJ IV	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / MILLILITRES / 200MG	715	930	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2896	C000222	CIPROFLOXACINE 250MG	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 250MG	462	600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2897	C000223	CIPROFLOXACINE 500MG	CIPROFLOXACINE	ANTIBIOTIQUE QUINOLONE / COMPRIMÉS / 500MG	377	490	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2898	C000224	CLONIDINE 0,150MG/ML INJ AMP 1ML	CLONIDINE	ANTI-HYPERTENSEUR CENTRAL / AMPOULE / 0.15MG	538	700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2899	C000225	CLOTRIMAZOLE VAGINALE+APPLICATEUR	CLOTRIMAZOLE	ANTI-FONGIQUE LOCAL / COMPRIMÉS / 500MG	769	1000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2900	C000226	CLOXACILLINE 1G INJ FLACON	CLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 1G	346	450	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2901	C000227	CLOXACILLINE 250MG SUSP BUV FLACON 60ML	CLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / MILLILITRES / 250MG	923	1200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2902	C000228	CLOXACILLINE 500MG INJ FLACON	CLOXACILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 500MG	265	345	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2903	C000230	CATHETER COURT avec ailettes 22Gx25mm unité	CATHETER COURT	DISPOSITIFS MEDICAUX / Grammes / 22 GX25 MM	346	450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2904	C000231	CATHETER COURT avec aillettes 18Gx45mm Unité	CATHETER COURT	DISPOSITIFS MEDICAUX / Grammes / 18 GX45MM	346	450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2905	C000232	CATHETER COURT avec aillettes 20G x32mm unité	CATHETER COURT	DISPOSITIFS MEDICAUX / Grammes / 20G x45mm Unité	346	450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2906	C000233	CATHETER COURT avec aillettes 24 Gx19mm Unité	CATHETER COURT	DISPOSITIFS MEDICAUX / Grammes / 24 GX19 MM	346	450	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2907	C000234	SALBUTAMOL Sulfate 4mg / Comp Blister	SALBUTAMOL	ANTI-ASTHMATIQUE / COMPRIMÉS / 4MG	38	50	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2908	C000235	COMPRESSE DE GAZE STERILE 17 fils 8 plis 10x10cm(40x40)2/sach B /10	COMPRESSE DE GAZE	DISPOSITIFS MEDICAUX / Grammes / 40X40	692	900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2909	C000236	SEL de REHYDRATATION ORALE Sachet (NOUVELLE FORMULE)	SEL de REHYDRATATION ORALE	ANTI-DIARRHEIQUE / GRAMMES / INCONNU	38	50	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2910	C000237	SERUM ANTI-TETANIQUE	ANTITOXINE TETANIQUE	SERUM/TETANOS / DOSE / 1500UI	2042	2655	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2911	C000238	SERUM ANTI-VENIMEUX POLYVALENT	IMMUNOGLOBULINE POLYVALENT	SERUM/MORSURE DE SERPENT / MILLILITRES / 1000MG	11538	15000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2912	C000240	COMPRESSE DE GAZE STERILLE 17 FILS 8PLIS 7.5X7.5 CM (30x30)2/sach B/10	COMPRESSE ABDO	DISPOSITIFS MEDICAUX / Grammes / 30X30	538	700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2913	C000241	ISOFLURANE 250ML/FLACON	ISOFLURANE	ANESTHESIQUES / Millilitres / 250 ML	28462	37000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2914	C000242	KETAMINE 50MG/ML	KETAMINE	ANESTHESIQUES GENERAUX / MILLILITRES / 50MG	731	950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2915	C000244	LIDOCAINE 2% 	LIDOCAINE	ANESTHESIQUE LOCAL / MILLILITRES / 0.02	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2916	C000248	CHLORURE DE SODIUM 10% inj amp 10ml	CHLORURE DE SODIUM	SOLUTES / Millilitres / 0.1	154	200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2917	C000249	LIDOCAINE A LA NAPHAZOLINE	LIDOCAINE+NAPHAZOLINE	ANESTHESIQUE LOCAL / MILLILITRES / 0.05	1077	1400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2918	C000250	COMPRESSE ABDOMINALE NON TISSE STERILE 45X45 CM SACHET /2	COMPRESSE ABDO	DISPOSITIFS MEDICAUX / Grammes / 45X45CM/SACHET/2	2242	2915	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2919	C000252	SOLUTION D'ACIDE AMINES SIMPLE (AMINOVEIN 5%) Fl / 500ml	SOLUTION D'ACIDE AMINES SIMPLE	SOLUTES DE REMPLISSAGE / Millilitres / 0.05	5327	6925	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2920	C000253	MANNITOL 20% INJ FLACON 500ML	MANNITOL	TROUBLES HYDRO-ELECTROLYTIQUES/SOLUTE MASSIF / MILLILITRES / 0.2	1000	1300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2921	C000254	MEBENDAZOLE 100MG/COMP BLISTER	MEBENDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 100MG	58	75	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2922	C000255	HYDROCHLORITE DE SODIUM	HYDROCHLORITE DE SODIUM	ANTISEPTIQUE / Millilitres / INCONNUE	1462	1900	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2923	C000256	MEBENDAZOLE 2% SUSP BUV FLACON 30ML	MEBENDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 100MG/5ML	692	900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2924	C000258	MEPIVACAINE 3% CAPSULE	MEPIVACAINE	ANESTHESIQUES GENERAUX / AMPOULE / 3%/	231	300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2925	C000260	MEPIVACAINE 2%	MEPIVACAINE	ANESTHESIQUES GENERAUX / MILLILITRES / 0.02	346	450	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2926	C000261	ETHILON NOIR (polyamide monofil)dec 2(3/0)90cmF2417aigFS-1 24mm3/8	ETHILON	DISPOSITIFS MEDICAUX / Grammes / 3/0	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2927	C000262	TETRACYCLINE 1% Pde Opht Tube 5g	TETRACYCLINE	ANTIBIOTIQUE CYCLINE / GRAMMES / 0.01	254	330	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2928	C000263	METFORMINE 850MG COMP BLISTER	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 850MG	515	670	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2929	C000264	METFORMINE HCL 500MG/COMP BLISTER/20	METFORMINE	ANTI-DIABETIQUE / COMPRIMÉS / 500MG	115	150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2930	C000265	VITAMINE B1 100MG SOLUTION INJECTABLE	THIAMINE (VIT B1)	ANTI-PARESTHESIQUE / AMPOULE / 100MG/1ML	115	150	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2931	C000266	METHYLDOPA 250MG/COMP BLISTER /20	METHYLDOPA	ANTI-HYPERTENSEUR CENTRAL / COMPRIMÉS / 250MG	385	500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2932	C000267	METHYLERGOMETRINE 0,2MG INJ AMP 1ML	METHYLERGOMETRINE	UTEROTONIQUE / AMPOULE / 0.2MG/1ML	231	300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2933	C000268	VITAMINE B1 250MG COMP SEC	THIAMINE (VIT B1)	ANTI-PARESTHESIQUE / COMPRIMÉS / 250MG	154	200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2934	C000269	ETHILON NOIR (polyamide monofil)dec3(2/0)90cm F2418 Aig FS26mm3/8c	ETHILON NOIR	DISPOSITIFS MEDICAUX / Grammes / 2/0	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2935	C000270	THIOPENTHAL 1G	THIOPENTAL	ANESTHESIQUES / AMPOULE / 1G	846	1100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2936	C000271	METOCLOPRAMIDE 10 MG INJ AMP 2 ML	METOCLOPRAMIDE	ANTI-EMETIQUE / AMPOULE / 20MG	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2937	C000272	THIOMPENTHAL 500MG	THIOPENTAL	ANESTHESIQUES GENERAUX / AMPOULE / 500MG	892	1160	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2938	C000273	METOCLOPRAMIDE 10 MG/COMP BLISTER B/20	METOCLOPRAMIDE	ANTI-EMETIQUE / COMPRIMÉS / 10MG	154	200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2939	C000274	METOPIMAZINE 10 MG/ML INJ AMP 1 ML	METOPIMAZINE	ANTI-EMETIQUE / AMPOULE / 10MG/ML	231	300	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2940	C000275	GANT de Chirirugie en Latex Stérile n°7 Paire	GANT	DISPOSITIFS MEDICAUX / Grammes / N°7 PAIRE	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2941	C000276	TIABENDAZOLE 500mg 	TIABENDAZOLE	ANTIPARASITAIRE / Grammes / 500 Mg	346	450	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2942	C000277	METRONIDAZOLE 200MG/5 ML SUSP BUV FLACON 60 ML	METRONIDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 125MG/5ML	385	500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2943	C000278	TIMOLOL 0,25% Collyre Flacon 3ml	TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.0025	615	800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2944	C000279	GANT de Chirugie en Latex stérile n°7.5 Paire	GANT	DISPOSITIFS MEDICAUX / Grammes / n°7.5 Paire	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2945	C000280	METRONIDAZOLE 250MG/COMP BLISTER B/20	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 250MG	223	290	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2946	C000281	TIMOLOL 0,50% collyre Flacon 3ml	TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.005	538	700	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2947	C000282	GANT de chirugie en latex Stérile n°8 Paire	GANT	DISPOSITIFS MEDICAUX / Grammes / N°8 Paire	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2948	C000283	METRONIDAZOLE 500MG FLACON INJ 100 ML	METRONIDAZOLE	ANTI-PARASITAIRE / MILLILITRES / 500MG	462	600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2949	C000284	TIMOLOL 0,25% collyre flacon 5ml	TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.0025	396	515	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2950	C000285	METRONIDAZOLE 500MG/COMP BLISTER B/20	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	269	350	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2951	C000286	GANT de Chirugie en Latex Stérile n°8,5 Paire	GANT	DISPOSITIFS MEDICAUX / Grammes / n°8,5 Paire	192	250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2952	C000287	TIMOLOL 0,50% cOLLYRE flacon 5ml	TIMOLOL	ANTI-GLAUCOMATEUX / MILLILITRES / 0.005	1385	1800	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2953	C000288	METRONIDAZOLE 	METRONIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	154	200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2954	C000289	TINIDAZOLE 500mg / Comp Blister B / 4	TINIDAZOLE	ANTI-PARASITAIRE / COMPRIMÉS / 500MG	154	200	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2955	C000290	GANT D'EXAMEN EN LATEX MMB/100	GANT	DISPOSITIFS MEDICAUX / Grammes / MM B/100	2969	3860	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2956	C000291	TRAMADOL 100 Mg inj amp 2 ml	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / AMPOULE / 100MG/2ML	431	560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2957	C000292	MICONAZOLE NITRATE 2% GEL DERMIQUE TUBE/30G	MICONAZOLE	ANTI-FONGIQUE TOPIQUE / GRAMMES / 0.02	615	800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2958	C000293	TRAMADOL 50mg/comp Blister B/20	TRAMADOL	ANALGESIQUE MORPHINIQUE MINEUR / COMPRIMÉS / 50MG	1385	1800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2959	C000294	MICONAZOLE	MICONAZOLE	ANTI-FONGIQUE LOCAL / COMPRIMÉS / 400MG	1554	2020	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2960	C000295	GLUCOSE 5% Monohydraté	GLUCOSE HYPERTONIQUE	SOLUTES / Millilitres / 5% poche 50ml	485	630	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2961	C000296	VACCIN ANTI-AMARIL	ANTIGENE FIEVRE JAUNE	VACCIN/FIEVRE JAUNE / DOSE / 1000UI	1231	1600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2962	C000299	VACCIN ANTI-HEPATITE B ADULTE (EUVAX)	ANTIGENE HEPATITE B	VACCIN/HEPATITE B / DOSE / 20µG	1923	2500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2963	C000300	MORPHINE 30MG	MORPHINE	ANALGESIQUE MORPHINIQUE / GELULE / 30MG	7600	9880	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2964	C000301	MORPHINE	MORPHINE	ANALGESIC MAJEUR / Grammes / 60 MG	15938	20720	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2965	C000302	VACCIN ANTI-MENINGOCOCCIQUE AC	ANTIGENES MENINGOCOQUES AC	VACCIN/MENINGITE / DOSE / 50µG/50µG	746	970	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2966	C000303	LAMES de bistouri stériles uu n°22	LAMES DE BISTOURI	DISPOSITIFS MEDICAUX / Millilitres / N°22	38	50	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2967	C000304	MULTIVITAMINES (A,D3,B1,B2,PP,C) COMPRIME BLISTER	VITAMINE A,D3,B1,B2,PP,C	VITAMINE ET SELS MINERAUX / Grammes / 0	77	100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2968	C000305	VACCIN ANTIRABIQUE (VERORAB)	VIRUS ANTIRABIQUE INACTIVE	VACCIN/RAGE / DOSE / 1000UI	6219	8085	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2969	C000306	LAMES DE Bistouri stériles uun°23	LAMES DE BISTOURI	DISPOSITIFS MEDICAUX /  / n°23	38	50	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2970	C000307	NETILMICINE 150 MG INJ AMP 1.5 ML	NETILMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 150MG	2385	3100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2971	C000309	NETILMICINE 25 MG INJ AMP 1 ML	NETILMICINE	ANTIBIOTIQUE AMINOSIDE / AMPOULE / 25MG	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2972	C000310	MICROPERFUSEUR(épicranienne)20Gxunité	MICROPERFUSEUR	DISPOSITIFS MEDICAUX / Grammes / 20g	77	100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2973	C000311	VACCIN TYPHIM	ANTIGENE SALMONELLA TYPHI	VACCIN/FIEVRE THYPHOIDE / DOSE / 25µG	2577	3350	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2974	C000312	LAMES DE BISTOURI STERILES uu N°24	LAMES DE BISTOURI	DISPOSITIFS MEDICAUX / Grammes / N°24	38	50	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2975	C000313	MICROPERFUSEUR (épicranienne)21gx unité	MICROPERFUSEUR	DISPOSITIFS MEDICAUX / Grammes / 21G	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2976	C000314	VIOLET de GENTIANE Poudre 25g Boite	VIOLET de GENTIANE	ANTISEPTIQUE / Grammes / 25 g	2831	3680	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2977	C000315	MICROPREFUSEUR (épicrannienne)	MICROPERFUSEUR	DISPOSITIFS MEDICAUX / Grammes / 22G	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2978	C000316	VITAMINE B Complxe (B1,B6,B12) Comp B/500	VITAMINE B	VITAMINE ET SELS MINERAUX / Grammes / INCONNU	462	600	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2979	C000317	MICROPERFUSEUR (épicranienne) 23Gx unité	MICROPERFUSEUR	DISPOSITIFS MEDICAUX / Grammes / 23g	77	100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2980	C000318	VITAMINE B Complexe inj amp 2ml B/100	VITAMINE B	VITAMINE ET SELS MINERAUX / Millilitres / INCONNU	154	200	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2981	C000319	MICROPERFUSEUR (épicranienne 25G)	MICROPERFUSEUR	DISPOSITIFS MEDICAUX / Grammes / 25G	77	100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2982	C000320	VITAMINE B12 Fer Sirop Flacon 180ml	VITAMINE B12	VITAMINE ET SELS MINERAUX / Millilitres / INCONNU	1031	1340	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2983	C000322	PERFUSEUR en PVC et AIGUILLE 23G	PERFUSEUR	DISPOSITIFS MEDICAUX / Grammes / 23G	192	250	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2984	C000323	PERFUSEUR EN PVC	PERFUSEUR	DISPOSITIFS MEDICAUX / Grammes / 21G	192	250	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2985	C000324	POCHE à urine 	POCHE à urine	DISPOSITIFS MEDICAUX / Millilitres / 2l	385	500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2986	C000325	PROLENE BLEU (polymère monofil) dec.3.5(0)75cm F2820 AigCP-2 26mm1/2	PROLENE	DISPOSITIFS MEDICAUX / Grammes / 0	1577	2050	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2987	C000326	SERINGUE 2 Pièces 	SERINGUE	DISPOSITIFS MEDICAUX / Millilitres / 10ml 21G	77	100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2988	C000327	SERINGUE 2Pièces 	SERINGUE	DISPOSITIFS MEDICAUX / Grammes / 2 ml 23 G	46	60	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2989	C000328	SERINGUE 2Pièces Luer Polypropylène 5ml + Aiguille 21Gx40mm unité	SERINGUE	DISPOSITIFS MEDICAUX / Grammes / 5 ml 21 G	77	100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2990	C000329	SONDE D'ALIMENTATION PEDIATRIQUE en PVC graduée CH10 40cm unité	SONDE D'ALIMENTATION	DISPOSITIFS MEDICAUX / Grammes / CH 10	346	450	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2991	C000330	SONDE D'ALIMENTATION PEDIATRIQUE EN pvc graduée CH6 40cm unité	SONDE D'ALIMENTATION	DISPOSITIFS MEDICAUX / Grammes / CH 6	346	450	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2992	C000331	SONDE DE FOLEY droite 2 voies latex enduct silic CH18 ball 15ml unité	SONDE DE FOLEY	DISPOSITIFS MEDICAUX / Grammes / CH 18	692	900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2993	C000332	SONDE DE FOLEY droite 2 voies  latex enduct silic CH14 ball 15ml unité	SONDE DE FOLEY	DISPOSITIFS MEDICAUX / Grammes / CH 14	692	900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2994	C000333	SONDE DE FOLEY droite 2voies latex enduct silic CH16 ball 15ml unité	SONDE DE FOLEY	DISPOSITIFS MEDICAUX / Grammes / CH16	692	900	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2995	C000334	SONDE URINAIRE de Nelaton Homme en PVC 18 40cm unité	SONDE URINAIRE	DISPOSITIFS MEDICAUX / Grammes / CH 18	385	500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2996	C000335	SPARADRAP Tissé Perforé Sécable 5mx18cm rouleau LEUKOPLAST	SPARADRAP	DISPOSITIFS MEDICAUX / Grammes / 5mx18cm	2523	3280	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2997	C000336	TEST DE GROSSESSE hcg ACON (Quic-Check°)	TEST DE GROSSESSE	DISPOSITIFS MEDICAUX / Grammes / 0	385	500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
2998	C000337	THERMOMETRE MEDICAL unité	thermometre	DISPOSITIFS MEDICAUX / Grammes / 0	385	500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
2999	C000338	TRANSFUSEUR complet avec chamb.et filtre ,site d'inj.en Y+Aig unité	Transfuseur	DISPOSITIFS MEDICAUX / Grammes / 0	346	450	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3000	C000339	TUBERCULINE 10 UI/0,1ML f1/1 DOSES	TUBERCULINE	DISPOSITIFS MEDICAUX / Grammes / 10 UI/0,1ml	385	500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3001	C000340	VICRYL Aig Rde SH plus DEC 3(2/0)1/2C 26mm 75cm JV317	VICRYL Serti	DISPOSITIFS MEDICAUX / Millilitres / (2/0)	1923	2500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3002	C000341	VICRLY Aig Tri déc 4(1)1/2c 40mm 90cm JV486	VICRYL Serti	DISPOSITIFS MEDICAUX / Grammes / -1	1923	2500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3003	C000342	VICRYL BOBINE (Autres déc)	VICRYL BOBINE	DISPOSITIFS MEDICAUX / Grammes / 0	2692	3500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3004	C000343	VICRYL bobine dec 3.5 (0) 250cm JV1207	VICRYL BOBINE	DISPOSITIFS MEDICAUX / Grammes / 0	2692	3500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3005	C000344	VICRYL BOBINE déc4(1)250cm.JV1208	VICRYL BOBINE	DISPOSITIFS MEDICAUX / Grammes / -1	2692	3500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3006	C000345	VICRYL BOBINE déc 5)250 cm JV 1209	VICRYL BOBINE	DISPOSITIFS MEDICAUX / Grammes / -2	2692	3500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3007	C000346	VICRYL Serti (Autres déc)	VICRYL Serti	DISPOSITIFS MEDICAUX / Grammes / 0	1538	2000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3008	C000347	COTON CARDE 500g Unité	COTON	DISPOSITIFS MEDICAUX / Grammes / 500 g	1738	2260	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3009	C000348	COTON CADRE 1000G Unité	COTON	DISPOSITIFS MEDICAUX / Grammes / 1000 G	3700	4810	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3010	C000349	Coton Hydrophyle 100g unité	COTON	DISPOSITIFS MEDICAUX / Grammes / 100g	500	650	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3011	C000350	Coton Hydrophile 500g	COTON	DISPOSITIFS MEDICAUX / Grammes / 500g	1538	2000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3012	C000351	CONCENTRE DE GLOBULES ROUGES UNITE ADULTE (CGRUA)	Concentré de globules rouges unité adulte	PRODUITS SANGUINS ET DERIVES / POCHE / 250ML	4615	6000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3013	C000352	CONCENTRE DE GLOBULES ROUGES UNITE ENFANT (CGRUE)	Concentré de globules rouges unité enfant	PRODUITS SANGUINS ET DERIVES / POCHE / 125ML	2692	3500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3014	C000353	PLASMA FRAIS CONGELE (PFC)	Plasma frais congélé	PRODUITS SANGUINS ET DERIVES / POCHE / 200ML	1538	2000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3015	C000354	CONCENTRE UNITAIRE DE PLAQUETTES (CUP)	concentré unitaire de plaquettes	PRODUITS SANGUINS ET DERIVES / POCHE / 100-150ML	1538	2000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3016	C000355	CONCENTRE STANDARD DE PLAQUETTES (CSP)	Concentré standard de plaquettes	PRODUITS SANGUINS ET DERIVES / POCHE / 250-300ML	4615	6000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3017	C000356	PLASMA RICHE EN PLAQUETTES (PRP)	plasma riche en plaquettes	Dérivés sanguins / Millilitre (s) / 250 ml	1538	2000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3018	C000357	SPARADRAP PERFORE	SPARADRAP	DISPOSITIFS MEDICAUX / Unite (s) / 25 cm	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3019	C000360	MERSUTURE VERT Dec 6	MERSUTURE	DISPOSITIFS MEDICAUX / Gramme (s) / FIL A SUTURE POLYESTER (3)	769	1000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3020	C000361	MERSUTURE VERT Dec 4	MERSUTURE	DISPOSITIFS MEDICAUX / Gramme (s) / FIL A SUTURE POLYESTER  (1)	769	1000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3021	C000362	PHENOBARBITAL	PHENOBARBITAL	ANTI-EPILEPTIQUE / AMPOULE / 40MG	827	1075	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3022	C000365	ARTEMETHER+LUMEFANTRINE (COARTESIANE)	ARTEMETHER 180mg +LUMEFANTRINE 1080mg (Coartesiane) suspension buvable	ANTIPALUDIQUE / Gramme (s) / 180/1080mg	1846	2400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3023	C000366	ARTESUMATE+AMODIAQUINE (Arsucam adulte)	ARTESUNATE + AMODIAQUINE	ANTIPALUDIQUE / Gramme (s) / 50/153mg	831	1080	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3024	C000367	ARTESUNATE+AMODIAQUINE (Arsucam enfant)	ARTESUNATE + AMODIAQUINE	ANTIPALUDIQUE / Gramme (s) / 50/153mg	435	565	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3025	C000368	BISACODYL	BISACODYL	LAXATIF / COMPRIMÉS / 5MG	108	140	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3026	C000369	BROMURE DE CALCIUM SIROP ARMAND	CALCIUM	TROUBLES ELECTROLYTIQUES/SELS MINERAUX / MILLILITRES / 100ML	1346	1750	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3027	C000370	CARBOCYSTEINE 2% SIROP	CARBOCYSTEINE	MUCOLYIQUE / Millilitre (s) / 100ml	912	1185	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3028	C000371	CEFADROXIL 125mg	CEFADROXIL	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 125MG/5ML	1400	1820	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3029	C000372	CEFADROXIL 250mg	CEFADROXIL	ANTIBIOTIQUE BETA-LACTAMINE CEPHALOSPORINE / MILLILITRES / 250MG/5ML	2058	2675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3030	C000373	CHARBON ACTIF	CHARBON ACTIVE	ADSORBANT INTESTINAL / Gramme (s) / 125 MG	115	150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3031	C000374	CHLORAMPHENICOL 500MG INJ	CHLORAMPHENICOL	ANTIBIOTIQUE PHENICOLE / AMPOULE / 500MG	1277	1660	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3032	C000375	CHLORPROMAZINE HCL 25 MG	CHLORPROMAZINE	NEUROLEPTIQUE / COMPRIMÉS / 25MG	88	115	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3033	C000376	CLOMIPRAMINE 	CLOMIPRAMINE	ANTI-DEPRESSEUR / COMPRIMÉS / 10MG	2042	2655	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3034	C000377	CLOMIPRAMINE	CLOMIPRAMINE	ANTI-DEPRESSEUR / AMPOULE / 25MG	269	350	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3035	C000379	CLORAZEPATE (TRANXENE)	CLORAZEPATE	ANXIOLYTIQUE/HYPNOTIQUE / AMPOULE / 50MG	1546	2010	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3036	C000381	CLORAZEPATE DIPOTASSIQUE	CLORAZEPATE	ANXIOLYTIQUE/HYPNOTIQUE / GELULE / 10MG	1377	1790	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3037	C000383	METHYLERGOMETRINE	METHYLERGOMETRINE	OXYTOCIQUES / Millilitre (s) / 0.5MG / ML	100	130	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3038	C000384	NOSCAPINE	NOSCAPINE	ANTITUSSIF / Gramme (s) / 15MG	762	990	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3039	C000385	PARACETAMOL CODEINE CAFEINE	PARACETAMOL CODEINE CAFEINE	ANALGESIQUE/ ANTIPYRETIQUE / Gramme (s) / 500MG	1288	1675	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3040	C000386	PARACETAMOL PEDIATRIQUE	PARACETAMOL	ANALGESIQUE/ANTI-PYRETIQUE P1 / MILLILITRES / 60MG/2ML	454	590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3041	C000388	PROCAINE PENICILLINE 4MUI	PROCAINE PENICILLINE	ANTIBIOTIQUE BETA-LACTAMINE PENECILLINE / AMPOULE / 4MUI	400	520	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3042	C000389	TERPINE CODEINE	TERPINE CODEINE	EXPECTORANT / Gramme (s) / 100 / 10MG	735	955	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3043	C000390	TETRACYCLINE CHLORHYDRATE	TETRACYCLINE	ANTIBIOTIQUE CYCLINE / GELULE / 250MG	231	300	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3044	C000393	AGRAFFE de MICHEL	AGRAFFE de MICHEL	DISPOSITIFS MEDICAUX / Unite (s) / PM	38	50	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3045	C000394	BANDE DE CREPE	BANDE DE CREPE 7 cm x 4 m unité	DISPOSITIFS MEDICAUX / Unite (s) / 7 cm x 4 m	250	325	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3046	C000395	BANDE DE OUATE	BANDE de OUATE synthétique hydrophobe 2,7 m x 10 cm unité	DISPOSITIFS MEDICAUX / Unite (s) / 2,7 CM x 10 M	485	630	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3047	C000396	GANT	GANT d'examen en latex PM, MM ou GM	DISPOSITIFS MEDICAUX / Unite (s) / PM, MM, ou GM, Paire	62	80	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3048	C000397	SERINGUE	SERINGUE à Insuline 100UI 3 Pièces 1 ML + Aig. sertie 29 G X 13 MM Unité	DISPOSITIFS MEDICAUX / Unite (s) / 1 ML 29 G	62	80	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3049	C000398	SONDE à OXYGENE	SONDE à OXYGENE en PVC embout mosse CH 40 cm unité	DISPOSITIFS MEDICAUX / Unite (s) / PM	312	405	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3050	C000399	SONDE DE LEVIN	SONDE DE LEVIN en PVC graduée ORX CH 125cm unité	DISPOSITIFS MEDICAUX / Unite (s) / PM	658	855	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3051	C000402	GANT LATEX PM/MM	GANT d'examen en latex PM/MM	DISPOSITIFS MEDICAUX / Unite (s) / 1 Paire	42	55	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3052	D000002	ACTIMOVE GAUNTLET DROIT-L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5700	7410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3053	D000003	ACTIMOVE GAUNTLET DROIT-M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5700	7410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3054	D000004	ACTIMOVE GAUNTLET DROIT-XL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5700	7410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3055	D000005	ACTIMOVE GAUNTLET DROIT SMALL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5700	7410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3056	D000006	ACTIMOVE GAUNTLET GAUCHE-M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5700	7410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3057	D000007	ACTIMOVE GAUNTLET GAUCHE-L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5700	7410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3058	D000008	ACTIMOVE GAUNTLET GAUCHE-XL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5700	7410	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3059	D000009	ACTIMOVE GAUNTLET GAUCHE SMALL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5700	7410	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3060	D000010	ACTIMOVE GENU ECO CLIPS 30CM U	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	11473	14915	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3061	D000011	ACTIMOVE GENU ECO CLIPS 40CM U	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	11473	14915	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3062	D000012	ACTIMOVE GENU ECO CLIPS 50 M/L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	13469	17510	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3063	D000013	ACTIMOVE GENU ECO CLIPS 50 S/M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	13469	17510	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3064	D000014	ACTIMOVE GENU ECO CLIPS 60 M/L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	14054	18270	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3065	D000015	ACTIMOVE GENU ECO CLIPS 60 S/M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	14054	18270	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3066	D000016	ACTIMOVE GENU ECO CLIPS 70 M/L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	13458	17495	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3067	D000017	ACTIMOVE GENU ECO CLIPS 70 S/M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	15881	20645	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3068	D000018	ACTIMOVE GENU TRI-PANEL 50CM-S	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	16158	21005	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3069	D000019	ACTIMOVE GENU TRI-PANEL 50CM-L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	16158	21005	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3070	D000020	ACTIMOVE GENU TRI-PANEL 60CM-L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	17165	22315	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3071	D000021	ACTIMOVE GENU TRI-PANEL 60CM-S	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	17165	22315	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3072	D000022	ACTIMOVE LOMBACARE L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	33712	43825	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3073	D000023	ACTIMOVE LOMBACARE M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	33712	43825	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3074	D000024	ACTIMOVE LOMBACARE X XL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	33712	43825	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3075	D000025	ACTIMOVE LOMBACARE XL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	33712	43825	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3076	D000026	ACTIMOVE LUMBAL-L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	10392	13510	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3077	D000027	ACTIMOVE LUMBAL-M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	10392	13510	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3078	D000028	ACTIMOVE LUMBAL-S	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	10392	13510	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3079	D000029	ACTIMOVE LUMBAL-XL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	10392	13510	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3080	D000030	ACTIMOVE LUMBAL-XXXL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	11438	14870	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3081	D000031	ACTIMOVE LUMBAL XXL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	11438	14870	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3082	D000032	ACTIMOVE MANUS DROIT-L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4542	5905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3083	D000033	ACTIMOVE MANUS DROIT-M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4542	5905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3084	D000034	ACTIMOVE MANUS DROIT S	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4542	5905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3086	D000036	ACTIMOVE MANUS GAUCHE L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4542	5905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3087	D000037	ACTIMOVE MANUS GAUCHE M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4542	5905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3088	D000038	ACTIMOVE MANUS GAUCHE S	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4542	5905	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3089	D000039	ACTIMOVE MANUS GAUCHE XL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4542	5905	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3090	D000040	ACTIMOVE MITELLA CONFORT L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4323	5620	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3091	D000041	ACTIMOVE MITELLA CONFORT M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4323	5620	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3092	D000042	ACTIMOVE MITELLA CONFORT S	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4323	5620	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3093	D000043	ACTIMOVE MITELLA CONFORT XL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4323	5620	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3094	D000044	ACTIMOVE PTKD	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	6408	8330	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3095	D000045	ACTIMOVE SLING & SWATHE L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	11708	15220	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3096	D000046	ACTIMOVE SLING & SWATHE M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	10442	13575	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3097	D000047	ACTIMOVE SLING & SWATHE S	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	9185	11940	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3098	D000048	ACTIMOVE TALOCAST GAUCHE	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	13619	17705	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3099	D000049	ACTIMOVE TALOCASTE DROIT	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	13619	17705	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3100	D000050	ACTIMOVE UMERUS CONFORT L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	6662	8660	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3101	D000051	ACTIMOVE UMERUS CONFORT M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	6662	8660	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3102	D000052	ACTIMOVE UMERUS CONFORT S	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	6662	8660	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3103	D000053	ACTIMOVE UMERUS CONFORT XL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	6662	8660	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3143	D000095	PLAQUE D.C.P SMALL	PLAQUE	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	53846	70000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3104	D000054	ACTIMOVE CERVICAL CONFORT XXL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4354	5660	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3105	D000055	ACTIMOVE CERVICAL CONFORT L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4354	5660	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3106	D000056	ACTIMOVE CERVICAL CONFORT M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4354	5660	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3107	D000057	ACTIMOVE CERVICAL CONFORT S	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4354	5660	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3108	D000058	ACTIMOVE CERVICAL CONFORT XL	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4354	5660	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3109	D000059	ACTIMOVE CERVICAL CONFORT XS	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4354	5660	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3110	D000060	ACTIMOVE CLAVICULA L	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4938	6420	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3111	D000061	ACTIMOVE CLAVICULA M	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4435	5765	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3112	D000062	ACTIMOVE CLAVICULA P	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	3531	4590	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3113	D000063	ACTIMOVE CLAVICULA S	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	3827	4975	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3114	D000064	ACTIMOVE FIXATION-LA PAIRE	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4404	5725	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3115	D000065	COMPRINET PRO T7	COMPRINET	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5804	7545	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3116	D000066	COMPRINET PRO T8	COMPRINET	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5804	7545	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3117	D000067	COMPRINET PRO LG/REG T6	COMPRINET	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5804	7545	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3118	D000068	COMPRINET PRO LN/REG T5	COMPRINET	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5804	7545	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3119	D000069	COMPRINET PRO MED IREG T3	COMPRINET	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5804	7545	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3120	D000070	COMPRINET PRO MED LNG T4	COMPRINET	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5804	7545	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3121	D000071	TRICODUR GENU BLEU/BLC L	TRICODUR	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	22715	29530	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3122	D000072	TRICODUR GENU BLEU/BLC M	TRICODUR	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	22715	29530	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3123	D000073	TRICODUR GENU BLEU/BLC S	TRICODUR	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	22715	29530	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3124	D000074	TRICODUR TALUS BLEU/BLC D L	TRICODUR	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	18746	24370	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3125	D000075	TRICODUR TALUS BLEU/BLC D M	TRICODUR	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	18746	24370	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3126	D000076	TRICODUR TALUS BLEU/BLC D S	TRICODUR	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	18746	24370	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3127	D000077	TRICODUR TALUS BLEU/BLC G S	TRICODUR	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	18746	24370	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3128	D000078	TRICODUR TALUS BLEU/BLC G L	TRICODUR	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	18746	24370	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3129	D000079	TRICODUR TALUS BLEU/BLC G M	TRICODUR	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	18746	24370	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3130	D000080	ACTIMOVE UMERUS CONFORT XS	ACTIMOVE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	6662	8660	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3131	D000081	PROTHESE TOTALE SANS CIMENT	PROTHESE	DISPOSITIFS MEDICAUX / Gramme (s) / 0	1315385	1710000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3132	D000082	PROTHESE TOTALE AVEC CIMENT	PROTHESE	DISPOSITIFS MEDICAUX / Gramme (s) / 0	934615	1215000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3133	D000083	PLAQUE D.C.S	PLAQUE	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	164923	214400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3134	D000084	LAME PLAQUE 130°	LAME PLAQUE	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	150000	195000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3135	D000085	LAME PLAQUE 95°	LAME PLAQUE	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	150000	195000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3136	D000088	PLAQUE D.H.S	PLAQUE	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	141846	184400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3137	D000089	CLOU UNIVERSEL D'OSTEOSYNTHESE VERROUILLE AVEC VIS DE VERROUILLE	CLOU FEMUR AVEC VIS	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	128846	167500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3138	D000090	CLOU UNIVERSEL D'OSTEOSYNTHESE VERROUILLE AVEC VIS DE VERROUILLE 2	CLOU TIBIA AVEC VIS	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	128846	167500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3139	D000091	PROTHESE PARTIELLE (DE THOMPSON)	PROTHESE	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	121538	158000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3140	D000092	PROTHESE PARTIELLE (DE MOORE)	PROTHESE	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	120385	156500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3141	D000093	PLAQUE D.C.P ETROITE	PLAQUE	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	53846	70000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3142	D000094	PLAQUE D.C.P LARGE	PLAQUE	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	53846	70000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3144	D000099	1/3 TUBES	TUBE	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	43846	57000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3145	D000100	CLOU D'OSTEOSYNTHESE DE KUNTSHCHER	CLOU	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	42769	55600	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3146	D000106	FLEXOBANDE	BANDE DE COMPRESSION A ALLONGEMENT LONG	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	12692	16500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3147	D000110	VIS SPONGIEUSE	VIS	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	8769	11400	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3148	D000111	VIS MALLEOLAIRE	VIS	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	8308	10800	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3149	D000113	JERSEY COTON	COTON HYDROFUGE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	7135	9275	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3150	D000115	COMPRINET PRO (Bas cuisse)	BAS MEDICAL DE COMPRESSION	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5804	7545	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3151	D000116	DELTA LITE PLUS	BANDE DE RESINE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	5362	6970	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3152	D000117	CUTICELL CLASSIC	PANSEMENT GRAS STERILE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4573	5945	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3153	D000118	COMPRILAN	BANDE DE COPRESSION A ALLONGEMENT COURT	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	4560	5928	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3154	D000122	VIS CORTICALE	VIS	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	4231	5500	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3155	D000125	LEUCKOPLAST S	SPARADRAP TRADITIONNEL	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	3077	4000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3156	D000127	CUTISORB ABSORB	PANSEMENT ABSORBANT	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	2585	3360	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3157	D000128	TENSOPLAST	BANDE DE CONTENTION ELASTIQUE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	2465	3205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3158	D000129	BROCHES DE KIRSCHNER	BROCHES	DISPOSITIFS MEDICAUX / Millilitre (s) / 0	2308	3000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3159	D000132	CUTIMED GEL	PANSEMENT HYDROGEL	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	2088	2715	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3160	D000133	BIPLATRIX	bande platrée	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	1958	2545	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3161	D000135	STRAPPAL	BANDE DE CONTENTION NON ELASTIQUE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	1900	2470	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3162	D000141	HYPAFIX Sparadrap hypoallergenique	SPARADRAP HYPOALLERGENIQUE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	1119	1455	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3163	D000142	EASIFIX COHESIVE	ELASTOMUL HAFT	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	1088	1415	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3164	D000144	SOFFBAN PLUS	COTON CARDE SYNTHETIQUE	DISPOSITIFS MEDICAUX / Millilitre (s) / PM	773	1005	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3165	D000147	CREPESSAN LITE Bande crepe en coton	BANDE DE CREPE	DISPOSITIFS MEDICAUX / Metre (s) / PM	431	560	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3166	D000157	BABYHALER CHAMBRE D'INHALATION BB ET ENFT	BABYHALER CHAMBRE D'INHALATION	DISPOSITIFS MEDICAUX / Unite (s) / PM	16388	21305	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3167	D000160	PHIL-CAST / BANDE DE RESINE	PHIL-CAST	DISPOSITIFS MEDICAUX / Metre (s) / 10 cm x 3,6 m	4423	5750	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3168	D000162	SOFBAN / BANDE DE PROTECTION	SOFBAN	DISPOSITIFS MEDICAUX / Metre (s) / 2,7 m x 10 cm	429	558	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3169	D000163	STERICRIN 2/0 CT 3/8/ Fil de suture en polyamide bleu	STERICRIN	DISPOSITIFS MEDICAUX / Metre (s) / PM	731	950	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3170	D000164	STERIDEK 2/0 CR 3/8 26 MM/ FIL DE SUTURE EN POLYESTER	STERIDEK	DISPOSITIFS MEDICAUX / Metre (s) / PM	1308	1700	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3171	D000165	STERIFIL JERSEY / Jersey médical	STERIFIL JERSEY	DISPOSITIFS MEDICAUX / Metre (s) / 10 cm x 25 m	2058	2675	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3172	D000168	STERILIN 2/0 3/8 26 MM/ Fil de suture en lin beige	STERILIN	DISPOSITIFS MEDICAUX / Metre (s) / PM	731	950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3173	D000169	STERISILK 1 CT 3/2 32 MM/Fil de suture en soie tressée	STERISILK	DISPOSITIFS MEDICAUX / Metre (s) / PM	927	1205	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3174	D000170	STERISILK 2/ 0 CR 3/ 8 25 MM/ Fil de suture en soie tressée	STERISILK	DISPOSITIFS MEDICAUX / Metre (s) / PM	927	1205	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3175	D000171	STERIXYL 0 CT 3/8 25 MM / Fil de suture en acide polyglycolique	STERIXYL	DISPOSITIFS MEDICAUX / Metre (s) / PM	1615	2100	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3176	D000172	STERIXYL 1 CR 4/8 36 MM / Fil de suture en acide polyglycolique	STERIXYL	DISPOSITIFS MEDICAUX / Metre (s) / PM	1615	2100	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3177	D000173	URGO STRAPPIN / BANBE STRAPPING	URGO STRAPPIN	DISPOSITIFS MEDICAUX / Metre (s) / 2,5 m x 6cm	1881	2445	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3178	D000174	URGO STRAPPIN / BANDE STRAPPING	URGO STRAPPIN	DISPOSITIFS MEDICAUX / Metre (s) / 2,5 m x10 cm	2884	3749	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3179	D000176	CATHETER POUR HEMODIALYSE PERMANENT	CATHETER	DM / Unite (s) / 0	153846	200000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3180	D000177	CATHETER POUR HEMODIALYSE NON PERMANENT	CATHETER	DM / Unite (s) / 0	38462	50000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3181	D000178	KIT IMPLANTS N°1	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	38462	50000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3182	D000179	KIT IMPLANTS N°2	IMPLANTS	DISPOSITIFS MEDICAUX /  / 0	76923	100000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3183	D000180	KIT IMPLANTS N°3	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	115385	150000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3184	D000181	KIT IMPLANTS N°4	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	153846	200000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3185	D000182	KIT IMPLANTS N°5	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	192308	250000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3186	D000183	KIT IMPLANTS N°6	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	230769	300000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3187	D000184	KIT IMPLANTS N°7	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	269231	350000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3188	D000185	KIT IMPLANTS N°8	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	307692	400000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3189	D000186	KIT IMPLANTS N°9	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	346154	450000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3190	D000187	KIT IMPLANTS N°10	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	384615	500000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3191	D000188	KIT IMPLANTS N°11	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	423077	550000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3192	D000189	KIT IMPLANTS N°12	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	461538	600000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3193	D000190	KIT IMPLANTS N°13	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	500000	650000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3194	D000191	KIT IMPLANTS N°14	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	538462	700000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3195	D000192	KIT IMPLANTS N°15	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	576923	750000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3196	D000193	KIT IMPLANTS N°16	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	615385	800000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3197	D000194	KIT IMPLANTS N°17	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	653846	850000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3198	D000195	KIT IMPLANTS N°18	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	692308	900000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3199	D000196	KIT IMPLANTS N°19	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	730769	950000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3200	D000197	KIT IMPLANTS N°20	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	769231	1000000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3201	D000198	KIT IMPLANTS N°21	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	807692	1050000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3202	D000199	KIT IMPLANTS N°22	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	846154	1100000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3203	D000200	KIT IMPLANTS N°23	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	884615	1150000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3204	D000201	KIT IMPLANTS N°24	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	923077	1200000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3205	D000202	KIT IMPLANTS N°25	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	961538	1250000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3206	D000203	KIT IMPLANTS N°26	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1000000	1300000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3207	D000204	KIT IMPLANTS N°27	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1038462	1350000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3208	D000205	KIT IMPLANTS N°28	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1076923	1400000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3209	D000206	KIT IMPLANTS N°29	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1115385	1450000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3210	D000207	KIT IMPLANTS N°30	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1153846	1500000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3211	D000208	KIT IMPLANTS N°31	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1192308	1550000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3212	D000209	KIT IMPLANTS N°32	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1230769	1600000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3213	D000210	KIT IMPLANTS N°33	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1269231	1650000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3214	D000211	KIT IMPLANTS N°34	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1307692	1700000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3215	D000212	KIT IMPLANTS N°35	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1346154	1750000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3216	D000213	KIT IMPLANTS N°36	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1384615	1800000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3217	D000214	KIT IMPLANTS N°37	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1423077	1850000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3218	D000215	KIT IMPLANTS N°38	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1461538	1900000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3219	D000216	KIT IMPLANTS N°39	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1500000	1950000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3220	D000217	KIT IMPLANTS N°40	IMPLANTS	DISPOSITIFS MEDICAUX / Unite (s) / 0	1538462	2000000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3221	D000218	BANDE DE CREPE LABELL	BANDE	DISPOSITIFS MEDICAUX /  / 10CM X 4M	442	575	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3222	D000222	BANDE DE CREPPE LABELL	BANDE	DISPOSITIFS MEDICAUX /  / 5cm x 4m	250	325	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3223	D000224	BANDE DE GAZE HYDROPHILE LABELL	BANDE	DISPOSITIFS MEDICAUX /  / 5cm X 3m	36	47	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3224	D000230	COMPRESSE DE GAZE STERILE LABELL	COMPRESSE	DISPOSITIFS MEDICAUX /  / 20x20	373	485	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3225	D000233	COTON CARDE LABELL	COTON	DISPOSITIFS MEDICAUX /  / 500G	2423	3150	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3226	D000234	COTON HYDROPHILE LABELL	COTON	DISPOSITIFS MEDICAUX /  / 1000G	5596	7275	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3227	D000238	GANT CHIR LATEX STERILE LABELL	GANT	DISPOSITIFS MEDICAUX /  / n°7.5	242	315	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3228	D000240	GANT D'EXAMEN LATEX LABELL PM	GANT	DISPOSITIFS MEDICAUX /  / n°6/7	3977	5170	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3229	D000241	GANT D'EXAMEN LATEX LABELL MM	GANT	DISPOSITIFS MEDICAUX /  / n°7/8	4104	5335	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3230	D000242	GANT D'EXAMEN LATEX LABELL GM	GANT	DISPOSITIFS MEDICAUX /  / n°8/9	4492	5840	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3231	D000246	MICROPERFUSEUR (EPICRANIENNE) LABELL	MICROPERFUSEUR	DISPOSITIFS MEDICAUX /  / 21G	96	125	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3232	D000250	TRANSFUSEUR LABELL	Transfuseur	DISPOSITIFS MEDICAUX /  / transfuseur	308	400	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3233	D000251	TRANSFUSEUR LABELL EN Y	Transfuseur	DISPOSITIFS MEDICAUX /  / transfuseur en y	219	285	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3234	D000254	CHAMBRE D'INHALATION BB, NRS et Enft	CHAMBRE D'INHALATION	DISPOSITIFS MEDICAUX / Unite (s) / PM	10385	13500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3235	D000255	CHAMBRE D'INHALATION Adulte	CHAMBRE D'INHALATION	DISPOSITIFS MEDICAUX / Unite (s) / PM	12073	15695	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3236	D000256	CANULE DE TRACHEOTOMIE Narang	CANULE DE TRACHEOTOMIE	DISPOSITIFS MEDICAUX / Unite (s) / 0	13846	18000	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3237	D000258	LAME DE DERMATOME Narang	LAME DE DERMATOME	DISPOSITIFS MEDICAUX / Unite (s) / 0	19231	25000	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3238	D000259	BANDE DE CREPE TETRA	BANDE DE CREPE	DISPOSITIFS MEDICAUX / Unite (s) / 4MX20CM	385	500	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3239	D000261	BANDE DE CREPE TETRA OTC	BANDE DE CREPE	DISPOSITIFS MEDICAUX / 4Unite (s) / 4MX10CM	331	430	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3240	D000262	BANDE DE CREPE OTC	BANDE DE CREPE	DISPOSITIFS MEDICAUX / Unite (s) / 4MX7CM	250	325	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3241	D000264	BANDE EXTENSIBLE TETRA	bande elastique	DISPOSITIFS MEDICAUX / Unite (s) / 4M X 20CM	238	310	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3242	D000269	COMPRESSE TETRA NON TISSEE STERILE	COMPRESSE STERILE	DISPOSITIFS MEDICAUX / Unite (s) / 10CM X 10CM	400	520	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3243	D000271	COMPRESSE GAZE STERILES TETRA	COMPRESSE STERILE	DISPOSITIFS MEDICAUX / Unite (s) / 20CM X 20CM	204	265	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3244	D000272	COMPRESSES GAZE STERILES TETRA	COMPRESSE STERILE	DISPOSITIFS MEDICAUX / Unite (s) / 30CM X 30CM	358	465	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3245	D000274	COTON TETRA ZIG ZAG	COTON HYDROPHILE	DISPOSITIFS MEDICAUX / Unite (s) / 100 G	646	840	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3246	D000275	TETRABANDE CONTENTION CHAIR	BANDE DE COMPRESSION	CONSOMMABLES CHIRURGICAUX / Unite (s) / 3,5M X 10 CM	3365	4375	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3247	D000277	TETRATUL STERILE 10 X 10 B/10	TULLE GRAS	CONSOMMABLES CHIRURGICAUX / Unite (s) / 10CM X 10CM	1300	1690	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3248	D000278	TETRAPLAIE STERILE	PANSEMENT	CONSOMMABLES CHIRURGICAUX / Unite (s) / 5CM X 7,2CM	808	1050	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3249	D000281	TETRASTRAP	BANDE ADHESIVE ELASTIQUE HYPOALLERGENIQUE	CONSOMMABLES CHIRURGICAUX / Unite (s) / 2,5M X 10CM	3808	4950	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3250	D000284	BETAPLAST N	PANSEMENT HYDROCELLULAIRE OU PANSEMENT ABSORBANT	CONSOMMABLES CHIRURGICAUX / Unite (s) / 10CM X 10CM	1415	1840	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3251	D000286	BETAPLAST H	PANSEMENT HYDROCOLLOIDE	CONSOMMABLES CHIRURGICAUX / Unite (s) / 10CM X 10CM	773	1005	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3252	D000287	BEST CAST TAILLE 2	BANDE DE RESINE	DISPOSITIFS MEDICAUX / Unite (s) / 3,6M X 5CM	2731	3550	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3253	D000288	BEST CAST TAILLE 3	BANDE DE RESINE	DISPOSITIFS MEDICAUX / Unite (s) / 3,6M X 7,5 CM	3365	4375	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
3254	D000289	BEST CAST TAILLE 4	BANDE DE RESINE	DISPOSITIFS MEDICAUX / Unite (s) / 3,6 M X 10 CM	4504	5855	5	100	1	t	2	2023-08-18 10:06:00	2023-08-18 10:06:00	Perissable	1	1	5	50
3255	D000290	BEST CAST TAILLE 5	BANDE DE RESINE	DISPOSITIFS MEDICAUX / Unite (s) / 3,6M X 12,5CM	5012	6515	5	100	1	t	2	2023-10-02 23:03:00	2023-10-02 23:03:00	Perissable	1	1	5	50
32561	aaaa	aaaa	aa	aa	56	1000	10	60	1	t	2	2023-11-10 10:15:03	2023-11-10 10:15:38	Perissable	1	1	0	0
32571	\N	aaabbb	aaabbb	aaabbb	1000	2000	1	90	1	t	2	2023-11-10 11:06:15	2023-11-10 11:06:15	\N	\N	\N	0	0
325813	aa	aaliib	aaliib	aa	456	500	5	200	13	f	2	2023-12-13 11:21:36	2023-12-13 11:22:58	Non_Perissable	1	1	0	0
\.


--
-- TOC entry 3577 (class 0 OID 16837)
-- Dependencies: 269
-- Data for Name: profil_users; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.profil_users (id, profil_id, user_id, created_at, updated_at) FROM stdin;
11	24	7	2023-11-23 14:27:44	2023-11-23 14:27:44
12	25	3	2023-11-23 14:28:04	2023-11-23 14:28:04
17	28	4	2023-11-23 14:30:15	2023-11-23 14:30:15
20	27	24	2023-11-24 13:02:49	2023-11-24 13:02:49
23	27	25	2023-11-24 13:07:00	2023-11-24 13:07:00
31	25	26	2023-11-25 16:11:20	2023-11-25 16:11:20
56	29	38	2023-12-13 10:45:17	2023-12-13 10:45:17
63	28	43	2023-12-26 15:16:16	2023-12-26 15:16:16
67	28	44	2023-12-26 15:52:10	2023-12-26 15:52:10
68	28	16	2023-12-26 15:55:22	2023-12-26 15:55:22
69	28	20	2023-12-28 16:05:30	2023-12-28 16:05:30
70	28	19	2023-12-28 16:38:26	2023-12-28 16:38:26
71	28	5	2023-12-28 16:38:57	2023-12-28 16:38:57
73	26	9	2024-01-27 16:22:32	2024-01-27 16:22:32
74	28	10	2024-01-27 16:24:55	2024-01-27 16:24:55
75	23	33	2024-01-27 18:01:42	2024-01-27 18:01:42
76	28	18	2024-01-27 18:02:49	2024-01-27 18:02:49
\.


--
-- TOC entry 3579 (class 0 OID 16842)
-- Dependencies: 271
-- Data for Name: profils; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.profils (profil_id, nom, statut, created_at, updated_at) FROM stdin;
23	Comptable	t	2023-11-14 16:21:24	2023-11-14 16:21:24
24	Pharmacien	t	2023-11-14 17:02:26	2023-11-14 17:02:26
25	Caissier(e)	t	2023-11-16 09:27:11	2023-11-19 13:29:40
26	Administrateur	t	2023-11-19 13:36:30	2023-11-19 13:36:30
27	Personnel SI	t	2023-11-22 17:44:19	2023-11-22 17:44:19
28	Personnel DPS	t	2023-11-22 17:45:05	2023-11-22 17:45:05
29	Administrateur FS	t	2023-12-13 09:50:03	2023-12-13 09:50:03
\.


--
-- TOC entry 3581 (class 0 OID 16847)
-- Dependencies: 273
-- Data for Name: reception_dps; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.reception_dps (reception_dps_id, code, date_reception, montant, etat, commande_id, user_id, centre_id, dps_id, created_at, updated_at, etat_liv) FROM stdin;
\.


--
-- TOC entry 3583 (class 0 OID 16855)
-- Dependencies: 275
-- Data for Name: reception_sis; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.reception_sis (reception_si_id, code, date_reception, etat_liv, commande_id, user_id, centre_id, created_at, updated_at, taux_liv, taux_tr) FROM stdin;
32	001REC1120231	2023-11-04	Transferee	26	1	1	2023-11-04 18:25:49	2023-11-04 18:25:49	100	0
33	001REC1120232	2023-11-09	Transferee	28	2	5	2023-11-09 18:26:59	2023-11-09 18:26:59	100	0
34	001REC1120233	2023-11-09	Transferee	29	3	2	2023-11-09 18:57:12	2023-11-09 18:57:12	100	0
35	002REC1120231	2023-11-09	Transferee	27	1	1	2023-11-09 19:10:39	2023-11-09 19:10:39	100	0
36	003REC1120231	2023-11-10	Transferee	30	1	1	2023-11-10 11:15:06	2023-11-10 11:15:06	91	0
37	004REC1120231	2023-11-10	Transferee	30	1	1	2023-11-10 11:15:14	2023-11-10 11:15:14	100	0
38	001REC1120237	2023-11-10	Transferee	31	7	7	2023-11-10 12:44:01	2023-11-10 12:44:01	100	0
\.


--
-- TOC entry 3585 (class 0 OID 16865)
-- Dependencies: 277
-- Data for Name: receptions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.receptions (reception_id, code, date_reception, montant, etat, user_id, centre_id, created_at, updated_at, commande_id, magasin_id) FROM stdin;
46	001REC11202311	2023-11-04	1202961.00	Livree	1	1	2023-11-04 18:28:17	2023-11-04 18:28:17	26	3
47	001REC11202325	2023-11-09	3101520.00	Livree	2	5	2023-11-09 18:27:35	2023-11-09 18:27:35	28	9
48	001REC11202332	2023-11-09	2196777.00	Livree	3	2	2023-11-09 18:57:55	2023-11-09 18:57:55	29	7
49	002REC11202311	2023-11-09	259187.00	Livree	1	1	2023-11-09 19:11:01	2023-11-09 19:11:01	27	3
50	003REC11202311	2023-11-10	127341.00	Partielle	1	1	2023-11-10 11:16:16	2023-11-10 11:16:16	30	3
51	001REC11202377	2023-11-10	89588.00	Livree	7	7	2023-11-10 12:44:38	2023-11-10 12:44:38	31	13
\.


--
-- TOC entry 3587 (class 0 OID 16874)
-- Dependencies: 279
-- Data for Name: reglements; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.reglements (reglement_id, date_reglement, montant_reglement, vente_id, user_id, centre_id, created_at, updated_at, reglement_source, dps_id) FROM stdin;
1	2023-11-01	6616	6	1	1	2023-11-01 20:04:23	2023-11-01 20:04:23	Vente	1
2	2023-11-01	6616	7	1	1	2023-11-01 21:19:28	2023-11-01 21:19:28	Vente	1
3	2023-11-01	4800	8	1	1	2023-11-01 21:21:10	2023-11-01 21:21:10	Vente	1
4	2023-11-02	3440	9	1	1	2023-11-02 00:09:22	2023-11-02 00:09:22	Vente	1
5	2023-11-02	6160	10	1	1	2023-11-02 00:38:11	2023-11-02 00:38:11	Vente	1
6	2023-11-02	4275	11	1	1	2023-11-02 00:39:11	2023-11-02 00:39:11	Vente	1
7	2023-11-02	744	12	1	1	2023-11-02 16:31:02	2023-11-02 16:31:02	Vente	1
8	2023-11-02	0	13	1	1	2023-11-02 16:31:29	2023-11-02 16:31:29	Vente	1
9	2023-11-02	1056	14	1	1	2023-11-02 16:31:53	2023-11-02 16:31:53	Vente	1
10	2023-11-02	0	15	1	1	2023-11-02 16:33:44	2023-11-02 16:33:44	Vente	1
11	2023-11-02	0	16	1	1	2023-11-02 17:06:41	2023-11-02 17:06:41	Vente	1
12	2023-11-03	572	18	1	1	2023-11-03 10:27:21	2023-11-03 10:27:21	Vente	1
13	2023-11-07	2860	19	1	1	2023-11-07 16:43:21	2023-11-07 16:43:21	Vente	1
14	2023-11-08	43800	20	1	1	2023-11-08 22:16:52	2023-11-08 22:16:52	Vente	1
15	2023-11-09	8245	21	3	2	2023-11-09 18:59:15	2023-11-09 18:59:15	Vente	1
16	2023-11-09	26130	22	1	1	2023-11-09 19:12:14	2023-11-09 19:12:14	Vente	1
17	2023-11-10	4430	23	7	7	2023-11-10 12:45:27	2023-11-10 12:45:27	Vente	1
18	2023-11-10	16795	24	7	7	2023-11-10 12:46:08	2023-11-10 12:46:08	Vente	1
19	2023-11-10	700	25	7	7	2023-11-10 12:46:50	2023-11-10 12:46:50	Vente	1
20	2023-11-10	0	26	7	7	2023-11-10 12:47:13	2023-11-10 12:47:13	Vente	1
21	2023-11-24	26130	27	26	1	2023-11-24 16:43:51	2023-11-24 16:43:51	Vente	1
\.


--
-- TOC entry 3589 (class 0 OID 16883)
-- Dependencies: 281
-- Data for Name: sorties; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.sorties (sortie_id, code, date, motif, cout, mag_num, user_id, centre_id, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3591 (class 0 OID 16891)
-- Dependencies: 283
-- Data for Name: stock_produits; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.stock_produits (stock_produit_id, produit_id, libelle, lot, magasin_id, centre_id, qte, date_peremption, created_at, updated_at, etat, qtea, dps_id) FROM stdin;
119	801	ABUFENE	\N	3	1	10	\N	2023-11-09 19:11:01	2023-11-09 19:11:39	Encours	23	1
120	1196	DIPICOR	\N	3	1	8	\N	2023-11-09 19:11:01	2023-11-09 19:11:39	Encours	23	1
121	801	ABUFENE	\N	4	1	6	\N	2023-11-09 19:11:25	2023-11-09 19:12:14	Encours	7	1
122	1196	DIPICOR	\N	4	1	10	\N	2023-11-09 19:11:25	2023-11-09 19:12:14	Encours	12	1
125	32571	aaabbb	\N	3	1	0	\N	2023-11-10 11:16:16	2023-11-10 11:16:16	Encours	0	1
126	1144	LAROXYL	\N	3	1	13	\N	2023-11-10 11:16:16	2023-11-10 11:16:16	Encours	13	1
127	3048	SERINGUE	09	3	1	45	2023-11-11	2023-11-10 11:16:16	2023-11-10 11:16:16	Encours	45	1
128	123	PANADOL	\N	3	1	90	0025-01-01	2023-11-10 11:16:16	2023-11-10 11:16:16	Encours	90	1
130	3048	SERINGUE	\N	13	7	41	\N	2023-11-10 12:44:38	2023-11-10 12:46:08	Encours	45	1
132	1653	CEFTRIAXONE	\N	13	7	9	\N	2023-11-10 12:44:38	2023-11-10 12:46:08	Encours	13	1
131	973	ANALGIN	\N	13	7	13	\N	2023-11-10 12:44:38	2023-11-10 12:46:50	Encours	20	1
129	286	DACRYOSERUM	\N	13	7	18	\N	2023-11-10 12:44:38	2023-11-10 12:47:13	Encours	23	1
123	801	ABUFENE	\N	5	1	5	\N	2023-11-09 19:11:39	2023-11-24 16:43:50	Encours	6	1
124	1196	DIPICOR	\N	5	1	1	\N	2023-11-09 19:11:39	2023-11-24 16:43:51	Encours	3	1
\.


--
-- TOC entry 3593 (class 0 OID 16901)
-- Dependencies: 285
-- Data for Name: stocks; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.stocks (created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3594 (class 0 OID 16904)
-- Dependencies: 286
-- Data for Name: transfert_dps; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.transfert_dps (transfert_dps_id, code, date_transfert, user_id, centre_id, created_at, updated_at, dps_id, reception_dps_id, observation, etat, commande_id) FROM stdin;
\.


--
-- TOC entry 3596 (class 0 OID 16915)
-- Dependencies: 288
-- Data for Name: transfert_sis; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.transfert_sis (transfert_si_id, code, date_transfert, user_id, centre_id, created_at, updated_at, reception_si_id, observation, etat, commande_id) FROM stdin;
29	001TR1120231	2023-11-04	1	1	2023-11-04 18:25:58	2023-11-04 18:25:58	32	\N	Livree	26
30	001TR1120232	2023-11-09	2	5	2023-11-09 18:27:08	2023-11-09 18:27:08	33	\N	Livree	28
31	001TR1120233	2023-11-09	3	2	2023-11-09 18:57:22	2023-11-09 18:57:22	34	\N	Livree	29
32	002TR1120231	2023-11-09	1	1	2023-11-09 19:10:47	2023-11-09 19:10:47	35	\N	Livree	27
33	003TR1120231	2023-11-10	1	1	2023-11-10 11:15:25	2023-11-10 11:15:25	36	\N	Encours	30
34	004TR1120231	2023-11-10	1	1	2023-11-10 11:15:30	2023-11-10 11:15:30	37	\N	Encours	30
35	001TR1120237	2023-11-10	7	7	2023-11-10 12:44:11	2023-11-10 12:44:11	38	\N	Livree	31
\.


--
-- TOC entry 3598 (class 0 OID 16923)
-- Dependencies: 290
-- Data for Name: transferts; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.transferts (transfert_id, code, date, source, destination, user_id, centre_id, created_at, updated_at, cout, source_id, destination_id) FROM stdin;
11	001TR11202325	2023-11-09	9	10	2	5	2023-11-09 18:32:28	2023-11-09 18:32:28	0	\N	\N
12	002TR11202325	2023-11-09	9	11	2	5	2023-11-09 18:33:09	2023-11-09 18:33:09	0	\N	\N
13	001TR11202332	2023-11-09	7	8	3	2	2023-11-09 18:58:39	2023-11-09 18:58:39	0	\N	\N
14	001TR11202311	2023-11-09	3	4	1	1	2023-11-09 19:11:25	2023-11-09 19:11:25	0	\N	\N
15	002TR11202311	2023-11-09	3	5	1	1	2023-11-09 19:11:39	2023-11-09 19:11:39	0	\N	\N
\.


--
-- TOC entry 3600 (class 0 OID 16929)
-- Dependencies: 292
-- Data for Name: usercons; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.usercons (created_at, updated_at, id) FROM stdin;
\.


--
-- TOC entry 3601 (class 0 OID 16932)
-- Dependencies: 293
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.users (id, name, email, email_verified_at, password, remember_token, created_at, updated_at, centre_id, statut, profil_id, dps_id, type) FROM stdin;
7	FOLY Emmaluela	njei	\N	$2y$10$XSUpWTTmgPxyEM5u76VeD.s4/FxUW804fTpeV81f60CMhLBpZHSym	\N	\N	2023-11-23 14:27:44	7	t	1	3	USER
3	ISSA ABALO	nadoba	\N	$2y$10$K8iem67G0bWwo7R.lwC7wuvuWTnYoknSR/vxCk7cxayPmbuNdsjVy	\N	\N	2023-11-23 14:28:04	3	t	1	4	USER
1	KAO ELOM	adabawere	\N	$2y$10$xByyknMMb7kVSFOyMnz/cegUJrw4LcNV1juq/ucfw/.iaZLTK8ubO	\N	2023-08-01 12:48:14	2023-08-01 12:48:14	1	t	1	1	USER
2	KADER KOSSI	bangeli	\N	$2y$10$C26ArcZ0EgEksYUgtJMcAugvHMTIilVk2UMBwPhKISWOug/cI09zi	\N	2023-08-08 08:54:36	2023-08-08 08:54:36	2	t	1	1	USER
6	MANAN Beatrice	sarakawa	\N	$2y$10$NR8SXf3Qwt0vU6401cjlUu3RI5aQgEOfAJR/GyRkRPPlhv7eXHNDe	\N	\N	\N	6	t	1	1	USER
8	TOURE Sadia	naware	\N	$2y$10$wRIxwI6C6q0Z5CVUZvnF0edxb/iDZZcZr49hTB/sQBefURyHTi2LG	\N	\N	\N	8	t	1	1	USER
4	KOUTOUMNA	kpindi	\N	$2y$10$qqtsQ17GZjH62Pi.n/AIuOhOA8VEGobZAXBCP3EJeuCDRg0kJ2som	\N	\N	2023-11-23 14:30:15	4	t	1	1	USER
43	esso	esso	\N	$2y$10$oAcd7GeMFzMCef4hbGM17eXrTiLgoOzuNxa6B8y.SjaEzzIyDBMvy	\N	2023-12-26 15:16:16	2023-12-26 15:16:16	16	t	\N	1	DPS
27	Mme	mme	\N	$2y$10$wPdka4q7nMEDzKnsVhesAOpGp0VMQ1PuazuJsRidXiWpbZZB8GnTO	\N	2023-11-23 08:15:03	2023-11-23 08:15:19	4	t	26	3	USER
26	KALAO Alex	alex	\N	$2y$10$noUwTCGHa86BMqi7rXA2/eqGv8WqJWzIlpdFlF87EZAvKJ3JaZnF2	\N	2023-11-22 17:58:23	2023-11-25 16:11:20	1	t	24	5	USER
44	test	test	\N	$2y$10$evLmicem6SZnidIsOjRA7egevisbQ2AkTjO5LipevJ3zubXfA02gm	\N	2023-12-26 15:50:39	2023-12-26 15:54:34	16	f	\N	1	DPS
16	Bernadette Elom	elomi	\N	$2y$10$RiW5cBkov6Nx8SGlaK7ocO3/Kptnzp3o.x9PyUgWSsYzG/sNjyuD.	\N	2023-11-21 15:16:49	2023-12-26 15:55:22	16	t	28	1	DPS
24	Dr TCHEOU	tcheou	\N	$2y$10$QxlIPUTDlr7zrKFYqaG5SuhaVgrDaBrmodHRIkjko6GQpewEieXDu	\N	2023-11-22 17:46:44	2023-11-24 13:02:49	17	t	27	6	SI
25	Dr Huberta	huberta	\N	$2y$10$y/dCYU2CL4Zp9HAgYQQVWefWc6KRRpvwuivjc81/X7YR3KgcbpbvK	\N	2023-11-22 17:47:37	2023-11-24 13:07:00	17	t	27	6	SI
20	AGBODJAN Prince	prince	\N	$2y$10$Db/DZLYrikHxojYmvarbi.bJJqob.RE929gQojdpBzjPCPbdQyqVu	\N	2023-11-22 15:10:30	2023-12-28 16:05:30	16	t	26	2	FS
19	ESSOHAM Ali	ali	\N	$2y$10$D/UyhtiQbe79l/bjqs5sgerxMFXJ5Se/GpjdJkovC0/QapKnRfe5G	\N	2023-11-21 18:21:52	2023-12-28 16:38:26	16	t	25	2	DPS
38	Fichal OURO-DJOBO	fichal	\N	$2y$10$01FaZiIsTkZqCmHr3eL4HexLql5FSJa6b10ip5scmBgOkFz8g9/bS	\N	2023-12-13 10:45:17	2023-12-13 10:45:17	3	t	\N	3	FS
9	Administrateur systeme	admin	\N	$2y$10$90Z2R4Je/xBKchXuIQxYCO/k3wAQAI3nt9mwVkkQ8eMxbTZZ8K.Xu	\N	2023-11-21 12:35:33	2024-01-27 16:22:32	17	t	1	6	FS
5	ESSOHAM Eli	djamde	\N	$2y$10$fXIcI/mrbvex6SIys90S/.w4.4XAZ0f3/5Nhie3JYY0ipTUah8MgW	\N	\N	2024-01-27 16:23:41	16	f	1	2	DPS
10	adam	adam	\N	$2y$10$itX5ooQjniS8folHuOmjBuVozFkqbB3b7nlvIkVwxukEtKr/5oUqW	\N	2023-11-21 15:03:44	2024-01-27 16:24:55	16	t	1	5	FS
33	ANASS OD	anass	\N	$2y$10$GF1uTw7vHiGxMxeY1fTRfurMGq8EKAGkQz.otXy/ts7s5eIvZLpiW	\N	2023-11-24 14:05:25	2024-01-27 18:01:42	4	t	\N	1	FS
18	APELETE Senam	senam	\N	$2y$10$HiJROYKeDCj7Llb2UCT9JOR.HcGcQHcfqep5bCRPoRAA..adQrzPa	\N	2023-11-21 18:19:20	2024-01-27 18:02:49	16	t	23	1	FS
\.


--
-- TOC entry 3603 (class 0 OID 16941)
-- Dependencies: 295
-- Data for Name: validations; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.validations (validation_id, date, etat, observation, commande_id, user_id, centre_id, created_at, updated_at) FROM stdin;
2	2023-09-25	\N	Revoyer le prix du para	8	1	1	2023-09-26 14:28:35	2023-09-26 14:28:35
3	2023-09-26	\N	Remplacer la quinine par du Coartem	8	1	1	2023-09-26 15:00:39	2023-09-26 15:00:39
4	2023-09-26	\N	RAS	8	1	1	2023-09-26 15:02:51	2023-09-26 15:02:51
1	2023-09-25	\N	Merci de revoir la quantité de la quinine 500mg/B12	7	1	2	2023-09-25 15:24:48	2023-09-26 17:32:24
5	2023-09-28	\N	quantite de para tres peu. merci d augmenter le nombre	9	1	1	2023-09-28 17:26:18	2023-09-28 17:26:18
6	2023-10-02	\N	RAS	9	1	1	2023-10-02 11:04:37	2023-10-02 11:04:37
7	2023-10-02	\N	RAS	10	1	1	2023-10-02 11:05:00	2023-10-02 11:05:00
8	2023-10-03	\N	RAS	11	1	1	2023-10-03 16:11:51	2023-10-03 16:11:51
9	2023-10-12	\N	RAS	14	1	1	2023-10-12 16:45:57	2023-10-12 16:45:57
10	2023-10-12	\N	RAS	13	1	1	2023-10-12 16:46:23	2023-10-12 16:46:23
11	2023-10-13	\N	RAS	12	1	1	2023-10-15 13:19:05	2023-10-15 13:19:05
12	2023-10-17	\N	RAS	15	1	1	2023-10-17 18:19:41	2023-10-17 18:19:41
13	2023-10-17	\N	RAS	16	1	1	2023-10-17 19:54:25	2023-10-17 19:54:25
14	2023-10-20	\N	RAS	17	1	1	2023-10-27 12:49:19	2023-10-27 12:49:19
15	2023-10-27	\N	RAS	18	1	1	2023-10-27 12:49:28	2023-10-27 12:49:28
16	2023-10-27	\N	RAS	20	1	1	2023-10-27 16:18:04	2023-10-27 16:18:04
17	2023-10-27	\N	RAS	19	1	1	2023-10-27 16:18:12	2023-10-27 16:18:12
18	2023-10-27	\N	RAS	21	1	1	2023-10-27 16:50:27	2023-10-27 16:50:27
19	2023-10-27	\N	RAS	22	1	1	2023-10-27 16:50:37	2023-10-27 16:50:37
20	2023-10-28	\N	RAS	23	1	1	2023-10-28 17:40:01	2023-10-28 17:40:01
21	2023-10-28	\N	RAS	24	1	1	2023-10-28 17:40:09	2023-10-28 17:40:09
22	2023-10-28	\N	RAS	25	1	1	2023-10-28 18:08:46	2023-10-28 18:08:46
23	2023-11-04	\N	RAS	26	1	1	2023-11-04 18:25:35	2023-11-04 18:25:35
24	2023-11-09	\N	RAS	28	2	5	2023-11-09 18:26:44	2023-11-09 18:26:44
25	2023-11-09	\N	RAS	29	3	2	2023-11-09 18:56:57	2023-11-09 18:56:57
26	2023-11-09	\N	RAS	27	3	1	2023-11-09 19:10:08	2023-11-09 19:10:08
27	2023-11-10	\N	RAS	30	1	1	2023-11-10 11:14:45	2023-11-10 11:14:45
28	2023-11-10	\N	RAS	31	7	7	2023-11-10 12:43:50	2023-11-10 12:43:50
\.


--
-- TOC entry 3605 (class 0 OID 16949)
-- Dependencies: 297
-- Data for Name: valider_commande_controllers; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.valider_commande_controllers (validation_id, code, date, commande_id, observation, user_id, centre_id, created_at, updated_at) FROM stdin;
\.


--
-- TOC entry 3607 (class 0 OID 16957)
-- Dependencies: 299
-- Data for Name: ventes; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.ventes (vente_id, code, date_vente, montant_total, prise_en_charge, net_apayer, montant_recu, reliquat, patient_id, assurance_id, user_id, centre_id, created_at, updated_at, etat, montant_paye, heure_vente, dps_id) FROM stdin;
6	01112311	2023-11-01	6616	0	6616	6616	0	1	11	1	1	2023-11-01 20:04:23	2023-11-01 20:04:23	Soldee	6616	20:04:23+00	1
7	02112311	2023-11-01	6616	0	6616	10000	3384	1	11	1	1	2023-11-01 21:19:28	2023-11-01 21:19:28	Soldee	6616	21:19:28+00	1
8	03112311	2023-11-01	4800	0	4800	4800	0	1	11	1	1	2023-11-01 21:21:10	2023-11-01 21:21:10	Soldee	4800	21:21:10+00	1
9	04112311	2023-11-02	3440	0	3440	3440	0	1	11	1	1	2023-11-02 00:09:22	2023-11-02 00:09:22	Soldee	3440	00:09:22+00	1
10	05112311	2023-11-02	6160	0	6160	6160	0	1	11	1	1	2023-11-02 00:38:11	2023-11-02 00:38:11	Soldee	6160	00:38:11+00	1
11	06112311	2023-11-02	4275	0	4275	4275	0	1	11	1	1	2023-11-02 00:39:11	2023-11-02 00:39:11	Soldee	4275	00:39:11+00	1
12	07112311	2023-11-02	3720	2976	744	744	0	1	21	1	1	2023-11-02 16:31:02	2023-11-02 16:31:02	Soldee	744	16:31:02+00	1
13	08112311	2023-11-02	4640	4640	0	0	0	1	31	1	1	2023-11-02 16:31:29	2023-11-02 16:31:29	Soldee	0	16:31:29+00	1
14	09112311	2023-11-02	5280	4224	1056	1056	0	1	21	1	1	2023-11-02 16:31:53	2023-11-02 16:31:53	Soldee	1056	16:31:53+00	1
15	010112311	2023-11-02	6020	6020	0	0	0	1	81	1	1	2023-11-02 16:33:44	2023-11-02 16:33:44	Soldee	0	16:33:44+00	1
16	011112311	2023-11-02	3000	3000	0	0	0	1	81	1	1	2023-11-02 17:06:41	2023-11-02 17:06:41	Soldee	0	17:06:41+00	1
18	012112311	2023-11-03	2860	2288	572	572	0	4	21	1	1	2023-11-03 10:27:21	2023-11-03 10:27:21	Soldee	572	10:27:21+00	1
19	013112311	2023-11-07	2860	0	2860	2860	0	1	11	1	1	2023-11-07 16:43:21	2023-11-07 16:43:21	Soldee	2860	16:43:21+00	1
20	014112311	2023-11-08	43800	0	43800	43800	0	1	11	1	1	2023-11-08 22:16:52	2023-11-08 22:16:52	Soldee	43800	22:16:52+00	1
21	01112332	2023-11-09	8245	0	8245	8245	0	1	11	3	2	2023-11-09 18:59:15	2023-11-09 18:59:15	Soldee	8245	18:59:15+00	1
22	015112311	2023-11-09	26130	0	26130	26130	0	5	11	1	1	2023-11-09 19:12:14	2023-11-09 19:12:14	Soldee	26130	19:12:14+00	1
23	01112377	2023-11-10	4430	0	4430	4430	0	6	11	7	7	2023-11-10 12:45:27	2023-11-10 12:45:27	Soldee	4430	12:45:27+00	1
24	02112377	2023-11-10	16795	0	16795	16795	0	1	11	7	7	2023-11-10 12:46:08	2023-11-10 12:46:08	Soldee	16795	12:46:08+00	1
25	03112377	2023-11-10	3500	2800	700	700	0	1	21	7	7	2023-11-10 12:46:50	2023-11-10 12:46:50	Soldee	700	12:46:50+00	1
26	04112377	2023-11-10	5350	5350	0	0	0	1	81	7	7	2023-11-10 12:47:13	2023-11-10 12:47:13	Soldee	0	12:47:12+00	1
27	011123261	2023-11-24	26130	0	26130	26130	0	7	11	26	1	2023-11-24 16:43:51	2023-11-24 16:43:51	Soldee	26130	16:43:50+00	1
\.


--
-- TOC entry 3663 (class 0 OID 0)
-- Dependencies: 201
-- Name: assurances_assurance_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.assurances_assurance_id_seq', 1, false);


--
-- TOC entry 3664 (class 0 OID 0)
-- Dependencies: 203
-- Name: categories_categorie_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.categories_categorie_id_seq', 19, true);


--
-- TOC entry 3665 (class 0 OID 0)
-- Dependencies: 205
-- Name: centres_centre_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.centres_centre_id_seq', 17, true);


--
-- TOC entry 3666 (class 0 OID 0)
-- Dependencies: 207
-- Name: commandes_commande_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.commandes_commande_id_seq', 35, true);


--
-- TOC entry 3667 (class 0 OID 0)
-- Dependencies: 209
-- Name: compte_bancaires_compte_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.compte_bancaires_compte_id_seq', 1, false);


--
-- TOC entry 3668 (class 0 OID 0)
-- Dependencies: 211
-- Name: correction_stocks_correction_stock_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.correction_stocks_correction_stock_id_seq', 3, true);


--
-- TOC entry 3669 (class 0 OID 0)
-- Dependencies: 213
-- Name: directions_dps_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.directions_dps_id_seq', 6, true);


--
-- TOC entry 3670 (class 0 OID 0)
-- Dependencies: 215
-- Name: droit_profils_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.droit_profils_id_seq', 1171, true);


--
-- TOC entry 3671 (class 0 OID 0)
-- Dependencies: 217
-- Name: droits_droit_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.droits_droit_id_seq', 6, true);


--
-- TOC entry 3672 (class 0 OID 0)
-- Dependencies: 219
-- Name: entrees_entree_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.entrees_entree_id_seq', 1, false);


--
-- TOC entry 3673 (class 0 OID 0)
-- Dependencies: 221
-- Name: factures_facture_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.factures_facture_id_seq', 1, false);


--
-- TOC entry 3674 (class 0 OID 0)
-- Dependencies: 223
-- Name: failed_jobs_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.failed_jobs_id_seq', 1, false);


--
-- TOC entry 3675 (class 0 OID 0)
-- Dependencies: 225
-- Name: fournisseurs_fournisseur_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.fournisseurs_fournisseur_id_seq', 1, false);


--
-- TOC entry 3676 (class 0 OID 0)
-- Dependencies: 227
-- Name: initialisations_ini_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.initialisations_ini_id_seq', 1, false);


--
-- TOC entry 3677 (class 0 OID 0)
-- Dependencies: 229
-- Name: magasins_magasin_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.magasins_magasin_id_seq', 13, true);


--
-- TOC entry 3678 (class 0 OID 0)
-- Dependencies: 231
-- Name: migrations_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.migrations_id_seq', 70, true);


--
-- TOC entry 3679 (class 0 OID 0)
-- Dependencies: 233
-- Name: mouvements_mouvement_stock_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.mouvements_mouvement_stock_id_seq', 268, true);


--
-- TOC entry 3680 (class 0 OID 0)
-- Dependencies: 235
-- Name: mutuelles_mutuelle_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.mutuelles_mutuelle_id_seq', 1, false);


--
-- TOC entry 3681 (class 0 OID 0)
-- Dependencies: 237
-- Name: operation_bancaires_operation_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.operation_bancaires_operation_id_seq', 6, true);


--
-- TOC entry 3682 (class 0 OID 0)
-- Dependencies: 240
-- Name: patients_patient_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.patients_patient_id_seq', 7, true);


--
-- TOC entry 3683 (class 0 OID 0)
-- Dependencies: 242
-- Name: personal_access_tokens_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.personal_access_tokens_id_seq', 1, false);


--
-- TOC entry 3684 (class 0 OID 0)
-- Dependencies: 244
-- Name: produit_commandes_"produit_commande_id" _seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public."produit_commandes_""produit_commande_id"" _seq"', 126, true);


--
-- TOC entry 3685 (class 0 OID 0)
-- Dependencies: 246
-- Name: produit_correction_stocks_produit_correction_stock_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.produit_correction_stocks_produit_correction_stock_id_seq', 32, true);


--
-- TOC entry 3686 (class 0 OID 0)
-- Dependencies: 248
-- Name: produit_entrees_"produit_entree_id" _seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public."produit_entrees_""produit_entree_id"" _seq"', 1, false);


--
-- TOC entry 3687 (class 0 OID 0)
-- Dependencies: 250
-- Name: produit_factures_produit_facture_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.produit_factures_produit_facture_id_seq', 1, false);


--
-- TOC entry 3688 (class 0 OID 0)
-- Dependencies: 252
-- Name: produit_reception_dps_"produit_reception_dps_id" _seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public."produit_reception_dps_""produit_reception_dps_id"" _seq"', 1, false);


--
-- TOC entry 3689 (class 0 OID 0)
-- Dependencies: 254
-- Name: produit_reception_sis_produit_reception_si_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.produit_reception_sis_produit_reception_si_id_seq', 142, true);


--
-- TOC entry 3690 (class 0 OID 0)
-- Dependencies: 256
-- Name: produit_receptions_"produit_reception_id" _seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public."produit_receptions_""produit_reception_id"" _seq"', 510, true);


--
-- TOC entry 3691 (class 0 OID 0)
-- Dependencies: 258
-- Name: produit_sorties_"produit_sortie_id" _seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public."produit_sorties_""produit_sortie_id"" _seq"', 1, false);


--
-- TOC entry 3692 (class 0 OID 0)
-- Dependencies: 260
-- Name: produit_transfert_dps_produit_transfert_dps_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.produit_transfert_dps_produit_transfert_dps_id_seq', 1, false);


--
-- TOC entry 3693 (class 0 OID 0)
-- Dependencies: 262
-- Name: produit_transfert_sis_produit_transfert_si_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.produit_transfert_sis_produit_transfert_si_id_seq', 1, false);


--
-- TOC entry 3694 (class 0 OID 0)
-- Dependencies: 264
-- Name: produit_transferts_"produit_transfert_id" _seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public."produit_transferts_""produit_transfert_id"" _seq"', 41, true);


--
-- TOC entry 3695 (class 0 OID 0)
-- Dependencies: 266
-- Name: produit_ventes_produit_vente_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.produit_ventes_produit_vente_id_seq', 47, true);


--
-- TOC entry 3696 (class 0 OID 0)
-- Dependencies: 268
-- Name: produits_produit_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.produits_produit_id_seq', 1, false);


--
-- TOC entry 3697 (class 0 OID 0)
-- Dependencies: 270
-- Name: profil_users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.profil_users_id_seq', 80, true);


--
-- TOC entry 3698 (class 0 OID 0)
-- Dependencies: 272
-- Name: profils_profil_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.profils_profil_id_seq', 29, true);


--
-- TOC entry 3699 (class 0 OID 0)
-- Dependencies: 274
-- Name: reception_dps_reception_dps_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.reception_dps_reception_dps_id_seq', 1, false);


--
-- TOC entry 3700 (class 0 OID 0)
-- Dependencies: 276
-- Name: reception_sis_reception_si_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.reception_sis_reception_si_id_seq', 38, true);


--
-- TOC entry 3701 (class 0 OID 0)
-- Dependencies: 278
-- Name: receptions_reception_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.receptions_reception_id_seq', 51, true);


--
-- TOC entry 3702 (class 0 OID 0)
-- Dependencies: 280
-- Name: reglements_regelement_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.reglements_regelement_id_seq', 21, true);


--
-- TOC entry 3703 (class 0 OID 0)
-- Dependencies: 282
-- Name: sorties_sortie_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.sorties_sortie_id_seq', 1, false);


--
-- TOC entry 3704 (class 0 OID 0)
-- Dependencies: 284
-- Name: stock_produits_stock_produit_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.stock_produits_stock_produit_id_seq', 132, true);


--
-- TOC entry 3705 (class 0 OID 0)
-- Dependencies: 287
-- Name: transfert_dps_transfert_dps_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.transfert_dps_transfert_dps_id_seq', 1, false);


--
-- TOC entry 3706 (class 0 OID 0)
-- Dependencies: 289
-- Name: transfert_sis_transfert_si_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.transfert_sis_transfert_si_id_seq', 35, true);


--
-- TOC entry 3707 (class 0 OID 0)
-- Dependencies: 291
-- Name: transferts_transfert_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.transferts_transfert_id_seq', 15, true);


--
-- TOC entry 3708 (class 0 OID 0)
-- Dependencies: 294
-- Name: users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.users_id_seq', 45, true);


--
-- TOC entry 3709 (class 0 OID 0)
-- Dependencies: 296
-- Name: validations_validation_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.validations_validation_id_seq', 28, true);


--
-- TOC entry 3710 (class 0 OID 0)
-- Dependencies: 298
-- Name: valider_commande_controllers_validation_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.valider_commande_controllers_validation_id_seq', 1, false);


--
-- TOC entry 3711 (class 0 OID 0)
-- Dependencies: 300
-- Name: ventes_vente_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.ventes_vente_id_seq', 27, true);


--
-- TOC entry 3269 (class 2606 OID 17016)
-- Name: assurances assurances_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.assurances
    ADD CONSTRAINT assurances_pkey PRIMARY KEY (assurance_id);


--
-- TOC entry 3271 (class 2606 OID 17018)
-- Name: categories categories_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.categories
    ADD CONSTRAINT categories_pkey PRIMARY KEY (categorie_id);


--
-- TOC entry 3273 (class 2606 OID 17020)
-- Name: centres centres_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.centres
    ADD CONSTRAINT centres_pkey PRIMARY KEY (centre_id);


--
-- TOC entry 3275 (class 2606 OID 17022)
-- Name: commandes commandes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.commandes
    ADD CONSTRAINT commandes_pkey PRIMARY KEY (commande_id);


--
-- TOC entry 3277 (class 2606 OID 17024)
-- Name: compte_bancaires compte_bancaires_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.compte_bancaires
    ADD CONSTRAINT compte_bancaires_pkey PRIMARY KEY (compte_id);


--
-- TOC entry 3279 (class 2606 OID 17026)
-- Name: correction_stocks correction_stocks_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.correction_stocks
    ADD CONSTRAINT correction_stocks_pkey PRIMARY KEY (correction_stock_id);


--
-- TOC entry 3281 (class 2606 OID 17028)
-- Name: directions directions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.directions
    ADD CONSTRAINT directions_pkey PRIMARY KEY (dps_id);


--
-- TOC entry 3283 (class 2606 OID 17030)
-- Name: droit_profils droit_profils_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.droit_profils
    ADD CONSTRAINT droit_profils_pkey PRIMARY KEY (id);


--
-- TOC entry 3285 (class 2606 OID 17032)
-- Name: droits droits_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.droits
    ADD CONSTRAINT droits_pkey PRIMARY KEY (droit_id);


--
-- TOC entry 3287 (class 2606 OID 17034)
-- Name: entrees entrees_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.entrees
    ADD CONSTRAINT entrees_pkey PRIMARY KEY (entree_id);


--
-- TOC entry 3289 (class 2606 OID 17036)
-- Name: factures factures_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.factures
    ADD CONSTRAINT factures_pkey PRIMARY KEY (facture_id);


--
-- TOC entry 3291 (class 2606 OID 17038)
-- Name: failed_jobs failed_jobs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.failed_jobs
    ADD CONSTRAINT failed_jobs_pkey PRIMARY KEY (id);


--
-- TOC entry 3293 (class 2606 OID 17040)
-- Name: failed_jobs failed_jobs_uuid_unique; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.failed_jobs
    ADD CONSTRAINT failed_jobs_uuid_unique UNIQUE (uuid);


--
-- TOC entry 3295 (class 2606 OID 17042)
-- Name: fournisseurs fournisseurs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.fournisseurs
    ADD CONSTRAINT fournisseurs_pkey PRIMARY KEY (fournisseur_id);


--
-- TOC entry 3297 (class 2606 OID 17044)
-- Name: initialisations initialisations_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.initialisations
    ADD CONSTRAINT initialisations_pkey PRIMARY KEY (ini_id);


--
-- TOC entry 3299 (class 2606 OID 17046)
-- Name: magasins magasins_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.magasins
    ADD CONSTRAINT magasins_pkey PRIMARY KEY (magasin_id);


--
-- TOC entry 3301 (class 2606 OID 17048)
-- Name: migrations migrations_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.migrations
    ADD CONSTRAINT migrations_pkey PRIMARY KEY (id);


--
-- TOC entry 3303 (class 2606 OID 17050)
-- Name: mouvements mouvements_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mouvements
    ADD CONSTRAINT mouvements_pkey PRIMARY KEY (mouvement_id);


--
-- TOC entry 3305 (class 2606 OID 17052)
-- Name: mutuelles mutuelles_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mutuelles
    ADD CONSTRAINT mutuelles_pkey PRIMARY KEY (mutuelle_id);


--
-- TOC entry 3307 (class 2606 OID 17054)
-- Name: operation_bancaires operation_bancaires_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.operation_bancaires
    ADD CONSTRAINT operation_bancaires_pkey PRIMARY KEY (operation_id);


--
-- TOC entry 3310 (class 2606 OID 17056)
-- Name: patients patients_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.patients
    ADD CONSTRAINT patients_pkey PRIMARY KEY (patient_id);


--
-- TOC entry 3312 (class 2606 OID 17058)
-- Name: personal_access_tokens personal_access_tokens_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.personal_access_tokens
    ADD CONSTRAINT personal_access_tokens_pkey PRIMARY KEY (id);


--
-- TOC entry 3314 (class 2606 OID 17060)
-- Name: personal_access_tokens personal_access_tokens_token_unique; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.personal_access_tokens
    ADD CONSTRAINT personal_access_tokens_token_unique UNIQUE (token);


--
-- TOC entry 3317 (class 2606 OID 17062)
-- Name: produit_commandes produit_commandes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_commandes
    ADD CONSTRAINT produit_commandes_pkey PRIMARY KEY (produit_commande_id);


--
-- TOC entry 3319 (class 2606 OID 17064)
-- Name: produit_correction_stocks produit_correction_stocks_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_correction_stocks
    ADD CONSTRAINT produit_correction_stocks_pkey PRIMARY KEY (produit_correction_stock_id);


--
-- TOC entry 3321 (class 2606 OID 17066)
-- Name: produit_entrees produit_entrees_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_entrees
    ADD CONSTRAINT produit_entrees_pkey PRIMARY KEY ("""produit_entree_id"" ");


--
-- TOC entry 3323 (class 2606 OID 17068)
-- Name: produit_factures produit_factures_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_factures
    ADD CONSTRAINT produit_factures_pkey PRIMARY KEY (produit_facture_id);


--
-- TOC entry 3325 (class 2606 OID 17070)
-- Name: produit_reception_dps produit_reception_dps_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_reception_dps
    ADD CONSTRAINT produit_reception_dps_pkey PRIMARY KEY ("""produit_reception_dps_id"" ");


--
-- TOC entry 3327 (class 2606 OID 17072)
-- Name: produit_reception_sis produit_reception_sis_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_reception_sis
    ADD CONSTRAINT produit_reception_sis_pkey PRIMARY KEY (produit_reception_si_id);


--
-- TOC entry 3329 (class 2606 OID 17074)
-- Name: produit_receptions produit_receptions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_receptions
    ADD CONSTRAINT produit_receptions_pkey PRIMARY KEY (produit_reception_id);


--
-- TOC entry 3331 (class 2606 OID 17076)
-- Name: produit_sorties produit_sorties_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_sorties
    ADD CONSTRAINT produit_sorties_pkey PRIMARY KEY ("""produit_sortie_id"" ");


--
-- TOC entry 3333 (class 2606 OID 17078)
-- Name: produit_transfert_dps produit_transfert_dps_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_transfert_dps
    ADD CONSTRAINT produit_transfert_dps_pkey PRIMARY KEY (produit_transfert_dps_id);


--
-- TOC entry 3335 (class 2606 OID 17080)
-- Name: produit_transfert_sis produit_transfert_sis_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_transfert_sis
    ADD CONSTRAINT produit_transfert_sis_pkey PRIMARY KEY (produit_transfert_si_id);


--
-- TOC entry 3337 (class 2606 OID 17082)
-- Name: produit_transferts produit_transferts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_transferts
    ADD CONSTRAINT produit_transferts_pkey PRIMARY KEY (produit_transfert_id);


--
-- TOC entry 3339 (class 2606 OID 17084)
-- Name: produit_ventes produit_ventes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produit_ventes
    ADD CONSTRAINT produit_ventes_pkey PRIMARY KEY (produit_vente_id);


--
-- TOC entry 3341 (class 2606 OID 17086)
-- Name: produits produits_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.produits
    ADD CONSTRAINT produits_pkey PRIMARY KEY (produit_id);


--
-- TOC entry 3343 (class 2606 OID 17088)
-- Name: profil_users profil_users_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.profil_users
    ADD CONSTRAINT profil_users_pkey PRIMARY KEY (id);


--
-- TOC entry 3345 (class 2606 OID 17090)
-- Name: profils profils_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.profils
    ADD CONSTRAINT profils_pkey PRIMARY KEY (profil_id);


--
-- TOC entry 3347 (class 2606 OID 17092)
-- Name: reception_dps reception_dps_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reception_dps
    ADD CONSTRAINT reception_dps_pkey PRIMARY KEY (reception_dps_id);


--
-- TOC entry 3349 (class 2606 OID 17094)
-- Name: reception_sis reception_sis_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reception_sis
    ADD CONSTRAINT reception_sis_pkey PRIMARY KEY (reception_si_id);


--
-- TOC entry 3351 (class 2606 OID 17096)
-- Name: receptions receptions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.receptions
    ADD CONSTRAINT receptions_pkey PRIMARY KEY (reception_id);


--
-- TOC entry 3353 (class 2606 OID 17098)
-- Name: reglements reglements_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reglements
    ADD CONSTRAINT reglements_pkey PRIMARY KEY (reglement_id);


--
-- TOC entry 3355 (class 2606 OID 17100)
-- Name: sorties sorties_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sorties
    ADD CONSTRAINT sorties_pkey PRIMARY KEY (sortie_id);


--
-- TOC entry 3357 (class 2606 OID 17102)
-- Name: stock_produits stock_produits_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stock_produits
    ADD CONSTRAINT stock_produits_pkey PRIMARY KEY (stock_produit_id);


--
-- TOC entry 3359 (class 2606 OID 17104)
-- Name: transfert_dps transfert_dps_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transfert_dps
    ADD CONSTRAINT transfert_dps_pkey PRIMARY KEY (transfert_dps_id);


--
-- TOC entry 3361 (class 2606 OID 17106)
-- Name: transfert_sis transfert_sis_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transfert_sis
    ADD CONSTRAINT transfert_sis_pkey PRIMARY KEY (transfert_si_id);


--
-- TOC entry 3363 (class 2606 OID 17108)
-- Name: transferts transferts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transferts
    ADD CONSTRAINT transferts_pkey PRIMARY KEY (transfert_id);


--
-- TOC entry 3365 (class 2606 OID 17110)
-- Name: users users_email_unique; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_email_unique UNIQUE (email);


--
-- TOC entry 3367 (class 2606 OID 17112)
-- Name: users users_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- TOC entry 3369 (class 2606 OID 17114)
-- Name: validations validations_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.validations
    ADD CONSTRAINT validations_pkey PRIMARY KEY (validation_id);


--
-- TOC entry 3371 (class 2606 OID 17116)
-- Name: valider_commande_controllers valider_commande_controllers_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.valider_commande_controllers
    ADD CONSTRAINT valider_commande_controllers_pkey PRIMARY KEY (validation_id);


--
-- TOC entry 3373 (class 2606 OID 17118)
-- Name: ventes ventes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ventes
    ADD CONSTRAINT ventes_pkey PRIMARY KEY (vente_id);


--
-- TOC entry 3308 (class 1259 OID 17119)
-- Name: password_resets_email_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX password_resets_email_index ON public.password_resets USING btree (email);


--
-- TOC entry 3315 (class 1259 OID 17120)
-- Name: personal_access_tokens_tokenable_type_tokenable_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX personal_access_tokens_tokenable_type_tokenable_id_index ON public.personal_access_tokens USING btree (tokenable_type, tokenable_id);


--
-- TOC entry 3374 (class 2606 OID 17121)
-- Name: droit_profils droit_profils_droit_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.droit_profils
    ADD CONSTRAINT droit_profils_droit_id_foreign FOREIGN KEY (droit_id) REFERENCES public.droits(droit_id) ON DELETE CASCADE;


--
-- TOC entry 3375 (class 2606 OID 17126)
-- Name: droit_profils droit_profils_profil_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.droit_profils
    ADD CONSTRAINT droit_profils_profil_id_foreign FOREIGN KEY (profil_id) REFERENCES public.profils(profil_id) ON DELETE CASCADE;


--
-- TOC entry 3376 (class 2606 OID 17131)
-- Name: profil_users profil_users_profil_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.profil_users
    ADD CONSTRAINT profil_users_profil_id_foreign FOREIGN KEY (profil_id) REFERENCES public.profils(profil_id) ON DELETE CASCADE;


--
-- TOC entry 3377 (class 2606 OID 17136)
-- Name: profil_users profil_users_user_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.profil_users
    ADD CONSTRAINT profil_users_user_id_foreign FOREIGN KEY (user_id) REFERENCES public.users(id) ON DELETE CASCADE;


-- Completed on 2024-02-26 09:51:02

--
-- PostgreSQL database dump complete
--

